/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.datavec.api.conf.Configuration;
import org.datavec.api.io.labels.PathLabelGenerator;
import org.datavec.api.records.reader.BaseRecordReader;
import org.datavec.api.records.reader.impl.jackson.FieldSelection;
import org.datavec.api.split.FileSplit;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class JacksonRecordReader
extends BaseRecordReader {
    private static final TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
    private FieldSelection selection;
    private ObjectMapper mapper;
    private boolean shuffle;
    private long rngSeed;
    private PathLabelGenerator labelGenerator;
    private int labelPosition;
    private InputSplit is;
    private Random r;
    private URI[] uris;
    private int cursor = 0;

    public JacksonRecordReader(FieldSelection selection, ObjectMapper mapper) {
        this(selection, mapper, false);
    }

    public JacksonRecordReader(FieldSelection selection, ObjectMapper mapper, boolean shuffle) {
        this(selection, mapper, shuffle, System.currentTimeMillis(), null);
    }

    public JacksonRecordReader(FieldSelection selection, ObjectMapper mapper, boolean shuffle, long rngSeed, PathLabelGenerator labelGenerator) {
        this(selection, mapper, shuffle, rngSeed, labelGenerator, -1);
    }

    public JacksonRecordReader(FieldSelection selection, ObjectMapper mapper, boolean shuffle, long rngSeed, PathLabelGenerator labelGenerator, int labelPosition) {
        this.selection = selection;
        this.mapper = mapper;
        this.shuffle = shuffle;
        this.rngSeed = rngSeed;
        if (shuffle) {
            this.r = new Random(rngSeed);
        }
        this.labelGenerator = labelGenerator;
        this.labelPosition = labelPosition;
    }

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
        if (split instanceof FileSplit) {
            throw new UnsupportedOperationException("Cannot use JacksonRecordReader with FileSplit");
        }
        this.uris = split.locations();
        if (this.shuffle) {
            List<URI> list = Arrays.asList(this.uris);
            Collections.shuffle(list, this.r);
            this.uris = list.toArray(new URI[this.uris.length]);
        }
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.initialize(split);
    }

    @Override
    public Collection<Writable> next() {
        String fileAsString;
        if (this.uris == null) {
            throw new IllegalStateException("URIs are null. Not initialized?");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        URI uri = this.uris[this.cursor++];
        this.invokeListeners(uri);
        try {
            fileAsString = FileUtils.readFileToString((File)new File(uri.toURL().getFile()));
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading URI file", e);
        }
        return this.readValues(uri, fileAsString);
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.uris.length;
    }

    @Override
    public List<String> getLabels() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.cursor = 0;
        if (this.shuffle) {
            List<URI> list = Arrays.asList(this.uris);
            Collections.shuffle(list, this.r);
            this.uris = list.toArray(new URI[this.uris.length]);
        }
    }

    @Override
    public Collection<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(dataInputStream));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line).append("\n");
        }
        return this.readValues(uri, sb.toString());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void setConf(Configuration conf) {
    }

    @Override
    public Configuration getConf() {
        return null;
    }

    private Collection<Writable> readValues(URI uri, String fileContents) {
        Map map;
        ArrayList<Writable> out = new ArrayList<Writable>();
        List<String[]> paths = this.selection.getFieldPaths();
        List<Writable> valueIfMissing = this.selection.getValueIfMissing();
        try {
            map = (Map)this.mapper.readValue(fileContents, typeRef);
        }
        catch (IOException e) {
            throw new RuntimeException("Error parsing file", e);
        }
        for (int i = 0; i < paths.size(); ++i) {
            if (i == this.labelPosition && this.labelGenerator != null) {
                out.add(this.labelGenerator.getLabelForPath(uri));
            }
            Object[] currPath = paths.get(i);
            String value = null;
            Map currMap = map;
            for (int j = 0; j < currPath.length; ++j) {
                if (currMap.containsKey(currPath[j])) {
                    Object o = currMap.get(currPath[j]);
                    if (j == currPath.length - 1) {
                        if (o instanceof String) {
                            value = (String)o;
                            continue;
                        }
                        if (o instanceof Number) {
                            value = o.toString();
                            continue;
                        }
                        throw new IllegalStateException("Expected to find String on path " + Arrays.toString(currPath) + ", found " + o.getClass() + " with value " + o);
                    }
                    if (!(o instanceof Map)) continue;
                    currMap = (Map)o;
                    continue;
                }
                value = null;
                break;
            }
            Writable outputWritable = value == null ? valueIfMissing.get(i) : new Text(value);
            out.add(outputWritable);
        }
        if ((this.labelPosition >= paths.size() || this.labelPosition == -1) && this.labelGenerator != null) {
            out.add(this.labelGenerator.getLabelForPath(uri));
        }
        return out;
    }
}

