/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml.binder;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.xml.bind.annotation.XmlElement;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.store.xml.XMLUtils;

public class XmlElementHandler
implements InvocationHandler {
    private ClassLoaderResolver clr;
    private AbstractMemberMetaData ammd;

    public XmlElementHandler(AbstractMemberMetaData ammd, ClassLoaderResolver clr) {
        this.ammd = ammd;
        this.clr = clr;
    }

    public static Annotation newProxy(AbstractMemberMetaData ammd, ClassLoaderResolver clr) {
        return (Annotation)Proxy.newProxyInstance(AbstractMemberMetaData.class.getClassLoader(), new Class[]{XmlElement.class}, (InvocationHandler)new XmlElementHandler(ammd, clr));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (name.equals("getClassValue")) {
            name = (String)args[1];
        }
        if (name.equals("annotationType")) {
            return XmlElement.class;
        }
        if (name.equals("namespace")) {
            String value = "##default";
            if (this.ammd.hasExtension("namespace")) {
                value = this.ammd.getValueForExtension("namespace");
            }
            return value;
        }
        if (name.equals("name")) {
            if (this.ammd.hasArray()) {
                return XMLUtils.getElementNameForMember(this.ammd, FieldRole.ROLE_ARRAY_ELEMENT);
            }
            if (this.ammd.hasCollection()) {
                return XMLUtils.getElementNameForMember(this.ammd, FieldRole.ROLE_COLLECTION_ELEMENT);
            }
            if (this.ammd.hasMap()) {
                return XMLUtils.getElementNameForMember(this.ammd, FieldRole.ROLE_MAP_VALUE);
            }
            return XMLUtils.getElementNameForMember(this.ammd, FieldRole.ROLE_FIELD);
        }
        if (name.equals("nillable")) {
            boolean value = false;
            if (this.ammd.hasExtension("nillable")) {
                value = Boolean.valueOf(this.ammd.getValueForExtension("nillable"));
            }
            return value;
        }
        if (name.equals("required")) {
            boolean value = false;
            if (this.ammd.hasExtension("required")) {
                value = Boolean.valueOf(this.ammd.getValueForExtension("required"));
            }
            return value;
        }
        if (name.equals("defaultValue")) {
            String value = "\u0000";
            if (this.ammd.hasExtension("defaultValue")) {
                value = this.ammd.getValueForExtension("defaultValue");
            }
            return value;
        }
        if (name.equals("type")) {
            Class<XmlElement.DEFAULT> type = XMLUtils.getElementTypeForMember(this.ammd, this.clr);
            return type != null ? type : XmlElement.DEFAULT.class;
        }
        return null;
    }
}

