/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.evaluator.JPQLEvaluator;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.xml.query.XMLCandidateList;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JPQLQuery
extends AbstractJPQLQuery {
    private static final long serialVersionUID = -5069640831833631716L;

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (JPQLQuery)null);
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, JPQLQuery q) {
        super(storeMgr, ec, (AbstractJPQLQuery)q);
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = this.getStoreManager().getConnection(this.ec);
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021046", (Object[])new Object[]{"JPQL", this.getSingleStringQuery(), null}));
            }
            Object candidates = null;
            candidates = this.candidateCollection == null ? new XMLCandidateList(this.candidateClass, this.subclasses, this.ec, (String)this.getExtension("datanucleus.query.resultCacheType"), mconn, this.ignoreCache) : new ArrayList(this.candidateCollection);
            JPQLEvaluator resultMapper = new JPQLEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
            Collection results = resultMapper.execute(true, true, true, true, true);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021074", (Object[])new Object[]{"JPQL", "" + (System.currentTimeMillis() - startTime)}));
            }
            if (this.type == Query.QueryType.BULK_DELETE) {
                this.ec.deleteObjects(results.toArray());
                Long l = results.size();
                return l;
            }
            if (this.type == Query.QueryType.BULK_UPDATE) {
                throw new NucleusException("Bulk Update is not yet supported");
            }
            Collection collection = results;
            return collection;
        }
        finally {
            mconn.release();
        }
    }
}

