/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml.binder;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.xml.bind.annotation.XmlElementRef;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.store.xml.XMLUtils;

public class XmlElementRefHandler
implements InvocationHandler {
    private ClassLoaderResolver clr;
    private AbstractMemberMetaData ammd;

    public XmlElementRefHandler(AbstractMemberMetaData ammd, ClassLoaderResolver clr) {
        this.ammd = ammd;
        this.clr = clr;
    }

    public static Annotation newProxy(AbstractMemberMetaData ammd, ClassLoaderResolver clr) {
        return (Annotation)Proxy.newProxyInstance(AbstractMemberMetaData.class.getClassLoader(), new Class[]{XmlElementRef.class}, (InvocationHandler)new XmlElementRefHandler(ammd, clr));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (name.equals("getClassValue")) {
            name = (String)args[1];
        }
        if (name.equals("annotationType")) {
            return XmlElementRef.class;
        }
        if (name.equals("namespace")) {
            String value = "##default";
            if (this.ammd.hasExtension("namespace")) {
                value = this.ammd.getValueForExtension("namespace");
            }
            return value;
        }
        if (name.equals("name")) {
            return XMLUtils.getElementNameForMember(this.ammd, FieldRole.ROLE_FIELD);
        }
        if (name.equals("type")) {
            if (this.ammd.hasExtension("type")) {
                try {
                    return this.clr.classForName(this.ammd.getValueForExtension("type"));
                }
                catch (ClassNotResolvedException cnre) {
                    throw new RuntimeException(cnre.getMessage());
                }
            }
            return XmlElementRef.DEFAULT.class;
        }
        return null;
    }
}

