/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.transaction.xa.XAResource;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.datanucleus.OMFContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    public ConnectionFactoryImpl(OMFContext omfContext, String resourceType) {
        super(omfContext, resourceType);
    }

    public ManagedConnection createManagedConnection(Object poolKey, Map transactionOptions) {
        return new ManagedConnectionImpl(this.omfContext, transactionOptions);
    }

    public class ManagedConnectionImpl
    extends AbstractManagedConnection {
        OMFContext omf;
        Map options;
        File file;

        public ManagedConnectionImpl(OMFContext omf, Map options) {
            this.omf = omf;
            this.options = options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.conn == null) {
                return;
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            try {
                try {
                    TransformerFactory tf = TransformerFactory.newInstance();
                    Transformer m = tf.newTransformer();
                    DOMSource source = new DOMSource((Document)this.conn);
                    FileOutputStream os = new FileOutputStream(this.file);
                    StreamResult result = new StreamResult(os);
                    m.setOutputProperty("indent", "yes");
                    m.transform(source, result);
                    os.close();
                }
                catch (Exception e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.conn = null;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
                }
            }
        }

        public Object getConnection() {
            if (this.conn == null) {
                String url = this.omf.getStoreManager().getConnectionURL();
                if (url == null) {
                    throw new NucleusException("you haven't specified persistence property 'datanucleus.ConnectionURL' (or alias)");
                }
                if (!url.startsWith("xml")) {
                    throw new NucleusException("invalid URL: " + url);
                }
                String str = url.substring(4);
                if (str.indexOf("file:") != 0) {
                    throw new NucleusException("invalid URL: " + url);
                }
                try {
                    String filename = str.substring(5);
                    this.file = new File(filename);
                    if (!this.file.exists()) {
                        this.file.createNewFile();
                        this.conn = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                    } else {
                        try {
                            this.conn = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.file);
                        }
                        catch (SAXException ex) {
                            this.conn = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                        }
                    }
                }
                catch (IOException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
                catch (ParserConfigurationException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            return this.conn;
        }

        public XAResource getXAResource() {
            return null;
        }
    }
}

