/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml;

import java.util.StringTokenizer;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.PersistFieldManager;
import org.datanucleus.store.xml.XMLManager;
import org.datanucleus.store.xml.XMLUtils;
import org.datanucleus.store.xml.binder.JAXBRuntimeBinder;
import org.datanucleus.store.xml.fieldmanager.FetchFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLPersistenceHandler
implements StorePersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.xml.Localisation", (ClassLoader)XMLManager.class.getClassLoader());
    protected final XMLManager storeMgr;
    private XPath xpath = XPathFactory.newInstance().newXPath();

    public XMLPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (XMLManager)storeMgr;
    }

    public void close() {
    }

    public void insertObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        if (sm.getClassMetaData().getIdentityType() == IdentityType.APPLICATION) {
            try {
                this.locateObject(sm);
                throw new NucleusUserException(LOCALISER.msg("XML.Insert.ObjectWithIdAlreadyExists", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            catch (NucleusObjectNotFoundException onfe) {
                // empty catch block
            }
        }
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            String expression;
            Document doc = (Document)mconn.getConnection();
            Node classnode = null;
            AbstractClassMetaData acmd = sm.getClassMetaData();
            long startTime = 0L;
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("XML.Insert.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            if ((expression = XMLUtils.getXPathForClass(acmd)) == null) {
                if (doc.getDocumentElement() == null) {
                    doc.appendChild(doc.createElement(XMLUtils.getDefaultRootXPath()));
                }
                classnode = doc.getDocumentElement();
            } else {
                if (this.xpath.evaluate(expression, doc, XPathConstants.NODE) == null) {
                    StringTokenizer xpathElement = new StringTokenizer(expression, "/");
                    String path = "";
                    String currentelement = null;
                    Node node = doc;
                    while (xpathElement.hasMoreElements()) {
                        currentelement = xpathElement.nextToken();
                        Node n = (Node)this.xpath.evaluate(path = path + "/" + currentelement, doc, XPathConstants.NODE);
                        if (n == null) {
                            node = node.appendChild(doc.createElement(currentelement));
                            continue;
                        }
                        node = n;
                    }
                }
                classnode = (Node)this.xpath.evaluate(expression, doc, XPathConstants.NODE);
            }
            JAXBRuntimeBinder.marshall(sm.getObject(), classnode, this.storeMgr.getMetaDataManager(), sm.getObjectManager().getClassLoaderResolver());
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementInsertCount();
            }
            if (acmd.getVersionMetaData() == null || acmd.getVersionMetaData().getVersionStrategy() != VersionStrategy.NONE) {
                // empty if block
            }
            int[] fieldNumbers = sm.getClassMetaData().getAllMemberPositions();
            sm.provideFields(fieldNumbers, (FieldManager)new PersistFieldManager(sm, true));
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.info((Object)LOCALISER.msg("XML.Insert.ObjectPersisted", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void updateObject(StateManager sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        AbstractClassMetaData acmd = sm.getClassMetaData();
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            Document doc = (Document)mconn.getConnection();
            long startTime = 0L;
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
                StringBuffer str = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("XML.Update.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), (Object)str));
            }
            if (acmd.getVersionMetaData() == null || acmd.getVersionMetaData().getVersionStrategy() != VersionStrategy.NONE) {
                // empty if block
            }
            String expression = XMLUtils.getXPathForClass(acmd);
            Node classnode = null;
            classnode = expression == null ? doc.getDocumentElement() : (Node)this.xpath.evaluate(expression, doc, XPathConstants.NODE);
            Node node = XMLUtils.findNode(doc, sm);
            node.getParentNode().removeChild(node);
            JAXBRuntimeBinder.marshall(sm.getObject(), classnode, this.storeMgr.getMetaDataManager(), sm.getObjectManager().getClassLoaderResolver());
            sm.provideFields(fieldNumbers, (FieldManager)new PersistFieldManager(sm, false));
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
            }
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            AbstractClassMetaData acmd;
            Document doc = (Document)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("XML.Delete.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            if ((acmd = sm.getClassMetaData()).getVersionMetaData() == null || acmd.getVersionMetaData().getVersionStrategy() != VersionStrategy.NONE) {
                // empty if block
            }
            Node node = XMLUtils.findNode(doc, sm);
            node.getParentNode().removeChild(node);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementDeleteCount();
            }
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchObject(StateManager sm, int[] fieldNumbers) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                StringBuffer fieldsString = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldsString.append(",");
                    }
                    fieldsString.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("XML.Fetch.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), (Object)fieldsString));
            }
            Document doc = (Document)mconn.getConnection();
            sm.replaceFields(fieldNumbers, (FieldManager)new FetchFieldManager(sm, doc));
            if (cmd.getVersionMetaData() == null || cmd.getVersionMetaData().getVersionStrategy() != VersionStrategy.NONE) {
                // empty if block
            }
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementFetchCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ObjectManager om, Object id) {
        return null;
    }

    public void locateObject(StateManager sm) {
        AbstractClassMetaData acmd = sm.getClassMetaData();
        if (acmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusException(LOCALISER.msg("XML.DatastoreID"));
        }
        if (acmd.getIdentityType() == IdentityType.NONDURABLE) {
            throw new NucleusException("Nondurable not supported");
        }
        ObjectManager om = sm.getObjectManager();
        boolean isStored = false;
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("XML.Locate.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
        }
        ManagedConnection mconn = this.storeMgr.getConnection(om);
        String expression = null;
        try {
            Document doc = (Document)mconn.getConnection();
            expression = XMLUtils.getXPathForClass(acmd);
            if (expression == null) {
                if (doc.getDocumentElement() != null) {
                    expression = "/" + doc.getDocumentElement().getNodeName();
                } else {
                    throw new NucleusObjectNotFoundException(LOCALISER.msg("XML.Object.NotFound", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), (Object)expression));
                }
            }
            expression = expression + "/" + XMLUtils.getElementNameForClass(acmd);
            String[] pk = acmd.getPrimaryKeyMemberNames();
            for (int i = 0; i < pk.length; ++i) {
                AbstractMemberMetaData pkmmd = acmd.getMetaDataForMember(pk[i]);
                String pkElement = XMLUtils.getElementNameForMember(pkmmd, 2);
                Object obj = sm.provideField(acmd.getPKMemberPositions()[i]);
                expression = expression + "/" + pkElement + "/text()='" + obj.toString() + "'";
            }
            isStored = (Boolean)this.xpath.evaluate(expression, doc, XPathConstants.BOOLEAN);
        }
        catch (Exception e) {
            throw new NucleusObjectNotFoundException(LOCALISER.msg("XML.Object.NotFound", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), (Object)expression));
        }
        finally {
            mconn.release();
        }
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        if (!isStored) {
            throw new NucleusObjectNotFoundException(LOCALISER.msg("XML.Object.NotFound", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), (Object)expression));
        }
    }
}

