/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml;

import java.util.StringTokenizer;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.xml.XMLManager;
import org.datanucleus.store.xml.XMLUtils;
import org.datanucleus.store.xml.binder.JAXBRuntimeBinder;
import org.datanucleus.store.xml.fieldmanager.FetchFieldManager;
import org.datanucleus.store.xml.fieldmanager.InsertFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLPersistenceHandler
implements StorePersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.xml.Localisation", (ClassLoader)XMLManager.class.getClassLoader());
    protected final XMLManager storeMgr;
    private XPath xpath = XPathFactory.newInstance().newXPath();

    public XMLPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (XMLManager)storeMgr;
    }

    public void close() {
    }

    public void insertObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        if (sm.getClassMetaData().getIdentityType() == IdentityType.APPLICATION) {
            try {
                this.locateObject(sm);
                throw new NucleusUserException(LOCALISER.msg("XML.Insert.ObjectWithIdAlreadyExists", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            catch (NucleusObjectNotFoundException onfe) {
                // empty catch block
            }
        }
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            String expression;
            Document doc = (Document)mconn.getConnection();
            Node classnode = null;
            AbstractClassMetaData acmd = sm.getClassMetaData();
            long startTime = 0L;
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("XML.Insert.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            if ((expression = acmd.getValueForExtension("xpath")) == null) {
                if (doc.getDocumentElement() == null) {
                    doc.appendChild(doc.createElement("root"));
                }
                classnode = doc.getDocumentElement();
            } else {
                if (this.xpath.evaluate(expression, doc, XPathConstants.NODE) == null) {
                    StringTokenizer xpathElement = new StringTokenizer(expression, "/");
                    String path = "";
                    String currentelement = null;
                    Node node = doc;
                    while (xpathElement.hasMoreElements()) {
                        currentelement = xpathElement.nextToken();
                        Node n = (Node)this.xpath.evaluate(path = path + "/" + currentelement, doc, XPathConstants.NODE);
                        if (n == null) {
                            node = node.appendChild(doc.createElement(currentelement));
                            continue;
                        }
                        node = n;
                    }
                }
                classnode = (Node)this.xpath.evaluate(expression, doc, XPathConstants.NODE);
            }
            JAXBRuntimeBinder.marshall(sm.getObject(), classnode, this.storeMgr.getMetaDataManager(), sm.getObjectManager().getClassLoaderResolver());
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementInsertCount();
            }
            if (acmd.getVersionMetaData() == null || acmd.getVersionMetaData().getVersionStrategy() != VersionStrategy.NONE) {
                // empty if block
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.info((Object)LOCALISER.msg("XML.Insert.ObjectPersisted", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
        int[] fieldNumbers = sm.getClassMetaData().getAllMemberPositions();
        sm.provideFields(fieldNumbers, (FieldManager)new InsertFieldManager(sm));
    }

    public void updateObject(StateManager sm, int[] fieldNumbers) {
        block7: {
            this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
            ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
            try {
                Document doc = (Document)mconn.getConnection();
                Node classnode = null;
                Object oldObject = sm.getObject();
                AbstractClassMetaData acmd = sm.getClassMetaData();
                if (acmd.getVersionMetaData() == null || acmd.getVersionMetaData().getVersionStrategy() != VersionStrategy.NONE) {
                    // empty if block
                }
                String expression = sm.getClassMetaData().getValueForExtension("xpath");
                String[] pk = sm.getClassMetaData().getPrimaryKeyMemberNames();
                int numIdFields = pk.length;
                if (numIdFields > 0) {
                    classnode = expression == null ? doc.getDocumentElement() : (Node)this.xpath.evaluate(expression, doc, XPathConstants.NODE);
                    Node node = XMLUtils.findNode(doc, sm);
                    node.getParentNode().removeChild(node);
                    JAXBRuntimeBinder.marshall(sm.getObject(), classnode, this.storeMgr.getMetaDataManager(), sm.getObjectManager().getClassLoaderResolver());
                    break block7;
                }
                throw new NucleusDataStoreException("No ID defined for " + oldObject.getClass());
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    public void deleteObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            AbstractClassMetaData acmd;
            Document doc = (Document)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("XML.Delete.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            if ((acmd = sm.getClassMetaData()).getVersionMetaData() == null || acmd.getVersionMetaData().getVersionStrategy() != VersionStrategy.NONE) {
                // empty if block
            }
            Node node = XMLUtils.findNode(doc, sm);
            node.getParentNode().removeChild(node);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementDeleteCount();
            }
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchObject(StateManager sm, int[] fieldNumbers) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            StringBuffer str = new StringBuffer("Fetching object \"");
            str.append(StringUtils.toJVMIDString((Object)sm.getObject())).append("\" (id=");
            str.append(sm.getObjectManager().getApiAdapter().getObjectId(sm)).append(")").append(" fields [");
            for (int i = 0; i < fieldNumbers.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
            }
            str.append("]");
            NucleusLogger.PERSISTENCE.debug((Object)str);
        }
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("XML.Fetch.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            Document doc = (Document)mconn.getConnection();
            sm.replaceFields(fieldNumbers, (FieldManager)new FetchFieldManager(sm, doc));
            if (cmd.getVersionMetaData() == null || cmd.getVersionMetaData().getVersionStrategy() != VersionStrategy.NONE) {
                // empty if block
            }
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementFetchCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ObjectManager om, Object id) {
        return null;
    }

    public void locateObject(StateManager sm) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusException(LOCALISER.msg("XML.DatastoreID"));
        }
        ObjectManager om = sm.getObjectManager();
        boolean isStored = false;
        String expression = null;
        expression = sm.getClassMetaData().getValueForExtension("xpath");
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("XML.Fetch.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
        }
        ManagedConnection mconn = this.storeMgr.getConnection(om);
        try {
            Document doc = (Document)mconn.getConnection();
            String[] pk = sm.getClassMetaData().getPrimaryKeyMemberNames();
            if (pk.length < 1) {
                throw new NucleusDataStoreException("No ID defined for " + cmd.getFullClassName());
            }
            if (expression == null) {
                expression = "/root";
            }
            expression = sm.getClassMetaData().hasExtension("name") ? expression + "/" + sm.getClassMetaData().getValueForExtension("name") : expression + "/" + sm.getClassMetaData().getName().substring(0, 1).toLowerCase() + sm.getClassMetaData().getName().substring(1);
            for (int i = 0; i < pk.length; ++i) {
                Object obj = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[i]);
                expression = expression + "/" + pk[i] + "/text()='" + obj.toString() + "'";
            }
            isStored = (Boolean)this.xpath.evaluate(expression, doc, XPathConstants.BOOLEAN);
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        if (!isStored) {
            throw new NucleusObjectNotFoundException(LOCALISER.msg("XML.Object.NotFound", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), (Object)expression));
        }
    }
}

