/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.math.BigInteger;
import java.util.List;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.ColumnExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;

public class NumericExpression
extends SQLExpression {
    public NumericExpression(SQLStatement stmt, JavaTypeMapping mapping, String sql) {
        super(stmt, null, mapping);
        this.st.clearStatement();
        this.st.append(sql);
    }

    public NumericExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, mapping);
    }

    public NumericExpression(Expression.MonadicOperator op, SQLExpression expr1) {
        super(op, expr1);
    }

    public NumericExpression(SQLExpression expr1, Expression.DyadicOperator op, SQLExpression expr2) {
        super(expr1, op, expr2);
    }

    public NumericExpression(SQLStatement stmt, JavaTypeMapping mapping, String functionName, List<SQLExpression> args) {
        super(stmt, mapping, functionName, args, null);
    }

    public NumericExpression(SQLStatement stmt, JavaTypeMapping mapping, String functionName, List<SQLExpression> args, List types) {
        super(stmt, mapping, functionName, args, types);
    }

    @Override
    public BooleanExpression eq(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, ExpressionUtils.getNumericExpression(expr));
        }
        return super.eq(expr);
    }

    @Override
    public BooleanExpression ne(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof NullLiteral) {
            return expr.ne(this);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, ExpressionUtils.getNumericExpression(expr));
        }
        return super.ne(expr);
    }

    @Override
    public BooleanExpression lt(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_LT, ExpressionUtils.getNumericExpression(expr));
        }
        return super.lt(expr);
    }

    @Override
    public BooleanExpression le(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_LTEQ, ExpressionUtils.getNumericExpression(expr));
        }
        return super.le(expr);
    }

    @Override
    public BooleanExpression gt(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_GT, ExpressionUtils.getNumericExpression(expr));
        }
        return super.gt(expr);
    }

    @Override
    public BooleanExpression ge(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_GTEQ, ExpressionUtils.getNumericExpression(expr));
        }
        return super.ge(expr);
    }

    @Override
    public BooleanExpression in(SQLExpression expr, boolean not) {
        return new BooleanExpression(this, not ? Expression.OP_NOTIN : Expression.OP_IN, expr);
    }

    @Override
    public SQLExpression add(SQLExpression expr) {
        if (expr instanceof NumericExpression) {
            return new NumericExpression(this, Expression.OP_ADD, expr).encloseInParentheses();
        }
        if (expr instanceof StringExpression) {
            StringExpression strExpr = (StringExpression)this.stmt.getSQLExpressionFactory().invokeOperation("numericToString", this, null);
            return new StringExpression(strExpr, Expression.OP_CONCAT, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(this, Expression.OP_ADD, ExpressionUtils.getNumericExpression(expr)).encloseInParentheses();
        }
        if (expr instanceof NullLiteral) {
            return expr;
        }
        return super.add(expr);
    }

    @Override
    public SQLExpression sub(SQLExpression expr) {
        if (expr instanceof NumericExpression) {
            return new NumericExpression(this, Expression.OP_SUB, expr).encloseInParentheses();
        }
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(this, Expression.OP_SUB, ExpressionUtils.getNumericExpression(expr)).encloseInParentheses();
        }
        return super.sub(expr);
    }

    @Override
    public SQLExpression mul(SQLExpression expr) {
        if (expr instanceof NumericExpression) {
            return new NumericExpression(this, Expression.OP_MUL, expr).encloseInParentheses();
        }
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(this, Expression.OP_MUL, ExpressionUtils.getNumericExpression(expr)).encloseInParentheses();
        }
        return super.mul(expr);
    }

    @Override
    public SQLExpression div(SQLExpression expr) {
        if (expr instanceof NumericExpression) {
            return new NumericExpression(this, Expression.OP_DIV, expr).encloseInParentheses();
        }
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(this, Expression.OP_DIV, ExpressionUtils.getNumericExpression(expr)).encloseInParentheses();
        }
        return super.div(expr);
    }

    @Override
    public SQLExpression mod(SQLExpression expr) {
        try {
            if (expr instanceof NumericExpression) {
                return this.stmt.getSQLExpressionFactory().invokeOperation("mod", this, expr).encloseInParentheses();
            }
            if (expr instanceof CharacterExpression) {
                return this.stmt.getSQLExpressionFactory().invokeOperation("mod", this, ExpressionUtils.getNumericExpression(expr)).encloseInParentheses();
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return new NumericExpression(this, Expression.OP_MOD, expr);
    }

    @Override
    public SQLExpression neg() {
        return new NumericExpression(Expression.OP_NEG, this);
    }

    @Override
    public SQLExpression com() {
        return this.neg().sub(new IntegerLiteral(this.stmt, this.mapping, BigInteger.ONE, this.parameterName));
    }

    @Override
    public SQLExpression bitAnd(SQLExpression expr) {
        return super.bitAnd(expr);
    }

    @Override
    public SQLExpression bitOr(SQLExpression expr) {
        return super.bitOr(expr);
    }
}

