/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.transaction.TransactionEventListener;
import org.datanucleus.util.NucleusLogger;

public class SerialisedLocalFileMapping
extends JavaTypeMapping
implements MappingCallbacks {
    public static final String EXTENSION_SERIALIZE_TO_FOLDER = "serializeToFileLocation";
    String folderName = null;

    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        super.initialize(mmd, table, clr);
        this.folderName = mmd.getValueForExtension(EXTENSION_SERIALIZE_TO_FOLDER);
        File folder = new File(this.folderName);
        if (!folder.exists()) {
            NucleusLogger.PERSISTENCE.debug((Object)("Creating folder for persistence data for field " + mmd.getFullFieldName() + " : folder=" + this.folderName));
            folder.mkdir();
        }
    }

    @Override
    public boolean includeInFetchStatement() {
        return false;
    }

    @Override
    public boolean includeInUpdateStatement() {
        return false;
    }

    @Override
    public boolean includeInInsertStatement() {
        return false;
    }

    @Override
    public Class getJavaType() {
        return this.mmd.getType();
    }

    @Override
    public void postInsert(final DNStateManager sm) {
        Object val = sm.provideField(this.mmd.getAbsoluteFieldNumber());
        this.serialiseFieldValue(sm, val);
        if (sm.getExecutionContext().getTransaction().isActive()) {
            sm.getExecutionContext().getTransaction().addTransactionEventListener(new TransactionEventListener(){

                public void transactionPreRollBack() {
                    File fieldFile = new File(SerialisedLocalFileMapping.this.getFilenameForStateManager(sm));
                    if (fieldFile.exists()) {
                        fieldFile.delete();
                    }
                }

                public void transactionStarted() {
                }

                public void transactionRolledBack() {
                }

                public void transactionPreFlush() {
                }

                public void transactionPreCommit() {
                }

                public void transactionFlushed() {
                }

                public void transactionEnded() {
                }

                public void transactionCommitted() {
                }

                public void transactionSetSavepoint(String name) {
                }

                public void transactionReleaseSavepoint(String name) {
                }

                public void transactionRollbackToSavepoint(String name) {
                }
            });
        }
    }

    @Override
    public void postFetch(DNStateManager sm) {
        Object value = this.deserialiseFieldValue(sm);
        sm.replaceField(this.mmd.getAbsoluteFieldNumber(), value);
    }

    @Override
    public void postUpdate(final DNStateManager sm) {
        final Object oldValue = this.deserialiseFieldValue(sm);
        Object val = sm.provideField(this.mmd.getAbsoluteFieldNumber());
        this.serialiseFieldValue(sm, val);
        if (sm.getExecutionContext().getTransaction().isActive()) {
            sm.getExecutionContext().getTransaction().addTransactionEventListener(new TransactionEventListener(){

                public void transactionPreRollBack() {
                    SerialisedLocalFileMapping.this.serialiseFieldValue(sm, oldValue);
                }

                public void transactionStarted() {
                }

                public void transactionRolledBack() {
                }

                public void transactionPreFlush() {
                }

                public void transactionPreCommit() {
                }

                public void transactionFlushed() {
                }

                public void transactionEnded() {
                }

                public void transactionCommitted() {
                }

                public void transactionSetSavepoint(String name) {
                }

                public void transactionReleaseSavepoint(String name) {
                }

                public void transactionRollbackToSavepoint(String name) {
                }
            });
        }
    }

    @Override
    public void preDelete(final DNStateManager sm) {
        final Object oldValue = sm.provideField(this.mmd.getAbsoluteFieldNumber());
        File fieldFile = new File(this.getFilenameForStateManager(sm));
        if (fieldFile.exists()) {
            fieldFile.delete();
        }
        if (sm.getExecutionContext().getTransaction().isActive()) {
            sm.getExecutionContext().getTransaction().addTransactionEventListener(new TransactionEventListener(){

                public void transactionPreRollBack() {
                    SerialisedLocalFileMapping.this.serialiseFieldValue(sm, oldValue);
                }

                public void transactionStarted() {
                }

                public void transactionRolledBack() {
                }

                public void transactionPreFlush() {
                }

                public void transactionPreCommit() {
                }

                public void transactionFlushed() {
                }

                public void transactionEnded() {
                }

                public void transactionCommitted() {
                }

                public void transactionSetSavepoint(String name) {
                }

                public void transactionReleaseSavepoint(String name) {
                }

                public void transactionRollbackToSavepoint(String name) {
                }
            });
        }
    }

    protected String getFilenameForStateManager(DNStateManager sm) {
        return this.folderName + System.getProperty("file.separator") + sm.getInternalObjectId();
    }

    protected void serialiseFieldValue(DNStateManager sm, Object value) {
        try {
            FileOutputStream fileOut = new FileOutputStream(this.getFilenameForStateManager(sm));
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(value);
            out.close();
            fileOut.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected Object deserialiseFieldValue(DNStateManager sm) {
        Object value = null;
        try {
            FileInputStream fileIn = new FileInputStream(this.getFilenameForStateManager(sm));
            ObjectInputStream in = new ObjectInputStream(fileIn);
            value = in.readObject();
            in.close();
            fileIn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return value;
    }
}

