/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.flush.FlushNonReferential;
import org.datanucleus.flush.FlushOrdered;
import org.datanucleus.flush.OperationQueue;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.table.ClassTable;

public class FlushReferential
extends FlushOrdered {
    public List<NucleusOptimisticException> execute(ExecutionContext ec, Collection<DNStateManager> primarySMs, Collection<DNStateManager> secondarySMs, OperationQueue smQueue) {
        List excps;
        DNStateManager sm;
        List flushExcps = null;
        HashSet<DNStateManager> unrelatedSMs = null;
        if (primarySMs != null) {
            Iterator<DNStateManager> opIter = primarySMs.iterator();
            while (opIter.hasNext()) {
                sm = opIter.next();
                if (sm.isEmbedded() || !this.isClassSuitableForBatching(ec, sm.getClassMetaData())) continue;
                if (unrelatedSMs == null) {
                    unrelatedSMs = new HashSet<DNStateManager>();
                }
                unrelatedSMs.add(sm);
                opIter.remove();
            }
        }
        if (secondarySMs != null) {
            Iterator<DNStateManager> smIter = secondarySMs.iterator();
            while (smIter.hasNext()) {
                sm = smIter.next();
                if (sm.isEmbedded() || !this.isClassSuitableForBatching(ec, sm.getClassMetaData())) continue;
                if (unrelatedSMs == null) {
                    unrelatedSMs = new HashSet();
                }
                unrelatedSMs.add(sm);
                smIter.remove();
            }
        }
        if (unrelatedSMs != null) {
            FlushNonReferential groupedFlush = new FlushNonReferential();
            flushExcps = groupedFlush.flushDeleteInsertUpdateGrouped(unrelatedSMs, ec);
        }
        if ((excps = super.execute(ec, primarySMs, secondarySMs, smQueue)) != null) {
            if (flushExcps == null) {
                flushExcps = excps;
            } else {
                flushExcps.addAll(excps);
            }
        }
        return flushExcps;
    }

    private boolean isClassSuitableForBatching(ExecutionContext ec, AbstractClassMetaData cmd) {
        if (cmd.hasRelations(ec.getClassLoaderResolver())) {
            return false;
        }
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)ec.getStoreManager();
        ClassTable table = (ClassTable)storeMgr.getDatastoreClass(cmd.getFullClassName(), ec.getClassLoaderResolver());
        do {
            if (this.isTableSuitableForBatching(table)) continue;
            return false;
        } while ((table = (ClassTable)table.getSuperDatastoreClass()) != null);
        return true;
    }

    private boolean isTableSuitableForBatching(ClassTable table) {
        if (table.hasExternalFkMappings()) {
            return false;
        }
        return !table.isObjectIdDatastoreAttributed();
    }
}

