/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.FetchPlanForClass;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.fieldmanager.ResultSetGetter;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.query.AbstractROF;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.ConcurrentReferenceHashMap;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public final class PersistentClassROF<T>
extends AbstractROF<T> {
    protected final AbstractClassMetaData rootCmd;
    protected Class<T> persistentClass;
    protected StatementClassMapping resultMapping = null;
    protected ResultSetGetter resultSetGetter = null;
    protected StatementClassMapping mappingDefinition;
    protected int[] mappedFieldNumbers;
    private Map resolvedClasses = new ConcurrentReferenceHashMap(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    public PersistentClassROF(ExecutionContext ec, ResultSet rs, FetchPlan fp, StatementClassMapping resultMapping, AbstractClassMetaData acmd, Class<T> persistentClass) {
        super(ec, rs, fp);
        this.resultMapping = resultMapping;
        this.rootCmd = acmd;
        this.persistentClass = persistentClass;
    }

    @Override
    public ResultSet getResultSet() {
        return this.rs;
    }

    @Override
    public T getObject() {
        AbstractClassMetaData cmd;
        Object[] subclasses;
        String[] subclasses2;
        String className = null;
        boolean requiresInheritanceCheck = true;
        String discrimValue = null;
        boolean hasDiscrimValue = false;
        boolean foundClassByDiscrim = false;
        StatementMappingIndex discrimMapIdx = this.resultMapping.getMappingForMemberPosition(SurrogateColumnType.DISCRIMINATOR.getFieldNumber());
        if (discrimMapIdx != null) {
            try {
                discrimValue = this.rs.getString(discrimMapIdx.getColumnPositions()[0]);
                if (discrimValue == null) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)"Value of discriminator is null so assuming object is null");
                    return null;
                }
                hasDiscrimValue = true;
                JavaTypeMapping discrimMapping = discrimMapIdx.getMapping();
                DiscriminatorMetaData dismd = discrimMapping != null ? discrimMapping.getTable().getDiscriminatorMetaData() : null;
                className = this.ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discrimValue, dismd);
                if (className != null) {
                    foundClassByDiscrim = true;
                }
                requiresInheritanceCheck = false;
            }
            catch (SQLException sqle) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)("Exception obtaining value of discriminator : " + sqle.getMessage()));
            }
        } else if (this.resultMapping.getNucleusTypeColumnName() != null) {
            try {
                className = this.rs.getString(this.resultMapping.getNucleusTypeColumnName());
                if (className == null) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)"Value of determiner column is null so assuming object is null");
                    return null;
                }
                className = className.trim();
                requiresInheritanceCheck = false;
            }
            catch (SQLException sqle) {
                // empty catch block
            }
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        Class pcClassForObject = this.persistentClass;
        if (className != null) {
            Class cls = (Class)this.resolvedClasses.get(className);
            if (cls != null) {
                pcClassForObject = cls;
            } else {
                pcClassForObject = this.persistentClass.getName().equals(className) ? this.persistentClass : clr.classForName(className, this.persistentClass.getClassLoader());
                this.resolvedClasses.put(className, pcClassForObject);
            }
        }
        if (requiresInheritanceCheck && ((subclasses2 = this.ec.getMetaDataManager().getSubclassesForClass(pcClassForObject.getName(), false)) == null || subclasses2.length == 0)) {
            requiresInheritanceCheck = false;
        }
        String warnMsg = null;
        if (Modifier.isAbstract(pcClassForObject.getModifiers()) && (subclasses = this.ec.getMetaDataManager().getSubclassesForClass(pcClassForObject.getName(), false)) != null) {
            Class concreteSubclass = null;
            int numConcreteSubclasses = 0;
            for (int i = 0; i < subclasses.length; ++i) {
                Class subcls = clr.classForName(subclasses[i]);
                if (Modifier.isAbstract(subcls.getModifiers())) continue;
                ++numConcreteSubclasses;
                concreteSubclass = subcls;
            }
            if (numConcreteSubclasses == 1) {
                NucleusLogger.DATASTORE_RETRIEVE.warn((Object)Localiser.msg((String)"052300", (Object[])new Object[]{pcClassForObject.getName(), concreteSubclass.getName()}));
                pcClassForObject = concreteSubclass;
            } else {
                if (numConcreteSubclasses == 0) {
                    throw new NucleusUserException(Localiser.msg((String)"052301", (Object[])new Object[]{pcClassForObject.getName()}));
                }
                Object warnMsgSuffix = hasDiscrimValue && !foundClassByDiscrim ? "No persistent class could be found that matches the discriminator value '" + discrimValue + "'. Has the metadata for all persistent concrete subclasses been added?" : "Really you need a discriminator to help identifying the type.";
                warnMsg = "Found type=" + pcClassForObject + " but abstract and more than 1 concrete subclass (" + StringUtils.objectArrayToString((Object[])subclasses) + ") when searching immediate subclasses. Choosing " + concreteSubclass + ". " + (String)warnMsgSuffix;
                pcClassForObject = concreteSubclass;
                requiresInheritanceCheck = true;
            }
        }
        if ((cmd = this.ec.getMetaDataManager().getMetaDataForClass(pcClassForObject, clr)) == null) {
            return null;
        }
        int[] fieldNumbers = this.resultMapping.getMemberNumbers();
        if (this.resultSetGetter == null) {
            if (this.rootCmd instanceof InterfaceMetaData) {
                this.mappingDefinition = new StatementClassMapping();
                this.mappingDefinition.setNucleusTypeColumnName(this.resultMapping.getNucleusTypeColumnName());
                this.mappedFieldNumbers = new int[fieldNumbers.length];
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    AbstractMemberMetaData mmd = this.rootCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                    this.mappedFieldNumbers[i] = cmd.getAbsolutePositionOfMember(mmd.getName());
                    this.mappingDefinition.addMappingForMember(this.mappedFieldNumbers[i], this.resultMapping.getMappingForMemberPosition(fieldNumbers[i]));
                }
            } else {
                this.mappingDefinition = this.resultMapping;
                this.mappedFieldNumbers = fieldNumbers;
            }
            this.resultSetGetter = new ResultSetGetter(this.ec, this.rs, this.mappingDefinition, this.rootCmd);
        }
        Object surrogateVersion = null;
        VersionMetaData vermd = cmd.getVersionMetaDataForClass();
        if (vermd != null) {
            StatementMappingIndex versionMappingIdx = null;
            versionMappingIdx = vermd.getMemberName() == null ? this.resultMapping.getMappingForMemberPosition(SurrogateColumnType.VERSION.getFieldNumber()) : this.resultMapping.getMappingForMemberPosition(cmd.getMetaDataForMember(vermd.getMemberName()).getAbsoluteFieldNumber());
            if (versionMappingIdx != null) {
                surrogateVersion = versionMappingIdx.getMapping().getObject(this.ec, this.rs, versionMappingIdx.getColumnPositions());
            }
        }
        if (this.persistentClass.isInterface() && !cmd.isImplementationOfPersistentDefinition() && (cmd = this.ec.getMetaDataManager().getMetaDataForInterface(this.persistentClass, clr)) == null) {
            cmd = this.ec.getMetaDataManager().getMetaDataForClass(pcClassForObject, clr);
        }
        FetchPlanForClass fpClass = this.fp.getFetchPlanForClass(cmd);
        ArrayList<Integer> memberNumbersToStoreTmp = new ArrayList<Integer>();
        for (int i = 0; i < this.mappedFieldNumbers.length; ++i) {
            int recDepth;
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(this.mappedFieldNumbers[i]);
            if (!RelationType.isRelationSingleValued((RelationType)mmd.getRelationType(clr)) || (recDepth = fpClass.getRecursionDepthForMember(this.mappedFieldNumbers[i])) != 0) continue;
            memberNumbersToStoreTmp.add(this.mappedFieldNumbers[i]);
        }
        int[] memberNumbersToStore = null;
        int[] memberNumbersToLoad = this.mappedFieldNumbers;
        if (memberNumbersToStoreTmp.size() > 0) {
            int[] memberNumberTmp = new int[this.mappedFieldNumbers.length - memberNumbersToStoreTmp.size()];
            int j = 0;
            for (int i = 0; i < fieldNumbers.length; ++i) {
                if (memberNumbersToStoreTmp.contains(this.mappedFieldNumbers[i])) continue;
                memberNumberTmp[j++] = this.mappedFieldNumbers[i];
            }
            memberNumbersToLoad = memberNumberTmp;
            memberNumbersToStore = new int[memberNumbersToStoreTmp.size()];
            j = 0;
            for (Integer absNum : memberNumbersToStoreTmp) {
                memberNumbersToStore[j++] = absNum;
            }
        }
        Object obj = null;
        boolean needToSetVersion = false;
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkNumbers = cmd.getPKMemberPositions();
            boolean nullObject = true;
            block11: for (int i = 0; i < pkNumbers.length; ++i) {
                StatementMappingIndex pkIdx = this.mappingDefinition.getMappingForMemberPosition(pkNumbers[i]);
                if (pkIdx == null) {
                    throw new NucleusException("You have just executed an SQL statement yet the information for the primary key column(s) is not available! Please generate a testcase and report this issue");
                }
                int[] colPositions = pkIdx.getColumnPositions();
                for (int j = 0; j < colPositions.length; ++j) {
                    try {
                        if (this.rs.getObject(colPositions[j]) != null) {
                            nullObject = false;
                            continue block11;
                        }
                    }
                    catch (SQLException sqle) {
                        NucleusLogger.DATASTORE_RETRIEVE.warn((Object)"Exception thrown while retrieving results ", (Throwable)sqle);
                    }
                    if (!nullObject) continue block11;
                }
            }
            if (!nullObject) {
                Object id;
                String idClassName;
                if (warnMsg != null) {
                    NucleusLogger.DATASTORE_RETRIEVE.warn((Object)warnMsg);
                }
                if ((idClassName = IdentityUtils.getTargetClassNameForIdentity((Object)(id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)this.ec, (AbstractClassMetaData)cmd, (Class)pcClassForObject, (boolean)requiresInheritanceCheck, (FieldManager)this.resultSetGetter)))) != null) {
                    pcClassForObject = clr.classForName(idClassName);
                }
                obj = this.findObjectWithIdAndLoadFields(id, memberNumbersToLoad, memberNumbersToStore, pcClassForObject, cmd, surrogateVersion);
            }
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            StatementMappingIndex datastoreIdMapping = this.resultMapping.getMappingForMemberPosition(SurrogateColumnType.DATASTORE_ID.getFieldNumber());
            JavaTypeMapping mapping = datastoreIdMapping.getMapping();
            Object id = mapping.getObject(this.ec, this.rs, datastoreIdMapping.getColumnPositions());
            if (id != null) {
                String idClassName = IdentityUtils.getTargetClassNameForIdentity((Object)id);
                if (!pcClassForObject.getName().equals(idClassName)) {
                    id = this.ec.getNucleusContext().getIdentityManager().getDatastoreId(pcClassForObject.getName(), IdentityUtils.getTargetKeyForDatastoreIdentity((Object)id));
                }
                if (warnMsg != null) {
                    NucleusLogger.DATASTORE_RETRIEVE.warn((Object)warnMsg);
                }
                if (this.mappedFieldNumbers == null) {
                    obj = this.ec.findObject(id, false, requiresInheritanceCheck, null);
                    needToSetVersion = true;
                } else {
                    obj = this.findObjectWithIdAndLoadFields(id, memberNumbersToLoad, memberNumbersToStore, requiresInheritanceCheck ? null : pcClassForObject, cmd, surrogateVersion);
                }
            }
        } else if (cmd.getIdentityType() == IdentityType.NONDURABLE) {
            String classNameForId = className;
            if (className == null) {
                classNameForId = cmd.getFullClassName();
            }
            Object id = this.ec.newObjectId(classNameForId, null);
            if (this.mappedFieldNumbers == null) {
                obj = this.ec.findObject(id, false, requiresInheritanceCheck, null);
                needToSetVersion = true;
            } else {
                obj = this.findObjectWithIdAndLoadFields(id, fieldNumbers, memberNumbersToStore, pcClassForObject, cmd, surrogateVersion);
            }
        }
        if (obj != null && needToSetVersion) {
            DNStateManager objSM;
            Object verFieldValue;
            int versionFieldNumber;
            if (surrogateVersion != null) {
                DNStateManager objSM2 = this.ec.findStateManager(obj);
                objSM2.setVersion(surrogateVersion);
            } else if (vermd != null && vermd.getMemberName() != null && this.resultMapping.getMappingForMemberPosition(versionFieldNumber = this.rootCmd.getMetaDataForMember(vermd.getMemberName()).getAbsoluteFieldNumber()) != null && (verFieldValue = (objSM = this.ec.findStateManager(obj)).provideField(versionFieldNumber)) != null) {
                objSM.setVersion(verFieldValue);
            }
        }
        return (T)obj;
    }

    private T findObjectWithIdAndLoadFields(Object id, final int[] membersToLoad, final int[] membersToStore, Class pcClass, final AbstractClassMetaData cmd, final Object surrogateVersion) {
        return (T)this.ec.findObject(id, new FieldValues(){

            public void fetchFields(DNStateManager sm) {
                Object verFieldValue;
                VersionMetaData vermd;
                int versionFieldNumber;
                PersistentClassROF.this.resultSetGetter.setStateManager(sm);
                sm.replaceFields(membersToLoad, (FieldManager)PersistentClassROF.this.resultSetGetter, false);
                if (surrogateVersion != null) {
                    sm.setVersion(surrogateVersion);
                } else if (cmd.getVersionMetaData() != null && cmd.getVersionMetaData().getMemberName() != null && PersistentClassROF.this.resultMapping.getMappingForMemberPosition(versionFieldNumber = PersistentClassROF.this.rootCmd.getMetaDataForMember((vermd = cmd.getVersionMetaData()).getMemberName()).getAbsoluteFieldNumber()) != null && (verFieldValue = sm.provideField(versionFieldNumber)) != null) {
                    sm.setVersion(verFieldValue);
                }
                if (membersToStore != null) {
                    for (int i = 0; i < membersToStore.length; ++i) {
                        StatementMappingIndex mapIdx = PersistentClassROF.this.mappingDefinition.getMappingForMemberPosition(membersToStore[i]);
                        JavaTypeMapping m = mapIdx.getMapping();
                        if (!(m instanceof PersistableMapping)) continue;
                        AbstractClassMetaData memberCmd = ((PersistableMapping)m).getClassMetaData();
                        Object memberId = null;
                        if (memberCmd.getIdentityType() == IdentityType.DATASTORE) {
                            memberId = MappingHelper.getDatastoreIdentityForResultSetRow(PersistentClassROF.this.ec, m, PersistentClassROF.this.rs, mapIdx.getColumnPositions(), memberCmd);
                        } else {
                            if (memberCmd.getIdentityType() != IdentityType.APPLICATION) break;
                            memberId = MappingHelper.getApplicationIdentityForResultSetRow(PersistentClassROF.this.ec, m, PersistentClassROF.this.rs, mapIdx.getColumnPositions(), memberCmd);
                        }
                        if (memberId == null) {
                            sm.replaceField(membersToStore[i], null);
                            continue;
                        }
                        sm.storeFieldValue(membersToStore[i], memberId);
                    }
                }
            }

            public void fetchNonLoadedFields(DNStateManager sm) {
                PersistentClassROF.this.resultSetGetter.setStateManager(sm);
                if (PersistentClassROF.this.updateAllFields) {
                    sm.replaceFields(membersToLoad, (FieldManager)PersistentClassROF.this.resultSetGetter);
                } else {
                    sm.replaceNonLoadedFields(membersToLoad, (FieldManager)PersistentClassROF.this.resultSetGetter);
                }
                if (membersToStore != null) {
                    for (int i = 0; i < membersToStore.length; ++i) {
                        if (sm.isFieldLoaded(membersToStore[i]) && !PersistentClassROF.this.updateAllFields) continue;
                        StatementMappingIndex mapIdx = PersistentClassROF.this.mappingDefinition.getMappingForMemberPosition(membersToStore[i]);
                        JavaTypeMapping m = mapIdx.getMapping();
                        Object memberId = null;
                        if (m instanceof PersistableMapping) {
                            AbstractClassMetaData memberCmd = ((PersistableMapping)m).getClassMetaData();
                            if (memberCmd.getIdentityType() == IdentityType.DATASTORE) {
                                memberId = MappingHelper.getDatastoreIdentityForResultSetRow(PersistentClassROF.this.ec, m, PersistentClassROF.this.rs, mapIdx.getColumnPositions(), memberCmd);
                            } else {
                                if (memberCmd.getIdentityType() != IdentityType.APPLICATION) break;
                                memberId = MappingHelper.getApplicationIdentityForResultSetRow(PersistentClassROF.this.ec, m, PersistentClassROF.this.rs, mapIdx.getColumnPositions(), memberCmd);
                            }
                        }
                        if (PersistentClassROF.this.updateAllFields && sm.isFieldLoaded(membersToStore[i])) {
                            sm.unloadField(membersToStore[i]);
                        }
                        if (memberId == null) {
                            sm.replaceField(membersToStore[i], null);
                            continue;
                        }
                        sm.storeFieldValue(membersToStore[i], memberId);
                    }
                }
            }

            public FetchPlan getFetchPlanForLoading() {
                return PersistentClassROF.this.fp;
            }
        }, pcClass, this.ignoreCache, false);
    }
}

