/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.CloudSpannerTypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.mapping.column.BigIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BinaryStreamColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BitColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BlobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BooleanColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.CharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.ClobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DateColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DecimalColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DoubleColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.FloatColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.IntegerColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NCharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NumericColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.RealColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.SmallIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimeColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimestampColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TinyIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarCharColumnMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.method.OptionalGetMethod;
import org.datanucleus.store.rdbms.sql.method.OptionalIsPresentMethod;
import org.datanucleus.store.rdbms.sql.method.OptionalOrElseMethod;
import org.datanucleus.store.rdbms.sql.method.StringCharAt2Method;
import org.datanucleus.store.rdbms.sql.method.StringEndsWith2Method;
import org.datanucleus.store.rdbms.sql.method.StringEqualsIgnoreCaseMethod;
import org.datanucleus.store.rdbms.sql.method.StringEqualsMethod;
import org.datanucleus.store.rdbms.sql.method.StringIndexOf5Method;
import org.datanucleus.store.rdbms.sql.method.StringLength3Method;
import org.datanucleus.store.rdbms.sql.method.StringMatchesMethod;
import org.datanucleus.store.rdbms.sql.method.StringReplaceAllMethod;
import org.datanucleus.store.rdbms.sql.method.StringStartsWith4Method;
import org.datanucleus.store.rdbms.sql.method.StringSubstring3Method;
import org.datanucleus.store.rdbms.sql.method.StringToLowerMethod;
import org.datanucleus.store.rdbms.sql.method.StringToUpperMethod;
import org.datanucleus.store.rdbms.sql.method.StringTrimLeftMethod;
import org.datanucleus.store.rdbms.sql.method.StringTrimMethod;
import org.datanucleus.store.rdbms.sql.method.StringTrimRightMethod;
import org.datanucleus.store.rdbms.sql.method.TemporalDayMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalDayOfWeekMethod7;
import org.datanucleus.store.rdbms.sql.method.TemporalDayOfYearMethod;
import org.datanucleus.store.rdbms.sql.method.TemporalHourMethod6;
import org.datanucleus.store.rdbms.sql.method.TemporalIsoWeekMethod;
import org.datanucleus.store.rdbms.sql.method.TemporalIsoYearMethod;
import org.datanucleus.store.rdbms.sql.method.TemporalMinuteMethod6;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthJavaMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalQuarterMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalSecondMethod7;
import org.datanucleus.store.rdbms.sql.method.TemporalWeekMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalYearMethod5;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class CloudSpannerAdapter
extends BaseDatastoreAdapter {
    public static final String CLOUD_SPANNER_RESERVED_KEYWORDS = "ALL,AND,ANY,ARRAY,AS,ASC,ASSERT_ROWS_MODIFIED,AT,BETWEEN,BY,CASE,CAST,COLLATE,CONTAINS,CREATE,CROSS,CUBE,CURRENT,DEFAULT,DEFINE,DESC,DISTINCT,ELSE,END,ENUM,ESCAPE,EXCEPT,EXCLUDE,EXISTS,EXTRACT,FALSE,FETCH,FOLLOWING,FOR,FROM,FULL,GROUP,GROUPING,GROUPS,HASH,HAVING,IF,IGNORE,IN,INNER,INTERSECT,INTERVAL,INTO,IS,JOIN,LATERAL,LEFT,LIKE,LIMIT,LOOKUP,MERGE,NATURAL,NEW,NO,NOT,NULL,NULLS,OF,ON,OR,ORDER,OUTER,OVER,PARTITION,PRECEDING,PROTO,RANGE,RECURSIVE,RESPECT,RIGHT,ROLLUP,ROWS,SELECT,SET,SOME,STRUCT,TABLESAMPLE,THEN,TO,TREAT,TRUE,UNBOUNDED,UNION,UNNEST,USING,WHEN,WHERE,WINDOW,WITH,WITHIN";

    public CloudSpannerAdapter(DatabaseMetaData metadata) {
        super(metadata);
        NucleusLogger.DATASTORE.debug((Object)"Initializing Cloud Spanner Adapter");
        this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)CLOUD_SPANNER_RESERVED_KEYWORDS));
        this.supportedOptions.remove("IdentityColumns");
        this.supportedOptions.remove("Sequences");
        this.supportedOptions.remove("ValueGeneratorUUIDString");
        this.supportedOptions.remove("SomeAllAnySubqueries");
        this.supportedOptions.remove("AlterTableDropForeignKey_Syntax");
        this.supportedOptions.remove("CharColumnsPaddedWithSpaces");
        this.supportedOptions.remove("NullEqualsEmptyString");
        this.supportedOptions.remove("UniqueInEndCreateStatements");
        this.supportedOptions.remove("NullsInCandidateKeys");
        this.supportedOptions.remove("ColumnOptions_NullsKeyword");
        this.supportedOptions.remove("ColumnOptions_DefaultKeyword");
        this.supportedOptions.remove("ColumnOptions_DefaultWithNotNull");
        this.supportedOptions.remove("ColumnOptions_DefaultBeforeNull");
        this.supportedOptions.remove("IdentityNullSpecification");
        this.supportedOptions.remove("IdentityColumnTypeSpecification");
        this.supportedOptions.remove("LockRowUsingSelectForUpdate");
        this.supportedOptions.remove("LockRowSelectForUpdateNowait");
        this.supportedOptions.remove("LockRowUsingOptionAfterFrom");
        this.supportedOptions.remove("LockRowUsingOptionWithinJoin");
        this.supportedOptions.remove("DistinctWithSelectForUpdate");
        this.supportedOptions.remove("GroupingWithSelectForUpdate");
        this.supportedOptions.remove("HavingWithSelectForUpdate");
        this.supportedOptions.remove("OrderingWithSelectForUpdate");
        this.supportedOptions.remove("MultipleTablesWithSelectForUpdate");
        this.supportedOptions.remove("CreateIndexesBeforeForeignKeys");
        this.supportedOptions.remove("AccessParentQueryInSubquery");
        this.supportedOptions.remove("OrderByWithNullsDirectives");
        this.supportedOptions.remove("OrderByNullsUsingIsNull");
        this.supportedOptions.remove("OrderByNullsUsingColumnIsNull");
        this.supportedOptions.remove("OrderByNullsUsingCaseNull");
        this.supportedOptions.remove("StoredProcs");
        this.supportedOptions.remove("FkDeleteActionCascade");
        this.supportedOptions.remove("FkDeleteActionRestrict");
        this.supportedOptions.remove("FkDeleteActionDefault");
        this.supportedOptions.remove("FkDeleteActionNull");
        this.supportedOptions.remove("FkUpdateActionCascade");
        this.supportedOptions.remove("FkUpdateActionRestrict");
        this.supportedOptions.remove("FkUpdateActionDefault");
        this.supportedOptions.remove("FkUpdateActionNull");
        this.supportedOptions.remove("PrimaryKeyInCreateStatements");
        this.supportedOptions.remove("CheckInCreateStatements");
        this.supportedOptions.remove("FKInEndCreateStatements");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("TxIsolationReadCommitted");
        this.supportedOptions.remove("TxIsolationReadUncommitted");
        this.supportedOptions.remove("TxIsolationReadRepeatableRead");
        this.supportedOptions.remove("EscapeExpressionInLikePredicate");
        this.supportedOptions.add("BitIsReallyBoolean");
        this.supportedOptions.add("ProjectionInTableReferenceJoins");
        this.supportedOptions.add("GroupByIncludesAllSelectPrimaries");
        this.supportedOptions.add("ANSI_CrossJoinAsInner11_Syntax");
        this.supportedOptions.add("BlobSetUsingSetString");
        this.supportedOptions.add("ClobSetUsingSetString");
        this.supportedOptions.add("OrderByUsingSelectColumnIndex");
        this.supportedOptions.add("UseUnionAll");
        this.supportedOptions.add("RawPrefixLikeStatements");
    }

    @Override
    public String getVendorID() {
        return "cloudspanner";
    }

    @Override
    public int getTransactionIsolationForSchemaCreation() {
        return 8;
    }

    @Override
    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        CloudSpannerTypeInfo sqlType = new CloudSpannerTypeInfo("BOOL", -7, 0, null, null, null, 1, false, 2, true, false, false, "BOOL", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-7, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("BYTES", 2004, 0xA00000, null, null, "(length)", 1, false, 2, true, false, false, "BYTES", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2004, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("STRING", 1, 0x280000, null, null, "(length)", 1, true, 1, true, false, false, "STRING", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)1, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("STRING", 2005, 0x280000, null, null, "(length)", 1, true, 3, true, false, false, "STRING", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2005, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("NUMERIC", 3, 0x280000, null, null, null, 1, false, 2, false, false, false, "NUMERIC", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)3, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("FLOAT64", 6, 15, null, null, null, 1, false, 2, false, false, false, "FLOAT64", 0, 0, 2);
        this.addSQLTypeForJDBCType(handler, mconn, (short)6, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("INT64", 4, 19, null, null, null, 1, false, 2, false, false, false, "INT64", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)4, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("BYTES", -4, 0xA00000, null, null, "(MAX)", 1, false, 2, true, false, false, "BYTES", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-4, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("STRING", -1, 0x280000, null, null, "(MAX)", 1, true, 3, true, false, false, "STRING", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-1, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("FLOAT64", 7, 15, null, null, null, 1, false, 2, false, false, false, "FLOAT64", 0, 0, 2);
        this.addSQLTypeForJDBCType(handler, mconn, (short)7, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("INT64", 5, 19, null, null, null, 1, false, 2, false, false, false, "INT64", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)5, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("TIMESTAMP", 92, 35, "TIMESTAMP ", null, null, 1, false, 2, true, false, false, "TIMESTAMP", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)92, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("INT64", -6, 19, null, null, null, 1, false, 2, false, false, false, "INT64", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-6, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("BYTES", -3, 0xA00000, null, null, "(length)", 1, false, 2, true, false, false, "BYTES", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-3, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("STRING", 12, 0x280000, null, null, "(length)", 1, true, 3, true, false, false, "STRING", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)12, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("STRING", -15, 0x280000, null, null, "(length)", 1, true, 3, true, false, false, "STRING", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-15, sqlType, true);
        sqlType = new CloudSpannerTypeInfo("STRING", 2011, 0x280000, null, null, "(length)", 1, true, 3, true, false, false, "STRING", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2011, sqlType, true);
    }

    @Override
    public boolean isValidPrimaryKeyType(JdbcType jdbcType) {
        return jdbcType != JdbcType.NUMERIC && jdbcType != JdbcType.DECIMAL;
    }

    @Override
    public boolean sequenceExists(Connection conn, String catalogName, String schemaName, String seqName) {
        return false;
    }

    @Override
    public String getCreateDatabaseStatement(String catalogName, String schemaName) {
        return "CREATE DATABASE " + schemaName;
    }

    @Override
    public String getDropDatabaseStatement(String catalogName, String schemaName) {
        return "DROP DATABASE " + schemaName;
    }

    @Override
    public String getDropTableStatement(Table table) {
        return "DROP TABLE " + table.toString();
    }

    @Override
    public String getCreateTableStatement(TableImpl table, Column[] columns, Properties props, IdentifierFactory factory) {
        StringBuilder createStmt = new StringBuilder();
        String indent = this.getContinuationString().length() == 0 ? "" : "    ";
        createStmt.append("CREATE TABLE ").append(table.toString()).append(this.getContinuationString()).append("(").append(this.getContinuationString());
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                createStmt.append(",").append(this.getContinuationString());
            }
            createStmt.append(indent).append(columns[i].getSQLDefinition());
        }
        createStmt.append(this.getContinuationString()).append(")");
        PrimaryKey pk = table.getPrimaryKey();
        if (pk != null && pk.getNumberOfColumns() > 0) {
            createStmt.append(indent).append(pk.toString());
        }
        return createStmt.toString();
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getEscapePatternExpression() {
        return "";
    }

    @Override
    public String getEscapeCharacter() {
        return "\\\\";
    }

    @Override
    public String getRangeByLimitEndOfStatementClause(long offset, long count, boolean hasOrdering) {
        String limitClause = String.format("LIMIT %d ", count);
        return offset > 0L ? limitClause + String.format("OFFSET %d ", offset) : limitClause;
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new CloudSpannerTypeInfo(rs);
    }

    @Override
    public boolean isStatementCancel(SQLException sqle) {
        return sqle.getErrorCode() == 1;
    }

    @Override
    public boolean isStatementTimeout(SQLException sqle) {
        return sqle.getErrorCode() == 4;
    }

    @Override
    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("YEAR".equals(methodName)) {
                return TemporalYearMethod5.class;
            }
            if ("MONTH".equals(methodName)) {
                return TemporalMonthMethod5.class;
            }
            if ("MONTH_JAVA".equals(methodName)) {
                return TemporalMonthJavaMethod5.class;
            }
            if ("DAY".equals(methodName)) {
                return TemporalDayMethod5.class;
            }
            if ("HOUR".equals(methodName)) {
                return TemporalHourMethod6.class;
            }
            if ("MINUTE".equals(methodName)) {
                return TemporalMinuteMethod6.class;
            }
            if ("SECOND".equals(methodName)) {
                return TemporalSecondMethod7.class;
            }
            if ("WEEK".equals(methodName)) {
                return TemporalWeekMethod5.class;
            }
            if ("QUARTER".equals(methodName)) {
                return TemporalQuarterMethod5.class;
            }
            if ("DAY_OF_WEEK".equals(methodName)) {
                return TemporalDayOfWeekMethod7.class;
            }
            if ("DAY_OF_YEAR".equals(methodName)) {
                return TemporalDayOfYearMethod.class;
            }
            if ("ISOYEAR".equals(methodName)) {
                return TemporalIsoYearMethod.class;
            }
            if ("ISOWEEK".equals(methodName)) {
                return TemporalIsoWeekMethod.class;
            }
        } else {
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if ("java.lang.String".equals(className)) {
                if ("charAt".equals(methodName)) {
                    return StringCharAt2Method.class;
                }
                if ("endsWith".equals(methodName)) {
                    return StringEndsWith2Method.class;
                }
                if ("equals".equals(methodName)) {
                    return StringEqualsMethod.class;
                }
                if ("equalsIgnoreCase".equals(methodName)) {
                    return StringEqualsIgnoreCaseMethod.class;
                }
                if ("indexOf".equals(methodName)) {
                    return StringIndexOf5Method.class;
                }
                if ("length".equals(methodName)) {
                    return StringLength3Method.class;
                }
                if ("matches".equals(methodName)) {
                    return StringMatchesMethod.class;
                }
                if ("replaceAll".equals(methodName)) {
                    return StringReplaceAllMethod.class;
                }
                if ("startsWith".equals(methodName)) {
                    return StringStartsWith4Method.class;
                }
                if ("substring".equals(methodName)) {
                    return StringSubstring3Method.class;
                }
                if ("toUpperCase".equals(methodName)) {
                    return StringToUpperMethod.class;
                }
                if ("toLowerCase".equals(methodName)) {
                    return StringToLowerMethod.class;
                }
                if ("trim".equals(methodName)) {
                    return StringTrimMethod.class;
                }
                if ("trimLeft".equals(methodName)) {
                    return StringTrimLeftMethod.class;
                }
                if ("trimRight".equals(methodName)) {
                    return StringTrimRightMethod.class;
                }
            }
            if ("java.util.Date".equals(className) || cls != null && Date.class.isAssignableFrom(cls)) {
                if ("getDay".equals(methodName)) {
                    return TemporalDayMethod5.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod7.class;
                }
                if ("getDate".equals(methodName)) {
                    return TemporalDayMethod5.class;
                }
                if ("getMonth".equals(methodName)) {
                    return TemporalMonthJavaMethod5.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod5.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod6.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod6.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod7.class;
                }
            }
            if ("java.time.LocalTime".equals(className)) {
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod6.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod6.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod7.class;
                }
            }
            if ("java.time.LocalDate".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod5.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod5.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod5.class;
                }
            }
            if ("java.time.LocalDateTime".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod5.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod5.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod5.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod6.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod6.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod7.class;
                }
            }
            if ("java.time.MonthDay".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod5.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod5.class;
                }
            }
            if ("java.time.Period".equals(className)) {
                if ("getMonths".equals(methodName)) {
                    return TemporalMonthMethod5.class;
                }
                if ("getDays".equals(methodName)) {
                    return TemporalDayMethod5.class;
                }
                if ("getYears".equals(methodName)) {
                    return TemporalYearMethod5.class;
                }
            }
            if ("java.time.YearMonth".equals(className)) {
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod5.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod5.class;
                }
            }
            if ("java.util.Optional".equals(className)) {
                if ("get".equals(methodName)) {
                    return OptionalGetMethod.class;
                }
                if ("isPresent".equals(methodName)) {
                    return OptionalIsPresentMethod.class;
                }
                if ("orElse".equals(methodName)) {
                    return OptionalOrElseMethod.class;
                }
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }

    @Override
    protected void loadColumnMappings(PluginManager mgr, ClassLoaderResolver clr) {
        this.registerColumnMapping(Boolean.class.getName(), BitColumnMapping.class, JDBCType.BIT, null, false);
        this.registerColumnMapping(Boolean.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "STRING", false);
        this.registerColumnMapping(Boolean.class.getName(), BooleanColumnMapping.class, JDBCType.BOOLEAN, "BOOLEAN", true);
        this.registerColumnMapping(Boolean.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "INT64", false);
        this.registerColumnMapping(Boolean.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, null, false);
        this.registerColumnMapping(Byte.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "INT64", true);
        this.registerColumnMapping(Byte.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, null, false);
        this.registerColumnMapping(Character.class.getName(), NVarcharColumnMapping.class, JDBCType.NVARCHAR, "STRING", true);
        this.registerColumnMapping(Character.class.getName(), CharColumnMapping.class, JDBCType.CHAR, null, false);
        this.registerColumnMapping(Character.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INT64", false);
        this.registerColumnMapping(Double.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, "FLOAT64", true);
        this.registerColumnMapping(Double.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, null, false);
        this.registerColumnMapping(Double.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Float.class.getName(), FloatColumnMapping.class, JDBCType.FLOAT, "FLOAT64", true);
        this.registerColumnMapping(Float.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, null, false);
        this.registerColumnMapping(Float.class.getName(), RealColumnMapping.class, JDBCType.REAL, null, false);
        this.registerColumnMapping(Float.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, null, false);
        this.registerColumnMapping(Float.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Integer.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INT64", true);
        this.registerColumnMapping(Integer.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, null, false);
        this.registerColumnMapping(Integer.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Integer.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, null, false);
        this.registerColumnMapping(Integer.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, null, false);
        this.registerColumnMapping(Long.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "INT64", true);
        this.registerColumnMapping(Long.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, null, false);
        this.registerColumnMapping(Long.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Long.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, null, false);
        this.registerColumnMapping(Long.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, null, false);
        this.registerColumnMapping(Short.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "INT64", true);
        this.registerColumnMapping(Short.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, null, false);
        this.registerColumnMapping(Short.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, null, false);
        this.registerColumnMapping(String.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, null, false);
        this.registerColumnMapping(String.class.getName(), CharColumnMapping.class, JDBCType.CHAR, null, false);
        this.registerColumnMapping(String.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "INT64", false);
        this.registerColumnMapping(String.class.getName(), ClobColumnMapping.class, JDBCType.CLOB, null, false);
        this.registerColumnMapping(String.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, null, false);
        this.registerColumnMapping(String.class.getName(), LongVarcharColumnMapping.class, JDBCType.LONGVARCHAR, null, false);
        this.registerColumnMapping(String.class.getName(), NVarcharColumnMapping.class, JDBCType.NVARCHAR, "STRING", true);
        this.registerColumnMapping(String.class.getName(), NCharColumnMapping.class, JDBCType.NCHAR, null, false);
        this.registerColumnMapping(BigDecimal.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, null, false);
        this.registerColumnMapping(BigDecimal.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerColumnMapping(BigInteger.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerColumnMapping(java.sql.Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", true);
        this.registerColumnMapping(java.sql.Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(java.sql.Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, null, false);
        this.registerColumnMapping(java.sql.Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "STRING", false);
        this.registerColumnMapping(java.sql.Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "INT64", false);
        this.registerColumnMapping(Time.class.getName(), TimeColumnMapping.class, JDBCType.TIME, null, false);
        this.registerColumnMapping(Time.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(Time.class.getName(), CharColumnMapping.class, JDBCType.CHAR, null, false);
        this.registerColumnMapping(Time.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "STRING", false);
        this.registerColumnMapping(Time.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "INT64", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(Timestamp.class.getName(), CharColumnMapping.class, JDBCType.CHAR, null, false);
        this.registerColumnMapping(Timestamp.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "STRING", false);
        this.registerColumnMapping(Timestamp.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimeColumnMapping.class, JDBCType.TIME, null, false);
        this.registerColumnMapping(Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", true);
        this.registerColumnMapping(Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, null, false);
        this.registerColumnMapping(Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "STRING", false);
        this.registerColumnMapping(Date.class.getName(), TimeColumnMapping.class, JDBCType.TIME, null, false);
        this.registerColumnMapping(Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "INT64", false);
        this.registerColumnMapping(Serializable.class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "BYTES", true);
        this.registerColumnMapping(Serializable.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, null, false);
        this.registerColumnMapping(Serializable.class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, null, false);
        this.registerColumnMapping(Serializable.class.getName(), BinaryColumnMapping.class, JDBCType.BINARY, null, false);
        this.registerColumnMapping(byte[].class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "BYTES", true);
        this.registerColumnMapping(byte[].class.getName(), BlobColumnMapping.class, JDBCType.BLOB, null, false);
        this.registerColumnMapping(byte[].class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, null, false);
        this.registerColumnMapping(byte[].class.getName(), BinaryColumnMapping.class, JDBCType.BINARY, null, false);
        this.registerColumnMapping(File.class.getName(), BinaryStreamColumnMapping.class, JDBCType.LONGVARBINARY, "BYTES", true);
        this.registerColumnMapping(DatastoreId.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, null, false);
        this.registerColumnMapping(DatastoreId.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INT64", true);
        this.registerColumnMapping(DatastoreId.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(DatastoreId.class.getName(), CharColumnMapping.class, JDBCType.CHAR, null, false);
        this.registerColumnMapping(DatastoreId.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "STRING", false);
        super.loadColumnMappings(mgr, clr);
    }
}

