/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.lang.reflect.Array;
import java.util.List;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.java.AbstractContainerMapping;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.scostore.ArrayStore;
import org.datanucleus.store.types.wrappers.backed.BackedSCO;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ArrayMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    @Override
    public Class getJavaType() {
        if (this.mmd != null) {
            return this.mmd.getType();
        }
        return null;
    }

    @Override
    protected boolean containerIsStoredInSingleColumn() {
        if (super.containerIsStoredInSingleColumn()) {
            return true;
        }
        return this.mmd != null && this.mmd.hasArray() && this.mmd.getJoinMetaData() == null && MetaDataUtils.getInstance().arrayStorableAsByteArrayInSingleColumn(this.mmd);
    }

    @Override
    public void insertPostProcessing(ObjectProvider op) {
    }

    @Override
    public void postInsert(ObjectProvider ownerOP) {
        ExecutionContext ec = ownerOP.getExecutionContext();
        Object value = ownerOP.provideField(this.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        if (this.containerIsStoredInSingleColumn()) {
            if (this.mmd.getArray().elementIsPersistent()) {
                Object[] arrElements;
                for (Object elem : arrElements = (Object[])value) {
                    ObjectProvider elemOP;
                    if (elem == null || (elemOP = ec.findObjectProvider(elem)) != null && ec.getApiAdapter().getExecutionContext(elem) != null) continue;
                    elemOP = ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(ec, elem, false, ownerOP, this.mmd.getAbsoluteFieldNumber());
                }
            }
            return;
        }
        int arrayLength = Array.getLength(value);
        boolean persistentElements = this.mmd.getRelationType(ec.getClassLoaderResolver()) != RelationType.NONE;
        boolean needsAttaching = false;
        if (persistentElements) {
            int i;
            Object[] array = (Object[])value;
            if (!this.mmd.isCascadePersist()) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{this.mmd.getFullFieldName()}));
                }
                for (i = 0; i < arrayLength; ++i) {
                    if (ec.getApiAdapter().isDetached(array[i]) || ec.getApiAdapter().isPersistent(array[i])) continue;
                    throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), array[i]);
                }
            } else if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007007", (Object[])new Object[]{this.mmd.getFullFieldName()}));
            }
            for (i = 0; i < arrayLength; ++i) {
                if (!ownerOP.getExecutionContext().getApiAdapter().isDetached(array[i])) continue;
                needsAttaching = true;
                break;
            }
        }
        if (needsAttaching) {
            SCO collWrapper = this.replaceFieldWithWrapper(ownerOP, null);
            if (arrayLength > 0) {
                collWrapper.attachCopy(value);
                ownerOP.getExecutionContext().flushOperationsForBackingStore(((BackedSCO)collWrapper).getBackingStore(), ownerOP);
            }
        } else if (arrayLength > 0) {
            ((ArrayStore)this.storeMgr.getBackingStoreForField(ownerOP.getExecutionContext().getClassLoaderResolver(), this.mmd, null)).set(ownerOP, value);
        }
    }

    @Override
    public void postFetch(ObjectProvider op) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        List elements = ((ArrayStore)this.storeMgr.getBackingStoreForField(op.getExecutionContext().getClassLoaderResolver(), this.mmd, null)).getArray(op);
        if (elements != null) {
            boolean primitiveArray = this.mmd.getType().getComponentType().isPrimitive();
            Object array = Array.newInstance(this.mmd.getType().getComponentType(), elements.size());
            for (int i = 0; i < elements.size(); ++i) {
                Object element = elements.get(i);
                if (primitiveArray) {
                    if (element instanceof Boolean) {
                        Array.setBoolean(array, i, (Boolean)element);
                        continue;
                    }
                    if (element instanceof Byte) {
                        Array.setByte(array, i, (Byte)element);
                        continue;
                    }
                    if (element instanceof Character) {
                        Array.setChar(array, i, ((Character)element).charValue());
                        continue;
                    }
                    if (element instanceof Double) {
                        Array.setDouble(array, i, (Double)element);
                        continue;
                    }
                    if (element instanceof Float) {
                        Array.setFloat(array, i, ((Float)element).floatValue());
                        continue;
                    }
                    if (element instanceof Integer) {
                        Array.setInt(array, i, (Integer)element);
                        continue;
                    }
                    if (element instanceof Long) {
                        Array.setLong(array, i, (Long)element);
                        continue;
                    }
                    if (!(element instanceof Short)) continue;
                    Array.setShort(array, i, (Short)element);
                    continue;
                }
                Array.set(array, i, element);
            }
            if (elements.size() == 0) {
                op.replaceFieldMakeDirty(this.getAbsoluteFieldNumber(), null);
            } else {
                op.replaceFieldMakeDirty(this.getAbsoluteFieldNumber(), array);
            }
        } else {
            op.replaceFieldMakeDirty(this.getAbsoluteFieldNumber(), null);
        }
    }

    @Override
    public void postUpdate(ObjectProvider ownerOP) {
        ExecutionContext ec = ownerOP.getExecutionContext();
        Object value = ownerOP.provideField(this.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null && this.mmd.getArray().elementIsPersistent()) {
                Object[] arrElements;
                for (Object elem : arrElements = (Object[])value) {
                    ObjectProvider elemOP;
                    if (elem == null || (elemOP = ec.findObjectProvider(elem)) != null && ec.getApiAdapter().getExecutionContext(elem) != null) continue;
                    elemOP = ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(ec, elem, false, ownerOP, this.mmd.getAbsoluteFieldNumber());
                }
            }
            return;
        }
        if (value == null) {
            ((ArrayStore)this.storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, null)).clear(ownerOP);
            return;
        }
        if (!this.mmd.isCascadeUpdate()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007008", (Object[])new Object[]{this.mmd.getFullFieldName()}));
            }
            return;
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007009", (Object[])new Object[]{this.mmd.getFullFieldName()}));
        }
        ArrayStore backingStore = (ArrayStore)this.storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, null);
        backingStore.clear(ownerOP);
        backingStore.set(ownerOP, value);
    }

    @Override
    public void preDelete(ObjectProvider ownerOP) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        ownerOP.isLoaded(this.getAbsoluteFieldNumber());
        Object value = ownerOP.provideField(this.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        ArrayStore backingStore = (ArrayStore)this.storeMgr.getBackingStoreForField(ownerOP.getExecutionContext().getClassLoaderResolver(), this.mmd, null);
        backingStore.clear(ownerOP);
    }
}

