/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.mapping.MappingManager;
import org.datanucleus.store.rdbms.mapping.MappingManagerImpl;
import org.datanucleus.store.rdbms.mapping.column.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.ForeignKeyInfo;
import org.datanucleus.store.rdbms.schema.JDBCTypeInfo;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTypesInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.AbsFunction;
import org.datanucleus.store.rdbms.sql.method.AcosFunction;
import org.datanucleus.store.rdbms.sql.method.ArrayContainsMethod;
import org.datanucleus.store.rdbms.sql.method.ArrayIsEmptyMethod;
import org.datanucleus.store.rdbms.sql.method.ArraySizeMethod;
import org.datanucleus.store.rdbms.sql.method.AsinFunction;
import org.datanucleus.store.rdbms.sql.method.AtanFunction;
import org.datanucleus.store.rdbms.sql.method.AvgFunction;
import org.datanucleus.store.rdbms.sql.method.CeilFunction;
import org.datanucleus.store.rdbms.sql.method.CoalesceFunction;
import org.datanucleus.store.rdbms.sql.method.CollectionContainsMethod;
import org.datanucleus.store.rdbms.sql.method.CollectionIsEmptyMethod;
import org.datanucleus.store.rdbms.sql.method.CollectionSizeMethod;
import org.datanucleus.store.rdbms.sql.method.CosFunction;
import org.datanucleus.store.rdbms.sql.method.CountFunction;
import org.datanucleus.store.rdbms.sql.method.CountStarFunction;
import org.datanucleus.store.rdbms.sql.method.CurrentDateFunction;
import org.datanucleus.store.rdbms.sql.method.CurrentTimeFunction;
import org.datanucleus.store.rdbms.sql.method.CurrentTimestampFunction;
import org.datanucleus.store.rdbms.sql.method.DegreesFunction;
import org.datanucleus.store.rdbms.sql.method.EnumOrdinalMethod;
import org.datanucleus.store.rdbms.sql.method.EnumToStringMethod;
import org.datanucleus.store.rdbms.sql.method.ExpFunction;
import org.datanucleus.store.rdbms.sql.method.FloorFunction;
import org.datanucleus.store.rdbms.sql.method.IndexFunction;
import org.datanucleus.store.rdbms.sql.method.JDOHelperGetObjectIdMethod;
import org.datanucleus.store.rdbms.sql.method.JDOHelperGetVersionMethod;
import org.datanucleus.store.rdbms.sql.method.ListGetMethod;
import org.datanucleus.store.rdbms.sql.method.ListIndexOfMethod;
import org.datanucleus.store.rdbms.sql.method.LogFunction;
import org.datanucleus.store.rdbms.sql.method.MapContainsEntryMethod;
import org.datanucleus.store.rdbms.sql.method.MapContainsKeyMethod;
import org.datanucleus.store.rdbms.sql.method.MapContainsValueMethod;
import org.datanucleus.store.rdbms.sql.method.MapGetMethod;
import org.datanucleus.store.rdbms.sql.method.MapIsEmptyMethod;
import org.datanucleus.store.rdbms.sql.method.MapKeyMethod;
import org.datanucleus.store.rdbms.sql.method.MapSizeMethod;
import org.datanucleus.store.rdbms.sql.method.MapValueMethod;
import org.datanucleus.store.rdbms.sql.method.MathAbsMethod;
import org.datanucleus.store.rdbms.sql.method.MathAcosMethod;
import org.datanucleus.store.rdbms.sql.method.MathAsinMethod;
import org.datanucleus.store.rdbms.sql.method.MathAtanMethod;
import org.datanucleus.store.rdbms.sql.method.MathCeilMethod;
import org.datanucleus.store.rdbms.sql.method.MathCosMethod;
import org.datanucleus.store.rdbms.sql.method.MathExpMethod;
import org.datanucleus.store.rdbms.sql.method.MathFloorMethod;
import org.datanucleus.store.rdbms.sql.method.MathLogMethod;
import org.datanucleus.store.rdbms.sql.method.MathPowerMethod;
import org.datanucleus.store.rdbms.sql.method.MathSinMethod;
import org.datanucleus.store.rdbms.sql.method.MathSqrtMethod;
import org.datanucleus.store.rdbms.sql.method.MathTanMethod;
import org.datanucleus.store.rdbms.sql.method.MathToDegreesMethod;
import org.datanucleus.store.rdbms.sql.method.MathToRadiansMethod;
import org.datanucleus.store.rdbms.sql.method.MaxFunction;
import org.datanucleus.store.rdbms.sql.method.MinFunction;
import org.datanucleus.store.rdbms.sql.method.NullIfFunction;
import org.datanucleus.store.rdbms.sql.method.ObjectGetClassMethod;
import org.datanucleus.store.rdbms.sql.method.OptionalGetMethod;
import org.datanucleus.store.rdbms.sql.method.OptionalIsPresentMethod;
import org.datanucleus.store.rdbms.sql.method.OptionalOrElseMethod;
import org.datanucleus.store.rdbms.sql.method.PowerFunction;
import org.datanucleus.store.rdbms.sql.method.RadiansFunction;
import org.datanucleus.store.rdbms.sql.method.RoundMethod;
import org.datanucleus.store.rdbms.sql.method.SQLBooleanMethod;
import org.datanucleus.store.rdbms.sql.method.SQLFunctionMethod;
import org.datanucleus.store.rdbms.sql.method.SQLNumericMethod;
import org.datanucleus.store.rdbms.sql.method.SinFunction;
import org.datanucleus.store.rdbms.sql.method.SqrtFunction;
import org.datanucleus.store.rdbms.sql.method.StringCharAtMethod;
import org.datanucleus.store.rdbms.sql.method.StringEndsWithMethod;
import org.datanucleus.store.rdbms.sql.method.StringEqualsIgnoreCaseMethod;
import org.datanucleus.store.rdbms.sql.method.StringEqualsMethod;
import org.datanucleus.store.rdbms.sql.method.StringIndexOfMethod;
import org.datanucleus.store.rdbms.sql.method.StringLengthMethod;
import org.datanucleus.store.rdbms.sql.method.StringMatchesMethod;
import org.datanucleus.store.rdbms.sql.method.StringReplaceAllMethod;
import org.datanucleus.store.rdbms.sql.method.StringStartsWithMethod;
import org.datanucleus.store.rdbms.sql.method.StringSubstringMethod;
import org.datanucleus.store.rdbms.sql.method.StringToLowerMethod;
import org.datanucleus.store.rdbms.sql.method.StringToUpperMethod;
import org.datanucleus.store.rdbms.sql.method.StringTrimLeftMethod;
import org.datanucleus.store.rdbms.sql.method.StringTrimMethod;
import org.datanucleus.store.rdbms.sql.method.StringTrimRightMethod;
import org.datanucleus.store.rdbms.sql.method.SumFunction;
import org.datanucleus.store.rdbms.sql.method.TanFunction;
import org.datanucleus.store.rdbms.sql.method.TemporalDayMethod;
import org.datanucleus.store.rdbms.sql.method.TemporalHourMethod;
import org.datanucleus.store.rdbms.sql.method.TemporalMinuteMethod;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthJavaMethod;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthMethod;
import org.datanucleus.store.rdbms.sql.method.TemporalSecondMethod;
import org.datanucleus.store.rdbms.sql.method.TemporalYearMethod;
import org.datanucleus.store.rdbms.sql.operation.NumericToStringOperation;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.rdbms.table.ViewImpl;
import org.datanucleus.store.schema.StoreSchemaData;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class BaseDatastoreAdapter
implements DatastoreAdapter {
    public static final int MAX_IDENTIFIER_LENGTH = 128;
    public static final String SQL92_RESERVED_WORDS = "ABSOLUTE,ACTION,ADD,ALL,ALLOCATE,ALTER,AND,ANY,ARE,AS,ASC,ASSERTION,AT,AUTHORIZATION,AVG,BEGIN,BETWEEN,BIT,BIT_LENGTH,BOTH,BY,CASCADE,CASCADED,CASE,CAST,CATALOG,CHAR,CHARACTER,CHAR_LENGTH,CHARACTER_LENGTH,CHECK,CLOSE,COALESCE,COLLATE,COLLATION,COLUMN,COMMIT,CONNECT,CONNECTION,CONSTRAINT,CONSTRAINTS,CONTINUE,CONVERT,CORRESPONDING,COUNT,CREATE,CROSS,CURRENT,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURSOR,DATE,DAY,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFAULT,DEFERRABLE,DEFERRED,DELETE,DESC,DESCRIBE,DESCRIPTOR,DIAGNOSTICS,DISCONNECT,DISTINCT,DOMAIN,DOUBLE,DROP,ELSE,END,END-EXEC,ESCAPE,EXCEPT,EXCEPTION,EXEC,EXECUTE,EXISTS,EXTERNAL,EXTRACT,FALSE,FETCH,FIRST,FLOAT,FOR,FOREIGN,FOUND,FROM,FULL,GET,GLOBAL,GO,GOTO,GRANT,GROUP,HAVING,HOUR,IDENTITY,IMMEDIATE,IN,INDICATOR,INITIALLY,INNER,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ISOLATION,JOIN,KEY,LANGUAGE,LAST,LEADING,LEFT,LEVEL,LIKE,LOCAL,LOWER,MATCH,MAX,MIN,MINUTE,MODULE,MONTH,NAMES,NATIONAL,NATURAL,NCHAR,NEXT,NO,NOT,NULL,NULLIF,NUMERIC,OCTET_LENGTH,OF,ON,ONLY,OPEN,OPTION,OR,ORDER,OUTER,OUTPUT,OVERLAPS,PAD,PARTIAL,POSITION,PRECISION,PREPARE,PRESERVE,PRIMARY,PRIOR,PRIVILEGES,PROCEDURE,PUBLIC,READ,REAL,REFERENCES,RELATIVE,RESTRICT,REVOKE,RIGHT,ROLLBACK,ROWS,SCHEMA,SCROLL,SECOND,SECTION,SELECT,SESSION,SESSION_USER,SET,SIZE,SMALLINT,SOME,SPACE,SQL,SQLCODE,SQLERROR,SQLSTATE,SUBSTRING,SUM,SYSTEM_USER,TABLE,TEMPORARY,THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSACTION,TRANSLATE,TRANSLATION,TRIM,TRUE,UNION,UNIQUE,UNKNOWN,UPDATE,UPPER,USAGE,USER,USING,VALUE,VALUES,VARCHAR,VARYING,VIEW,WHEN,WHENEVER,WHERE,WITH,WORK,WRITE,YEAR,ZONE";
    public static final String SQL99_RESERVED_WORDS = "ABSOLUTE,ACTION,ADD,AFTER,ALL,ALLOCATE,ALTER,AND,ANY,ARE,ARRAY,AS,ASC,ASENSITIVE,ASSERTION,ASYMMETRIC,AT,ATOMIC,AUTHORIZATION,BEFORE,BEGIN,BETWEEN,BINARY,BIT,BLOB,BOOLEAN,BOTH,BREADTH,BY,CALL,CALLED,CASCADE,CASCADED,CASE,CAST,CATALOG,CHAR,CHARACTER,CHECK,CLOB,CLOSE,COLLATE,COLLATION,COLUMN,COMMIT,CONDITION,CONNECT,CONNECTION,CONSTRAINT,CONSTRAINTS,CONSTRUCTOR,CONTINUE,CORRESPONDING,CREATE,CROSS,CUBE,CURRENT,CURRENT_DATE,CURRENT_DEFAULT_TRANSFORM_GROUP,CURRENT_PATH,CURRENT_ROLE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_TRANSFORM_GROUP_FOR_TYPE,CURRENT_USER,CURSOR,CYCLE,DATA,DATE,DAY,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFAULT,DEFERRABLE,DEFERRED,DELETE,DEPTH,DEREF,DESC,DESCRIBE,DESCRIPTOR,DETERMINISTIC,DIAGNOSTICS,DISCONNECT,DISTINCT,DO,DOMAIN,DOUBLE,DROP,DYNAMIC,EACH,ELSE,ELSEIF,END,EQUALS,ESCAPE,EXCEPT,EXCEPTION,EXEC,EXECUTE,EXISTS,EXIT,EXTERNAL,FALSE,FETCH,FILTER,FIRST,FLOAT,FOR,FOREIGN,FOUND,FREE,FROM,FULL,FUNCTION,GENERAL,GET,GLOBAL,GO,GOTO,GRANT,GROUP,GROUPING,HANDLER,HAVING,HOLD,HOUR,IDENTITY,IF,IMMEDIATE,IN,INDICATOR,INITIALLY,INNER,INOUT,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ISOLATION,ITERATE,JOIN,KEY,LANGUAGE,LARGE,LAST,LATERAL,LEADING,LEAVE,LEFT,LEVEL,LIKE,LOCAL,LOCALTIME,LOCALTIMESTAMP,LOCATOR,LOOP,MAP,MATCH,METHOD,MINUTE,MODIFIES,MODULE,MONTH,NAMES,NATIONAL,NATURAL,NCHAR,NCLOB,NEW,NEXT,NO,NONE,NOT,NULL,NUMERIC,OBJECT,OF,OLD,ON,ONLY,OPEN,OPTION,OR,ORDER,ORDINALITY,OUT,OUTER,OUTPUT,OVER,OVERLAPS,PAD,PARAMETER,PARTIAL,PARTITION,PATH,PRECISION,PREPARE,PRESERVE,PRIMARY,PRIOR,PRIVILEGES,PROCEDURE,PUBLIC,RANGE,READ,READS,REAL,RECURSIVE,REF,REFERENCES,REFERENCING,RELATIVE,RELEASE,REPEAT,RESIGNAL,RESTRICT,RESULT,RETURN,RETURNS,REVOKE,RIGHT,ROLE,ROLLBACK,ROLLUP,ROUTINE,ROW,ROWS,SAVEPOINT,SCHEMA,SCOPE,SCROLL,SEARCH,SECOND,SECTION,SELECT,SENSITIVE,SESSION,SESSION_USER,SET,SETS,SIGNAL,SIMILAR,SIZE,SMALLINT,SOME,SPACE,SPECIFIC,SPECIFICTYPE,SQL,SQLEXCEPTION,SQLSTATE,SQLWARNING,START,STATE,STATIC,SYMMETRIC,SYSTEM,SYSTEM_USER,TABLE,TEMPORARY,THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSACTION,TRANSLATION,TREAT,TRIGGER,TRUE,UNDER,UNDO,UNION,UNIQUE,UNKNOWN,UNNEST,UNTIL,UPDATE,USAGE,USER,USING,VALUE,VALUES,VARCHAR,VARYING,VIEW,WHEN,WHENEVER,WHERE,WHILE,WINDOW,WITH,WITHIN,WITHOUT,WORK,WRITE,YEAR,ZONE";
    public static final String SQL2003_RESERVED_WORDS = "ADD,ALL,ALLOCATE,ALTER,AND,ANY,ARE,ARRAY,AS,ASENSITIVE,ASYMMETRIC,AT,ATOMIC,AUTHORIZATION,BEGIN,BETWEEN,BIGINT,BINARY,BLOB,BOOLEAN,BOTH,BY,CALL,CALLED,CASCADED,CASE,CAST,CHAR,CHARACTER,CHECK,CLOB,CLOSE,COLLATE,COLUMN,COMMIT,CONDITION,CONNECT,CONSTRAINT,CONTINUE,CORRESPONDING,CREATE,CROSS,CUBE,CURRENT,CURRENT_DATE,CURRENT_DEFAULT_TRANSFORM_GROUP,CURRENT_PATH,CURRENT_ROLE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_TRANSFORM_GROUP_FOR_TYPE,CURRENT_USER,CURSOR,CYCLE,DATE,DAY,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFAULT,DELETE,DEREF,DESCRIBE,DETERMINISTIC,DISCONNECT,DISTINCT,DO,DOUBLE,DROP,DYNAMIC,EACH,ELEMENT,ELSE,ELSEIF,END,ESCAPE,EXCEPT,EXEC,EXECUTE,EXISTS,EXIT,EXTERNAL,FALSE,FETCH,FILTER,FLOAT,FOR,FOREIGN,FREE,FROM,FULL,FUNCTION,GET,GLOBAL,GRANT,GROUP,GROUPING,HANDLER,HAVING,HOLD,HOUR,IDENTITY,IF,IMMEDIATE,IN,INDICATOR,INNER,INOUT,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ITERATE,JOIN,LANGUAGE,LARGE,LATERAL,LEADING,LEAVE,LEFT,LIKE,LOCAL,LOCALTIME,LOCALTIMESTAMP,LOOP,MATCH,MEMBER,MERGE,METHOD,MINUTE,MODIFIES,MODULE,MONTH,MULTISET,NATIONAL,NATURAL,NCHAR,NCLOB,NEW,NO,NONE,NOT,NULL,NUMERIC,OF,OLD,ON,ONLY,OPEN,OR,ORDER,OUT,OUTER,OUTPUT,OVER,OVERLAPS,PARAMETER,PARTITION,PRECISION,PREPARE,PRIMARY,PROCEDURE,RANGE,READS,REAL,RECURSIVE,REF,REFERENCES,REFERENCING,RELEASE,REPEAT,RESIGNAL,RESULT,RETURN,RETURNS,REVOKE,RIGHT,ROLLBACK,ROLLUP,ROW,ROWS,SAVEPOINT,SCOPE,SCROLL,SEARCH,SECOND,SELECT,SENSITIVE,SESSION_USER,SET,SIGNAL,SIMILAR,SMALLINT,SOME,SPECIFIC,SPECIFICTYPE,SQL,SQLEXCEPTION,SQLSTATE,SQLWARNING,START,STATIC,SUBMULTISET,SYMMETRIC,SYSTEM,SYSTEM_USER,TABLE,TABLESAMPLE,THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSLATION,TREAT,TRIGGER,TRUE,UNDO,UNION,UNIQUE,UNKNOWN,UNNEST,UNTIL,UPDATE,USER,USING,VALUE,VALUES,VARCHAR,VARYING,WHEN,WHENEVER,WHERE,WHILE,WINDOW,WITH,WITHIN,WITHOUT,YEAR";
    public static final String NONRESERVED_WORDS = "ADA,C,CATALOG_NAME,CHARACTER_SET_CATALOG,CHARACTER_SET_NAME,CHARACTER_SET_SCHEMA,CLASS_ORIGIN,COBOL,COLLATION_CATALOG,COLLATION_NAME,COLLATION_SCHEMA,COLUMN_NAME,COMMAND_FUNCTION,COMMITTED,CONDITION_NUMBER,CONNECTION_NAME,CONSTRAINT_CATALOG,CONSTRAINT_NAME,CONSTRAINT_SCHEMA,CURSOR_NAME,DATA,DATETIME_INTERVAL_CODE,DATETIME_INTERVAL_PRECISION,DYNAMIC_FUNCTION,FORTRAN,LENGTH,MESSAGE_LENGTH,MESSAGE_OCTET_LENGTH,MESSAGE_TEXT,MORE,MUMPS,NAME,NULLABLE,NUMBER,PASCAL,PLI,REPEATABLE,RETURNED_LENGTH,RETURNED_OCTET_LENGTH,RETURNED_SQLSTATE,ROW_COUNT,SCALE,SCHEMA_NAME,SERIALIZABLE,SERVER_NAME,SUBCLASS_ORIGIN,TABLE_NAME,TYPE,UNCOMMITTED,UNNAMED";
    protected Map<Integer, String> supportedJdbcTypesById = new HashMap<Integer, String>();
    protected Map<Integer, String> unsupportedJdbcTypesById = new HashMap<Integer, String>();
    protected final HashSet<String> reservedKeywords = new HashSet();
    protected String datastoreProductName;
    protected String datastoreProductVersion;
    protected int datastoreMajorVersion;
    protected int datastoreMinorVersion;
    protected int datastoreRevisionVersion = 0;
    protected String identifierQuoteString;
    protected Collection<String> supportedOptions = new HashSet<String>();
    protected String driverName;
    protected String driverVersion;
    protected int driverMajorVersion;
    protected int driverMinorVersion;
    protected int maxTableNameLength;
    protected int maxConstraintNameLength;
    protected int maxIndexNameLength;
    protected int maxColumnNameLength;
    protected String catalogSeparator;
    protected Map<String, Object> properties = null;
    Map<String, ColumnTypeMappings> datastoreTypeMappingsByJavaType = new HashMap<String, ColumnTypeMappings>();

    protected BaseDatastoreAdapter(DatabaseMetaData metadata) {
        this.supportedJdbcTypesById.put(-5, "BIGINT");
        this.supportedJdbcTypesById.put(-7, "BIT");
        this.supportedJdbcTypesById.put(2004, "BLOB");
        this.supportedJdbcTypesById.put(16, "BOOLEAN");
        this.supportedJdbcTypesById.put(1, "CHAR");
        this.supportedJdbcTypesById.put(2005, "CLOB");
        this.supportedJdbcTypesById.put(70, "DATALINK");
        this.supportedJdbcTypesById.put(91, "DATE");
        this.supportedJdbcTypesById.put(3, "DECIMAL");
        this.supportedJdbcTypesById.put(8, "DOUBLE");
        this.supportedJdbcTypesById.put(6, "FLOAT");
        this.supportedJdbcTypesById.put(4, "INTEGER");
        this.supportedJdbcTypesById.put(-4, "LONGVARBINARY");
        this.supportedJdbcTypesById.put(-1, "LONGVARCHAR");
        this.supportedJdbcTypesById.put(2, "NUMERIC");
        this.supportedJdbcTypesById.put(7, "REAL");
        this.supportedJdbcTypesById.put(5, "SMALLINT");
        this.supportedJdbcTypesById.put(92, "TIME");
        this.supportedJdbcTypesById.put(93, "TIMESTAMP");
        this.supportedJdbcTypesById.put(-6, "TINYINT");
        this.supportedJdbcTypesById.put(-3, "VARBINARY");
        this.supportedJdbcTypesById.put(12, "VARCHAR");
        this.supportedJdbcTypesById.put(-9, "NVARCHAR");
        this.supportedJdbcTypesById.put(-15, "NCHAR");
        this.supportedJdbcTypesById.put(2011, "NCLOB");
        this.supportedJdbcTypesById.put(1111, "OTHER");
        this.supportedJdbcTypesById.put(2009, "SQLXML");
        this.supportedJdbcTypesById.put(2003, "ARRAY");
        this.supportedJdbcTypesById.put(-2, "BINARY");
        this.unsupportedJdbcTypesById.put(2001, "DISTINCT");
        this.unsupportedJdbcTypesById.put(2000, "JAVA_OBJECT");
        this.unsupportedJdbcTypesById.put(0, "NULL");
        this.unsupportedJdbcTypesById.put(2006, "REF");
        this.unsupportedJdbcTypesById.put(2002, "STRUCT");
        this.unsupportedJdbcTypesById.put(2012, "REF_CURSOR");
        this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)SQL92_RESERVED_WORDS));
        this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)SQL99_RESERVED_WORDS));
        this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)SQL2003_RESERVED_WORDS));
        this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)NONRESERVED_WORDS));
        try {
            block43: {
                try {
                    String sqlKeywordsString = metadata.getSQLKeywords();
                    this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)sqlKeywordsString));
                }
                catch (SQLFeatureNotSupportedException sqlKeywordsString) {
                    // empty catch block
                }
                this.driverMinorVersion = metadata.getDriverMinorVersion();
                this.driverMajorVersion = metadata.getDriverMajorVersion();
                this.driverName = metadata.getDriverName();
                this.driverVersion = metadata.getDriverVersion();
                this.datastoreProductName = metadata.getDatabaseProductName();
                this.datastoreProductVersion = metadata.getDatabaseProductVersion();
                StringBuilder strippedProductVersion = new StringBuilder();
                char previousChar = ' ';
                for (int i = 0; i < this.datastoreProductVersion.length(); ++i) {
                    char c = this.datastoreProductVersion.charAt(i);
                    if (Character.isDigit(c) || c == '.') {
                        if (previousChar != ' ') {
                            if (strippedProductVersion.length() == 0) {
                                strippedProductVersion.append(previousChar);
                            }
                            strippedProductVersion.append(c);
                        }
                        previousChar = c;
                        continue;
                    }
                    previousChar = ' ';
                }
                this.datastoreMajorVersion = metadata.getDatabaseMajorVersion();
                this.datastoreMinorVersion = metadata.getDatabaseMinorVersion();
                try {
                    StringTokenizer parts;
                    boolean noDBVersion = false;
                    if (this.datastoreMajorVersion <= 0 && this.datastoreMinorVersion <= 0) {
                        noDBVersion = true;
                    }
                    if ((parts = new StringTokenizer(strippedProductVersion.toString(), ".")).hasMoreTokens()) {
                        if (noDBVersion) {
                            try {
                                this.datastoreMajorVersion = Integer.parseInt(parts.nextToken());
                            }
                            catch (Exception e) {
                                this.datastoreMajorVersion = -1;
                            }
                        } else {
                            parts.nextToken();
                        }
                    }
                    if (parts.hasMoreTokens()) {
                        if (noDBVersion) {
                            try {
                                this.datastoreMinorVersion = Integer.parseInt(parts.nextToken());
                            }
                            catch (Exception e) {
                                this.datastoreMajorVersion = -1;
                            }
                        } else {
                            parts.nextToken();
                        }
                    }
                    if (parts.hasMoreTokens()) {
                        try {
                            this.datastoreRevisionVersion = Integer.parseInt(parts.nextToken());
                        }
                        catch (Exception e) {
                            this.datastoreRevisionVersion = -1;
                        }
                    }
                }
                catch (Throwable t) {
                    StringTokenizer parts = new StringTokenizer(strippedProductVersion.toString(), ".");
                    if (parts.hasMoreTokens()) {
                        try {
                            this.datastoreMajorVersion = Integer.parseInt(parts.nextToken());
                        }
                        catch (Exception e) {
                            this.datastoreMajorVersion = -1;
                        }
                    }
                    if (parts.hasMoreTokens()) {
                        try {
                            this.datastoreMinorVersion = Integer.parseInt(parts.nextToken());
                        }
                        catch (Exception e) {
                            this.datastoreMajorVersion = -1;
                        }
                    }
                    if (!parts.hasMoreTokens()) break block43;
                    try {
                        this.datastoreRevisionVersion = Integer.parseInt(parts.nextToken());
                    }
                    catch (Exception e) {
                        this.datastoreRevisionVersion = -1;
                    }
                }
            }
            this.maxTableNameLength = metadata.getMaxTableNameLength();
            this.maxConstraintNameLength = metadata.getMaxTableNameLength();
            this.maxIndexNameLength = metadata.getMaxTableNameLength();
            this.maxColumnNameLength = metadata.getMaxColumnNameLength();
            if (metadata.supportsCatalogsInTableDefinitions()) {
                this.supportedOptions.add("CatalogInTableDefinition");
            }
            if (metadata.supportsSchemasInTableDefinitions()) {
                this.supportedOptions.add("SchemaInTableDefinition");
            }
            if (metadata.supportsBatchUpdates()) {
                this.supportedOptions.add("StatementBatching");
            }
            if (metadata.storesLowerCaseIdentifiers()) {
                this.supportedOptions.add("LowerCaseIdentifiers");
            }
            if (metadata.storesMixedCaseIdentifiers()) {
                this.supportedOptions.add("MixedCaseIdentifiers");
            }
            if (metadata.storesUpperCaseIdentifiers()) {
                this.supportedOptions.add("UpperCaseIdentifiers");
            }
            if (metadata.storesLowerCaseQuotedIdentifiers()) {
                this.supportedOptions.add("LowerCaseQuotedIdentifiers");
            }
            if (metadata.storesMixedCaseQuotedIdentifiers()) {
                this.supportedOptions.add("MixedCaseQuotedIdentifiers");
            }
            if (metadata.storesUpperCaseQuotedIdentifiers()) {
                this.supportedOptions.add("UpperCaseQuotedIdentifiers");
            }
            if (metadata.supportsMixedCaseIdentifiers()) {
                this.supportedOptions.add("MixedCaseSensitiveIdentifiers");
            }
            if (metadata.supportsMixedCaseQuotedIdentifiers()) {
                this.supportedOptions.add("MixedCaseQuotedSensitiveIdentifiers");
            }
            this.supportedOptions.add("HoldCursorsOverCommit");
            this.catalogSeparator = metadata.getCatalogSeparator();
            this.catalogSeparator = this.catalogSeparator == null || this.catalogSeparator.trim().length() < 1 ? "." : this.catalogSeparator;
            this.identifierQuoteString = metadata.getIdentifierQuoteString();
            this.identifierQuoteString = null == this.identifierQuoteString || this.identifierQuoteString.trim().length() < 1 ? "\"" : this.identifierQuoteString;
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"051004"), (Throwable)e);
        }
        this.supportedOptions.add("ResultSetTypeForwardOnly");
        this.supportedOptions.add("ResultSetTypeScrollSens");
        this.supportedOptions.add("ResultSetTypeScrollInsens");
        this.supportedOptions.add("RightOuterJoin");
        this.supportedOptions.add("SomeAllAnySubqueries");
        this.supportedOptions.add("UpdateStmtAllowTableAliasInSet");
        this.supportedOptions.add("UpdateDeleteStmtAllowTableAliasInWhere");
        this.supportedOptions.add("Views");
        this.supportedOptions.add("DateTimeStoresMillisecs");
        this.supportedOptions.add("EscapeExpressionInLikePredicate");
        this.supportedOptions.add("Union_Syntax");
        this.supportedOptions.add("Exists_Syntax");
        this.supportedOptions.add("AlterTableDropConstraint_Syntax");
        this.supportedOptions.add("DeferredConstraints");
        this.supportedOptions.add("DistinctWithSelectForUpdate");
        this.supportedOptions.add("GroupingWithSelectForUpdate");
        this.supportedOptions.add("HavingWithSelectForUpdate");
        this.supportedOptions.add("OrderingWithSelectForUpdate");
        this.supportedOptions.add("MultipleTablesWithSelectForUpdate");
        this.supportedOptions.add("PersistOfUnassignedChar");
        this.supportedOptions.add("CheckInCreateStatements");
        this.supportedOptions.add("GetGeneratedKeysStatement");
        this.supportedOptions.add("BooleanExpression");
        this.supportedOptions.add("NullsInCandidateKeys");
        this.supportedOptions.add("ColumnOptions_NullsKeyword");
        this.supportedOptions.add("ColumnOptions_DefaultKeyword");
        this.supportedOptions.add("ColumnOptions_DefaultWithNotNull");
        this.supportedOptions.add("ColumnOptions_DefaultBeforeNull");
        this.supportedOptions.add("ANSI_Join_Syntax");
        this.supportedOptions.add("ANSI_CrossJoin_Syntax");
        this.supportedOptions.add("AutoIncrementNullSpecification");
        this.supportedOptions.add("AutoIncrementColumnTypeSpecification");
        this.supportedOptions.add("IncludeOrderByColumnsInSelect");
        this.supportedOptions.add("AccessParentQueryInSubquery");
        this.supportedOptions.add("SubqueryInHaving");
        this.supportedOptions.add("ValueGeneratorUUIDString");
        this.supportedOptions.add("FkDeleteActionCascade");
        this.supportedOptions.add("FkDeleteActionRestrict");
        this.supportedOptions.add("FkDeleteActionDefault");
        this.supportedOptions.add("FkDeleteActionNull");
        this.supportedOptions.add("FkUpdateActionCascade");
        this.supportedOptions.add("FkUpdateActionRestrict");
        this.supportedOptions.add("FkUpdateActionDefault");
        this.supportedOptions.add("FkUpdateActionNull");
        this.supportedOptions.add("TxIsolationReadCommitted");
        this.supportedOptions.add("TxIsolationReadUncommitted");
        this.supportedOptions.add("TxIsolationReadRepeatableRead");
        this.supportedOptions.add("TxIsolationSerializable");
    }

    @Override
    public void initialise(StoreSchemaHandler handler, ManagedConnection mconn) {
        int jdbcType;
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)handler.getStoreManager();
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        this.loadColumnMappings(storeMgr.getNucleusContext().getPluginManager(), clr);
        this.initialiseTypes(handler, mconn);
        RDBMSTypesInfo types = (RDBMSTypesInfo)handler.getSchemaData(mconn.getConnection(), "types", null);
        for (Map.Entry<Integer, String> entry : this.supportedJdbcTypesById.entrySet()) {
            jdbcType = entry.getKey();
            if (types.getChild("" + jdbcType) != null) continue;
            this.deregisterColumnMappingsForJDBCType(entry.getValue());
        }
        for (Map.Entry<Integer, String> entry : this.unsupportedJdbcTypesById.entrySet()) {
            jdbcType = entry.getKey();
            if (types.getChild("" + jdbcType) != null) continue;
            this.deregisterColumnMappingsForJDBCType(entry.getValue());
        }
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            TreeSet<String> javaTypes = new TreeSet<String>(this.datastoreTypeMappingsByJavaType.keySet());
            for (String javaType : javaTypes) {
                ColumnTypeMappings datastoreTypeMappings = this.datastoreTypeMappingsByJavaType.get(javaType);
                if (!NucleusLogger.DATASTORE.isDebugEnabled()) continue;
                NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"054009", (Object[])new Object[]{javaType, StringUtils.collectionToString(datastoreTypeMappings.columnMappingByJdbcType.keySet()), StringUtils.collectionToString(datastoreTypeMappings.columnMappingBySqlType.keySet()), datastoreTypeMappings.defaultJdbcType, datastoreTypeMappings.defaultSqlType}));
            }
        }
    }

    @Override
    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        handler.getSchemaData(mconn.getConnection(), "types", null);
    }

    @Override
    public void initialiseDatastore(Connection conn) {
    }

    @Override
    public String getPreferredDefaultSQLTypeForJDBCType(JdbcType jdbcType) {
        return null;
    }

    @Override
    public String getNameForJDBCType(int jdbcType) {
        String typeName = this.supportedJdbcTypesById.get(jdbcType);
        if (typeName == null) {
            typeName = this.unsupportedJdbcTypesById.get(jdbcType);
        }
        return typeName;
    }

    @Override
    public int getJDBCTypeForName(String typeName) {
        if (typeName == null) {
            return 0;
        }
        Set<Map.Entry<Integer, String>> entries = this.supportedJdbcTypesById.entrySet();
        for (Map.Entry<Integer, String> entry : entries) {
            if (!typeName.equalsIgnoreCase(entry.getValue())) continue;
            return entry.getKey();
        }
        return 0;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        if (props != null) {
            if (this.properties == null) {
                this.properties = new HashMap<String, Object>();
            }
            this.properties.putAll(props);
        }
    }

    public Object getValueForProperty(String name) {
        return this.properties != null ? this.properties.get(name) : null;
    }

    protected Collection<SQLTypeInfo> getSQLTypeInfoForJdbcType(StoreSchemaHandler handler, ManagedConnection mconn, short jdbcTypeNumber) {
        String key;
        RDBMSTypesInfo types = (RDBMSTypesInfo)handler.getSchemaData(mconn.getConnection(), "types", null);
        JDBCTypeInfo jdbcType = (JDBCTypeInfo)types.getChild(key = "" + jdbcTypeNumber);
        if (jdbcType == null) {
            return null;
        }
        return jdbcType.getChildren().values();
    }

    protected void addSQLTypeForJDBCType(StoreSchemaHandler handler, ManagedConnection mconn, short jdbcTypeNumber, SQLTypeInfo sqlType, boolean addIfNotPresent) {
        String key;
        RDBMSTypesInfo types = (RDBMSTypesInfo)handler.getSchemaData(mconn.getConnection(), "types", null);
        JDBCTypeInfo jdbcType = (JDBCTypeInfo)types.getChild(key = "" + jdbcTypeNumber);
        if (jdbcType != null && !addIfNotPresent) {
            return;
        }
        if (jdbcType == null) {
            jdbcType = new JDBCTypeInfo(jdbcTypeNumber);
            types.addChild((StoreSchemaData)jdbcType);
            jdbcType.addChild(sqlType);
        } else {
            jdbcType.addChild(sqlType);
        }
    }

    @Override
    public boolean supportsTransactionIsolation(int level) {
        return level == 0 && this.supportsOption("TxIsolationNone") || level == 2 && this.supportsOption("TxIsolationReadCommitted") || level == 1 && this.supportsOption("TxIsolationReadUncommitted") || level == 4 && this.supportsOption("TxIsolationReadRepeatableRead") || level == 8 && this.supportsOption("TxIsolationSerializable");
    }

    @Override
    public Collection<String> getSupportedOptions() {
        return this.supportedOptions;
    }

    @Override
    public boolean supportsOption(String option) {
        return this.supportedOptions.contains(option);
    }

    @Override
    public MappingManager getMappingManager(RDBMSStoreManager storeMgr) {
        return new MappingManagerImpl(storeMgr);
    }

    @Override
    public long getAdapterTime(Timestamp time) {
        long timestamp = this.getTime(time.getTime(), time.getNanos());
        int ms = this.getMiliseconds(time.getNanos());
        return timestamp + (long)ms;
    }

    protected long getTime(long time, long nanos) {
        if (nanos < 0L) {
            return (time / 1000L - 1L) * 1000L;
        }
        return time / 1000L * 1000L;
    }

    protected int getMiliseconds(long nanos) {
        return (int)(nanos / 1000000L);
    }

    @Override
    public String getDatastoreProductName() {
        return this.datastoreProductName;
    }

    @Override
    public String getDatastoreProductVersion() {
        return this.datastoreProductVersion;
    }

    @Override
    public String getDatastoreDriverName() {
        return this.driverName;
    }

    @Override
    public String getDatastoreDriverVersion() {
        return this.driverVersion;
    }

    @Override
    public boolean supportsQueryFetchSize(int size) {
        return true;
    }

    @Override
    public String getVendorID() {
        return null;
    }

    @Override
    public boolean isReservedKeyword(String word) {
        return this.reservedKeywords.contains(word.toUpperCase());
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    @Override
    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    @Override
    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    @Override
    public int getDatastoreIdentifierMaxLength(IdentifierType identifierType) {
        if (identifierType == IdentifierType.TABLE) {
            return this.maxTableNameLength;
        }
        if (identifierType == IdentifierType.COLUMN) {
            return this.maxColumnNameLength;
        }
        if (identifierType == IdentifierType.CANDIDATE_KEY) {
            return this.maxConstraintNameLength;
        }
        if (identifierType == IdentifierType.FOREIGN_KEY) {
            return this.maxConstraintNameLength;
        }
        if (identifierType == IdentifierType.INDEX) {
            return this.maxIndexNameLength;
        }
        if (identifierType == IdentifierType.PRIMARY_KEY) {
            return this.maxConstraintNameLength;
        }
        if (identifierType == IdentifierType.SEQUENCE) {
            return this.maxTableNameLength;
        }
        return -1;
    }

    @Override
    public int getMaxForeignKeys() {
        return 9999;
    }

    @Override
    public int getMaxIndexes() {
        return 9999;
    }

    @Override
    public Iterator iteratorReservedWords() {
        return this.reservedKeywords.iterator();
    }

    @Override
    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        return new RDBMSColumnInfo(rs);
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new SQLTypeInfo(rs);
    }

    @Override
    public ForeignKeyInfo newFKInfo(ResultSet rs) {
        return new ForeignKeyInfo(rs);
    }

    @Override
    public int getUnlimitedLengthPrecisionValue(SQLTypeInfo typeInfo) {
        if (typeInfo.getCreateParams() != null && typeInfo.getCreateParams().length() > 0) {
            return typeInfo.getPrecision();
        }
        return -1;
    }

    @Override
    public boolean isValidPrimaryKeyType(JdbcType datatype) {
        return datatype != JdbcType.BLOB && datatype != JdbcType.CLOB && datatype != JdbcType.LONGVARBINARY;
    }

    @Override
    public String getSurrogateForEmptyStrings() {
        return null;
    }

    @Override
    public int getTransactionIsolationForSchemaCreation() {
        return 8;
    }

    @Override
    public int getRequiredTransactionIsolationLevel() {
        return -1;
    }

    @Override
    public String getCatalogName(Connection conn) throws SQLException {
        throw new UnsupportedOperationException(Localiser.msg((String)"051015", (Object[])new Object[]{this.datastoreProductName, this.datastoreProductVersion}));
    }

    @Override
    public String getSchemaName(Connection conn) throws SQLException {
        throw new UnsupportedOperationException(Localiser.msg((String)"051016", (Object[])new Object[]{this.datastoreProductName, this.datastoreProductVersion}));
    }

    @Override
    public String getCatalogSeparator() {
        return this.catalogSeparator;
    }

    @Override
    public String getSelectWithLockOption() {
        return null;
    }

    @Override
    public String getSelectForUpdateText() {
        return "FOR UPDATE";
    }

    @Override
    public String getSelectNewUUIDStmt() {
        return null;
    }

    public String getNewUUIDFunction() {
        return null;
    }

    @Override
    public String getOrderString(StoreManager storeMgr, String orderString, SQLExpression sqlExpr) {
        return orderString;
    }

    @Override
    public boolean validToSelectMappingInStatement(SelectStatement stmt, JavaTypeMapping m) {
        return true;
    }

    @Override
    public String getAutoIncrementStmt(Table table, String columnName) {
        throw new UnsupportedOperationException(Localiser.msg((String)"051019"));
    }

    @Override
    public String getAutoIncrementKeyword() {
        throw new UnsupportedOperationException(Localiser.msg((String)"051019"));
    }

    @Override
    public Class getAutoIncrementJavaTypeForType(Class type) {
        return type;
    }

    @Override
    public boolean isIdentityFieldDataType(String typeName) {
        throw new UnsupportedOperationException(Localiser.msg((String)"051019"));
    }

    @Override
    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " () VALUES ()";
    }

    @Override
    public boolean sequenceExists(Connection conn, String catalogName, String schemaName, String seqName) {
        return true;
    }

    @Override
    public String getSequenceCreateStmt(String sequence_name, Integer min, Integer max, Integer start, Integer increment, Integer cache_size) {
        throw new UnsupportedOperationException(Localiser.msg((String)"051020"));
    }

    @Override
    public String getSequenceNextStmt(String sequence_name) {
        throw new UnsupportedOperationException(Localiser.msg((String)"051020"));
    }

    @Override
    public ResultSet getExistingIndexes(Connection conn, String catalog, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public String getCreateTableStatement(TableImpl table, Column[] columns, Properties props, IdentifierFactory factory) {
        PrimaryKey pk;
        StringBuilder createStmt = new StringBuilder();
        String indent = "    ";
        if (this.getContinuationString().length() == 0) {
            indent = "";
        }
        createStmt.append("CREATE TABLE ").append(table.toString()).append(this.getContinuationString()).append("(").append(this.getContinuationString());
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                createStmt.append(",").append(this.getContinuationString());
            }
            createStmt.append(indent).append(columns[i].getSQLDefinition());
        }
        if (this.supportsOption("PrimaryKeyInCreateStatements") && (pk = table.getPrimaryKey()) != null && pk.size() > 0) {
            boolean includePk = true;
            if (this.supportsOption("AutoIncrementPkInCreateTableColumnDef")) {
                for (Column pkCol : pk.getColumns()) {
                    if (!pkCol.isIdentity()) continue;
                    includePk = false;
                    break;
                }
            }
            if (includePk) {
                createStmt.append(",").append(this.getContinuationString());
                if (pk.getName() != null) {
                    String identifier = factory.getIdentifierInAdapterCase(pk.getName());
                    createStmt.append(indent).append("CONSTRAINT ").append(identifier).append(" ").append(pk.toString());
                } else {
                    createStmt.append(indent).append(pk.toString());
                }
            }
        }
        if (this.supportsOption("UniqueInEndCreateStatements")) {
            StringBuilder uniqueConstraintStmt = new StringBuilder();
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].isUnique()) continue;
                if (uniqueConstraintStmt.length() < 1) {
                    uniqueConstraintStmt.append(",").append(this.getContinuationString());
                    uniqueConstraintStmt.append(indent).append(" UNIQUE (");
                } else {
                    uniqueConstraintStmt.append(",");
                }
                uniqueConstraintStmt.append(columns[i].getIdentifier().toString());
            }
            if (uniqueConstraintStmt.length() > 1) {
                uniqueConstraintStmt.append(")");
                createStmt.append(uniqueConstraintStmt.toString());
            }
        }
        if (this.supportsOption("FKInEndCreateStatements")) {
            StringBuilder fkConstraintStmt = new StringBuilder();
            ClassLoaderResolver clr = table.getStoreManager().getNucleusContext().getClassLoaderResolver(null);
            List<ForeignKey> fks = table.getExpectedForeignKeys(clr);
            if (fks != null && !fks.isEmpty()) {
                for (ForeignKey fk : fks) {
                    NucleusLogger.GENERAL.debug((Object)(">> TODO Add FK in CREATE TABLE as " + fk));
                }
            }
            if (fkConstraintStmt.length() > 1) {
                createStmt.append(fkConstraintStmt.toString());
            }
        }
        if (this.supportsOption("CheckInEndCreateStatements")) {
            StringBuilder checkConstraintStmt = new StringBuilder();
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i].getCheckConstraints() == null) continue;
                checkConstraintStmt.append(",").append(this.getContinuationString());
                checkConstraintStmt.append(indent).append(columns[i].getCheckConstraints());
            }
            if (checkConstraintStmt.length() > 1) {
                createStmt.append(checkConstraintStmt.toString());
            }
        }
        createStmt.append(this.getContinuationString()).append(")");
        return createStmt.toString();
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        if (pk.getName() != null) {
            String identifier = factory.getIdentifierInAdapterCase(pk.getName());
            return "ALTER TABLE " + pk.getTable().toString() + " ADD CONSTRAINT " + identifier + ' ' + pk;
        }
        return "ALTER TABLE " + pk.getTable().toString() + " ADD " + pk;
    }

    @Override
    public String getAddCandidateKeyStatement(CandidateKey ck, IdentifierFactory factory) {
        StringBuilder str = new StringBuilder("ALTER TABLE ").append(ck.getTable().toString());
        if (ck.getName() != null) {
            String identifier = factory.getIdentifierInAdapterCase(ck.getName());
            str.append(" ADD CONSTRAINT ").append(identifier).append(" UNIQUE ").append(ck.getColumnList());
        } else {
            str.append(" ADD UNIQUE ").append(ck.getColumnList());
        }
        String extendedSetting = ck.getValueForExtension("extended-setting");
        if (extendedSetting != null) {
            str.append(" ").append(extendedSetting);
        }
        return str.toString();
    }

    @Override
    public String getAddForeignKeyStatement(ForeignKey fk, IdentifierFactory factory) {
        if (fk.getName() != null) {
            String identifier = factory.getIdentifierInAdapterCase(fk.getName());
            return "ALTER TABLE " + fk.getTable().toString() + " ADD CONSTRAINT " + identifier + ' ' + fk;
        }
        return "ALTER TABLE " + fk.getTable().toString() + " ADD " + fk;
    }

    @Override
    public String getAddColumnStatement(Table table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD " + col.getSQLDefinition();
    }

    @Override
    public String getCreateIndexStatement(Index idx, IdentifierFactory factory) {
        StringBuilder str = new StringBuilder();
        str.append("CREATE ").append(idx.getUnique() ? "UNIQUE " : "").append("INDEX ");
        str.append(factory.newTableIdentifier(idx.getName()).getFullyQualifiedName(true));
        str.append(" ON ").append(idx.getTable().toString());
        str.append(" ").append(idx.getColumnList());
        String extendedSetting = idx.getValueForExtension("extended-setting");
        if (extendedSetting != null) {
            str.append(" ").append(extendedSetting);
        }
        return str.toString();
    }

    @Override
    public String getCheckConstraintForValues(DatastoreIdentifier identifier, Object[] values, boolean nullable) {
        StringBuilder constraints = new StringBuilder("CHECK (");
        constraints.append(identifier);
        constraints.append(" IN (");
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                constraints.append(",");
            }
            if (values[i] instanceof String) {
                constraints.append("'").append(values[i]).append("'");
                continue;
            }
            constraints.append(values[i]);
        }
        constraints.append(")");
        if (nullable) {
            constraints.append(" OR " + identifier + " IS NULL");
        }
        constraints.append(")");
        return constraints.toString();
    }

    @Override
    public String getCreateDatabaseStatement(String catalogName, String schemaName) {
        return "CREATE SCHEMA " + schemaName;
    }

    @Override
    public String getDropDatabaseStatement(String catalogName, String schemaName) {
        return "DROP SCHEMA " + schemaName;
    }

    @Override
    public String getDropTableStatement(Table table) {
        return "DROP TABLE " + table.toString() + " CASCADE";
    }

    @Override
    public String getDropViewStatement(ViewImpl view) {
        return "DROP VIEW " + view.toString();
    }

    @Override
    public String getDeleteTableStatement(SQLTable tbl) {
        return "DELETE FROM " + tbl.toString();
    }

    @Override
    public SQLText getUpdateTableStatement(SQLTable tbl, SQLText setSQL) {
        SQLText sql = new SQLText("UPDATE ");
        sql.append(tbl.toString());
        sql.append(" ").append(setSQL);
        return sql;
    }

    @Override
    public String getRangeByLimitEndOfStatementClause(long offset, long count, boolean hasOrdering) {
        return "";
    }

    @Override
    public String getRangeByRowNumberColumn() {
        return "";
    }

    @Override
    public String getRangeByRowNumberColumn2() {
        return "";
    }

    @Override
    public ResultSet getColumns(Connection conn, String catalog, String schema, String tableNamePattern, String columnNamePattern) throws SQLException {
        return conn.getMetaData().getColumns(catalog, schema, tableNamePattern, columnNamePattern);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("================ DatabaseAdapter ==================");
        sb.append("\n");
        sb.append("Adapter : " + this.getClass().getName());
        sb.append("\n");
        sb.append("Datastore : name=\"" + this.datastoreProductName + "\" version=\"" + this.datastoreProductVersion + "\" (major=" + this.datastoreMajorVersion + ", minor=" + this.datastoreMinorVersion + ", revision=" + this.datastoreRevisionVersion + ")");
        sb.append("\n");
        sb.append("Driver : name=\"" + this.driverName + "\" version=\"" + this.driverVersion + "\" (major=" + this.driverMajorVersion + ", minor=" + this.driverMinorVersion + ")");
        sb.append("\n");
        sb.append("===================================================");
        return sb.toString();
    }

    @Override
    public String getDatastoreDateStatement() {
        return "SELECT CURRENT_TIMESTAMP";
    }

    @Override
    public String getPatternExpressionAnyCharacter() {
        return "_";
    }

    @Override
    public String getPatternExpressionZeroMoreCharacters() {
        return "%";
    }

    @Override
    public String getEscapePatternExpression() {
        return "ESCAPE '\\'";
    }

    @Override
    public String getEscapeCharacter() {
        return "\\";
    }

    public String getContinuationString() {
        return "\n";
    }

    @Override
    public String getNumericConversionFunction() {
        return "ASCII";
    }

    @Override
    public boolean isStatementCancel(SQLException sqle) {
        return false;
    }

    @Override
    public boolean isStatementTimeout(SQLException sqle) {
        return false;
    }

    @Override
    public boolean validToIndexMapping(JavaTypeMapping mapping) {
        return true;
    }

    @Override
    public Class getSQLOperationClass(String operationName) {
        if ("numericToString".equals(operationName)) {
            return NumericToStringOperation.class;
        }
        return null;
    }

    @Override
    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("abs".equals(methodName)) {
                return AbsFunction.class;
            }
            if ("acos".equals(methodName)) {
                return AcosFunction.class;
            }
            if ("asin".equals(methodName)) {
                return AsinFunction.class;
            }
            if ("atan".equals(methodName)) {
                return AtanFunction.class;
            }
            if ("avg".equals(methodName)) {
                return AvgFunction.class;
            }
            if ("ceil".equals(methodName)) {
                return CeilFunction.class;
            }
            if ("cos".equals(methodName)) {
                return CosFunction.class;
            }
            if ("count".equals(methodName)) {
                return CountFunction.class;
            }
            if ("exp".equals(methodName)) {
                return ExpFunction.class;
            }
            if ("floor".equals(methodName)) {
                return FloorFunction.class;
            }
            if ("log".equals(methodName)) {
                return LogFunction.class;
            }
            if ("max".equals(methodName)) {
                return MaxFunction.class;
            }
            if ("min".equals(methodName)) {
                return MinFunction.class;
            }
            if ("power".equals(methodName)) {
                return PowerFunction.class;
            }
            if ("sin".equals(methodName)) {
                return SinFunction.class;
            }
            if ("sqrt".equals(methodName)) {
                return SqrtFunction.class;
            }
            if ("sum".equals(methodName)) {
                return SumFunction.class;
            }
            if ("tan".equals(methodName)) {
                return TanFunction.class;
            }
            if ("degrees".equals(methodName)) {
                return DegreesFunction.class;
            }
            if ("radians".equals(methodName)) {
                return RadiansFunction.class;
            }
            if ("ABS".equals(methodName)) {
                return AbsFunction.class;
            }
            if ("ACOS".equals(methodName)) {
                return AcosFunction.class;
            }
            if ("ASIN".equals(methodName)) {
                return AsinFunction.class;
            }
            if ("ATAN".equals(methodName)) {
                return AtanFunction.class;
            }
            if ("AVG".equals(methodName)) {
                return AvgFunction.class;
            }
            if ("CEIL".equals(methodName)) {
                return CeilFunction.class;
            }
            if ("COS".equals(methodName)) {
                return CosFunction.class;
            }
            if ("COUNT".equals(methodName)) {
                return CountFunction.class;
            }
            if ("COUNTSTAR".equals(methodName)) {
                return CountStarFunction.class;
            }
            if ("EXP".equals(methodName)) {
                return ExpFunction.class;
            }
            if ("FLOOR".equals(methodName)) {
                return FloorFunction.class;
            }
            if ("LOG".equals(methodName)) {
                return LogFunction.class;
            }
            if ("MAX".equals(methodName)) {
                return MaxFunction.class;
            }
            if ("MIN".equals(methodName)) {
                return MinFunction.class;
            }
            if ("POWER".equals(methodName)) {
                return PowerFunction.class;
            }
            if ("SIN".equals(methodName)) {
                return SinFunction.class;
            }
            if ("SQRT".equals(methodName)) {
                return SqrtFunction.class;
            }
            if ("SUM".equals(methodName)) {
                return SumFunction.class;
            }
            if ("TAN".equals(methodName)) {
                return TanFunction.class;
            }
            if ("RADIANS".equals(methodName)) {
                return RadiansFunction.class;
            }
            if ("DEGREES".equals(methodName)) {
                return DegreesFunction.class;
            }
            if ("COALESCE".equals(methodName)) {
                return CoalesceFunction.class;
            }
            if ("NULLIF".equals(methodName)) {
                return NullIfFunction.class;
            }
            if ("INDEX".equals(methodName)) {
                return IndexFunction.class;
            }
            if ("CURRENT_DATE".equals(methodName)) {
                return CurrentDateFunction.class;
            }
            if ("CURRENT_TIME".equals(methodName)) {
                return CurrentTimeFunction.class;
            }
            if ("CURRENT_TIMESTAMP".equals(methodName)) {
                return CurrentTimestampFunction.class;
            }
            if ("Math.abs".equals(methodName)) {
                return MathAbsMethod.class;
            }
            if ("Math.acos".equals(methodName)) {
                return MathAcosMethod.class;
            }
            if ("Math.asin".equals(methodName)) {
                return MathAsinMethod.class;
            }
            if ("Math.atan".equals(methodName)) {
                return MathAtanMethod.class;
            }
            if ("Math.ceil".equals(methodName)) {
                return MathCeilMethod.class;
            }
            if ("Math.cos".equals(methodName)) {
                return MathCosMethod.class;
            }
            if ("Math.exp".equals(methodName)) {
                return MathExpMethod.class;
            }
            if ("Math.floor".equals(methodName)) {
                return MathFloorMethod.class;
            }
            if ("Math.log".equals(methodName)) {
                return MathLogMethod.class;
            }
            if ("Math.power".equals(methodName)) {
                return MathPowerMethod.class;
            }
            if ("Math.round".equals(methodName)) {
                return RoundMethod.class;
            }
            if ("Math.sin".equals(methodName)) {
                return MathSinMethod.class;
            }
            if ("Math.sqrt".equals(methodName)) {
                return MathSqrtMethod.class;
            }
            if ("Math.tan".equals(methodName)) {
                return MathTanMethod.class;
            }
            if ("Math.toRadians".equals(methodName)) {
                return MathToRadiansMethod.class;
            }
            if ("Math.toDegrees".equals(methodName)) {
                return MathToDegreesMethod.class;
            }
            if ("JDOHelper.getObjectId".equals(methodName)) {
                return JDOHelperGetObjectIdMethod.class;
            }
            if ("JDOHelper.getVersion".equals(methodName)) {
                return JDOHelperGetVersionMethod.class;
            }
            if ("SQL_boolean".equals(methodName)) {
                return SQLBooleanMethod.class;
            }
            if ("SQL_numeric".equals(methodName)) {
                return SQLNumericMethod.class;
            }
            if ("SQL_function".equals(methodName)) {
                return SQLFunctionMethod.class;
            }
            if ("YEAR".equals(methodName)) {
                return TemporalYearMethod.class;
            }
            if ("MONTH".equals(methodName)) {
                return TemporalMonthMethod.class;
            }
            if ("MONTH_JAVA".equals(methodName)) {
                return TemporalMonthJavaMethod.class;
            }
            if ("DAY".equals(methodName)) {
                return TemporalDayMethod.class;
            }
            if ("HOUR".equals(methodName)) {
                return TemporalHourMethod.class;
            }
            if ("MINUTE".equals(methodName)) {
                return TemporalMinuteMethod.class;
            }
            if ("SECOND".equals(methodName)) {
                return TemporalSecondMethod.class;
            }
            if ("ROUND".equals(methodName)) {
                return RoundMethod.class;
            }
        } else {
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if ("java.lang.Character".equals(className)) {
                if ("toUpperCase".equals(methodName)) {
                    return StringToUpperMethod.class;
                }
                if ("toLowerCase".equals(methodName)) {
                    return StringToLowerMethod.class;
                }
            }
            if ("java.lang.Enum".equals(className)) {
                if ("ordinal".equals(methodName)) {
                    return EnumOrdinalMethod.class;
                }
                if ("toString".equals(methodName)) {
                    return EnumToStringMethod.class;
                }
            }
            if ("java.lang.Object".equals(className) && "getClass".equals(methodName)) {
                return ObjectGetClassMethod.class;
            }
            if ("java.lang.String".equals(className)) {
                if ("charAt".equals(methodName)) {
                    return StringCharAtMethod.class;
                }
                if ("endsWith".equals(methodName)) {
                    return StringEndsWithMethod.class;
                }
                if ("equals".equals(methodName)) {
                    return StringEqualsMethod.class;
                }
                if ("equalsIgnoreCase".equals(methodName)) {
                    return StringEqualsIgnoreCaseMethod.class;
                }
                if ("indexOf".equals(methodName)) {
                    return StringIndexOfMethod.class;
                }
                if ("length".equals(methodName)) {
                    return StringLengthMethod.class;
                }
                if ("matches".equals(methodName)) {
                    return StringMatchesMethod.class;
                }
                if ("replaceAll".equals(methodName)) {
                    return StringReplaceAllMethod.class;
                }
                if ("startsWith".equals(methodName)) {
                    return StringStartsWithMethod.class;
                }
                if ("substring".equals(methodName)) {
                    return StringSubstringMethod.class;
                }
                if ("toUpperCase".equals(methodName)) {
                    return StringToUpperMethod.class;
                }
                if ("toLowerCase".equals(methodName)) {
                    return StringToLowerMethod.class;
                }
                if ("trim".equals(methodName)) {
                    return StringTrimMethod.class;
                }
                if ("trimLeft".equals(methodName)) {
                    return StringTrimLeftMethod.class;
                }
                if ("trimRight".equals(methodName)) {
                    return StringTrimRightMethod.class;
                }
            }
            if ("java.util.Collection".equals(className) || cls != null && Collection.class.isAssignableFrom(cls)) {
                if ("contains".equals(methodName)) {
                    return CollectionContainsMethod.class;
                }
                if ("isEmpty".equals(methodName)) {
                    return CollectionIsEmptyMethod.class;
                }
                if ("size".equals(methodName)) {
                    return CollectionSizeMethod.class;
                }
                if ("get".equals(methodName)) {
                    return ListGetMethod.class;
                }
                if ("indexOf".equals(methodName)) {
                    return ListIndexOfMethod.class;
                }
            }
            if ("java.util.Date".equals(className) || cls != null && Date.class.isAssignableFrom(cls)) {
                if ("getDay".equals(methodName)) {
                    return TemporalDayMethod.class;
                }
                if ("getDate".equals(methodName)) {
                    return TemporalDayMethod.class;
                }
                if ("getMonth".equals(methodName)) {
                    return TemporalMonthJavaMethod.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod.class;
                }
            }
            if ("java.util.Map".equals(className) || cls != null && Map.class.isAssignableFrom(cls)) {
                if ("mapKey".equals(methodName)) {
                    return MapKeyMethod.class;
                }
                if ("mapValue".equals(methodName)) {
                    return MapValueMethod.class;
                }
                if ("containsEntry".equals(methodName)) {
                    return MapContainsEntryMethod.class;
                }
                if ("containsKey".equals(methodName)) {
                    return MapContainsKeyMethod.class;
                }
                if ("containsValue".equals(methodName)) {
                    return MapContainsValueMethod.class;
                }
                if ("get".equals(methodName)) {
                    return MapGetMethod.class;
                }
                if ("isEmpty".equals(methodName)) {
                    return MapIsEmptyMethod.class;
                }
                if ("size".equals(methodName)) {
                    return MapSizeMethod.class;
                }
            }
            if ("ARRAY".equals(className)) {
                if ("contains".equals(methodName)) {
                    return ArrayContainsMethod.class;
                }
                if ("isEmpty".equals(methodName)) {
                    return ArrayIsEmptyMethod.class;
                }
                if ("size".equals(methodName)) {
                    return ArraySizeMethod.class;
                }
                if ("length".equals(methodName)) {
                    return ArraySizeMethod.class;
                }
            }
            if ("java.time.LocalTime".equals(className)) {
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod.class;
                }
            }
            if ("java.time.LocalDate".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod.class;
                }
            }
            if ("java.time.LocalDateTime".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod.class;
                }
            }
            if ("java.time.MonthDay".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod.class;
                }
            }
            if ("java.time.Period".equals(className)) {
                if ("getMonths".equals(methodName)) {
                    return TemporalMonthMethod.class;
                }
                if ("getDays".equals(methodName)) {
                    return TemporalDayMethod.class;
                }
                if ("getYears".equals(methodName)) {
                    return TemporalYearMethod.class;
                }
            }
            if ("java.time.YearMonth".equals(className)) {
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod.class;
                }
            }
            if ("java.util.Optional".equals(className)) {
                if ("get".equals(methodName)) {
                    return OptionalGetMethod.class;
                }
                if ("isPresent".equals(methodName)) {
                    return OptionalIsPresentMethod.class;
                }
                if ("orElse".equals(methodName)) {
                    return OptionalOrElseMethod.class;
                }
            }
        }
        return null;
    }

    protected void loadColumnMappings(PluginManager pluginMgr, ClassLoaderResolver clr) {
        ConfigurationElement[] elems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.store.rdbms.column_mapping", null, null);
        if (elems != null) {
            for (ConfigurationElement elem : elems) {
                String javaName = elem.getAttribute("java-type").trim();
                String columnMappingClassName = elem.getAttribute("column-mapping-class");
                String jdbcType = elem.getAttribute("jdbc-type");
                String sqlType = elem.getAttribute("sql-type");
                String defaultJava = elem.getAttribute("default");
                boolean defaultForJavaType = false;
                if (defaultJava != null && defaultJava.equalsIgnoreCase("true")) {
                    defaultForJavaType = Boolean.TRUE;
                }
                Class mappingType = null;
                if (StringUtils.isWhitespace((String)columnMappingClassName)) continue;
                try {
                    mappingType = pluginMgr.loadClass(elem.getExtension().getPlugin().getSymbolicName(), columnMappingClassName);
                }
                catch (NucleusException ne) {
                    NucleusLogger.DATASTORE.error((Object)Localiser.msg((String)"041013", (Object[])new Object[]{columnMappingClassName}));
                }
                HashSet<String> includes = new HashSet<String>();
                HashSet<String> excludes = new HashSet<String>();
                for (ConfigurationElement childElem : elem.getChildren()) {
                    if (childElem.getName().equals("includes")) {
                        includes.add(childElem.getAttribute("vendor-id"));
                        continue;
                    }
                    if (!childElem.getName().equals("excludes")) continue;
                    excludes.add(childElem.getAttribute("vendor-id"));
                }
                if (excludes.contains(this.getVendorID()) || !includes.isEmpty() && !includes.contains(this.getVendorID())) continue;
                this.registerColumnMapping(javaName, (Class<? extends ColumnMapping>)mappingType, jdbcType, sqlType, defaultForJavaType);
            }
        }
    }

    @Override
    public void registerColumnMapping(String javaTypeName, Class<? extends ColumnMapping> columnMappingType, String jdbcType, String sqlType, boolean dflt) {
        ColumnTypeMappings typeMappings = this.datastoreTypeMappingsByJavaType.get(javaTypeName);
        if (typeMappings == null) {
            typeMappings = new ColumnTypeMappings();
            this.datastoreTypeMappingsByJavaType.put(javaTypeName, typeMappings);
        }
        if (!StringUtils.isWhitespace((String)jdbcType)) {
            typeMappings.columnMappingByJdbcType.put(jdbcType, columnMappingType);
        }
        if (!StringUtils.isWhitespace((String)sqlType)) {
            typeMappings.columnMappingBySqlType.put(sqlType, columnMappingType);
        }
        if (dflt) {
            typeMappings.defaultJdbcType = jdbcType;
            typeMappings.defaultSqlType = sqlType;
            typeMappings.defaultColumnMappingType = columnMappingType;
        }
    }

    public void registerColumnMapping(String javaTypeName, Class<? extends ColumnMapping> columnMappingType, JDBCType jdbcType, String sqlType, boolean dflt) {
        this.registerColumnMapping(javaTypeName, columnMappingType, jdbcType != null ? jdbcType.getName() : null, sqlType, dflt);
    }

    @Override
    public void deregisterColumnMappingsForJDBCType(String jdbcTypeName) {
        for (Map.Entry<String, ColumnTypeMappings> typeMappingEntry : this.datastoreTypeMappingsByJavaType.entrySet()) {
            ColumnTypeMappings typeMappings = typeMappingEntry.getValue();
            Class<? extends ColumnMapping> dsMappingType = typeMappings.columnMappingByJdbcType.remove(jdbcTypeName);
            if (dsMappingType != null && NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"054010", (Object[])new Object[]{typeMappingEntry.getKey(), jdbcTypeName}));
            }
            typeMappings.columnMappingBySqlType.remove(jdbcTypeName);
            if (!jdbcTypeName.equals(typeMappings.defaultJdbcType)) continue;
            typeMappings.defaultJdbcType = null;
            typeMappings.defaultSqlType = null;
            typeMappings.defaultColumnMappingType = null;
            NucleusLogger.DATASTORE.warn((Object)("Default type for java type of " + typeMappingEntry.getKey() + " was previously jdbc-type=" + jdbcTypeName + " but this is not provided by the JDBC driver! Please report this to the DataNucleus developers"));
            if (typeMappings.columnMappingByJdbcType.size() <= 0) continue;
            typeMappings.defaultJdbcType = typeMappings.columnMappingByJdbcType.keySet().iterator().next();
            typeMappings.defaultColumnMappingType = typeMappings.columnMappingByJdbcType.get(typeMappings.defaultJdbcType);
        }
    }

    @Override
    public String getDefaultSqlTypeForJavaType(String javaType, String jdbcType) {
        if (javaType == null || jdbcType == null) {
            return null;
        }
        ColumnTypeMappings typeMappings = this.datastoreTypeMappingsByJavaType.get(javaType);
        if (typeMappings != null) {
            return typeMappings.defaultSqlType;
        }
        return null;
    }

    @Override
    public Class<? extends ColumnMapping> getColumnMappingClass(String javaType, String jdbcType, String sqlType, ClassLoaderResolver clr, String fieldName) {
        if (javaType == null) {
            return null;
        }
        ColumnTypeMappings typeMappings = this.datastoreTypeMappingsByJavaType.get(javaType = ClassUtils.getWrapperTypeNameForPrimitiveTypeName((String)javaType));
        if (typeMappings != null) {
            Class<? extends ColumnMapping> cls;
            if (sqlType != null) {
                cls = typeMappings.columnMappingBySqlType.get(sqlType.toUpperCase());
                if (cls != null) {
                    return cls;
                }
                if (jdbcType == null) {
                    if (fieldName != null) {
                        throw new NucleusException(Localiser.msg((String)"054001", (Object[])new Object[]{javaType, sqlType, fieldName})).setFatal();
                    }
                    throw new NucleusException(Localiser.msg((String)"054000", (Object[])new Object[]{javaType, sqlType})).setFatal();
                }
            }
            if (jdbcType != null) {
                cls = typeMappings.columnMappingByJdbcType.get(jdbcType.toUpperCase());
                if (cls != null) {
                    return cls;
                }
                if (fieldName != null) {
                    throw new NucleusException(Localiser.msg((String)"054003", (Object[])new Object[]{javaType, jdbcType, fieldName})).setFatal();
                }
                throw new NucleusException(Localiser.msg((String)"054002", (Object[])new Object[]{javaType, jdbcType})).setFatal();
            }
        } else {
            Class javaTypeClass = clr.classForName(javaType);
            for (Class superClass = javaTypeClass.getSuperclass(); superClass != null && !superClass.getName().equals(ClassNameConstants.Object) && typeMappings == null; superClass = superClass.getSuperclass()) {
                typeMappings = this.datastoreTypeMappingsByJavaType.get(superClass.getName());
            }
        }
        if (typeMappings != null) {
            if (typeMappings.defaultColumnMappingType != null) {
                return typeMappings.defaultColumnMappingType;
            }
            if (typeMappings.columnMappingByJdbcType.size() > 0) {
                return typeMappings.columnMappingByJdbcType.values().iterator().next();
            }
        }
        if (fieldName != null) {
            throw new NucleusException(Localiser.msg((String)"054005", (Object[])new Object[]{javaType, jdbcType, sqlType, fieldName})).setFatal();
        }
        throw new NucleusException(Localiser.msg((String)"054004", (Object[])new Object[]{javaType, jdbcType, sqlType})).setFatal();
    }

    protected static class ColumnTypeMappings {
        String defaultJdbcType;
        String defaultSqlType;
        Class<? extends ColumnMapping> defaultColumnMappingType;
        Map<String, Class<? extends ColumnMapping>> columnMappingByJdbcType = new HashMap<String, Class<? extends ColumnMapping>>();
        Map<String, Class<? extends ColumnMapping>> columnMappingBySqlType = new HashMap<String, Class<? extends ColumnMapping>>();

        protected ColumnTypeMappings() {
        }

        public String toString() {
            return "jdbc-types=" + StringUtils.collectionToString(this.columnMappingByJdbcType.keySet()) + ", sql-types=" + StringUtils.collectionToString(this.columnMappingBySqlType.keySet()) + " default (jdbc-type=" + this.defaultJdbcType + ", sql-type=" + this.defaultSqlType + ")";
        }
    }
}

