/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.connectionpool;

import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.connectionpool.AbstractConnectionPoolFactory;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPool;
import org.datanucleus.store.rdbms.connectionpool.DatastorePoolException;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.StringUtils;

public class DBCP2ConnectionPoolFactory
extends AbstractConnectionPoolFactory {
    @Override
    public ConnectionPool createConnectionPool(StoreManager storeMgr) {
        GenericObjectPool connectionPool;
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        String dbDriver = storeMgr.getConnectionDriverName();
        if (!StringUtils.isWhitespace((String)dbDriver)) {
            this.loadDriver(dbDriver, clr);
        }
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"org.apache.commons.pool2.ObjectPool", (String)"commons-pool-2.x.jar");
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"org.apache.commons.dbcp2.ConnectionFactory", (String)"commons-dbcp-2.x.jar");
        PoolingDataSource ds = null;
        String dbURL = storeMgr.getConnectionURL();
        try {
            int value;
            Properties dbProps = DBCP2ConnectionPoolFactory.getPropertiesForDriver(storeMgr);
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(dbURL, dbProps);
            PoolableConnectionFactory poolableCF = null;
            poolableCF = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
            String testSQL = null;
            if (storeMgr.hasProperty("datanucleus.connectionPool.testSQL")) {
                testSQL = storeMgr.getStringProperty("datanucleus.connectionPool.testSQL");
                poolableCF.setValidationQuery(testSQL);
            }
            connectionPool = new GenericObjectPool((PooledObjectFactory)poolableCF);
            poolableCF.setPool((ObjectPool)connectionPool);
            if (testSQL != null) {
                connectionPool.setTestOnBorrow(true);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.maxIdle") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.maxIdle")) > 0) {
                connectionPool.setMaxIdle(value);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.minIdle") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.minIdle")) > 0) {
                connectionPool.setMinIdle(value);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.maxActive") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.maxActive")) > 0) {
                connectionPool.setMaxTotal(value);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.maxWait") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.maxWait")) > 0) {
                connectionPool.setMaxWaitMillis((long)value);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.timeBetweenEvictionRunsMillis") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.timeBetweenEvictionRunsMillis")) > 0) {
                connectionPool.setTimeBetweenEvictionRunsMillis((long)value);
                int maxIdle = connectionPool.getMaxIdle();
                int numTestsPerEvictionRun = (int)Math.ceil((double)maxIdle / 4.0);
                connectionPool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.minEvictableIdleTimeMillis") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.minEvictableIdleTimeMillis")) > 0) {
                connectionPool.setMinEvictableIdleTimeMillis((long)value);
            }
            ds = new PoolingDataSource((ObjectPool)connectionPool);
        }
        catch (Exception e) {
            throw new DatastorePoolException("DBCP2", dbDriver, dbURL, e);
        }
        return new DBCPConnectionPool(ds, (ObjectPool)connectionPool);
    }

    public class DBCPConnectionPool
    implements ConnectionPool {
        final PoolingDataSource dataSource;
        final ObjectPool pool;

        public DBCPConnectionPool(PoolingDataSource ds, ObjectPool pool) {
            this.dataSource = ds;
            this.pool = pool;
        }

        @Override
        public void close() {
            try {
                this.pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public DataSource getDataSource() {
            return this.dataSource;
        }
    }
}

