/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.MappingConsumer;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.MappingType;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.request.StatementMappingDefinition;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class DeleteRequest
extends Request {
    private final MappingCallbacks[] callbacks;
    private final String deleteStmt;
    private final String deleteStmtOptimistic;
    private final String softDeleteStmt;
    private StatementMappingDefinition mappingStatementIndex;
    private StatementMappingIndex multitenancyStatementMapping;
    private final int[] whereFieldNumbers;
    private final AbstractMemberMetaData[] oneToOneNonOwnerFields;
    protected AbstractClassMetaData cmd = null;
    protected VersionMetaData versionMetaData = null;
    protected boolean versionChecks = false;

    public DeleteRequest(DatastoreClass table, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        super(table);
        this.cmd = cmd;
        this.versionMetaData = table.getVersionMetaData();
        if (this.versionMetaData != null && this.versionMetaData.getVersionStrategy() != VersionStrategy.NONE) {
            this.versionChecks = true;
        }
        this.mappingStatementIndex = new StatementMappingDefinition();
        DeleteMappingConsumer consumer = new DeleteMappingConsumer(clr, cmd);
        table.provideNonPrimaryKeyMappings(consumer);
        consumer.setWhereClauseConsumption();
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            table.providePrimaryKeyMappings(consumer);
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            table.provideSurrogateMapping(SurrogateColumnType.DATASTORE_ID, consumer);
        } else {
            AbstractMemberMetaData[] mmds = cmd.getManagedMembers();
            table.provideMappingsForMembers(consumer, mmds, false);
        }
        table.provideSurrogateMapping(SurrogateColumnType.MULTITENANCY, consumer);
        this.deleteStmt = consumer.getStatement();
        if (this.versionMetaData != null) {
            if (this.versionMetaData.getFieldName() != null) {
                AbstractMemberMetaData[] versionFmds = new AbstractMemberMetaData[]{cmd.getMetaDataForMember(this.versionMetaData.getFieldName())};
                table.provideMappingsForMembers(consumer, versionFmds, false);
            } else {
                table.provideSurrogateMapping(SurrogateColumnType.VERSION, consumer);
            }
        }
        this.deleteStmtOptimistic = consumer.getStatement();
        this.softDeleteStmt = table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE) != null ? consumer.getSoftDeleteStatement() : null;
        this.whereFieldNumbers = consumer.getWhereFieldNumbers();
        this.callbacks = consumer.getMappingCallBacks().toArray(new MappingCallbacks[consumer.getMappingCallBacks().size()]);
        this.oneToOneNonOwnerFields = consumer.getOneToOneNonOwnerFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void execute(ObjectProvider op) {
        int i;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"052210", (Object[])new Object[]{op.getObjectAsPrintable(), this.table}));
        }
        ClassLoaderResolver clr = op.getExecutionContext().getClassLoaderResolver();
        HashSet<Object> relatedObjectsToDelete = null;
        for (i = 0; i < this.callbacks.length; ++i) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"052212", (Object[])new Object[]{op.getObjectAsPrintable(), ((JavaTypeMapping)((Object)this.callbacks[i])).getMemberMetaData().getFullFieldName()}));
            }
            this.callbacks[i].preDelete(op);
            JavaTypeMapping mapping = (JavaTypeMapping)((Object)this.callbacks[i]);
            AbstractMemberMetaData mmd = mapping.getMemberMetaData();
            RelationType relationType = mmd.getRelationType(clr);
            if (!mmd.isDependent() || relationType != RelationType.ONE_TO_ONE_UNI && (relationType != RelationType.ONE_TO_ONE_BI || mmd.getMappedBy() != null)) continue;
            try {
                op.isLoaded(mmd.getAbsoluteFieldNumber());
                Object relatedPc = op.provideField(mmd.getAbsoluteFieldNumber());
                boolean relatedObjectDeleted = op.getExecutionContext().getApiAdapter().isDeleted(relatedPc);
                if (relatedObjectDeleted) continue;
                if (relatedObjectsToDelete == null) {
                    relatedObjectsToDelete = new HashSet<Object>();
                }
                relatedObjectsToDelete.add(relatedPc);
                continue;
            }
            catch (Exception relatedPc) {
                // empty catch block
            }
        }
        if (this.oneToOneNonOwnerFields != null && this.oneToOneNonOwnerFields.length > 0) {
            for (i = 0; i < this.oneToOneNonOwnerFields.length; ++i) {
                AbstractMemberMetaData relatedFmd = this.oneToOneNonOwnerFields[i];
                this.updateOneToOneBidirectionalOwnerObjectForField(op, relatedFmd);
            }
        }
        String stmt = null;
        ExecutionContext ec = op.getExecutionContext();
        RDBMSStoreManager storeMgr = this.table.getStoreManager();
        boolean optimisticChecks = false;
        if (this.table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE) != null) {
            stmt = this.softDeleteStmt;
        } else {
            optimisticChecks = this.versionMetaData != null && ec.getTransaction().getOptimistic() && this.versionChecks;
            stmt = optimisticChecks ? this.deleteStmtOptimistic : this.deleteStmt;
        }
        try {
            ManagedConnection mconn = storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                boolean batch = true;
                if (optimisticChecks || !ec.getTransaction().isActive()) {
                    batch = false;
                }
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, batch);
                try {
                    if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
                        StatementMappingIndex mapIdx = this.mappingStatementIndex.getWhereDatastoreId();
                        for (int i2 = 0; i2 < mapIdx.getNumberOfParameterOccurrences(); ++i2) {
                            this.table.getSurrogateMapping(SurrogateColumnType.DATASTORE_ID, false).setObject(ec, ps, mapIdx.getParameterPositionsForOccurrence(i2), op.getInternalObjectId());
                        }
                    } else {
                        void var14_26;
                        StatementClassMapping mappingDefinition = new StatementClassMapping();
                        StatementMappingIndex[] idxs = this.mappingStatementIndex.getWhereFields();
                        boolean bl = false;
                        while (var14_26 < idxs.length) {
                            if (idxs[var14_26] != null) {
                                mappingDefinition.addMappingForMember((int)var14_26, idxs[var14_26]);
                            }
                            ++var14_26;
                        }
                        op.provideFields(this.whereFieldNumbers, (FieldManager)new ParameterSetter(op, ps, mappingDefinition));
                    }
                    if (this.multitenancyStatementMapping != null) {
                        this.table.getSurrogateMapping(SurrogateColumnType.MULTITENANCY, false).setObject(ec, ps, this.multitenancyStatementMapping.getParameterPositionsForOccurrence(0), ec.getNucleusContext().getMultiTenancyId(ec, this.cmd));
                    }
                    if (optimisticChecks) {
                        JavaTypeMapping verMapping = this.mappingStatementIndex.getWhereVersion().getMapping();
                        Object currentVersion = op.getTransactionalVersion();
                        if (currentVersion == null) {
                            String string = Localiser.msg((String)"052202", (Object[])new Object[]{op.getInternalObjectId(), this.table});
                            NucleusLogger.PERSISTENCE.error((Object)string);
                            throw new NucleusException(string);
                        }
                        StatementMappingIndex statementMappingIndex = this.mappingStatementIndex.getWhereVersion();
                        for (int i4 = 0; i4 < statementMappingIndex.getNumberOfParameterOccurrences(); ++i4) {
                            verMapping.setObject(ec, ps, statementMappingIndex.getParameterPositionsForOccurrence(i4), currentVersion);
                        }
                    }
                    int[] rcs = sqlControl.executeStatementUpdate(ec, mconn, stmt, ps, !batch);
                    if (optimisticChecks && rcs[0] == 0) {
                        throw new NucleusOptimisticException(Localiser.msg((String)"052203", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId(), "" + op.getTransactionalVersion()}), op.getObject());
                    }
                    if (relatedObjectsToDelete != null && !relatedObjectsToDelete.isEmpty()) {
                        for (Object e : relatedObjectsToDelete) {
                            ec.deleteObjectInternal(e);
                        }
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            String msg = Localiser.msg((String)"052211", (Object[])new Object[]{op.getObjectAsPrintable(), stmt, e.getMessage()});
            NucleusLogger.DATASTORE_PERSIST.warn((Object)msg);
            ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
            exceptions.add(e);
            while ((e = e.getNextException()) != null) {
                exceptions.add(e);
            }
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOneToOneBidirectionalOwnerObjectForField(ObjectProvider op, AbstractMemberMetaData fmd) {
        if (this.softDeleteStmt != null) {
            return;
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"052217", (Object[])new Object[]{op.getObjectAsPrintable(), fmd.getFullFieldName()}));
        }
        RDBMSStoreManager storeMgr = this.table.getStoreManager();
        ExecutionContext ec = op.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(clr);
        boolean checkFK = true;
        if (ec.getStringProperty("datanucleus.deletionPolicy").equals("JDO2")) {
            checkFK = false;
        }
        if (checkFK) {
            for (int i = 0; i < relatedMmds.length; ++i) {
                ForeignKeyMetaData relFkmd = relatedMmds[i].getForeignKeyMetaData();
                if (relFkmd == null || relFkmd.getDeleteAction() == null) continue;
                return;
            }
        }
        String fullClassName = ((AbstractClassMetaData)relatedMmds[0].getParent()).getFullClassName();
        String[] classes = (AbstractClassMetaData)relatedMmds[0].getParent() instanceof InterfaceMetaData ? storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(fullClassName, clr) : new String[]{fullClassName};
        HashSet<DatastoreClass> datastoreClasses = new HashSet<DatastoreClass>();
        for (int i = 0; i < classes.length; ++i) {
            datastoreClasses.add(storeMgr.getDatastoreClass(classes[i], clr));
        }
        for (DatastoreClass refTable : datastoreClasses) {
            int j;
            JavaTypeMapping refMapping = refTable.getMemberMapping(fmd.getMappedBy());
            if (!refMapping.isNullable()) continue;
            StringBuilder clearLinkStmt = new StringBuilder("UPDATE " + refTable.toString() + " SET ");
            for (j = 0; j < refMapping.getNumberOfDatastoreMappings(); ++j) {
                if (j > 0) {
                    clearLinkStmt.append(",");
                }
                clearLinkStmt.append(refMapping.getDatastoreMapping(j).getColumn().getIdentifier());
                clearLinkStmt.append("=NULL");
            }
            clearLinkStmt.append(" WHERE ");
            for (j = 0; j < refMapping.getNumberOfDatastoreMappings(); ++j) {
                if (j > 0) {
                    clearLinkStmt.append(" AND ");
                }
                clearLinkStmt.append(refMapping.getDatastoreMapping(j).getColumn().getIdentifier());
                clearLinkStmt.append("=?");
            }
            try {
                ManagedConnection mconn = storeMgr.getConnectionManager().getConnection(ec);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = null;
                    try {
                        ps = sqlControl.getStatementForUpdate(mconn, clearLinkStmt.toString(), false);
                        refMapping.setObject(ec, ps, MappingHelper.getMappingIndices(1, refMapping), op.getObject());
                        sqlControl.executeStatementUpdate(ec, mconn, clearLinkStmt.toString(), ps, true);
                    }
                    finally {
                        if (ps == null) continue;
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (Exception e) {
                throw new NucleusDataStoreException("Update request failed", (Throwable)e);
            }
        }
    }

    private class DeleteMappingConsumer
    implements MappingConsumer {
        boolean initialized = false;
        StringBuilder where = new StringBuilder();
        int paramIndex = 1;
        private List whereFields = new ArrayList();
        private List oneToOneNonOwnerFields = new ArrayList();
        private List mc = new ArrayList();
        private final ClassLoaderResolver clr;
        private final AbstractClassMetaData cmd;
        private boolean whereClauseConsumption = false;

        public DeleteMappingConsumer(ClassLoaderResolver clr, AbstractClassMetaData cmd) {
            this.clr = clr;
            this.cmd = cmd;
            this.paramIndex = 1;
        }

        public void setWhereClauseConsumption() {
            this.whereClauseConsumption = true;
        }

        @Override
        public void preConsumeMapping(int highest) {
            if (!this.initialized) {
                DeleteRequest.this.mappingStatementIndex.setWhereFields(new StatementMappingIndex[highest]);
                DeleteRequest.this.mappingStatementIndex.setUpdateFields(new StatementMappingIndex[highest]);
                this.initialized = true;
            }
        }

        @Override
        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData mmd) {
            if (!mmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                return;
            }
            if (m.includeInUpdateStatement()) {
                if (this.whereClauseConsumption) {
                    VersionMetaData vermd = this.cmd.getVersionMetaDataForTable();
                    if (!DeleteRequest.this.table.managesClass(this.cmd.getFullClassName())) {
                        vermd = this.cmd.getBaseAbstractClassMetaData().getVersionMetaDataForClass();
                    }
                    if (vermd != null && vermd.getFieldName() != null && mmd.getName().equals(vermd.getFieldName())) {
                        StatementMappingIndex sei = new StatementMappingIndex(m);
                        DeleteRequest.this.mappingStatementIndex.setWhereVersion(sei);
                        int[] parametersIndex = new int[]{this.paramIndex++};
                        sei.addParameterOccurrence(parametersIndex);
                        if (this.where.length() > 0) {
                            this.where.append(" AND ");
                        }
                        this.where.append(m.getDatastoreMapping(0).getColumn().getIdentifier());
                        this.where.append("=");
                        this.where.append(m.getDatastoreMapping(0).getUpdateInputParameter());
                    } else {
                        Integer abs_field_num = mmd.getAbsoluteFieldNumber();
                        int[] parametersIndex = new int[m.getNumberOfDatastoreMappings()];
                        StatementMappingIndex sei = new StatementMappingIndex(m);
                        sei.addParameterOccurrence(parametersIndex);
                        ((DeleteRequest)DeleteRequest.this).mappingStatementIndex.getWhereFields()[mmd.getAbsoluteFieldNumber()] = sei;
                        for (int j = 0; j < parametersIndex.length; ++j) {
                            if (this.where.length() > 0) {
                                this.where.append(" AND ");
                            }
                            this.where.append(m.getDatastoreMapping(j).getColumn().getIdentifier());
                            this.where.append("=");
                            this.where.append(m.getDatastoreMapping(j).getUpdateInputParameter());
                            if (!this.whereFields.contains(abs_field_num)) {
                                this.whereFields.add(abs_field_num);
                            }
                            ++this.paramIndex;
                        }
                    }
                }
                if ((m instanceof PersistableMapping || m instanceof ReferenceMapping) && m.getNumberOfDatastoreMappings() == 0) {
                    RelationType relationType = mmd.getRelationType(this.clr);
                    if (relationType == RelationType.ONE_TO_ONE_BI) {
                        if (mmd.getMappedBy() != null) {
                            this.oneToOneNonOwnerFields.add(mmd);
                        }
                    } else if (relationType == RelationType.MANY_TO_ONE_BI) {
                        AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(this.clr);
                        if (mmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) {
                            // empty if block
                        }
                    }
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mc.add(m);
            }
        }

        @Override
        public void consumeMapping(JavaTypeMapping m, MappingType mappingType) {
            if (mappingType == MappingType.DATASTORE_ID) {
                if (this.where.length() > 0) {
                    this.where.append(" AND ");
                }
                this.where.append(m.getDatastoreMapping(0).getColumn().getIdentifier().toString());
                this.where.append("=");
                this.where.append(m.getDatastoreMapping(0).getUpdateInputParameter());
                StatementMappingIndex datastoreMappingIdx = new StatementMappingIndex(m);
                DeleteRequest.this.mappingStatementIndex.setWhereDatastoreId(datastoreMappingIdx);
                int[] param = new int[]{this.paramIndex++};
                datastoreMappingIdx.addParameterOccurrence(param);
            } else if (mappingType == MappingType.VERSION) {
                if (this.where.length() > 0) {
                    this.where.append(" AND ");
                }
                this.where.append(m.getDatastoreMapping(0).getColumn().getIdentifier());
                this.where.append("=");
                this.where.append(m.getDatastoreMapping(0).getUpdateInputParameter());
                StatementMappingIndex versStmtIdx = new StatementMappingIndex(m);
                DeleteRequest.this.mappingStatementIndex.setWhereVersion(versStmtIdx);
                int[] param = new int[]{this.paramIndex++};
                versStmtIdx.addParameterOccurrence(param);
            } else if (mappingType == MappingType.MULTITENANCY) {
                JavaTypeMapping tenantMapping = DeleteRequest.this.table.getSurrogateMapping(SurrogateColumnType.MULTITENANCY, false);
                if (this.where.length() > 0) {
                    this.where.append(" AND ");
                }
                this.where.append(tenantMapping.getDatastoreMapping(0).getColumn().getIdentifier().toString());
                this.where.append("=");
                this.where.append(tenantMapping.getDatastoreMapping(0).getUpdateInputParameter());
                DeleteRequest.this.multitenancyStatementMapping = new StatementMappingIndex(tenantMapping);
                int[] param = new int[]{this.paramIndex++};
                DeleteRequest.this.multitenancyStatementMapping.addParameterOccurrence(param);
            }
        }

        @Override
        public void consumeUnmappedColumn(Column col) {
        }

        public int[] getWhereFieldNumbers() {
            int[] fieldNumbers = new int[this.whereFields.size()];
            for (int i = 0; i < this.whereFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.whereFields.get(i);
            }
            return fieldNumbers;
        }

        public AbstractMemberMetaData[] getOneToOneNonOwnerFields() {
            AbstractMemberMetaData[] fmds = new AbstractMemberMetaData[this.oneToOneNonOwnerFields.size()];
            for (int i = 0; i < this.oneToOneNonOwnerFields.size(); ++i) {
                fmds[i] = (AbstractMemberMetaData)this.oneToOneNonOwnerFields.get(i);
            }
            return fmds;
        }

        public List getMappingCallBacks() {
            return this.mc;
        }

        public String getStatement() {
            return "DELETE FROM " + DeleteRequest.this.table.toString() + " WHERE " + this.where;
        }

        public String getSoftDeleteStatement() {
            org.datanucleus.store.schema.table.Column softDeleteCol = DeleteRequest.this.table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE);
            return "UPDATE " + DeleteRequest.this.table.toString() + " SET " + softDeleteCol.getName() + "=TRUE WHERE " + this.where;
        }
    }
}

