/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.NoTableManagedException;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedKeyPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedValuePCMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.ColumnCreator;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.DatastoreMap;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.rdbms.table.TableUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class MapTable
extends JoinTable
implements DatastoreMap {
    protected Table ownerTable;
    private JavaTypeMapping keyMapping;
    private JavaTypeMapping valueMapping;
    private JavaTypeMapping orderMapping;

    public MapTable(Table ownerTable, DatastoreIdentifier tableName, AbstractMemberMetaData mmd, RDBMSStoreManager storeMgr) {
        super(ownerTable, tableName, mmd, storeMgr);
    }

    @Override
    public void initialize(ClassLoaderResolver clr) {
        Column elementCol;
        int i;
        this.assertIsUninitialized();
        MapMetaData mapmd = this.mmd.getMap();
        if (mapmd == null) {
            throw new NucleusUserException(Localiser.msg((String)"057017", (Object[])new Object[]{this.mmd}));
        }
        PrimaryKeyMetaData pkmd = this.mmd.getJoinMetaData() != null ? this.mmd.getJoinMetaData().getPrimaryKeyMetaData() : null;
        boolean pkColsSpecified = pkmd != null && pkmd.getColumnMetaData() != null;
        boolean pkRequired = this.requiresPrimaryKey();
        ColumnMetaData[] ownerColmd = null;
        if (this.mmd.getJoinMetaData() != null && this.mmd.getJoinMetaData().getColumnMetaData() != null && this.mmd.getJoinMetaData().getColumnMetaData().length > 0) {
            ownerColmd = this.mmd.getJoinMetaData().getColumnMetaData();
        }
        this.ownerMapping = ColumnCreator.createColumnsForJoinTables(clr.classForName(this.ownerType), this.mmd, ownerColmd, this.storeMgr, this, pkRequired, false, FieldRole.ROLE_OWNER, clr, null);
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            this.logMapping(this.mmd.getFullFieldName() + ".[OWNER]", this.ownerMapping);
        }
        String keyValueFieldName = this.mmd.getKeyMetaData() != null ? this.mmd.getKeyMetaData().getMappedBy() : null;
        String valueKeyFieldName = this.mmd.getValueMetaData() != null ? this.mmd.getValueMetaData().getMappedBy() : null;
        boolean keyPC = this.mmd.hasMap() && this.mmd.getMap().keyIsPersistent();
        Class keyCls = clr.classForName(mapmd.getKeyType());
        if (keyValueFieldName == null || !this.isEmbeddedValuePC()) {
            if (this.isSerialisedKey() || this.isEmbeddedKeyPC() || this.isEmbeddedKey() && !keyPC || ClassUtils.isReferenceType((Class)keyCls)) {
                this.keyMapping = this.storeMgr.getMappingManager().getMapping(this, this.mmd, clr, FieldRole.ROLE_MAP_KEY);
                if (Boolean.TRUE.equals(this.mmd.getContainer().allowNulls())) {
                    for (int i2 = 0; i2 < this.keyMapping.getNumberOfDatastoreMappings(); ++i2) {
                        Column elementCol2 = this.keyMapping.getDatastoreMapping(i2).getColumn();
                        elementCol2.setNullable(true);
                    }
                }
                if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                    this.logMapping(this.mmd.getFullFieldName() + ".[KEY]", this.keyMapping);
                }
                if (valueKeyFieldName != null && this.isEmbeddedKeyPC()) {
                    EmbeddedKeyPCMapping embMapping = (EmbeddedKeyPCMapping)this.keyMapping;
                    this.valueMapping = embMapping.getJavaTypeMapping(valueKeyFieldName);
                }
            } else {
                ColumnMetaData[] keyColmd = null;
                KeyMetaData keymd = this.mmd.getKeyMetaData();
                if (keymd != null && keymd.getColumnMetaData() != null && keymd.getColumnMetaData().length > 0) {
                    keyColmd = keymd.getColumnMetaData();
                }
                this.keyMapping = ColumnCreator.createColumnsForJoinTables(keyCls, this.mmd, keyColmd, this.storeMgr, this, false, false, FieldRole.ROLE_MAP_KEY, clr, null);
                if (this.mmd.getContainer().allowNulls() == Boolean.TRUE) {
                    for (i = 0; i < this.keyMapping.getNumberOfDatastoreMappings(); ++i) {
                        elementCol = this.keyMapping.getDatastoreMapping(i).getColumn();
                        elementCol.setNullable(true);
                    }
                }
                if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                    this.logMapping(this.mmd.getFullFieldName() + ".[KEY]", this.keyMapping);
                }
            }
        }
        boolean valuePC = this.mmd.hasMap() && this.mmd.getMap().valueIsPersistent();
        Class valueCls = clr.classForName(mapmd.getValueType());
        if (valueKeyFieldName == null || !this.isEmbeddedKeyPC()) {
            if (this.isSerialisedValue() || this.isEmbeddedValuePC() || this.isEmbeddedValue() && !valuePC || ClassUtils.isReferenceType((Class)valueCls)) {
                this.valueMapping = this.storeMgr.getMappingManager().getMapping(this, this.mmd, clr, FieldRole.ROLE_MAP_VALUE);
                if (this.mmd.getContainer().allowNulls() == Boolean.TRUE) {
                    for (i = 0; i < this.valueMapping.getNumberOfDatastoreMappings(); ++i) {
                        elementCol = this.valueMapping.getDatastoreMapping(i).getColumn();
                        elementCol.setNullable(true);
                    }
                }
                if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                    this.logMapping(this.mmd.getFullFieldName() + ".[VALUE]", this.valueMapping);
                }
                if (keyValueFieldName != null && this.isEmbeddedValuePC()) {
                    EmbeddedValuePCMapping embMapping = (EmbeddedValuePCMapping)this.valueMapping;
                    this.keyMapping = embMapping.getJavaTypeMapping(keyValueFieldName);
                }
            } else {
                ColumnMetaData[] valueColmd = null;
                ValueMetaData valuemd = this.mmd.getValueMetaData();
                if (valuemd != null && valuemd.getColumnMetaData() != null && valuemd.getColumnMetaData().length > 0) {
                    valueColmd = valuemd.getColumnMetaData();
                }
                this.valueMapping = ColumnCreator.createColumnsForJoinTables(clr.classForName(mapmd.getValueType()), this.mmd, valueColmd, this.storeMgr, this, false, true, FieldRole.ROLE_MAP_VALUE, clr, null);
                if (this.mmd.getContainer().allowNulls() == Boolean.TRUE) {
                    for (int i3 = 0; i3 < this.valueMapping.getNumberOfDatastoreMappings(); ++i3) {
                        Column elementCol3 = this.valueMapping.getDatastoreMapping(i3).getColumn();
                        elementCol3.setNullable(true);
                    }
                }
                if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                    this.logMapping(this.mmd.getFullFieldName() + ".[VALUE]", this.valueMapping);
                }
            }
        }
        boolean orderRequired = false;
        if (this.mmd.getOrderMetaData() != null) {
            orderRequired = true;
        } else if (this.requiresPrimaryKey() && !pkColsSpecified) {
            if (this.isEmbeddedKeyPC()) {
                if (this.mmd.hasExtension("surrogate-pk-column") && this.mmd.getValueForExtension("surrogate-pk-column").equalsIgnoreCase("true")) {
                    orderRequired = true;
                } else if (this.storeMgr.getApiAdapter().getName().equalsIgnoreCase("JDO") && this.mmd.getMap().getKeyClassMetaData(clr).getIdentityType() != IdentityType.APPLICATION) {
                    orderRequired = true;
                }
            } else if (this.isSerialisedKey()) {
                orderRequired = true;
            } else if (this.keyMapping instanceof ReferenceMapping) {
                ReferenceMapping refMapping = (ReferenceMapping)this.keyMapping;
                if (refMapping.getJavaTypeMapping().length > 1) {
                    orderRequired = true;
                }
            } else if (!(this.keyMapping instanceof PersistableMapping)) {
                elementCol = this.keyMapping.getDatastoreMapping(0).getColumn();
                if (!this.storeMgr.getDatastoreAdapter().isValidPrimaryKeyType(elementCol.getJdbcType())) {
                    orderRequired = true;
                }
            }
        }
        if (orderRequired) {
            ColumnMetaData orderColmd = null;
            if (this.mmd.getOrderMetaData() != null && this.mmd.getOrderMetaData().getColumnMetaData() != null && this.mmd.getOrderMetaData().getColumnMetaData().length > 0) {
                orderColmd = this.mmd.getOrderMetaData().getColumnMetaData()[0];
                if (orderColmd.getName() == null) {
                    orderColmd = new ColumnMetaData(orderColmd);
                    DatastoreIdentifier id = this.storeMgr.getIdentifierFactory().newIndexFieldIdentifier(this.mmd);
                    orderColmd.setName(id.getName());
                }
            } else {
                DatastoreIdentifier id = this.storeMgr.getIdentifierFactory().newIndexFieldIdentifier(this.mmd);
                orderColmd = new ColumnMetaData();
                orderColmd.setName(id.getName());
            }
            this.orderMapping = this.storeMgr.getMappingManager().getMapping(Integer.TYPE);
            ColumnCreator.createIndexColumn(this.orderMapping, this.storeMgr, clr, this, orderColmd, pkRequired && !pkColsSpecified);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.logMapping(this.mmd.getFullFieldName() + ".[ORDER]", this.orderMapping);
            }
        }
        if (pkRequired) {
            if (pkColsSpecified) {
                this.applyUserPrimaryKeySpecification(pkmd);
            } else if (orderRequired) {
                this.orderMapping.getDatastoreMapping(0).getColumn().setPrimaryKey();
            } else {
                for (int i4 = 0; i4 < this.keyMapping.getNumberOfDatastoreMappings(); ++i4) {
                    this.keyMapping.getDatastoreMapping(i4).getColumn().setPrimaryKey();
                }
            }
        }
        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"057023", (Object[])new Object[]{this}));
        }
        this.storeMgr.registerTableInitialized(this);
        this.state = 2;
    }

    protected void applyUserPrimaryKeySpecification(PrimaryKeyMetaData pkmd) {
        ColumnMetaData[] pkCols = pkmd.getColumnMetaData();
        for (int i = 0; i < pkCols.length; ++i) {
            int j;
            String colName = pkCols[i].getName();
            boolean found = false;
            for (j = 0; j < this.ownerMapping.getNumberOfDatastoreMappings(); ++j) {
                if (!this.ownerMapping.getDatastoreMapping(j).getColumn().getIdentifier().getName().equals(colName)) continue;
                this.ownerMapping.getDatastoreMapping(j).getColumn().setPrimaryKey();
                found = true;
            }
            if (!found) {
                for (j = 0; j < this.keyMapping.getNumberOfDatastoreMappings(); ++j) {
                    if (!this.keyMapping.getDatastoreMapping(j).getColumn().getIdentifier().getName().equals(colName)) continue;
                    this.keyMapping.getDatastoreMapping(j).getColumn().setPrimaryKey();
                    found = true;
                }
            }
            if (!found) {
                for (j = 0; j < this.valueMapping.getNumberOfDatastoreMappings(); ++j) {
                    if (!this.valueMapping.getDatastoreMapping(j).getColumn().getIdentifier().getName().equals(colName)) continue;
                    this.valueMapping.getDatastoreMapping(j).getColumn().setPrimaryKey();
                    found = true;
                }
            }
            if (found) continue;
            throw new NucleusUserException(Localiser.msg((String)"057040", (Object[])new Object[]{this.toString(), colName}));
        }
    }

    public boolean isEmbeddedKey() {
        if (this.mmd.getMap() != null && this.mmd.getMap().isSerializedKey()) {
            return false;
        }
        return this.mmd.getMap() != null && this.mmd.getMap().isEmbeddedKey();
    }

    public boolean isSerialisedKey() {
        return this.mmd.getMap() != null && this.mmd.getMap().isSerializedKey();
    }

    public boolean isSerialisedKeyPC() {
        return this.mmd.getMap() != null && this.mmd.getMap().isSerializedKey() && this.mmd.getMap().keyIsPersistent();
    }

    public boolean isEmbeddedKeyPC() {
        AbstractClassMetaData keyCmd;
        if (this.mmd.getMap() != null && this.mmd.getMap().isSerializedKey()) {
            return false;
        }
        if (this.mmd.getKeyMetaData() != null && this.mmd.getKeyMetaData().getEmbeddedMetaData() != null) {
            return true;
        }
        return this.mmd.getMap() != null && (keyCmd = this.mmd.getMap().getKeyClassMetaData(this.storeMgr.getNucleusContext().getClassLoaderResolver(null))) != null && keyCmd.isEmbeddedOnly();
    }

    public boolean isEmbeddedValue() {
        if (this.mmd.getMap() != null && this.mmd.getMap().isSerializedValue()) {
            return false;
        }
        return this.mmd.getMap() != null && this.mmd.getMap().isEmbeddedValue();
    }

    public boolean isSerialisedValue() {
        return this.mmd.getMap() != null && this.mmd.getMap().isSerializedValue();
    }

    public boolean isSerialisedValuePC() {
        return this.mmd.getMap() != null && this.mmd.getMap().isSerializedValue() && this.mmd.getMap().valueIsPersistent();
    }

    public boolean isEmbeddedValuePC() {
        AbstractClassMetaData valCmd;
        if (this.mmd.getMap() != null && this.mmd.getMap().isSerializedValue()) {
            return false;
        }
        if (this.mmd.getValueMetaData() != null && this.mmd.getValueMetaData().getEmbeddedMetaData() != null) {
            return true;
        }
        return this.mmd.getMap() != null && (valCmd = this.mmd.getMap().getValueClassMetaData(this.storeMgr.getNucleusContext().getClassLoaderResolver(null))) != null && valCmd.isEmbeddedOnly();
    }

    @Override
    public JavaTypeMapping getKeyMapping() {
        this.assertIsInitialized();
        return this.keyMapping;
    }

    @Override
    public JavaTypeMapping getValueMapping() {
        this.assertIsInitialized();
        return this.valueMapping;
    }

    public String getKeyType() {
        return this.mmd.getMap().getKeyType();
    }

    public String getValueType() {
        return this.mmd.getMap().getValueType();
    }

    public JavaTypeMapping getOrderMapping() {
        this.assertIsInitialized();
        return this.orderMapping;
    }

    public List getExpectedForeignKeys(ClassLoaderResolver clr) {
        this.assertIsInitialized();
        boolean autoMode = false;
        if (this.storeMgr.getStringProperty("datanucleus.rdbms.constraintCreateMode").equals("DataNucleus")) {
            autoMode = true;
        }
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        try {
            ForeignKey fk;
            Collection fks;
            AbstractMemberMetaData embFmd;
            JavaTypeMapping embFieldMapping;
            EmbeddedMapping embMapping;
            ForeignKey fk2;
            ForeignKeyMetaData fkmd;
            DatastoreClass referencedTable = this.storeMgr.getDatastoreClass(this.ownerType, clr);
            if (referencedTable != null) {
                fkmd = null;
                if (this.mmd.getJoinMetaData() != null) {
                    fkmd = this.mmd.getJoinMetaData().getForeignKeyMetaData();
                }
                if (fkmd != null || autoMode) {
                    fk2 = new ForeignKey(this.ownerMapping, this.dba, referencedTable, true);
                    fk2.setForMetaData(fkmd);
                    foreignKeys.add(fk2);
                }
            }
            if (!this.isSerialisedValuePC()) {
                if (this.isEmbeddedValuePC()) {
                    embMapping = (EmbeddedValuePCMapping)this.valueMapping;
                    for (int i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                        embFieldMapping = embMapping.getJavaTypeMapping(i);
                        embFmd = embFieldMapping.getMemberMetaData();
                        if (ClassUtils.isReferenceType((Class)embFmd.getType()) && embFieldMapping instanceof ReferenceMapping) {
                            fks = TableUtils.getForeignKeysForReferenceField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr);
                            foreignKeys.addAll(fks);
                            continue;
                        }
                        if (this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(embFmd.getType(), clr) == null || embFieldMapping.getNumberOfDatastoreMappings() <= 0 || !(embFieldMapping instanceof PersistableMapping) || (fk = TableUtils.getForeignKeyForPCField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr)) == null) continue;
                        foreignKeys.add(fk);
                    }
                } else if (this.mmd.getMap().valueIsPersistent() && (referencedTable = this.storeMgr.getDatastoreClass(this.mmd.getMap().getValueType(), clr)) != null) {
                    fkmd = null;
                    if (this.mmd.getValueMetaData() != null) {
                        fkmd = this.mmd.getValueMetaData().getForeignKeyMetaData();
                    }
                    if (fkmd != null || autoMode) {
                        fk2 = new ForeignKey(this.valueMapping, this.dba, referencedTable, true);
                        fk2.setForMetaData(fkmd);
                        foreignKeys.add(fk2);
                    }
                }
            }
            if (!this.isSerialisedKeyPC()) {
                if (this.isEmbeddedKeyPC()) {
                    embMapping = (EmbeddedKeyPCMapping)this.keyMapping;
                    for (int i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                        embFieldMapping = embMapping.getJavaTypeMapping(i);
                        embFmd = embFieldMapping.getMemberMetaData();
                        if (ClassUtils.isReferenceType((Class)embFmd.getType()) && embFieldMapping instanceof ReferenceMapping) {
                            fks = TableUtils.getForeignKeysForReferenceField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr);
                            foreignKeys.addAll(fks);
                            continue;
                        }
                        if (this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(embFmd.getType(), clr) == null || embFieldMapping.getNumberOfDatastoreMappings() <= 0 || !(embFieldMapping instanceof PersistableMapping) || (fk = TableUtils.getForeignKeyForPCField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr)) == null) continue;
                        foreignKeys.add(fk);
                    }
                } else if (this.mmd.getMap().keyIsPersistent() && (referencedTable = this.storeMgr.getDatastoreClass(this.mmd.getMap().getKeyType(), clr)) != null) {
                    fkmd = null;
                    if (this.mmd.getKeyMetaData() != null) {
                        fkmd = this.mmd.getKeyMetaData().getForeignKeyMetaData();
                    }
                    if (fkmd != null || autoMode) {
                        fk2 = new ForeignKey(this.keyMapping, this.dba, referencedTable, true);
                        fk2.setForMetaData(fkmd);
                        foreignKeys.add(fk2);
                    }
                }
            }
        }
        catch (NoTableManagedException noTableManagedException) {
            // empty catch block
        }
        return foreignKeys;
    }

    protected Set getExpectedIndices(ClassLoaderResolver clr) {
        Index index;
        Index index2;
        IndexMetaData imd;
        JavaTypeMapping embFieldMapping;
        int i;
        EmbeddedMapping embMapping;
        Index index3;
        HashSet<Index> indices = new HashSet<Index>();
        if (this.mmd.getIndexMetaData() != null) {
            index3 = TableUtils.getIndexForField(this, this.mmd.getIndexMetaData(), this.ownerMapping);
            if (index3 != null) {
                indices.add(index3);
            }
        } else if (this.mmd.getJoinMetaData() != null && this.mmd.getJoinMetaData().getIndexMetaData() != null) {
            index3 = TableUtils.getIndexForField(this, this.mmd.getJoinMetaData().getIndexMetaData(), this.ownerMapping);
            if (index3 != null) {
                indices.add(index3);
            }
        } else {
            index3 = TableUtils.getIndexForField(this, null, this.ownerMapping);
            if (index3 != null) {
                indices.add(index3);
            }
        }
        if (this.keyMapping instanceof EmbeddedKeyPCMapping) {
            embMapping = (EmbeddedKeyPCMapping)this.keyMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                imd = embFieldMapping.getMemberMetaData().getIndexMetaData();
                if (imd == null || (index2 = TableUtils.getIndexForField(this, imd, embFieldMapping)) == null) continue;
                indices.add(index2);
            }
        } else {
            Index index4;
            KeyMetaData keymd = this.mmd.getKeyMetaData();
            if (keymd != null && keymd.getIndexMetaData() != null) {
                IndexMetaData idxmd = this.mmd.getKeyMetaData().getIndexMetaData();
                index = TableUtils.getIndexForField(this, idxmd, this.keyMapping);
                if (index != null) {
                    indices.add(index);
                }
            } else if (this.keyMapping instanceof PersistableMapping && (index4 = TableUtils.getIndexForField(this, null, this.keyMapping)) != null) {
                indices.add(index4);
            }
        }
        if (this.valueMapping instanceof EmbeddedValuePCMapping) {
            embMapping = (EmbeddedValuePCMapping)this.valueMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                imd = embFieldMapping.getMemberMetaData().getIndexMetaData();
                if (imd == null || (index2 = TableUtils.getIndexForField(this, imd, embFieldMapping)) == null) continue;
                indices.add(index2);
            }
        } else {
            Index index5;
            ValueMetaData valmd = this.mmd.getValueMetaData();
            if (valmd != null && valmd.getIndexMetaData() != null) {
                IndexMetaData idxmd = this.mmd.getValueMetaData().getIndexMetaData();
                index = TableUtils.getIndexForField(this, idxmd, this.valueMapping);
                if (index != null) {
                    indices.add(index);
                }
            } else if (this.valueMapping instanceof PersistableMapping && (index5 = TableUtils.getIndexForField(this, null, this.valueMapping)) != null) {
                indices.add(index5);
            }
        }
        return indices;
    }

    protected List getExpectedCandidateKeys() {
        CandidateKey ck;
        UniqueMetaData unimd;
        CandidateKey ck2;
        UniqueMetaData umd;
        JavaTypeMapping embFieldMapping;
        int i;
        EmbeddedMapping embMapping;
        List<CandidateKey> candidateKeys = super.getExpectedCandidateKeys();
        if (this.keyMapping instanceof EmbeddedKeyPCMapping) {
            embMapping = (EmbeddedKeyPCMapping)this.keyMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                umd = embFieldMapping.getMemberMetaData().getUniqueMetaData();
                if (umd == null || (ck2 = TableUtils.getCandidateKeyForField(this, umd, embFieldMapping)) == null) continue;
                candidateKeys.add(ck2);
            }
        } else if (this.mmd.getKeyMetaData() != null && (unimd = this.mmd.getKeyMetaData().getUniqueMetaData()) != null && (ck = TableUtils.getCandidateKeyForField(this, unimd, this.keyMapping)) != null) {
            candidateKeys.add(ck);
        }
        if (this.valueMapping instanceof EmbeddedValuePCMapping) {
            embMapping = (EmbeddedValuePCMapping)this.valueMapping;
            for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                embFieldMapping = embMapping.getJavaTypeMapping(i);
                umd = embFieldMapping.getMemberMetaData().getUniqueMetaData();
                if (umd == null || (ck2 = TableUtils.getCandidateKeyForField(this, umd, embFieldMapping)) == null) continue;
                candidateKeys.add(ck2);
            }
        } else if (this.mmd.getValueMetaData() != null && (unimd = this.mmd.getValueMetaData().getUniqueMetaData()) != null && (ck = TableUtils.getCandidateKeyForField(this, unimd, this.valueMapping)) != null) {
            candidateKeys.add(ck);
        }
        return candidateKeys;
    }

    @Override
    public JavaTypeMapping getMemberMapping(AbstractMemberMetaData mmd) {
        return null;
    }
}

