/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.sql.operation.SQLOperation;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class SQLExpressionFactory {
    private static final Class[] EXPR_CREATION_ARG_TYPES = new Class[]{SQLStatement.class, SQLTable.class, JavaTypeMapping.class};
    private static final Class[] LIT_CREATION_ARG_TYPES = new Class[]{SQLStatement.class, JavaTypeMapping.class, Object.class, String.class};
    RDBMSStoreManager storeMgr;
    ClassLoaderResolver clr;
    Map<String, Class> expressionClassByMappingName = new ConcurrentHashMap<String, Class>();
    Map<String, Class> literalClassByMappingName = new ConcurrentHashMap<String, Class>();
    Set<MethodKey> pluginSqlMethodsKeysSupported = new HashSet<MethodKey>();
    Map<MethodKey, SQLMethod> sqlMethodsByKey = new HashMap<MethodKey, SQLMethod>();
    Set<String> pluginSqlOperationKeysSupported = new HashSet<String>();
    Map<String, SQLOperation> sqlOperationsByName = new HashMap<String, SQLOperation>();
    Map<Class, JavaTypeMapping> mappingByClass = new HashMap<Class, JavaTypeMapping>();

    public SQLExpressionFactory(RDBMSStoreManager storeMgr) {
        ConfigurationElement[] operationElems;
        Object key;
        this.storeMgr = storeMgr;
        this.clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        PluginManager pluginMgr = storeMgr.getNucleusContext().getPluginManager();
        ConfigurationElement[] methodElems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.store.rdbms.sql_method", null, null);
        if (methodElems != null) {
            for (int i = 0; i < methodElems.length; ++i) {
                String datastoreName = methodElems[i].getAttribute("datastore");
                if (!StringUtils.isWhitespace((String)datastoreName) && !storeMgr.getDatastoreAdapter().getVendorID().equals(datastoreName)) continue;
                String className = methodElems[i].getAttribute("class");
                String methodName = methodElems[i].getAttribute("method").trim();
                key = this.getSQLMethodKey(datastoreName, className, methodName);
                this.pluginSqlMethodsKeysSupported.add((MethodKey)key);
            }
        }
        if ((operationElems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.store.rdbms.sql_operation", null, null)) != null) {
            for (int i = 0; i < operationElems.length; ++i) {
                String datastoreName = operationElems[i].getAttribute("datastore");
                if (!StringUtils.isWhitespace((String)datastoreName) && !storeMgr.getDatastoreAdapter().getVendorID().equals(datastoreName)) continue;
                String name = operationElems[i].getAttribute("name").trim();
                key = this.getSQLOperationKey(datastoreName, name);
                this.pluginSqlOperationKeysSupported.add((String)key);
            }
        }
    }

    public SQLExpression newExpression(SQLStatement stmt, SQLTable sqlTbl, JavaTypeMapping mapping) {
        return this.newExpression(stmt, sqlTbl, mapping, null);
    }

    public SQLExpression newExpression(SQLStatement stmt, SQLTable sqlTbl, JavaTypeMapping mapping, JavaTypeMapping parentMapping) {
        SQLTable exprSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, sqlTbl, parentMapping == null ? mapping : parentMapping);
        Object[] args = new Object[]{stmt, exprSqlTbl, mapping};
        Class expressionClass = this.expressionClassByMappingName.get(mapping.getClass().getName());
        if (expressionClass != null) {
            return (SQLExpression)ClassUtils.newInstance((Class)expressionClass, (Class[])EXPR_CREATION_ARG_TYPES, (Object[])new Object[]{stmt, exprSqlTbl, mapping});
        }
        try {
            SQLExpression sqlExpr = (SQLExpression)this.storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.sql_expression", "mapping-class", mapping.getClass().getName(), "expression-class", EXPR_CREATION_ARG_TYPES, args);
            if (sqlExpr == null) {
                throw new NucleusException(Localiser.msg((String)"060004", (Object[])new Object[]{mapping.getClass().getName()}));
            }
            this.expressionClassByMappingName.put(mapping.getClass().getName(), sqlExpr.getClass());
            return sqlExpr;
        }
        catch (Exception e) {
            String msg = Localiser.msg((String)"060005", (Object[])new Object[]{mapping.getClass().getName()});
            NucleusLogger.QUERY.error((Object)msg, (Throwable)e);
            throw new NucleusException(msg, (Throwable)e);
        }
    }

    public SQLExpression newLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
        Class literalClass;
        Object[] args = new Object[]{stmt, mapping, value, null};
        if (mapping != null && (literalClass = this.literalClassByMappingName.get(mapping.getClass().getName())) != null) {
            return (SQLExpression)ClassUtils.newInstance((Class)literalClass, (Class[])LIT_CREATION_ARG_TYPES, (Object[])args);
        }
        try {
            if (mapping == null) {
                return (SQLExpression)ClassUtils.newInstance(NullLiteral.class, (Class[])LIT_CREATION_ARG_TYPES, (Object[])args);
            }
            SQLExpression sqlExpr = (SQLExpression)this.storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.sql_expression", "mapping-class", mapping.getClass().getName(), "literal-class", LIT_CREATION_ARG_TYPES, args);
            if (sqlExpr == null) {
                throw new NucleusException(Localiser.msg((String)"060006", (Object[])new Object[]{mapping.getClass().getName()}));
            }
            this.literalClassByMappingName.put(mapping.getClass().getName(), sqlExpr.getClass());
            return sqlExpr;
        }
        catch (Exception e) {
            String mappingName = mapping != null ? mapping.getClass().getName() : null;
            NucleusLogger.QUERY.error((Object)("Exception creating SQLLiteral for mapping " + mappingName), (Throwable)e);
            throw new NucleusException(Localiser.msg((String)"060007", (Object[])new Object[]{mappingName}));
        }
    }

    public SQLExpression newLiteralParameter(SQLStatement stmt, JavaTypeMapping mapping, Object value, String paramName) {
        try {
            Object[] args = new Object[]{stmt, mapping, value, paramName};
            if (mapping == null) {
                return (SQLExpression)ClassUtils.newInstance(ParameterLiteral.class, (Class[])LIT_CREATION_ARG_TYPES, (Object[])args);
            }
            SQLExpression sqlExpr = (SQLExpression)this.storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.sql_expression", "mapping-class", mapping.getClass().getName(), "literal-class", LIT_CREATION_ARG_TYPES, args);
            if (sqlExpr == null) {
                throw new NucleusException(Localiser.msg((String)"060006", (Object[])new Object[]{mapping.getClass().getName()}));
            }
            return sqlExpr;
        }
        catch (Exception e) {
            String mappingName = mapping != null ? mapping.getClass().getName() : null;
            NucleusLogger.QUERY.error((Object)("Exception creating SQLLiteral for mapping " + mappingName), (Throwable)e);
            throw new NucleusException(Localiser.msg((String)"060007", (Object[])new Object[]{mappingName}));
        }
    }

    public SQLExpression invokeMethod(SQLStatement stmt, String className, String methodName, SQLExpression expr, List args) {
        SQLMethod method = this.getMethod(className, methodName, args);
        if (method != null) {
            return method.getExpression(stmt, expr, args);
        }
        return null;
    }

    public boolean isMethodRegistered(String className, String methodName) {
        if (this.storeMgr.getDatastoreAdapter().getSQLMethodClass(className, methodName, this.clr) != null) {
            return true;
        }
        if (this.pluginSqlMethodsKeysSupported.contains(this.getSQLMethodKey(this.storeMgr.getDatastoreAdapter().getVendorID(), className, methodName))) {
            return true;
        }
        return this.pluginSqlMethodsKeysSupported.contains(this.getSQLMethodKey(null, className, methodName));
    }

    public void registerMethod(String className, String methodName, SQLMethod method) {
        if (this.isMethodRegistered(className, methodName)) {
            throw new NucleusUserException("SQLMethod already defined for class=" + className + " method=" + methodName);
        }
        MethodKey methodKey = this.getSQLMethodKey(this.storeMgr.getDatastoreAdapter().getVendorID(), className, methodName);
        this.pluginSqlMethodsKeysSupported.add(methodKey);
        this.sqlMethodsByKey.put(methodKey, method);
    }

    protected SQLMethod getMethod(String className, String methodName, List args) {
        String[] stringArray;
        String[] stringArray2;
        String datastoreId = this.storeMgr.getDatastoreAdapter().getVendorID();
        MethodKey methodKey1 = this.getSQLMethodKey(datastoreId, className, methodName);
        MethodKey methodKey2 = null;
        SQLMethod method = this.sqlMethodsByKey.get(methodKey1);
        if (method == null) {
            methodKey2 = this.getSQLMethodKey(null, className, methodName);
            method = this.sqlMethodsByKey.get(methodKey2);
        }
        if (method != null) {
            return method;
        }
        Class sqlMethodCls = this.storeMgr.getDatastoreAdapter().getSQLMethodClass(className, methodName, this.clr);
        if (sqlMethodCls != null) {
            try {
                method = (SQLMethod)sqlMethodCls.newInstance();
                MethodKey key = this.getSQLMethodKey(datastoreId, className, methodName);
                this.sqlMethodsByKey.put(key, method);
                return method;
            }
            catch (Exception e) {
                throw new NucleusException("Error creating SQLMethod of type " + sqlMethodCls.getName() + " for class=" + className + " method=" + methodName);
            }
        }
        boolean datastoreDependent = true;
        if (!this.pluginSqlMethodsKeysSupported.contains(methodKey1)) {
            datastoreDependent = false;
            if (!this.pluginSqlMethodsKeysSupported.contains(methodKey2)) {
                boolean unsupported = true;
                if (!StringUtils.isWhitespace((String)className)) {
                    Class methodCls;
                    Class cls = this.clr.classForName(className);
                    for (MethodKey methodKey : this.pluginSqlMethodsKeysSupported) {
                        if (!methodKey.methodName.equals(methodName) || !methodKey.datastoreName.equals(datastoreId)) continue;
                        methodCls = null;
                        try {
                            methodCls = this.clr.classForName(methodKey.clsName);
                        }
                        catch (ClassNotResolvedException classNotResolvedException) {
                            // empty catch block
                        }
                        if (methodCls == null || !methodCls.isAssignableFrom(cls)) continue;
                        method = this.sqlMethodsByKey.get(methodKey);
                        if (method != null) {
                            MethodKey superMethodKey = new MethodKey();
                            superMethodKey.clsName = className;
                            superMethodKey.methodName = methodKey.methodName;
                            superMethodKey.datastoreName = methodKey.datastoreName;
                            this.sqlMethodsByKey.put(superMethodKey, method);
                            return method;
                        }
                        className = methodKey.clsName;
                        datastoreId = methodKey.datastoreName;
                        datastoreDependent = true;
                        unsupported = false;
                        break;
                    }
                    if (unsupported) {
                        for (MethodKey methodKey : this.pluginSqlMethodsKeysSupported) {
                            if (!methodKey.methodName.equals(methodName) || !methodKey.datastoreName.equals("ALL")) continue;
                            methodCls = null;
                            try {
                                methodCls = this.clr.classForName(methodKey.clsName);
                            }
                            catch (ClassNotResolvedException superMethodKey) {
                                // empty catch block
                            }
                            if (methodCls == null || !methodCls.isAssignableFrom(cls)) continue;
                            method = this.sqlMethodsByKey.get(methodKey);
                            if (method != null) {
                                MethodKey superMethodKey = new MethodKey();
                                superMethodKey.clsName = className;
                                superMethodKey.methodName = methodKey.methodName;
                                superMethodKey.datastoreName = methodKey.datastoreName;
                                this.sqlMethodsByKey.put(superMethodKey, method);
                                return method;
                            }
                            className = methodKey.clsName;
                            datastoreId = methodKey.datastoreName;
                            datastoreDependent = false;
                            unsupported = false;
                            break;
                        }
                    }
                }
                if (unsupported) {
                    if (className != null) {
                        throw new NucleusUserException(Localiser.msg((String)"060008", (Object[])new Object[]{methodName, className}));
                    }
                    throw new NucleusUserException(Localiser.msg((String)"060009", (Object[])new Object[]{methodName}));
                }
            }
        }
        PluginManager pluginMgr = this.storeMgr.getNucleusContext().getPluginManager();
        if (datastoreDependent) {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "class";
            stringArray3[1] = "method";
            stringArray2 = stringArray3;
            stringArray3[2] = "datastore";
        } else {
            String[] stringArray4 = new String[2];
            stringArray4[0] = "class";
            stringArray2 = stringArray4;
            stringArray4[1] = "method";
        }
        String[] attrNames = stringArray2;
        if (datastoreDependent) {
            String[] stringArray5 = new String[3];
            stringArray5[0] = className;
            stringArray5[1] = methodName;
            stringArray = stringArray5;
            stringArray5[2] = datastoreId;
        } else {
            String[] stringArray6 = new String[2];
            stringArray6[0] = className;
            stringArray = stringArray6;
            stringArray6[1] = methodName;
        }
        String[] attrValues = stringArray;
        try {
            method = (SQLMethod)pluginMgr.createExecutableExtension("org.datanucleus.store.rdbms.sql_method", attrNames, attrValues, "evaluator", new Class[0], new Object[0]);
            this.sqlMethodsByKey.put(this.getSQLMethodKey(datastoreDependent ? datastoreId : null, className, methodName), method);
            return method;
        }
        catch (Exception e) {
            throw new NucleusUserException(Localiser.msg((String)"060011", (Object[])new Object[]{"class=" + className + " method=" + methodName}), (Throwable)e);
        }
    }

    private MethodKey getSQLMethodKey(String datastoreName, String className, String methodName) {
        MethodKey key = new MethodKey();
        key.clsName = className != null ? className.trim() : "";
        key.methodName = methodName;
        key.datastoreName = datastoreName != null ? datastoreName.trim() : "ALL";
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLExpression invokeOperation(String name, SQLExpression expr, SQLExpression expr2) {
        String[] stringArray;
        String[] stringArray2;
        DatastoreAdapter dba = this.storeMgr.getDatastoreAdapter();
        SQLOperation operation = this.sqlOperationsByName.get(name);
        if (operation != null) {
            return operation.getExpression(expr, expr2);
        }
        Class sqlOpClass = dba.getSQLOperationClass(name);
        if (sqlOpClass != null) {
            try {
                operation = (SQLOperation)sqlOpClass.newInstance();
                this.sqlOperationsByName.put(name, operation);
                return operation.getExpression(expr, expr2);
            }
            catch (Exception e) {
                throw new NucleusException("Error creating SQLOperation of type " + sqlOpClass.getName() + " for operation " + name);
            }
        }
        String datastoreId = dba.getVendorID();
        String key = this.getSQLOperationKey(datastoreId, name);
        boolean datastoreDependent = true;
        if (!this.pluginSqlOperationKeysSupported.contains(key)) {
            key = this.getSQLOperationKey(null, name);
            datastoreDependent = false;
            if (!this.pluginSqlOperationKeysSupported.contains(key)) {
                throw new UnsupportedOperationException("Operation " + name + " on datastore=" + datastoreId + " not supported");
            }
        }
        PluginManager pluginMgr = this.storeMgr.getNucleusContext().getPluginManager();
        if (datastoreDependent) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "name";
            stringArray2 = stringArray3;
            stringArray3[1] = "datastore";
        } else {
            String[] stringArray4 = new String[1];
            stringArray2 = stringArray4;
            stringArray4[0] = "name";
        }
        String[] attrNames = stringArray2;
        if (datastoreDependent) {
            String[] stringArray5 = new String[2];
            stringArray5[0] = name;
            stringArray = stringArray5;
            stringArray5[1] = datastoreId;
        } else {
            String[] stringArray6 = new String[1];
            stringArray = stringArray6;
            stringArray6[0] = name;
        }
        String[] attrValues = stringArray;
        try {
            SQLOperation sQLOperation = operation = (SQLOperation)pluginMgr.createExecutableExtension("org.datanucleus.store.rdbms.sql_operation", attrNames, attrValues, "evaluator", null, null);
            synchronized (sQLOperation) {
                this.sqlOperationsByName.put(key, operation);
                return operation.getExpression(expr, expr2);
            }
        }
        catch (Exception e) {
            throw new NucleusUserException(Localiser.msg((String)"060011", (Object[])new Object[]{"operation=" + name}), (Throwable)e);
        }
    }

    private String getSQLOperationKey(String datastoreName, String name) {
        return (datastoreName != null ? datastoreName.trim() : "ALL") + "#" + name;
    }

    public JavaTypeMapping getMappingForType(Class cls, boolean useCached) {
        JavaTypeMapping mapping = null;
        if (useCached && (mapping = this.mappingByClass.get(cls)) != null) {
            return mapping;
        }
        mapping = this.storeMgr.getMappingManager().getMappingWithDatastoreMapping(cls, false, false, this.clr);
        this.mappingByClass.put(cls, mapping);
        return mapping;
    }

    public JavaTypeMapping getMappingForType(Class cls) {
        return this.getMappingForType(cls, true);
    }

    private class MethodKey {
        String clsName;
        String methodName;
        String datastoreName;

        private MethodKey() {
        }

        public int hashCode() {
            return (this.clsName + this.methodName + this.datastoreName).hashCode();
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof MethodKey)) {
                return false;
            }
            MethodKey otherKey = (MethodKey)other;
            return otherKey.clsName.equals(this.clsName) && otherKey.methodName.equals(this.methodName) && otherKey.datastoreName.equals(this.datastoreName);
        }
    }
}

