/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.DatabaseMetaData;
import java.util.Date;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.SQLiteTypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.method.StringIndexOf2Method;
import org.datanucleus.store.rdbms.sql.method.StringLength3Method;
import org.datanucleus.store.rdbms.sql.method.StringSubstring3Method;
import org.datanucleus.store.rdbms.sql.method.TemporalDayMethod4;
import org.datanucleus.store.rdbms.sql.method.TemporalDayOfWeekMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalHourMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalMinuteMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthJavaMethod4;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthMethod4;
import org.datanucleus.store.rdbms.sql.method.TemporalSecondMethod6;
import org.datanucleus.store.rdbms.sql.method.TemporalYearMethod4;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;

public class SQLiteAdapter
extends BaseDatastoreAdapter {
    protected static final int MAX_IDENTIFIER_LENGTH = 128;

    public SQLiteAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("CheckInEndCreateStatements");
        this.supportedOptions.add("UniqueInEndCreateStatements");
        this.supportedOptions.add("FKInEndCreateStatements");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("AutoIncrementPkInCreateTableColumnDef");
        this.supportedOptions.add("OrderByNullsUsingColumnIsNull");
        this.supportedOptions.remove("TxIsolationReadCommitted");
        this.supportedOptions.remove("TxIsolationReadRepeatableRead");
        this.supportedOptions.remove("AutoIncrementNullSpecification");
        this.supportedOptions.remove("RightOuterJoin");
        this.supportedOptions.remove("SomeAllAnySubqueries");
        this.supportedOptions.remove("UpdateStmtAllowTableAliasInSet");
        this.supportedOptions.remove("UpdateDeleteStmtAllowTableAliasInWhere");
        this.maxTableNameLength = 128;
        this.maxColumnNameLength = 128;
        this.maxConstraintNameLength = 128;
        this.maxIndexNameLength = 128;
    }

    @Override
    public String getVendorID() {
        return "sqlite";
    }

    @Override
    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        SQLiteTypeInfo sqlType = new SQLiteTypeInfo("double", 8, 0, null, null, null, 1, true, 3, false, false, false, "double", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)8, sqlType, true);
        sqlType = new SQLiteTypeInfo("float", 6, 0, null, null, null, 1, true, 3, false, false, false, "float", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)6, sqlType, true);
        sqlType = new SQLiteTypeInfo("decimal", 3, 0, null, null, null, 1, true, 3, false, false, false, "decimal", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)3, sqlType, true);
        sqlType = new SQLiteTypeInfo("numeric", 2, 0, null, null, null, 1, true, 3, false, false, false, "numeric", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2, sqlType, true);
        sqlType = new SQLiteTypeInfo("integer", 16, 0, null, null, null, 1, true, 3, false, false, false, "integer", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)16, sqlType, true);
        sqlType = new SQLiteTypeInfo("integer", -7, 0, null, null, null, 1, true, 3, false, false, false, "integer", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-7, sqlType, true);
        sqlType = new SQLiteTypeInfo("tinyint", -6, 0, null, null, null, 1, true, 3, false, false, false, "tinyint", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-6, sqlType, true);
        sqlType = new SQLiteTypeInfo("smallint", 5, 0, null, null, null, 1, true, 3, false, false, false, "smallint", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)5, sqlType, true);
        sqlType = new SQLiteTypeInfo("bigint", -5, 0, null, null, null, 1, true, 3, false, false, false, "bigint", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-5, sqlType, true);
        sqlType = new SQLiteTypeInfo("char", 1, 255, null, null, null, 1, true, 3, false, false, false, "char", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)1, sqlType, true);
        sqlType = new SQLiteTypeInfo("varchar", 12, 255, null, null, null, 1, true, 3, false, false, false, "varchar", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)12, sqlType, true);
        sqlType = new SQLiteTypeInfo("longvarchar", -1, 0xFFFFFF, null, null, null, 1, true, 3, false, false, false, "longvarchar", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-1, sqlType, true);
        sqlType = new SQLiteTypeInfo("clob", 2005, Integer.MAX_VALUE, null, null, null, 1, true, 3, false, false, false, "clob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2005, sqlType, true);
        sqlType = new SQLiteTypeInfo("date", 91, 0, null, null, null, 1, true, 3, false, false, false, "date", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)91, sqlType, true);
        sqlType = new SQLiteTypeInfo("time", 92, 0, null, null, null, 1, true, 3, false, false, false, "time", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)92, sqlType, true);
        sqlType = new SQLiteTypeInfo("timestamp", 93, 0, null, null, null, 1, true, 3, false, false, false, "timestamp", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)93, sqlType, true);
        sqlType = new SQLiteTypeInfo("blob", -2, 255, null, null, null, 1, true, 3, false, false, false, "blob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-2, sqlType, true);
        sqlType = new SQLiteTypeInfo("blob", -3, 255, null, null, null, 1, true, 3, false, false, false, "blob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-3, sqlType, true);
        sqlType = new SQLiteTypeInfo("blob", -4, 0xFFFFFF, null, null, null, 1, true, 3, false, false, false, "blob", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-4, sqlType, true);
    }

    @Override
    public String getCreateDatabaseStatement(String catalogName, String schemaName) {
        throw new UnsupportedOperationException("SQLite does not support CREATE SCHEMA; everything is in a single schema");
    }

    @Override
    public String getDropDatabaseStatement(String catalogName, String schemaName) {
        throw new UnsupportedOperationException("SQLite does not support DROP SCHEMA; everything is in a single schema");
    }

    @Override
    public String getDropTableStatement(Table table) {
        return "DROP TABLE " + table.toString();
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getAddCandidateKeyStatement(CandidateKey ck, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getAddForeignKeyStatement(ForeignKey fk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public SQLText getUpdateTableStatement(SQLTable tbl, SQLText setSQL) {
        SQLText sql = new SQLText("UPDATE ").append(tbl.getTable().toString());
        sql.append(" ").append(setSQL);
        return sql;
    }

    @Override
    public String getDeleteTableStatement(SQLTable tbl) {
        return "DELETE FROM " + tbl.getTable().toString();
    }

    @Override
    public String getRangeByLimitEndOfStatementClause(long offset, long count, boolean hasOrdering) {
        if (offset >= 0L && count > 0L) {
            return "LIMIT " + count + " OFFSET " + offset + " ";
        }
        if (offset <= 0L && count > 0L) {
            return "LIMIT " + count + " ";
        }
        if (offset >= 0L && count < 0L) {
            return "LIMIT 9223372036854775807 OFFSET " + offset + " ";
        }
        return "";
    }

    @Override
    public String getAutoIncrementStmt(Table table, String columnName) {
        return "SELECT last_insert_rowid()";
    }

    @Override
    public String getAutoIncrementKeyword() {
        return "autoincrement";
    }

    @Override
    public Class getAutoIncrementJavaTypeForType(Class type) {
        if (type.isPrimitive()) {
            return Integer.TYPE;
        }
        return Integer.class;
    }

    @Override
    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("YEAR".equals(methodName)) {
                return TemporalYearMethod4.class;
            }
            if ("MONTH".equals(methodName)) {
                return TemporalMonthMethod4.class;
            }
            if ("MONTH_JAVA".equals(methodName)) {
                return TemporalMonthJavaMethod4.class;
            }
            if ("DAY".equals(methodName)) {
                return TemporalDayMethod4.class;
            }
            if ("DAY_OF_WEEK".equals(methodName)) {
                return TemporalDayOfWeekMethod5.class;
            }
            if ("HOUR".equals(methodName)) {
                return TemporalHourMethod5.class;
            }
            if ("MINUTE".equals(methodName)) {
                return TemporalMinuteMethod5.class;
            }
            if ("SECOND".equals(methodName)) {
                return TemporalSecondMethod6.class;
            }
        } else {
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if ("java.lang.String".equals(className)) {
                if ("indexOf".equals(methodName)) {
                    return StringIndexOf2Method.class;
                }
                if ("length".equals(methodName)) {
                    return StringLength3Method.class;
                }
                if ("substring".equals(methodName)) {
                    return StringSubstring3Method.class;
                }
            } else if ("java.util.Date".equals(className) || cls != null && Date.class.isAssignableFrom(cls)) {
                if ("getDay".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod5.class;
                }
                if ("getDate".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getMonth".equals(methodName)) {
                    return TemporalMonthJavaMethod4.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod4.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod5.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod5.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod6.class;
                }
            } else if ("java.time.LocalTime".equals(className)) {
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod5.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod5.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod6.class;
                }
            } else if ("java.time.LocalDate".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod5.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod4.class;
                }
            } else if ("java.time.LocalDateTime".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod5.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod4.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod5.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod5.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod6.class;
                }
            } else if ("java.time.MonthDay".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod4.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
            } else if ("java.time.Period".equals(className)) {
                if ("getMonths".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
                if ("getDays".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
                if ("getYears".equals(methodName)) {
                    return TemporalYearMethod4.class;
                }
            } else if ("java.time.YearMonth".equals(className)) {
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod4.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod4.class;
                }
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }
}

