/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Date;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.FirebirdTypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.method.StringLength2Method;
import org.datanucleus.store.rdbms.sql.method.TemporalDayMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalDayOfWeekMethod6;
import org.datanucleus.store.rdbms.sql.method.TemporalHourMethod6;
import org.datanucleus.store.rdbms.sql.method.TemporalMinuteMethod6;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthJavaMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthMethod5;
import org.datanucleus.store.rdbms.sql.method.TemporalSecondMethod6;
import org.datanucleus.store.rdbms.sql.method.TemporalSecondMethod7;
import org.datanucleus.store.rdbms.sql.method.TemporalYearMethod5;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.Localiser;

public class FirebirdAdapter
extends BaseDatastoreAdapter {
    public FirebirdAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("BooleanExpression");
        this.supportedOptions.remove("NullsInCandidateKeys");
        this.supportedOptions.remove("ColumnOptions_NullsKeyword");
        this.supportedOptions.remove("IncludeOrderByColumnsInSelect");
        this.supportedOptions.add("AlterTableDropForeignKey_Syntax");
        this.supportedOptions.add("CreateIndexesBeforeForeignKeys");
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.add("OrderByWithNullsDirectives");
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("GroupByIncludesAllSelectPrimaries");
        this.supportedOptions.remove("HoldCursorsOverCommit");
        if (this.datastoreMajorVersion < 2) {
            this.supportedOptions.remove("ANSI_CrossJoin_Syntax");
            this.supportedOptions.add("ANSI_CrossJoinAsInner11_Syntax");
        }
    }

    @Override
    public String getVendorID() {
        return "firebird";
    }

    @Override
    public String getDropTableStatement(Table table) {
        return "DROP TABLE " + table.toString();
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new FirebirdTypeInfo(rs);
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getSequenceCreateStmt(String sequenceName, Integer min, Integer max, Integer start, Integer increment, Integer cacheSize) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CREATE SEQUENCE ");
        stmt.append(sequenceName);
        return stmt.toString();
    }

    @Override
    public String getSequenceNextStmt(String sequenceName) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("SELECT GEN_ID(");
        stmt.append(sequenceName);
        stmt.append(",1) FROM RDB$DATABASE");
        return stmt.toString();
    }

    @Override
    public String getRangeByLimitEndOfStatementClause(long offset, long count, boolean hasOrdering) {
        if (offset >= 0L && count > 0L) {
            return "ROWS " + (offset + 1L) + " TO " + (offset + count) + " ";
        }
        if (offset <= 0L && count > 0L) {
            return "ROWS 1 TO " + count + " ";
        }
        if (offset >= 0L && count < 0L) {
            return "ROWS " + offset + " ";
        }
        return "";
    }

    public boolean supportsCharLengthFunction() {
        return this.datastoreMajorVersion > 1;
    }

    @Override
    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("YEAR".equals(methodName)) {
                return TemporalYearMethod5.class;
            }
            if ("MONTH".equals(methodName)) {
                return TemporalMonthMethod5.class;
            }
            if ("MONTH_JAVA".equals(methodName)) {
                return TemporalMonthJavaMethod5.class;
            }
            if ("DAY".equals(methodName)) {
                return TemporalDayMethod5.class;
            }
            if ("DAY_OF_WEEK".equals(methodName)) {
                return TemporalDayOfWeekMethod6.class;
            }
            if ("HOUR".equals(methodName)) {
                return TemporalHourMethod6.class;
            }
            if ("MINUTE".equals(methodName)) {
                return TemporalMinuteMethod6.class;
            }
            if ("SECOND".equals(methodName)) {
                return TemporalSecondMethod7.class;
            }
        } else {
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if ("java.lang.String".equals(className) && "length".equals(methodName)) {
                return StringLength2Method.class;
            }
            if ("java.util.Date".equals(className) || cls != null && Date.class.isAssignableFrom(cls)) {
                if ("getDay".equals(methodName)) {
                    return TemporalDayMethod5.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod6.class;
                }
                if ("getDate".equals(methodName)) {
                    return TemporalDayMethod5.class;
                }
                if ("getMonth".equals(methodName)) {
                    return TemporalMonthJavaMethod5.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod5.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod6.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod6.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod7.class;
                }
            } else if ("java.time.LocalTime".equals(className)) {
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod6.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod6.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod6.class;
                }
            } else if ("java.time.LocalDate".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod5.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod6.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod5.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod5.class;
                }
            } else if ("java.time.LocalDateTime".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod5.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod6.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod5.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod5.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod6.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod6.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod6.class;
                }
            } else if ("java.time.MonthDay".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod5.class;
                }
                if ("java.time.MonthDay".equals(className) && "getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod5.class;
                }
            } else if ("java.time.Period".equals(className)) {
                if ("getMonths".equals(methodName)) {
                    return TemporalMonthMethod5.class;
                }
                if ("getDays".equals(methodName)) {
                    return TemporalMonthMethod5.class;
                }
                if ("getYears".equals(methodName)) {
                    return TemporalYearMethod5.class;
                }
            } else if ("java.time.YearMonth".equals(className)) {
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod5.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod5.class;
                }
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }
}

