/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.util.Localiser;

public class StringStartsWithMethod
extends AbstractSQLMethod {
    @Override
    public SQLExpression getExpression(SQLExpression expr, List<SQLExpression> args) {
        if (args == null || args.size() == 0 || args.size() > 2) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"startsWith", "StringExpression", 0, "StringExpression/CharacterExpression/Parameter"}));
        }
        SQLExpression substrExpr = args.get(0);
        if (!(substrExpr instanceof StringExpression || substrExpr instanceof CharacterExpression || substrExpr instanceof ParameterLiteral)) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"startsWith", "StringExpression", 0, "StringExpression/CharacterExpression/Parameter"}));
        }
        if (args.size() > 1) {
            if (substrExpr.isParameter()) {
                SQLLiteral substrLit = (SQLLiteral)((Object)substrExpr);
                this.stmt.getQueryGenerator().useParameterExpressionAsLiteral(substrLit);
                if (substrLit.getValue() == null) {
                    return new BooleanExpression(expr, Expression.OP_LIKE, ExpressionUtils.getEscapedPatternExpression(substrExpr));
                }
            }
            StringLiteral likeSubstrExpr = new StringLiteral(this.stmt, expr.getJavaTypeMapping(), Character.valueOf('%'), null);
            return new BooleanExpression(expr, Expression.OP_LIKE, ExpressionUtils.getEscapedPatternExpression(substrExpr).add(likeSubstrExpr));
        }
        if (substrExpr.isParameter()) {
            SQLLiteral substrLit = (SQLLiteral)((Object)substrExpr);
            this.stmt.getQueryGenerator().useParameterExpressionAsLiteral(substrLit);
            if (substrLit.getValue() == null) {
                return new BooleanExpression(expr, Expression.OP_LIKE, ExpressionUtils.getEscapedPatternExpression(substrExpr));
            }
        }
        StringLiteral likeSubstrExpr = new StringLiteral(this.stmt, expr.getJavaTypeMapping(), Character.valueOf('%'), null);
        return new BooleanExpression(expr, Expression.OP_LIKE, ExpressionUtils.getEscapedPatternExpression(substrExpr).add(likeSubstrExpr));
    }
}

