/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.H2TypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class H2Adapter
extends BaseDatastoreAdapter {
    private String schemaName;

    public H2Adapter(DatabaseMetaData metadata) {
        super(metadata);
        try {
            ResultSet rs = metadata.getSchemas();
            while (rs.next()) {
                if (!rs.getBoolean("IS_DEFAULT")) continue;
                this.schemaName = rs.getString("TABLE_SCHEM");
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE_SCHEMA.warn((Object)"Exception when trying to get default schema name for datastore", (Throwable)e);
        }
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("CheckInEndCreateStatements");
        this.supportedOptions.add("UniqueInEndCreateStatements");
        this.supportedOptions.add("OrderByWithNullsDirectives");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("TxIsolationReadRepeatableRead");
        this.supportedOptions.remove("TxIsolationNone");
        this.supportedOptions.add("CreateIndexesBeforeForeignKeys");
    }

    @Override
    public String getVendorID() {
        return "h2";
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new H2TypeInfo(rs);
    }

    @Override
    public int getDatastoreIdentifierMaxLength(IdentifierType identifierType) {
        if (identifierType == IdentifierType.TABLE) {
            return 128;
        }
        if (identifierType == IdentifierType.COLUMN) {
            return 128;
        }
        if (identifierType == IdentifierType.CANDIDATE_KEY) {
            return 128;
        }
        if (identifierType == IdentifierType.FOREIGN_KEY) {
            return 128;
        }
        if (identifierType == IdentifierType.INDEX) {
            return 128;
        }
        if (identifierType == IdentifierType.PRIMARY_KEY) {
            return 128;
        }
        if (identifierType == IdentifierType.SEQUENCE) {
            return 128;
        }
        return super.getDatastoreIdentifierMaxLength(identifierType);
    }

    @Override
    public String getCreateDatabaseStatement(String catalogName, String schemaName) {
        return "CREATE SCHEMA IF NOT EXISTS " + schemaName;
    }

    @Override
    public String getDropDatabaseStatement(String catalogName, String schemaName) {
        return "DROP SCHEMA IF EXISTS " + schemaName;
    }

    @Override
    public String getAddColumnStatement(Table table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    @Override
    public String getRangeByLimitEndOfStatementClause(long offset, long count, boolean hasOrdering) {
        if (offset >= 0L && count > 0L) {
            return "LIMIT " + count + " OFFSET " + offset + " ";
        }
        if (offset <= 0L && count > 0L) {
            return "LIMIT " + count + " ";
        }
        if (offset >= 0L && count < 0L) {
            return "LIMIT 2147483647 OFFSET " + offset + " ";
        }
        return "";
    }

    @Override
    public String getSchemaName(Connection conn) throws SQLException {
        return this.schemaName;
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getAutoIncrementStmt(Table table, String columnName) {
        return "CALL IDENTITY()";
    }

    @Override
    public String getAutoIncrementKeyword() {
        return "IDENTITY";
    }

    @Override
    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES(NULL)";
    }

    @Override
    public boolean isValidPrimaryKeyType(JdbcType datatype) {
        return true;
    }

    @Override
    public String getSequenceCreateStmt(String sequenceName, Integer min, Integer max, Integer start, Integer increment, Integer cacheSize) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CREATE SEQUENCE IF NOT EXISTS ");
        stmt.append(sequenceName);
        if (min != null) {
            stmt.append(" START WITH " + min);
        } else if (start != null) {
            stmt.append(" START WITH " + start);
        }
        if (max != null) {
            throw new NucleusUserException(Localiser.msg((String)"051022"));
        }
        if (increment != null) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cacheSize != null) {
            stmt.append(" CACHE " + cacheSize);
        }
        return stmt.toString();
    }

    @Override
    public String getSequenceNextStmt(String sequenceName) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CALL NEXT VALUE FOR ");
        stmt.append(sequenceName);
        return stmt.toString();
    }

    @Override
    public boolean isStatementCancel(SQLException sqle) {
        return sqle.getErrorCode() == 90051;
    }
}

