/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.BigDecimalMapping;
import org.datanucleus.store.rdbms.mapping.java.BigIntegerMapping;
import org.datanucleus.store.rdbms.mapping.java.BooleanMapping;
import org.datanucleus.store.rdbms.mapping.java.ByteMapping;
import org.datanucleus.store.rdbms.mapping.java.CharacterMapping;
import org.datanucleus.store.rdbms.mapping.java.DateMapping;
import org.datanucleus.store.rdbms.mapping.java.DiscriminatorMapping;
import org.datanucleus.store.rdbms.mapping.java.DoubleMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedMapping;
import org.datanucleus.store.rdbms.mapping.java.FloatMapping;
import org.datanucleus.store.rdbms.mapping.java.IntegerMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.LongMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableIdMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.ShortMapping;
import org.datanucleus.store.rdbms.mapping.java.SqlDateMapping;
import org.datanucleus.store.rdbms.mapping.java.SqlTimeMapping;
import org.datanucleus.store.rdbms.mapping.java.SqlTimestampMapping;
import org.datanucleus.store.rdbms.mapping.java.StringMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.ByteLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.ColumnExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.FloatingPointLiteral;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalLiteral;
import org.datanucleus.store.rdbms.sql.expression.TypeConverterLiteral;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ObjectExpression
extends SQLExpression {
    public ObjectExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, mapping);
    }

    public ObjectExpression(SQLStatement stmt, JavaTypeMapping mapping, String functionName, List args) {
        super(stmt, mapping, functionName, args, null);
    }

    public ObjectExpression(SQLStatement stmt, JavaTypeMapping mapping, String functionName, List args, List types) {
        super(stmt, mapping, functionName, args, types);
    }

    public void useFirstColumnOnly() {
        if (this.mapping.getNumberOfDatastoreMappings() <= 1) {
            return;
        }
        this.subExprs = new SQLExpression.ColumnExpressionList();
        ColumnExpression colExpr = new ColumnExpression(this.stmt, this.table, this.mapping.getDatastoreMapping(0).getColumn());
        this.subExprs.addExpression(colExpr);
        this.st.clearStatement();
        this.st.append(this.subExprs.toString());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BooleanExpression eq(SQLExpression expr) {
        this.addSubexpressionsToRelatedExpression(expr);
        if (this.mapping instanceof PersistableIdMapping && expr instanceof StringLiteral && (oidString = (String)((StringLiteral)expr).getValue()) != null) {
            cmd = this.stmt.getRDBMSManager().getMetaDataManager().getMetaDataForClass(this.mapping.getType(), this.stmt.getQueryGenerator().getClassLoaderResolver());
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                try {
                    id = this.stmt.getRDBMSManager().getNucleusContext().getIdentityManager().getDatastoreId(oidString);
                    if (id == null) ** GOTO lbl16
                }
                catch (IllegalArgumentException iae) {
                    NucleusLogger.QUERY.info((Object)("Attempted comparison of " + this + " and " + expr + " where the former is a datastore-identity and the latter is of incorrect form (" + oidString + ")"));
                    exprFactory = this.stmt.getSQLExpressionFactory();
                    m = exprFactory.getMappingForType(Boolean.TYPE, true);
                    return exprFactory.newLiteral(this.stmt, m, false).eq(exprFactory.newLiteral(this.stmt, m, true));
                }
            } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                // empty if block
            }
        }
lbl16:
        // 7 sources

        if (this.mapping instanceof ReferenceMapping && expr.mapping instanceof PersistableMapping) {
            return this.processComparisonOfImplementationWithReference(this, expr, false);
        }
        if (this.mapping instanceof PersistableMapping && expr.mapping instanceof ReferenceMapping) {
            return this.processComparisonOfImplementationWithReference(expr, this, false);
        }
        bExpr = null;
        if (!this.isParameter() && !expr.isParameter()) {
            if (!(expr instanceof NullLiteral)) {
                if (this.literalIsValidForSimpleComparison(expr)) {
                    if (this.subExprs.size() > 1) {
                        return super.eq(expr);
                    }
                    return new BooleanExpression(this, Expression.OP_EQ, expr);
                }
                if (expr instanceof ObjectExpression) {
                    return ExpressionUtils.getEqualityExpressionForObjectExpressions(this, (ObjectExpression)expr, true);
                }
                if (this.subExprs == null) {
                    return new BooleanExpression(this, Expression.OP_EQ, expr);
                }
                return super.eq(expr);
            }
        } else {
            if (this.subExprs.size() <= 1) {
                return new BooleanExpression(this, Expression.OP_EQ, expr);
            }
            i = 0;
            while (true) {
                if (i >= this.subExprs.size()) {
                    return bExpr;
                }
                subexpr = this.subExprs.getExpression(i).eq(((ObjectExpression)expr).subExprs.getExpression(i));
                bExpr = bExpr == null ? subexpr : bExpr.and(subexpr);
                ++i;
            }
        }
        i = 0;
        while (true) {
            if (i >= this.subExprs.size()) {
                return bExpr;
            }
            subexpr = expr.eq(this.subExprs.getExpression(i));
            bExpr = bExpr == null ? subexpr : bExpr.and(subexpr);
            ++i;
        }
    }

    protected BooleanExpression processComparisonOfImplementationWithReference(SQLExpression refExpr, SQLExpression implExpr, boolean negate) {
        ReferenceMapping refMapping = (ReferenceMapping)refExpr.mapping;
        JavaTypeMapping[] implMappings = refMapping.getJavaTypeMapping();
        int subExprStart = 0;
        int subExprEnd = 0;
        for (int i = 0; i < implMappings.length; ++i) {
            if (implMappings[i].getType().equals(implExpr.mapping.getType())) {
                subExprEnd = subExprStart + implMappings[i].getNumberOfDatastoreMappings();
                break;
            }
            subExprStart += implMappings[i].getNumberOfDatastoreMappings();
        }
        BooleanExpression bExpr = null;
        int implMappingNum = 0;
        for (int i = subExprStart; i < subExprEnd; ++i) {
            BooleanExpression subexpr = refExpr.subExprs.getExpression(i).eq(implExpr.subExprs.getExpression(implMappingNum++));
            bExpr = bExpr == null ? subexpr : bExpr.and(subexpr);
        }
        if (bExpr == null) {
            return ExpressionUtils.getEqualityExpressionForObjectExpressions((ObjectExpression)refExpr, (ObjectExpression)implExpr, true);
        }
        return negate ? new BooleanExpression(Expression.OP_NOT, bExpr.encloseInParentheses()) : bExpr;
    }

    @Override
    public BooleanExpression ne(SQLExpression expr) {
        this.addSubexpressionsToRelatedExpression(expr);
        if (this.mapping instanceof ReferenceMapping && expr.mapping instanceof PersistableMapping) {
            return this.processComparisonOfImplementationWithReference(this, expr, true);
        }
        if (this.mapping instanceof PersistableMapping && expr.mapping instanceof ReferenceMapping) {
            return this.processComparisonOfImplementationWithReference(expr, this, true);
        }
        SQLExpression bExpr = null;
        if (this.isParameter() || expr.isParameter()) {
            if (this.subExprs.size() > 1) {
                for (int i = 0; i < this.subExprs.size(); ++i) {
                    BooleanExpression subexpr = this.subExprs.getExpression(i).eq(((ObjectExpression)expr).subExprs.getExpression(i));
                    bExpr = bExpr == null ? subexpr : ((BooleanExpression)bExpr).and(subexpr);
                }
                return new BooleanExpression(Expression.OP_NOT, bExpr != null ? bExpr.encloseInParentheses() : null);
            }
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof NullLiteral) {
            for (int i = 0; i < this.subExprs.size(); ++i) {
                BooleanExpression subexpr = expr.eq(this.subExprs.getExpression(i));
                bExpr = bExpr == null ? subexpr : ((BooleanExpression)bExpr).and(subexpr);
            }
            return new BooleanExpression(Expression.OP_NOT, bExpr != null ? bExpr.encloseInParentheses() : null);
        }
        if (this.literalIsValidForSimpleComparison(expr)) {
            if (this.subExprs.size() > 1) {
                return super.ne(expr);
            }
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof ObjectExpression) {
            return ExpressionUtils.getEqualityExpressionForObjectExpressions(this, (ObjectExpression)expr, false);
        }
        if (this.subExprs == null) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        return super.ne(expr);
    }

    protected void addSubexpressionsToRelatedExpression(SQLExpression expr) {
        if (expr.subExprs == null && this.subExprs != null) {
            expr.subExprs = new SQLExpression.ColumnExpressionList();
            for (int i = 0; i < this.subExprs.size(); ++i) {
                expr.subExprs.addExpression(new ColumnExpression(this.stmt, expr.parameterName, expr.mapping, null, i));
            }
        }
    }

    private boolean literalIsValidForSimpleComparison(SQLExpression expr) {
        return expr instanceof BooleanLiteral && this.mapping instanceof BooleanMapping || expr instanceof ByteLiteral && this.mapping instanceof ByteMapping || expr instanceof CharacterLiteral && this.mapping instanceof CharacterMapping || expr instanceof FloatingPointLiteral && (this.mapping instanceof FloatMapping || this.mapping instanceof DoubleMapping || this.mapping instanceof BigDecimalMapping) || expr instanceof IntegerLiteral && (this.mapping instanceof IntegerMapping || this.mapping instanceof LongMapping || this.mapping instanceof BigIntegerMapping) || this.mapping instanceof ShortMapping || expr instanceof TemporalLiteral && (this.mapping instanceof DateMapping || this.mapping instanceof SqlDateMapping || this.mapping instanceof SqlTimeMapping || this.mapping instanceof SqlTimestampMapping) || expr instanceof StringLiteral && (this.mapping instanceof StringMapping || this.mapping instanceof CharacterMapping);
    }

    @Override
    public BooleanExpression in(SQLExpression expr, boolean not) {
        return new BooleanExpression(this, not ? Expression.OP_NOTIN : Expression.OP_IN, expr);
    }

    @Override
    public BooleanExpression lt(SQLExpression expr) {
        if (this.subExprs == null) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        return super.lt(expr);
    }

    @Override
    public BooleanExpression le(SQLExpression expr) {
        if (this.subExprs == null) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        return super.le(expr);
    }

    @Override
    public BooleanExpression gt(SQLExpression expr) {
        if (this.subExprs == null) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        return super.gt(expr);
    }

    @Override
    public BooleanExpression ge(SQLExpression expr) {
        if (this.subExprs == null) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        return super.ge(expr);
    }

    @Override
    public SQLExpression cast(SQLExpression expr) {
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        ClassLoaderResolver clr = this.stmt.getClassLoaderResolver();
        String castClassName = (String)((StringLiteral)expr).getValue();
        Class type = null;
        try {
            type = this.stmt.getQueryGenerator().resolveClass(castClassName);
        }
        catch (ClassNotResolvedException cnre) {
            type = null;
        }
        if (type == null) {
            throw new NucleusUserException(Localiser.msg((String)"037017", (Object[])new Object[]{castClassName}));
        }
        SQLExpressionFactory exprFactory = this.stmt.getSQLExpressionFactory();
        Class memberType = clr.classForName(this.mapping.getType());
        if (!memberType.isAssignableFrom(type) && !type.isAssignableFrom(memberType)) {
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
            return exprFactory.newLiteral(this.stmt, m, false).eq(exprFactory.newLiteral(this.stmt, m, true));
        }
        if (memberType == type) {
            return this;
        }
        if (this.mapping instanceof EmbeddedMapping) {
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
            return exprFactory.newLiteral(this.stmt, m, false).eq(exprFactory.newLiteral(this.stmt, m, true));
        }
        if (this.mapping instanceof ReferenceMapping) {
            ReferenceMapping refMapping = (ReferenceMapping)this.mapping;
            if (refMapping.getMappingStrategy() != 0) {
                throw new NucleusUserException("Impossible to do cast of interface to " + type.getName() + " since interface is persisted as embedded String. Use per-implementation mapping to allow this query");
            }
            JavaTypeMapping[] implMappings = refMapping.getJavaTypeMapping();
            for (int i = 0; i < implMappings.length; ++i) {
                Class implType = clr.classForName(implMappings[i].getType());
                if (!type.isAssignableFrom(implType)) continue;
                DatastoreClass castTable = storeMgr.getDatastoreClass(type.getName(), clr);
                SQLTable castSqlTbl = this.stmt.leftOuterJoin(this.table, implMappings[i], refMapping, castTable, null, castTable.getIdMapping(), null, null, null);
                return exprFactory.newExpression(this.stmt, castSqlTbl, castTable.getIdMapping());
            }
            NucleusLogger.QUERY.warn((Object)("Unable to process cast of interface field to " + type.getName() + " since it has no implementations that match that type"));
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
            return exprFactory.newLiteral(this.stmt, m, false).eq(exprFactory.newLiteral(this.stmt, m, true));
        }
        if (this.mapping instanceof PersistableMapping) {
            AbstractClassMetaData castCmd;
            DatastoreClass castTable = storeMgr.getDatastoreClass(type.getName(), clr);
            SQLTable castSqlTbl = this.stmt.getTable(castTable, this.table.getGroupName());
            if (castSqlTbl == null) {
                castSqlTbl = this.stmt.leftOuterJoin(this.table, this.table.getTable().getIdMapping(), castTable, null, castTable.getIdMapping(), null, this.table.getGroupName());
            }
            if (castSqlTbl == this.table && (castCmd = storeMgr.getMetaDataManager().getMetaDataForClass(type, clr)).hasDiscriminatorStrategy()) {
                NucleusLogger.QUERY.warn((Object)(">> Currently do not support adding restriction on discriminator for table=" + this.table + " to " + type));
            }
            return exprFactory.newExpression(this.stmt, castSqlTbl, castTable.getIdMapping());
        }
        throw new NucleusUserException("Dont currently support ObjectExpression.cast(" + type + ")");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BooleanExpression is(SQLExpression expr, boolean not) {
        JavaTypeMapping m;
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        ClassLoaderResolver clr = this.stmt.getClassLoaderResolver();
        String instanceofClassName = null;
        SQLExpression classExpr = expr;
        if (expr instanceof TypeConverterLiteral) {
            classExpr = ((TypeConverterLiteral)expr).getDelegate();
        }
        if (!(classExpr instanceof StringLiteral)) throw new NucleusUserException("Do not currently support `instanceof` with class expression of type " + classExpr);
        instanceofClassName = (String)((StringLiteral)classExpr).getValue();
        Class type = null;
        try {
            type = this.stmt.getQueryGenerator().resolveClass(instanceofClassName);
        }
        catch (ClassNotResolvedException cnre) {
            type = null;
        }
        if (type == null) {
            throw new NucleusUserException(Localiser.msg((String)"037016", (Object[])new Object[]{instanceofClassName}));
        }
        SQLExpressionFactory exprFactory = this.stmt.getSQLExpressionFactory();
        Class memberType = clr.classForName(this.mapping.getType());
        if (!memberType.isAssignableFrom(type) && !type.isAssignableFrom(memberType)) {
            JavaTypeMapping m2 = exprFactory.getMappingForType(Boolean.TYPE, true);
            return exprFactory.newLiteral(this.stmt, m2, true).eq(exprFactory.newLiteral(this.stmt, m2, not));
        }
        if (memberType == type) {
            JavaTypeMapping m3 = exprFactory.getMappingForType(Boolean.TYPE, true);
            return exprFactory.newLiteral(this.stmt, m3, true).eq(exprFactory.newLiteral(this.stmt, m3, !not));
        }
        if (this.mapping instanceof EmbeddedMapping) {
            AbstractClassMetaData fieldCmd = storeMgr.getMetaDataManager().getMetaDataForClass(this.mapping.getType(), clr);
            if (fieldCmd.hasDiscriminatorStrategy()) {
                JavaTypeMapping discMapping = ((EmbeddedMapping)this.mapping).getDiscriminatorMapping();
                AbstractClassMetaData typeCmd = storeMgr.getMetaDataManager().getMetaDataForClass(type, clr);
                SQLExpression discExpr = this.stmt.getSQLExpressionFactory().newExpression(this.stmt, this.table, discMapping);
                SQLExpression discValExpr = this.stmt.getSQLExpressionFactory().newLiteral(this.stmt, discMapping, typeCmd.getDiscriminatorValue());
                BooleanExpression typeExpr = not ? discExpr.ne(discValExpr) : discExpr.eq(discValExpr);
                Iterator subclassIter = storeMgr.getSubClassesForClass(type.getName(), true, clr).iterator();
                while (subclassIter.hasNext()) {
                    BooleanExpression subtypeExpr;
                    String subclassName = (String)subclassIter.next();
                    AbstractClassMetaData subtypeCmd = storeMgr.getMetaDataManager().getMetaDataForClass(subclassName, clr);
                    Object subtypeDiscVal = subtypeCmd.getDiscriminatorValue();
                    discValExpr = this.stmt.getSQLExpressionFactory().newLiteral(this.stmt, discMapping, subtypeDiscVal);
                    BooleanExpression booleanExpression = subtypeExpr = not ? discExpr.ne(discValExpr) : discExpr.eq(discValExpr);
                    if (not) {
                        typeExpr = typeExpr.and(subtypeExpr);
                        continue;
                    }
                    typeExpr = typeExpr.ior(subtypeExpr);
                }
                return typeExpr;
            }
            JavaTypeMapping m4 = exprFactory.getMappingForType(Boolean.TYPE, true);
            return exprFactory.newLiteral(this.stmt, m4, true).eq(exprFactory.newLiteral(this.stmt, m4, not));
        }
        if (!(this.mapping instanceof PersistableMapping)) {
            if (!(this.mapping instanceof ReferenceMapping)) throw new NucleusException("Dont currently support " + this + " instanceof " + type.getName());
        }
        AbstractClassMetaData memberCmd = storeMgr.getMetaDataManager().getMetaDataForClass(this.mapping.getType(), clr);
        DatastoreClass memberTable = null;
        if (memberCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
            AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass(memberCmd, clr);
            if (cmds == null) throw new NucleusUserException(Localiser.msg((String)"037005", (Object[])new Object[]{this.mapping.getMemberMetaData().getFullFieldName()}));
            if (cmds.length > 1) {
                NucleusLogger.QUERY.warn((Object)Localiser.msg((String)"037006", (Object[])new Object[]{this.mapping.getMemberMetaData().getFullFieldName(), cmds[0].getFullClassName()}));
            }
            memberTable = storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr);
        } else {
            memberTable = storeMgr.getDatastoreClass(this.mapping.getType(), clr);
        }
        DiscriminatorMetaData dismd = memberTable.getDiscriminatorMetaData();
        DiscriminatorMapping discMapping = (DiscriminatorMapping)memberTable.getDiscriminatorMapping(false);
        if (discMapping != null) {
            SQLTable targetSqlTbl = null;
            if (this.mapping.getTable() != memberTable) {
                targetSqlTbl = this.stmt.getTable(memberTable, null);
                if (targetSqlTbl == null) {
                    targetSqlTbl = this.stmt.innerJoin(this.getSQLTable(), this.mapping, memberTable, null, memberTable.getIdMapping(), null, null);
                }
            } else {
                targetSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(this.stmt, this.getSQLTable(), discMapping);
            }
            SQLTable discSqlTbl = targetSqlTbl;
            BooleanExpression discExpr = null;
            if (!Modifier.isAbstract(type.getModifiers())) {
                discExpr = SQLStatementHelper.getExpressionForDiscriminatorForClass(this.stmt, type.getName(), dismd, discMapping, discSqlTbl, clr);
            }
            Iterator subclassIter = storeMgr.getSubClassesForClass(type.getName(), true, clr).iterator();
            boolean multiplePossibles = false;
            while (subclassIter.hasNext()) {
                String subclassName = (String)subclassIter.next();
                Class subclass = clr.classForName(subclassName);
                if (Modifier.isAbstract(subclass.getModifiers())) continue;
                BooleanExpression discExprSub = SQLStatementHelper.getExpressionForDiscriminatorForClass(this.stmt, subclassName, dismd, discMapping, discSqlTbl, clr);
                if (discExpr != null) {
                    multiplePossibles = true;
                    discExpr = discExpr.ior(discExprSub);
                    continue;
                }
                discExpr = discExprSub;
            }
            if (!multiplePossibles || discExpr == null) return not && discExpr != null ? discExpr.not() : discExpr;
            discExpr.encloseInParentheses();
            return not && discExpr != null ? discExpr.not() : discExpr;
        }
        DatastoreClass table = null;
        if (memberCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
            AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass(memberCmd, clr);
            if (cmds == null) throw new NucleusUserException(Localiser.msg((String)"037005", (Object[])new Object[]{this.mapping.getMemberMetaData().getFullFieldName()}));
            if (cmds.length > 1) {
                NucleusLogger.QUERY.warn((Object)Localiser.msg((String)"037006", (Object[])new Object[]{this.mapping.getMemberMetaData().getFullFieldName(), cmds[0].getFullClassName()}));
            }
            table = storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr);
        } else {
            table = storeMgr.getDatastoreClass(this.mapping.getType(), clr);
        }
        if (table.managesClass(type.getName())) {
            m = exprFactory.getMappingForType(Boolean.TYPE, true);
            return exprFactory.newLiteral(this.stmt, m, true).eq(exprFactory.newLiteral(this.stmt, m, !not));
        }
        if (table == this.stmt.getPrimaryTable().getTable()) {
            m = exprFactory.getMappingForType(Boolean.TYPE, true);
            if (this.stmt instanceof SelectStatement) {
                SelectStatement selectStmt = (SelectStatement)this.stmt;
                if (selectStmt.getNumberOfUnions() == 0) {
                    Class mainCandidateCls = clr.classForName(this.stmt.getCandidateClassName());
                    if (type.isAssignableFrom(mainCandidateCls) != not) return exprFactory.newLiteral(this.stmt, m, true).eq(exprFactory.newLiteral(this.stmt, m, true));
                    return exprFactory.newLiteral(this.stmt, m, true).eq(exprFactory.newLiteral(this.stmt, m, false));
                }
                NucleusLogger.QUERY.warn((Object)("TYPE/INSTANCEOF operator for class=" + memberCmd.getFullClassName() + " on table=" + memberTable + " for type=" + instanceofClassName + " but there is no discriminator and using UNIONs. Any subsequent handling is likely incorrect TODO"));
                Class mainCandidateCls = clr.classForName(this.stmt.getCandidateClassName());
                if (type.isAssignableFrom(mainCandidateCls) == not) {
                    BooleanExpression unionClauseExpr = exprFactory.newLiteral(this.stmt, m, true).eq(exprFactory.newLiteral(this.stmt, m, false));
                    this.stmt.whereAnd(unionClauseExpr, false);
                }
                List<SelectStatement> unionStmts = selectStmt.getUnions();
                Iterator<SelectStatement> subclassName = unionStmts.iterator();
                while (subclassName.hasNext()) {
                    SelectStatement unionStmt = subclassName.next();
                    Class unionCandidateCls = clr.classForName(unionStmt.getCandidateClassName());
                    if (type.isAssignableFrom(unionCandidateCls) != not) continue;
                    BooleanExpression unionClauseExpr = exprFactory.newLiteral(unionStmt, m, true).eq(exprFactory.newLiteral(unionStmt, m, false));
                    unionStmt.whereAnd(unionClauseExpr, false);
                }
                return exprFactory.newLiteral(this.stmt, m, true).eq(exprFactory.newLiteral(this.stmt, m, true));
            }
            DatastoreClass instanceofTable = storeMgr.getDatastoreClass(type.getName(), clr);
            this.stmt.innerJoin(this.table, this.table.getTable().getIdMapping(), instanceofTable, null, instanceofTable.getIdMapping(), null, this.table.getGroupName());
            return exprFactory.newLiteral(this.stmt, m, true).eq(exprFactory.newLiteral(this.stmt, m, !not));
        }
        DatastoreClass instanceofTable = storeMgr.getDatastoreClass(type.getName(), clr);
        this.stmt.innerJoin(this.table, this.table.getTable().getIdMapping(), instanceofTable, null, instanceofTable.getIdMapping(), null, this.table.getGroupName());
        JavaTypeMapping m5 = exprFactory.getMappingForType(Boolean.TYPE, true);
        return exprFactory.newLiteral(this.stmt, m5, true).eq(exprFactory.newLiteral(this.stmt, m5, !not));
    }

    @Override
    public SQLExpression invoke(String methodName, List args) {
        return this.stmt.getRDBMSManager().getSQLExpressionFactory().invokeMethod(this.stmt, Object.class.getName(), methodName, this, args);
    }
}

