/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.lang.reflect.Constructor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchPlan;
import org.datanucleus.FetchPlanForClass;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.query.NullOrderingType;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.compiler.Symbol;
import org.datanucleus.query.expression.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.ArrayExpression;
import org.datanucleus.query.expression.CaseExpression;
import org.datanucleus.query.expression.ClassExpression;
import org.datanucleus.query.expression.CreatorExpression;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.JoinExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.SubqueryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.VersionHelper;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.StatementClassMapping;
import org.datanucleus.store.rdbms.mapping.StatementMappingIndex;
import org.datanucleus.store.rdbms.mapping.java.AbstractContainerMapping;
import org.datanucleus.store.rdbms.mapping.java.DatastoreIdMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.OptionalMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableIdMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.StringMapping;
import org.datanucleus.store.rdbms.mapping.java.TemporalMapping;
import org.datanucleus.store.rdbms.query.QueryGenerator;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.query.StatementNewObjectMapping;
import org.datanucleus.store.rdbms.query.StatementResultMapping;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.UpdateStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.CaseBooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.CaseExpression;
import org.datanucleus.store.rdbms.sql.expression.CaseNumericExpression;
import org.datanucleus.store.rdbms.sql.expression.CaseStringExpression;
import org.datanucleus.store.rdbms.sql.expression.CollectionExpression;
import org.datanucleus.store.rdbms.sql.expression.ColumnExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.MapExpression;
import org.datanucleus.store.rdbms.sql.expression.NewObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.ResultAliasExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.StringSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.SubqueryExpressionComponent;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.rdbms.sql.expression.TemporalLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.UnboundExpression;
import org.datanucleus.store.rdbms.table.ArrayTable;
import org.datanucleus.store.rdbms.table.ClassTable;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.ElementContainerTable;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Imports;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class QueryToSQLMapper
extends AbstractExpressionEvaluator
implements QueryGenerator {
    public static final String OPTION_CASE_INSENSITIVE = "CASE_INSENSITIVE";
    public static final String OPTION_EXPLICIT_JOINS = "EXPLICIT_JOINS";
    public static final String OPTION_NON_DISTINCT_IMPLICIT_JOINS = "NON_DISTINCT_IMPLICIT_JOINS";
    public static final String OPTION_BULK_UPDATE_VERSION = "BULK_UPDATE_VERSION";
    public static final String OPTION_SELECT_CANDIDATE_ID_ONLY = "RESULT_CANDIDATE_ID";
    public static final String OPTION_NULL_PARAM_USE_IS_NULL = "USE_IS_NULL_FOR_NULL_PARAM";
    public static final String MAP_KEY_ALIAS_SUFFIX = "_KEY";
    public static final String MAP_VALUE_ALIAS_SUFFIX = "_VALUE";
    final String candidateAlias;
    final AbstractClassMetaData candidateCmd;
    final boolean subclasses;
    final QueryCompilation compilation;
    final Map parameters;
    Map<String, Object> parameterValueByName = null;
    Map<Integer, String> paramNameByPosition = null;
    int positionalParamNumber = -1;
    Map<String, Object> extensionsByName = null;
    SQLStatement stmt;
    final StatementClassMapping resultDefinitionForClass;
    final StatementResultMapping resultDefinition;
    Map<Object, SQLExpression> expressionForParameter;
    final RDBMSStoreManager storeMgr;
    final FetchPlan fetchPlan;
    final SQLExpressionFactory exprFactory;
    ExecutionContext ec;
    ClassLoaderResolver clr;
    Imports importsDefinition = null;
    Map<String, Object> compileProperties = new HashMap<String, Object>();
    CompilationComponent compileComponent;
    Deque<SQLExpression> stack;
    Map<String, SQLTableMapping> sqlTableByPrimary = new HashMap<String, SQLTableMapping>();
    Set<String> resultAliases = null;
    Map<String, String> explicitJoinPrimaryByAlias = null;
    Map<String, JavaTypeMapping> paramMappingForName = new HashMap<String, JavaTypeMapping>();
    Set<String> options = new HashSet<String>();
    public QueryToSQLMapper parentMapper = null;
    SQLJoin.JoinType defaultJoinType = null;
    SQLJoin.JoinType defaultJoinTypeFilter = null;
    boolean precompilable = true;
    boolean processingOnClause = false;

    public QueryToSQLMapper(SQLStatement stmt, QueryCompilation compilation, Map parameters, StatementClassMapping resultDefForClass, StatementResultMapping resultDef, AbstractClassMetaData cmd, boolean subclasses, FetchPlan fetchPlan, ExecutionContext ec, Imports importsDefinition, Set<String> options, Map<String, Object> extensions) {
        this.parameters = parameters;
        this.compilation = compilation;
        this.stmt = stmt;
        this.resultDefinitionForClass = resultDefForClass;
        this.resultDefinition = resultDef;
        this.candidateCmd = cmd;
        this.candidateAlias = compilation.getCandidateAlias();
        this.subclasses = subclasses;
        this.fetchPlan = fetchPlan;
        this.storeMgr = stmt.getRDBMSManager();
        this.exprFactory = stmt.getRDBMSManager().getSQLExpressionFactory();
        this.ec = ec;
        this.clr = ec.getClassLoaderResolver();
        this.importsDefinition = importsDefinition;
        if (options != null) {
            this.options.addAll(options);
        }
        this.extensionsByName = extensions;
        this.stmt.setQueryGenerator(this);
        SQLTableMapping tblMapping = new SQLTableMapping(stmt.getPrimaryTable(), this.candidateCmd, stmt.getPrimaryTable().getTable().getIdMapping());
        this.setSQLTableMappingForAlias(this.candidateAlias, tblMapping);
        this.stack = new ArrayDeque<SQLExpression>();
    }

    void setDefaultJoinType(SQLJoin.JoinType joinType) {
        this.defaultJoinType = joinType;
    }

    void setDefaultJoinTypeFilter(SQLJoin.JoinType joinType) {
        this.defaultJoinTypeFilter = joinType;
    }

    void setParentMapper(QueryToSQLMapper parent) {
        this.parentMapper = parent;
    }

    @Override
    public String getQueryLanguage() {
        return this.compilation.getQueryLanguage();
    }

    @Override
    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    @Override
    public CompilationComponent getCompilationComponent() {
        return this.compileComponent;
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.ec;
    }

    @Override
    public Object getProperty(String name) {
        return this.compileProperties.get(name);
    }

    public boolean isPrecompilable() {
        return this.precompilable;
    }

    protected void setNotPrecompilable() {
        if (this.parentMapper != null) {
            this.parentMapper.setNotPrecompilable();
        }
        this.precompilable = false;
    }

    public Map<Integer, String> getParameterNameByPosition() {
        return this.paramNameByPosition;
    }

    public void compile() {
        if (NucleusLogger.QUERY.isDebugEnabled() && this.parentMapper == null) {
            StringBuilder str = new StringBuilder("JoinType : navigation(default=");
            str.append(this.defaultJoinType != null ? this.defaultJoinType : "(using nullability)");
            str.append(", filter=");
            str.append(this.defaultJoinTypeFilter != null ? this.defaultJoinTypeFilter : "(using nullability)");
            str.append(")");
            if (this.extensionsByName != null) {
                for (Map.Entry<String, Object> entry : this.extensionsByName.entrySet()) {
                    String key = entry.getKey();
                    if (!key.startsWith("datanucleus.query.jdoql.") || !key.endsWith(".join")) continue;
                    String alias = key.substring("datanucleus.query.jdoql.".length(), key.lastIndexOf(".join"));
                    str.append(", ").append(alias).append("=").append(entry.getValue());
                }
            }
            NucleusLogger.QUERY.debug((Object)("Compile of " + this.compilation.getQueryLanguage() + " into SQL - " + str));
        }
        this.compileFrom();
        this.compileFilter();
        if (this.stmt instanceof UpdateStatement) {
            this.compileUpdate((UpdateStatement)this.stmt);
        } else if (this.stmt instanceof SelectStatement) {
            SelectStatement selectStmt = (SelectStatement)this.stmt;
            if (this.compilation.getResultDistinct()) {
                selectStmt.setDistinct(true);
            } else if (!this.options.contains(OPTION_EXPLICIT_JOINS) && this.compilation.getExprResult() == null && selectStmt.getNumberOfTableGroups() > 1 && !this.options.contains(OPTION_NON_DISTINCT_IMPLICIT_JOINS)) {
                selectStmt.setDistinct(true);
            }
            this.compileResult(selectStmt);
            this.compileGrouping(selectStmt);
            this.compileHaving(selectStmt);
            this.compileOrdering(selectStmt);
        }
        Collection symbols = this.compilation.getSymbolTable().getSymbolNames();
        Iterator symIter = symbols.iterator();
        while (symIter.hasNext()) {
            Symbol sym = this.compilation.getSymbolTable().getSymbol((String)symIter.next());
            if (sym.getType() != 2 || this.compilation.getCompilationForSubquery(sym.getQualifiedName()) != null || this.hasSQLTableMappingForAlias(sym.getQualifiedName())) continue;
            throw new QueryCompilerSyntaxException("Query has variable \"" + sym.getQualifiedName() + "\" which is not bound to the query");
        }
    }

    protected void compileFrom() {
        if (this.compilation.getExprFrom() != null) {
            this.compileComponent = CompilationComponent.FROM;
            Expression[] fromExprs = this.compilation.getExprFrom();
            for (int i = 0; i < fromExprs.length; ++i) {
                ClassExpression clsExpr = (ClassExpression)fromExprs[i];
                this.compileFromClassExpression(clsExpr);
            }
            this.compileComponent = null;
        }
    }

    protected void compileFilter() {
        if (this.compilation.getExprFilter() != null) {
            this.compileComponent = CompilationComponent.FILTER;
            if (QueryUtils.expressionHasOrOperator((Expression)this.compilation.getExprFilter())) {
                this.compileProperties.put("Filter.OR", true);
            }
            if (QueryUtils.expressionHasNotOperator((Expression)this.compilation.getExprFilter())) {
                this.compileProperties.put("Filter.NOT", true);
            }
            if (this.stmt instanceof SelectStatement && ((SelectStatement)this.stmt).getNumberOfUnions() > 0) {
                List<SelectStatement> unionStmts = ((SelectStatement)this.stmt).getUnions();
                SQLStatement originalStmt = this.stmt;
                ((SelectStatement)this.stmt).setAllowUnions(false);
                SQLExpression filterSqlExpr = (SQLExpression)this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
                if (!(filterSqlExpr instanceof BooleanExpression)) {
                    throw new QueryCompilerSyntaxException("Filter compiles to something that is not a boolean expression. Kindly fix your query : " + filterSqlExpr);
                }
                BooleanExpression filterExpr = this.getBooleanExpressionForUseInFilter((BooleanExpression)filterSqlExpr);
                this.stmt.whereAnd(filterExpr, true);
                ((SelectStatement)this.stmt).setAllowUnions(true);
                for (SelectStatement unionStmt : unionStmts) {
                    this.stmt = unionStmt;
                    this.stmt.setQueryGenerator(this);
                    filterSqlExpr = (SQLExpression)this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
                    if (!(filterSqlExpr instanceof BooleanExpression)) {
                        throw new QueryCompilerSyntaxException("Filter compiles to something that is not a boolean expression. Kindly fix your query : " + filterSqlExpr);
                    }
                    filterExpr = this.getBooleanExpressionForUseInFilter((BooleanExpression)filterSqlExpr);
                    this.stmt.whereAnd(filterExpr, true);
                    this.stmt.setQueryGenerator(null);
                }
                this.stmt = originalStmt;
            } else {
                SQLExpression filterSqlExpr = (SQLExpression)this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
                if (!(filterSqlExpr instanceof BooleanExpression)) {
                    throw new QueryCompilerSyntaxException("Filter compiles to something that is not a boolean expression. Kindly fix your query : " + filterSqlExpr);
                }
                BooleanExpression filterExpr = (BooleanExpression)filterSqlExpr;
                filterExpr = this.getBooleanExpressionForUseInFilter(filterExpr);
                this.stmt.whereAnd(filterExpr, true);
            }
            this.compileComponent = null;
        }
    }

    protected void compileResult(SelectStatement stmt) {
        if (this.compilation.getExprResult() != null) {
            this.compileComponent = CompilationComponent.RESULT;
            boolean unionsPresent = stmt.getNumberOfUnions() > 0;
            Expression[] resultExprs = this.compilation.getExprResult();
            for (int i = 0; i < resultExprs.length; ++i) {
                StatementMappingIndex idx;
                StatementMappingIndex idx2;
                SQLExpression sqlExpr;
                String alias = resultExprs[i].getAlias();
                if (alias != null && this.resultAliases == null) {
                    this.resultAliases = new HashSet<String>();
                }
                if (resultExprs[i] instanceof InvokeExpression) {
                    this.processInvokeExpression((InvokeExpression)resultExprs[i]);
                    sqlExpr = this.stack.pop();
                    this.validateExpressionForResult(sqlExpr);
                    idx2 = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    int[] cols = stmt.select(sqlExpr, alias);
                    idx2.setColumnPositions(cols);
                    if (alias != null) {
                        this.resultAliases.add(alias);
                        idx2.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx2);
                    continue;
                }
                if (resultExprs[i] instanceof PrimaryExpression) {
                    PrimaryExpression primExpr = (PrimaryExpression)resultExprs[i];
                    if (primExpr.getId().equals(this.candidateAlias)) {
                        StatementClassMapping map = new StatementClassMapping(this.candidateCmd.getFullClassName(), null);
                        SQLStatementHelper.selectFetchPlanOfCandidateInStatement(stmt, map, this.candidateCmd, this.fetchPlan, 1);
                        this.resultDefinition.addMappingForResultExpression(i, map);
                        continue;
                    }
                    this.processPrimaryExpression(primExpr);
                    SQLExpression sqlExpr2 = this.stack.pop();
                    if (primExpr.getId().endsWith("#KEY") || primExpr.getId().endsWith("#VALUE")) {
                        AbstractMemberMetaData selMmd;
                        StatementClassMapping map;
                        if (sqlExpr2.getJavaTypeMapping() instanceof PersistableMapping) {
                            String selectedType = ((PersistableMapping)sqlExpr2.getJavaTypeMapping()).getType();
                            AbstractClassMetaData selectedCmd = this.ec.getMetaDataManager().getMetaDataForClass(selectedType, this.clr);
                            FetchPlanForClass fpForCmd = this.fetchPlan.getFetchPlanForClass(selectedCmd);
                            int[] membersToSelect = fpForCmd.getMemberNumbers();
                            ClassTable selectedTable = (ClassTable)sqlExpr2.getSQLTable().getTable();
                            map = new StatementClassMapping(selectedCmd.getFullClassName(), null);
                            if (selectedCmd.getIdentityType() == IdentityType.DATASTORE) {
                                int[] cols = stmt.select(sqlExpr2.getSQLTable(), selectedTable.getDatastoreIdMapping(), alias);
                                StatementMappingIndex idx3 = new StatementMappingIndex(selectedTable.getDatastoreIdMapping());
                                idx3.setColumnPositions(cols);
                                map.addMappingForMember(-1, idx3);
                            }
                            for (int memberToSelect : membersToSelect) {
                                selMmd = selectedCmd.getMetaDataForManagedMemberAtAbsolutePosition(memberToSelect);
                                SQLStatementHelper.selectMemberOfSourceInStatement(stmt, map, this.fetchPlan, sqlExpr2.getSQLTable(), selMmd, this.clr, 1, null);
                            }
                            this.resultDefinition.addMappingForResultExpression(i, map);
                            continue;
                        }
                        if (sqlExpr2.getJavaTypeMapping() instanceof EmbeddedMapping) {
                            EmbeddedMapping embMapping = (EmbeddedMapping)sqlExpr2.getJavaTypeMapping();
                            String selectedType = embMapping.getType();
                            AbstractClassMetaData selectedCmd = this.ec.getMetaDataManager().getMetaDataForClass(selectedType, this.clr);
                            FetchPlanForClass fpForCmd = this.fetchPlan.getFetchPlanForClass(selectedCmd);
                            int[] membersToSelect = fpForCmd.getMemberNumbers();
                            map = new StatementClassMapping(selectedCmd.getFullClassName(), null);
                            for (int memberToSelect : membersToSelect) {
                                selMmd = selectedCmd.getMetaDataForManagedMemberAtAbsolutePosition(memberToSelect);
                                JavaTypeMapping selMapping = embMapping.getJavaTypeMapping(selMmd.getName());
                                if (!selMapping.includeInFetchStatement()) continue;
                                int[] cols = stmt.select(sqlExpr2.getSQLTable(), selMapping, alias);
                                StatementMappingIndex idx4 = new StatementMappingIndex(selMapping);
                                idx4.setColumnPositions(cols);
                                map.addMappingForMember(memberToSelect, idx4);
                            }
                            this.resultDefinition.addMappingForResultExpression(i, map);
                            continue;
                        }
                    }
                    this.validateExpressionForResult(sqlExpr2);
                    if (sqlExpr2 instanceof SQLLiteral) {
                        idx = new StatementMappingIndex(sqlExpr2.getJavaTypeMapping());
                        idx.setColumnPositions(stmt.select(sqlExpr2, alias));
                        if (alias != null) {
                            this.resultAliases.add(alias);
                            idx.setColumnAlias(alias);
                        }
                        this.resultDefinition.addMappingForResultExpression(i, idx);
                        continue;
                    }
                    idx = new StatementMappingIndex(sqlExpr2.getJavaTypeMapping());
                    idx.setColumnPositions(stmt.select(sqlExpr2.getSQLTable(), sqlExpr2.getJavaTypeMapping(), alias));
                    if (alias != null) {
                        this.resultAliases.add(alias);
                        idx.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof ParameterExpression) {
                    this.processParameterExpression((ParameterExpression)resultExprs[i], true);
                    sqlExpr = this.stack.pop();
                    this.validateExpressionForResult(sqlExpr);
                    idx2 = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx2.setColumnPositions(stmt.select(sqlExpr, alias));
                    if (alias != null) {
                        this.resultAliases.add(alias);
                        idx2.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx2);
                    continue;
                }
                if (resultExprs[i] instanceof VariableExpression) {
                    this.processVariableExpression((VariableExpression)resultExprs[i]);
                    sqlExpr = this.stack.pop();
                    this.validateExpressionForResult(sqlExpr);
                    if (sqlExpr instanceof UnboundExpression) {
                        this.processUnboundExpression((UnboundExpression)sqlExpr);
                        sqlExpr = this.stack.pop();
                        NucleusLogger.QUERY.debug((Object)"QueryToSQL.exprResult variable was still unbound, so binding via cross-join");
                    }
                    idx2 = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx2.setColumnPositions(stmt.select(sqlExpr, alias));
                    if (alias != null) {
                        this.resultAliases.add(alias);
                        idx2.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx2);
                    continue;
                }
                if (resultExprs[i] instanceof Literal) {
                    this.processLiteral((Literal)resultExprs[i]);
                    sqlExpr = this.stack.pop();
                    this.validateExpressionForResult(sqlExpr);
                    idx2 = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx2.setColumnPositions(stmt.select(sqlExpr, alias));
                    if (alias != null) {
                        this.resultAliases.add(alias);
                        idx2.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx2);
                    continue;
                }
                if (resultExprs[i] instanceof CreatorExpression) {
                    this.processCreatorExpression((CreatorExpression)resultExprs[i]);
                    sqlExpr = (NewObjectExpression)this.stack.pop();
                    StatementNewObjectMapping stmtMap = this.getStatementMappingForNewObjectExpression((NewObjectExpression)sqlExpr, stmt);
                    this.resultDefinition.addMappingForResultExpression(i, stmtMap);
                    continue;
                }
                if (resultExprs[i] instanceof DyadicExpression || resultExprs[i] instanceof org.datanucleus.query.expression.CaseExpression) {
                    if (unionsPresent) {
                        stmt.setAllowUnions(false);
                        resultExprs[i].evaluate((ExpressionEvaluator)this);
                        sqlExpr = this.stack.pop();
                        int[] cols = stmt.select(sqlExpr, alias);
                        idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                        idx.setColumnPositions(cols);
                        if (alias != null) {
                            this.resultAliases.add(alias);
                            idx.setColumnAlias(alias);
                        }
                        this.resultDefinition.addMappingForResultExpression(i, idx);
                        stmt.setAllowUnions(true);
                        List<SelectStatement> unionStmts = stmt.getUnions();
                        SelectStatement originalStmt = stmt;
                        for (SelectStatement unionStmt : unionStmts) {
                            this.stmt = unionStmt;
                            unionStmt.setQueryGenerator(this);
                            unionStmt.setAllowUnions(false);
                            resultExprs[i].evaluate((ExpressionEvaluator)this);
                            sqlExpr = this.stack.pop();
                            cols = unionStmt.select(sqlExpr, alias);
                            unionStmt.setQueryGenerator(null);
                            unionStmt.setAllowUnions(true);
                        }
                        this.stmt = originalStmt;
                        continue;
                    }
                    resultExprs[i].evaluate((ExpressionEvaluator)this);
                    sqlExpr = this.stack.pop();
                    idx2 = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx2.setColumnPositions(stmt.select(sqlExpr, alias));
                    if (alias != null) {
                        this.resultAliases.add(alias);
                        idx2.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx2);
                    continue;
                }
                throw new NucleusException("Dont currently support result clause containing expression of type " + resultExprs[i]);
            }
            if (stmt.getNumberOfSelects() == 0) {
                stmt.select(this.exprFactory.newLiteral(stmt, this.storeMgr.getMappingManager().getMapping(Integer.class), 1), null);
            }
        } else {
            int maxFetchDepth;
            this.compileComponent = CompilationComponent.RESULT;
            if (this.candidateCmd.getIdentityType() == IdentityType.NONDURABLE) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"052520", (Object[])new Object[]{this.candidateCmd.getFullClassName()}));
                }
                this.fetchPlan.setGroup("all");
            }
            if (this.subclasses) {
                // empty if block
            }
            if ((maxFetchDepth = this.fetchPlan.getMaxFetchDepth()) < 0) {
                maxFetchDepth = 3;
            }
            if (this.options.contains(OPTION_SELECT_CANDIDATE_ID_ONLY)) {
                SQLStatementHelper.selectIdentityOfCandidateInStatement(stmt, this.resultDefinitionForClass, this.candidateCmd);
            } else if (this.parentMapper != null && this.resultDefinitionForClass == null) {
                SQLStatementHelper.selectIdentityOfCandidateInStatement(stmt, this.resultDefinitionForClass, this.candidateCmd);
            } else if (stmt.allUnionsForSamePrimaryTable()) {
                SQLStatementHelper.selectFetchPlanOfCandidateInStatement(stmt, this.resultDefinitionForClass, this.candidateCmd, this.fetchPlan, this.parentMapper == null ? maxFetchDepth : 0);
            } else if (this.candidateCmd.getInheritanceMetaData() != null && this.candidateCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
                SQLStatementHelper.selectFetchPlanOfCandidateInStatement(stmt, this.resultDefinitionForClass, this.candidateCmd, this.fetchPlan, this.parentMapper == null ? maxFetchDepth : 0);
            } else {
                SQLStatementHelper.selectIdentityOfCandidateInStatement(stmt, this.resultDefinitionForClass, this.candidateCmd);
            }
        }
        this.compileComponent = null;
    }

    protected void compileUpdate(UpdateStatement stmt) {
        if (this.compilation.getExprUpdate() != null) {
            this.compileComponent = CompilationComponent.UPDATE;
            Expression[] updateExprs = this.compilation.getExprUpdate();
            SQLExpression[] updateSqlExprs = new SQLExpression[updateExprs.length];
            boolean performingUpdate = false;
            for (int i = 0; i < updateExprs.length; ++i) {
                DyadicExpression updateExpr = (DyadicExpression)updateExprs[i];
                SQLExpression leftSqlExpr = null;
                if (updateExpr.getLeft() instanceof PrimaryExpression) {
                    this.processPrimaryExpression((PrimaryExpression)updateExpr.getLeft());
                    leftSqlExpr = this.stack.pop();
                    if (leftSqlExpr.getSQLTable() != stmt.getPrimaryTable()) {
                        leftSqlExpr = null;
                    }
                } else {
                    throw new NucleusException("Dont currently support update clause containing left expression of type " + updateExpr.getLeft());
                }
                if (leftSqlExpr == null) continue;
                if (!stmt.getDatastoreAdapter().supportsOption("UpdateStmtAllowTableAliasInSet")) {
                    for (int j = 0; j < leftSqlExpr.getNumberOfSubExpressions(); ++j) {
                        ColumnExpression colExpr = leftSqlExpr.getSubExpression(j);
                        colExpr.setOmitTableFromString(true);
                    }
                }
                performingUpdate = true;
                SQLExpression rightSqlExpr = null;
                if (updateExpr.getRight() instanceof Literal) {
                    this.processLiteral((Literal)updateExpr.getRight());
                    rightSqlExpr = this.stack.pop();
                } else if (updateExpr.getRight() instanceof ParameterExpression) {
                    ParameterExpression paramExpr = (ParameterExpression)updateExpr.getRight();
                    this.paramMappingForName.put(paramExpr.getId(), leftSqlExpr.getJavaTypeMapping());
                    this.processParameterExpression(paramExpr);
                    rightSqlExpr = this.stack.pop();
                } else if (updateExpr.getRight() instanceof PrimaryExpression) {
                    this.processPrimaryExpression((PrimaryExpression)updateExpr.getRight());
                    rightSqlExpr = this.stack.pop();
                } else if (updateExpr.getRight() instanceof DyadicExpression) {
                    updateExpr.getRight().evaluate((ExpressionEvaluator)this);
                    rightSqlExpr = this.stack.pop();
                } else if (updateExpr.getRight() instanceof org.datanucleus.query.expression.CaseExpression) {
                    updateExpr.getRight().evaluate((ExpressionEvaluator)this);
                    rightSqlExpr = this.stack.pop();
                } else if (updateExpr.getRight() instanceof VariableExpression) {
                    this.processVariableExpression((VariableExpression)updateExpr.getRight());
                    rightSqlExpr = this.stack.pop();
                    if (rightSqlExpr instanceof UnboundExpression) {
                        throw new NucleusException("Found UnboundExpression in UPDATE clause!");
                    }
                } else {
                    throw new NucleusException("Dont currently support update clause containing right expression of type " + updateExpr.getRight());
                }
                if (rightSqlExpr == null) continue;
                updateSqlExprs[i] = leftSqlExpr.eq(rightSqlExpr);
            }
            if (this.candidateCmd.isVersioned() && this.options.contains(OPTION_BULK_UPDATE_VERSION)) {
                JavaTypeMapping verMapping;
                BooleanExpression updateSqlExpr = null;
                ClassTable table = (ClassTable)stmt.getPrimaryTable().getTable();
                ClassTable verTable = table.getTableManagingMapping(verMapping = table.getVersionMapping(true));
                if (verTable == stmt.getPrimaryTable().getTable()) {
                    VersionMetaData vermd = this.candidateCmd.getVersionMetaDataForClass();
                    if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                        SQLTable verSqlTbl = stmt.getTable(verTable, stmt.getPrimaryTable().getGroupName());
                        NumericExpression verExpr = new NumericExpression((SQLStatement)stmt, verSqlTbl, verMapping);
                        SQLExpression incrExpr = ((SQLExpression)verExpr).add(new IntegerLiteral((SQLStatement)stmt, this.exprFactory.getMappingForType(Integer.class, false), 1, null));
                        updateSqlExpr = ((SQLExpression)verExpr).eq(incrExpr);
                        SQLExpression[] oldArray = updateSqlExprs;
                        updateSqlExprs = new SQLExpression[oldArray.length + 1];
                        System.arraycopy(oldArray, 0, updateSqlExprs, 0, oldArray.length);
                        updateSqlExprs[oldArray.length] = updateSqlExpr;
                        performingUpdate = true;
                    } else if (vermd.getVersionStrategy() == VersionStrategy.DATE_TIME) {
                        SQLTable verSqlTbl = stmt.getTable(verTable, stmt.getPrimaryTable().getGroupName());
                        NumericExpression verExpr = new NumericExpression((SQLStatement)stmt, verSqlTbl, verMapping);
                        Object newVersion = VersionHelper.getNextVersion((VersionStrategy)vermd.getVersionStrategy(), null);
                        JavaTypeMapping valMapping = this.exprFactory.getMappingForType(newVersion.getClass(), false);
                        TemporalLiteral valExpr = new TemporalLiteral((SQLStatement)stmt, valMapping, newVersion, null);
                        updateSqlExpr = ((SQLExpression)verExpr).eq(valExpr);
                        SQLExpression[] oldArray = updateSqlExprs;
                        updateSqlExprs = new SQLExpression[oldArray.length + 1];
                        System.arraycopy(oldArray, 0, updateSqlExprs, 0, oldArray.length);
                        updateSqlExprs[oldArray.length] = updateSqlExpr;
                        performingUpdate = true;
                    }
                }
            }
            if (performingUpdate) {
                stmt.setUpdates(updateSqlExprs);
            }
        }
        this.compileComponent = null;
    }

    protected void validateExpressionForResult(SQLExpression sqlExpr) {
        JavaTypeMapping m = sqlExpr.getJavaTypeMapping();
        if (m != null && m instanceof AbstractContainerMapping && m.getNumberOfDatastoreMappings() != 1) {
            throw new NucleusUserException(Localiser.msg((String)"021213"));
        }
    }

    protected void compileGrouping(SelectStatement stmt) {
        if (this.compilation.getExprGrouping() != null) {
            this.compileComponent = CompilationComponent.GROUPING;
            Expression[] groupExprs = this.compilation.getExprGrouping();
            for (int i = 0; i < groupExprs.length; ++i) {
                stmt.addGroupingExpression((SQLExpression)groupExprs[i].evaluate((ExpressionEvaluator)this));
            }
            this.compileComponent = null;
        }
    }

    protected void compileHaving(SelectStatement stmt) {
        if (this.compilation.getExprHaving() != null) {
            this.compileComponent = CompilationComponent.HAVING;
            Expression havingExpr = this.compilation.getExprHaving();
            Object havingEval = havingExpr.evaluate((ExpressionEvaluator)this);
            if (!(havingEval instanceof BooleanExpression)) {
                throw new NucleusUserException(Localiser.msg((String)"021051", (Object[])new Object[]{havingExpr}));
            }
            stmt.setHaving((BooleanExpression)havingEval);
            this.compileComponent = null;
        }
    }

    protected void compileOrdering(SelectStatement stmt) {
        if (this.compilation.getExprOrdering() != null) {
            this.compileComponent = CompilationComponent.ORDERING;
            Expression[] orderingExpr = this.compilation.getExprOrdering();
            SQLExpression[] orderSqlExprs = new SQLExpression[orderingExpr.length];
            boolean[] directions = new boolean[orderingExpr.length];
            NullOrderingType[] nullOrders = new NullOrderingType[orderingExpr.length];
            for (int i = 0; i < orderingExpr.length; ++i) {
                String orderDir;
                PrimaryExpression orderPrimExpr;
                OrderExpression orderExpr = (OrderExpression)orderingExpr[i];
                Expression expr = orderExpr.getLeft();
                if (expr instanceof PrimaryExpression && (orderPrimExpr = (PrimaryExpression)expr).getTuples().size() == 1 && this.resultAliases != null && this.resultAliases.contains(orderPrimExpr.getId().toLowerCase())) {
                    orderSqlExprs[i] = new ResultAliasExpression(stmt, orderPrimExpr.getId());
                }
                if (orderSqlExprs[i] == null) {
                    orderSqlExprs[i] = (SQLExpression)orderExpr.getLeft().evaluate((ExpressionEvaluator)this);
                }
                directions[i] = (orderDir = orderExpr.getSortOrder()) != null && !orderDir.equals("ascending");
                nullOrders[i] = orderExpr.getNullOrder();
            }
            stmt.setOrdering(orderSqlExprs, directions, nullOrders);
            this.compileComponent = null;
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void compileFromClassExpression(ClassExpression clsExpr) {
        clsExprSym = clsExpr.getSymbol();
        baseCls = clsExprSym != null ? clsExprSym.getValueType() : null;
        candSqlTbl = this.stmt.getPrimaryTable();
        mmgr = this.storeMgr.getMetaDataManager();
        cmd = mmgr.getMetaDataForClass(baseCls, this.clr);
        if (baseCls != null && !this.candidateAlias.equals(clsExpr.getAlias())) {
            candTbl = this.storeMgr.getDatastoreClass(baseCls.getName(), this.clr);
            candSqlTbl = this.stmt.crossJoin(candTbl, clsExpr.getAlias(), null);
            tblMapping = new SQLTableMapping(candSqlTbl, cmd, candTbl.getIdMapping());
            this.setSQLTableMappingForAlias(clsExpr.getAlias(), tblMapping);
        }
        if (clsExpr.getCandidateExpression() != null && this.parentMapper != null) {
            this.processFromClauseSubquery(clsExpr, candSqlTbl, mmgr);
        }
        rightExpr = clsExpr.getRight();
        sqlTbl = candSqlTbl;
        previousMapping = null;
        while (rightExpr != null) {
            block119: {
                block115: {
                    block117: {
                        block118: {
                            block116: {
                                if (!(rightExpr instanceof JoinExpression)) break block115;
                                joinExpr = (JoinExpression)rightExpr;
                                exprJoinType = joinExpr.getType();
                                joinType = SQLJoin.getJoinTypeForJoinExpressionType(exprJoinType);
                                joinedExpr = joinExpr.getJoinedExpression();
                                joinOnExpr = joinExpr.getOnExpression();
                                joinAlias = joinExpr.getAlias();
                                joinPrimExpr = null;
                                castCls = null;
                                if (joinedExpr instanceof PrimaryExpression) {
                                    joinPrimExpr = (PrimaryExpression)joinedExpr;
                                } else if (joinedExpr instanceof DyadicExpression && joinedExpr.getOperator() == Expression.OP_CAST) {
                                    joinPrimExpr = (PrimaryExpression)joinedExpr.getLeft();
                                    castClassName = (String)((Literal)joinedExpr.getRight()).getLiteral();
                                    castCls = this.clr.classForName(castClassName);
                                } else {
                                    throw new NucleusException("We do not currently support JOIN to " + joinedExpr);
                                }
                                iter = joinPrimExpr.getTuples().iterator();
                                rootId = (String)iter.next();
                                if (joinPrimExpr.getTuples().size() == 1 && !rootId.endsWith("#KEY") && !rootId.endsWith("#VALUE")) {
                                    if (joinOnExpr == null) {
                                        throw new NucleusUserException("Query has join to " + joinPrimExpr.getId() + " yet this is a root component and there is no ON expression");
                                    }
                                    baseCls = this.resolveClass(joinPrimExpr.getId());
                                    baseTbl = this.storeMgr.getDatastoreClass(baseCls.getName(), this.clr);
                                    sqlTbl = this.stmt.join(joinType, candSqlTbl, baseTbl, joinAlias, null, null, true);
                                    cmd = mmgr.getMetaDataForClass(baseCls, this.clr);
                                    tblMapping = new SQLTableMapping(sqlTbl, cmd, baseTbl.getIdMapping());
                                    this.setSQLTableMappingForAlias(joinAlias, tblMapping);
                                    this.processingOnClause = true;
                                    joinOnExpr.evaluate((ExpressionEvaluator)this);
                                    joinOnSqlExpr = (BooleanExpression)this.stack.pop();
                                    this.processingOnClause = false;
                                    this.stmt.addAndConditionToJoinForTable(sqlTbl, joinOnSqlExpr, true);
                                    rightExpr = rightExpr.getRight();
                                    continue;
                                }
                                joinTableGroupName = null;
                                tblMappingSqlTbl = null;
                                tblIdMapping = null;
                                tblMmd = null;
                                mapKey = false;
                                mapValue = false;
                                rootComponent = rootId;
                                if (rootComponent.endsWith("#KEY")) {
                                    mapKey = true;
                                    rootComponent = rootComponent.substring(0, rootComponent.length() - 4);
                                } else if (rootComponent.endsWith("#VALUE")) {
                                    mapValue = true;
                                    rootComponent = rootComponent.substring(0, rootComponent.length() - 6);
                                }
                                if (!rootComponent.equalsIgnoreCase(this.candidateAlias)) break block116;
                                cmd = this.candidateCmd;
                                joinTableGroupName = joinPrimExpr.getId();
                                sqlTbl = candSqlTbl;
                                break block117;
                            }
                            sqlTblMapping = this.getSQLTableMappingForAlias(rootComponent);
                            if (sqlTblMapping == null) break block118;
                            if (sqlTblMapping.mmd == null || !mapKey && !mapValue) ** GOTO lbl96
                            mapmd = sqlTblMapping.mmd.getMap();
                            cmd = mapKey != false ? mapmd.getKeyClassMetaData(this.clr) : mapmd.getValueClassMetaData(this.clr);
                            sqlTbl = this.stmt.getTable(rootComponent + "_MAP");
                            if (sqlTbl == null && (sqlTbl = this.stmt.getTable((rootComponent + "_MAP").toUpperCase())) == null) {
                                sqlTbl = this.stmt.getTable((rootComponent + "_MAP").toLowerCase());
                            }
                            v0 = aliasForJoin = iter.hasNext() != false ? null : joinAlias;
                            v1 = mapKey ? mapmd.isEmbeddedKey() || mapmd.isSerializedKey() : (embedded = mapmd.isEmbeddedValue() != false || mapmd.isSerializedValue() != false);
                            if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
                                if (!embedded) {
                                    if (mapKey) {
                                        keyTable = this.storeMgr.getDatastoreClass(mapmd.getKeyType(), this.clr);
                                        sqlTbl = this.stmt.join(joinType, sqlTbl, ((MapTable)sqlTbl.getTable()).getKeyMapping(), keyTable, aliasForJoin, keyTable.getIdMapping(), null, joinTableGroupName, true);
                                    } else {
                                        valueTable = this.storeMgr.getDatastoreClass(mapmd.getValueType(), this.clr);
                                        sqlTbl = this.stmt.join(joinType, sqlTbl, ((MapTable)sqlTbl.getTable()).getValueMapping(), valueTable, aliasForJoin, valueTable.getIdMapping(), null, joinTableGroupName, true);
                                    }
                                    tblMappingSqlTbl = sqlTbl;
                                    tblIdMapping = tblMappingSqlTbl.getTable().getIdMapping();
                                }
                            } else {
                                ** if (mapmd.getMapType() != MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE && mapmd.getMapType() != MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) goto lbl99
lbl96:
                                // 1 sources

                                cmd = sqlTblMapping.cmd;
                                sqlTbl = sqlTblMapping.table;
lbl-1000:
                                // 1 sources

                                {
                                    // empty if block
                                }
                            }
lbl99:
                            // 4 sources

                            joinTableGroupName = sqlTbl.getGroupName() + joinPrimExpr.getId().substring(rootComponent.length());
                            break block117;
                        }
                        throw new NucleusUserException("Query has " + joinPrimExpr.getId() + " yet the first component " + rootComponent + " is unknown!");
                    }
                    while (iter.hasNext()) {
                        id = (String)iter.next();
                        ids = null;
                        ids = id.contains(".") != false ? StringUtils.split((String)id, (String)".") : new String[]{id};
                        for (k = 0; k < ids.length; ++k) {
                            lastComponent = k == ids.length - 1;
                            thisComponent = ids[k];
                            mapKey = false;
                            mapValue = false;
                            if (thisComponent.endsWith("#KEY")) {
                                thisComponent = thisComponent.substring(0, thisComponent.length() - 4);
                                mapKey = true;
                            } else if (thisComponent.endsWith("#VALUE")) {
                                thisComponent = thisComponent.substring(0, thisComponent.length() - 6);
                                mapValue = true;
                            }
                            mmd = cmd.getMetaDataForMember(thisComponent);
                            if (mmd == null) {
                                if (exprJoinType == JoinExpression.JoinType.JOIN_LEFT_OUTER || exprJoinType == JoinExpression.JoinType.JOIN_LEFT_OUTER_FETCH) {
                                    subclasses = mmgr.getSubclassesForClass(cmd.getFullClassName(), true);
                                    for (l = 0; l < subclasses.length; ++l) {
                                        subCmd = mmgr.getMetaDataForClass(subclasses[l], this.clr);
                                        if (subCmd == null || (mmd = subCmd.getMetaDataForMember(thisComponent)) == null) continue;
                                        cmd = subCmd;
                                        break;
                                    }
                                }
                                if (mmd == null) {
                                    throw new NucleusUserException("Query has " + joinPrimExpr.getId() + " yet " + thisComponent + " is not found. Fix your input");
                                }
                            }
                            tblMmd = null;
                            aliasForJoin = null;
                            if (k == ids.length - 1 && !iter.hasNext()) {
                                aliasForJoin = joinAlias;
                            }
                            relationType = mmd.getRelationType(this.clr);
                            relTable = null;
                            relMmd = null;
                            if (relationType != RelationType.NONE && JoinExpression.JoinType.isFetch((JoinExpression.JoinType)exprJoinType)) {
                                fgName = "QUERY_FETCH_" + mmd.getFullFieldName();
                                fetchGrpMgr = this.storeMgr.getNucleusContext().getFetchGroupManager();
                                if (fetchGrpMgr.getFetchGroupsWithName(fgName) == null) {
                                    grp = new FetchGroup((NucleusContext)this.storeMgr.getNucleusContext(), fgName, this.clr.classForName(cmd.getFullClassName()));
                                    grp.addMember(mmd.getName());
                                    fetchGrpMgr.addFetchGroup(grp);
                                }
                                this.fetchPlan.addGroup(fgName);
                            }
                            if (relationType == RelationType.ONE_TO_ONE_UNI) {
                                otherMapping = null;
                                castDiscrimValues = null;
                                if (castCls != null && lastComponent) {
                                    cmd = mmgr.getMetaDataForClass(castCls, this.clr);
                                    if (cmd.hasDiscriminatorStrategy()) {
                                        castDiscrimValues = this.getDiscriminatorValuesForCastClass(cmd);
                                    }
                                } else {
                                    cmd = mmgr.getMetaDataForClass(mmd.getType(), this.clr);
                                }
                                if (mmd.isEmbedded()) {
                                    otherMapping = sqlTbl.getTable().getMemberMapping(mmd);
                                } else {
                                    if (sqlTbl.getTable() instanceof CollectionTable) {
                                        collTbl = (CollectionTable)sqlTbl.getTable();
                                        elemMapping = collTbl.getElementMapping();
                                        if (elemMapping instanceof EmbeddedMapping) {
                                            otherMapping = ((EmbeddedMapping)elemMapping).getJavaTypeMapping(mmd.getName());
                                        }
                                    } else {
                                        otherMapping = sqlTbl.getTable().getMemberMapping(mmd);
                                    }
                                    relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                                    if (otherMapping == null && previousMapping != null && previousMapping instanceof EmbeddedMapping) {
                                        embMapping = (EmbeddedMapping)previousMapping;
                                        otherMapping = embMapping.getJavaTypeMapping(mmd.getName());
                                    }
                                    if (otherMapping == null) {
                                        tblGroupName = sqlTbl.getGroupName();
                                        grp = this.stmt.getTableGroup(tblGroupName);
                                        nextSqlTbl = null;
                                        for (SQLTable grpTbl : grpTbls = grp.getTables()) {
                                            if (grpTbl.getTable().getMemberMapping(mmd) == null) continue;
                                            otherMapping = grpTbl.getTable().getMemberMapping(mmd);
                                            break;
                                        }
                                        if ((newSqlTbl = this.stmt.join(joinType, sqlTbl, otherMapping, relTable, aliasForJoin, relTable.getIdMapping(), null, joinTableGroupName, false)) != null) {
                                            nextSqlTbl = newSqlTbl;
                                        }
                                        if (this.stmt instanceof SelectStatement && (unionStmts = ((SelectStatement)this.stmt).getUnions()) != null) {
                                            for (SQLStatement unionStmt : unionStmts) {
                                                otherMapping = null;
                                                grp = unionStmt.getTableGroup(tblGroupName);
                                                for (SQLTable grpTbl : unionGrpTbls = grp.getTables()) {
                                                    if (grpTbl.getTable().getMemberMapping(mmd) == null) continue;
                                                    otherMapping = grpTbl.getTable().getMemberMapping(mmd);
                                                    break;
                                                }
                                                if ((newSqlTbl = unionStmt.join(joinType, sqlTbl, otherMapping, relTable, aliasForJoin, relTable.getIdMapping(), castDiscrimValues, joinTableGroupName, false)) == null) continue;
                                                nextSqlTbl = newSqlTbl;
                                            }
                                        }
                                        sqlTbl = nextSqlTbl;
                                    } else {
                                        sqlTbl = this.stmt.join(joinType, sqlTbl, otherMapping, relTable, aliasForJoin, relTable.getIdMapping(), castDiscrimValues, joinTableGroupName, true);
                                    }
                                }
                                previousMapping = otherMapping;
                                tblIdMapping = sqlTbl.getTable().getIdMapping();
                                tblMappingSqlTbl = sqlTbl;
                                continue;
                            }
                            if (relationType == RelationType.ONE_TO_ONE_BI) {
                                otherMapping = null;
                                castDiscrimValues = null;
                                if (castCls != null && lastComponent) {
                                    cmd = mmgr.getMetaDataForClass(castCls, this.clr);
                                    if (cmd.hasDiscriminatorStrategy()) {
                                        castDiscrimValues = this.getDiscriminatorValuesForCastClass(cmd);
                                    }
                                } else {
                                    cmd = mmgr.getMetaDataForClass(mmd.getType(), this.clr);
                                }
                                if (mmd.isEmbedded()) {
                                    otherMapping = sqlTbl.getTable().getMemberMapping(mmd);
                                } else {
                                    relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                                    if (mmd.getMappedBy() != null) {
                                        relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                                        relMapping = relTable.getMemberMapping(relMmd);
                                        sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), relTable, aliasForJoin, relMapping, castDiscrimValues, joinTableGroupName, true);
                                    } else {
                                        if (sqlTbl.getTable() instanceof CollectionTable) {
                                            collTbl = (CollectionTable)sqlTbl.getTable();
                                            elemMapping = collTbl.getElementMapping();
                                            if (elemMapping instanceof EmbeddedMapping) {
                                                otherMapping = ((EmbeddedMapping)elemMapping).getJavaTypeMapping(mmd.getName());
                                            }
                                        } else {
                                            otherMapping = sqlTbl.getTable().getMemberMapping(mmd);
                                        }
                                        if (otherMapping == null && previousMapping != null && previousMapping instanceof EmbeddedMapping) {
                                            embMapping = (EmbeddedMapping)previousMapping;
                                            otherMapping = embMapping.getJavaTypeMapping(mmd.getName());
                                        }
                                        sqlTbl = this.stmt.join(joinType, sqlTbl, otherMapping, relTable, aliasForJoin, relTable.getIdMapping(), castDiscrimValues, joinTableGroupName, true);
                                    }
                                }
                                previousMapping = otherMapping;
                                tblIdMapping = sqlTbl.getTable().getIdMapping();
                                tblMappingSqlTbl = sqlTbl;
                                continue;
                            }
                            if (relationType == RelationType.ONE_TO_MANY_BI) {
                                previousMapping = null;
                                if (mmd.hasCollection()) {
                                    cmd = mmd.getCollection().getElementClassMetaData(this.clr);
                                    if (mmd.getCollection().isEmbeddedElement() && mmd.getJoinMetaData() != null) {
                                        relEmbTable = (CollectionTable)this.storeMgr.getTable(mmd);
                                        relOwnerMapping = relEmbTable.getOwnerMapping();
                                        tblMappingSqlTbl = sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), relEmbTable, aliasForJoin, relOwnerMapping, null, joinTableGroupName, true);
                                        tblIdMapping = relEmbTable.getElementMapping();
                                        continue;
                                    }
                                    relTable = this.storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
                                    relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                                    if (mmd.getJoinMetaData() != null || relMmd.getJoinMetaData() != null) {
                                        joinTbl = (ElementContainerTable)this.storeMgr.getTable(mmd);
                                        joinSqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null, true);
                                        sqlTbl = this.stmt.join(joinType, joinSqlTbl, joinTbl.getElementMapping(), relTable, aliasForJoin, relTable.getIdMapping(), null, joinTableGroupName, true);
                                    } else {
                                        sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), relTable, aliasForJoin, relTable.getMemberMapping(relMmd), null, joinTableGroupName, true);
                                    }
                                    tblIdMapping = sqlTbl.getTable().getIdMapping();
                                    tblMappingSqlTbl = sqlTbl;
                                    continue;
                                }
                                if (mmd.hasMap()) {
                                    mapmd = mmd.getMap();
                                    cmd = mapmd.getValueClassMetaData(this.clr);
                                    tblMmd = mmd;
                                    v2 = mapKey ? mapmd.isEmbeddedKey() || mapmd.isSerializedKey() : (embedded = mapmd.isEmbeddedValue() != false || mapmd.isSerializedValue() != false);
                                    if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
                                        joinTbl = (MapTable)this.storeMgr.getTable(mmd);
                                        aliasForMap = embedded != false ? aliasForJoin : aliasForJoin + "_MAP";
                                        sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, aliasForMap, joinTbl.getOwnerMapping(), null, null, true);
                                        if (embedded) {
                                            tblMappingSqlTbl = sqlTbl;
                                            tblIdMapping = mapKey != false ? joinTbl.getKeyMapping() : joinTbl.getValueMapping();
                                            continue;
                                        }
                                        if (mapKey) {
                                            relTable = this.storeMgr.getDatastoreClass(mapmd.getKeyType(), this.clr);
                                            sqlTbl = this.stmt.join(joinType, sqlTbl, joinTbl.getKeyMapping(), relTable, aliasForJoin, relTable.getIdMapping(), null, joinTableGroupName, true);
                                        } else {
                                            relTable = this.storeMgr.getDatastoreClass(mapmd.getValueType(), this.clr);
                                            sqlTbl = this.stmt.join(joinType, sqlTbl, joinTbl.getValueMapping(), relTable, aliasForJoin, relTable.getIdMapping(), null, joinTableGroupName, true);
                                        }
                                        tblMappingSqlTbl = sqlTbl;
                                        tblIdMapping = tblMappingSqlTbl.getTable().getIdMapping();
                                        continue;
                                    }
                                    if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
                                        valTable = this.storeMgr.getDatastoreClass(mapmd.getValueType(), this.clr);
                                        mapTblOwnerMapping = mmd.getMappedBy() != null ? valTable.getMemberMapping(mapmd.getValueClassMetaData(this.clr).getMetaDataForMember(mmd.getMappedBy())) : valTable.getExternalMapping(mmd, 5);
                                        aliasForMap = embedded != false || mapKey == false ? aliasForJoin : aliasForJoin + "_MAP";
                                        sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), valTable, aliasForMap, mapTblOwnerMapping, null, null, true);
                                        if (!embedded && mapKey) {
                                            keyMapping = valTable.getMemberMapping(mmd.getKeyMetaData().getMappedBy());
                                            relTable = this.storeMgr.getDatastoreClass(mapmd.getKeyType(), this.clr);
                                            sqlTbl = this.stmt.join(joinType, sqlTbl, keyMapping, relTable, aliasForJoin, relTable.getIdMapping(), null, joinTableGroupName, true);
                                        }
                                        tblMappingSqlTbl = sqlTbl;
                                        tblIdMapping = tblMappingSqlTbl.getTable().getIdMapping();
                                        continue;
                                    }
                                    if (mapmd.getMapType() != MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) continue;
                                    keyTable = this.storeMgr.getDatastoreClass(mapmd.getKeyType(), this.clr);
                                    mapTblOwnerMapping = mmd.getMappedBy() != null ? keyTable.getMemberMapping(mapmd.getKeyClassMetaData(this.clr).getMetaDataForMember(mmd.getMappedBy())) : keyTable.getExternalMapping(mmd, 5);
                                    aliasForMap = embedded != false || mapKey != false ? aliasForJoin : aliasForJoin + "_MAP";
                                    sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), keyTable, aliasForMap, mapTblOwnerMapping, null, null, true);
                                    if (!embedded && !mapKey) {
                                        valueMapping = keyTable.getMemberMapping(mmd.getValueMetaData().getMappedBy());
                                        relTable = this.storeMgr.getDatastoreClass(mapmd.getValueType(), this.clr);
                                        sqlTbl = this.stmt.join(joinType, sqlTbl, valueMapping, relTable, aliasForJoin, relTable.getIdMapping(), null, joinTableGroupName, true);
                                    }
                                    tblMappingSqlTbl = sqlTbl;
                                    tblIdMapping = tblMappingSqlTbl.getTable().getIdMapping();
                                    continue;
                                }
                                if (!mmd.hasArray()) continue;
                                cmd = mmd.getArray().getElementClassMetaData(this.clr);
                                if (mmd.getArray().isEmbeddedElement() && mmd.getJoinMetaData() != null) {
                                    relEmbTable = (ArrayTable)this.storeMgr.getTable(mmd);
                                    relOwnerMapping = relEmbTable.getOwnerMapping();
                                    tblMappingSqlTbl = sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), relEmbTable, aliasForJoin, relOwnerMapping, null, joinTableGroupName, true);
                                    tblIdMapping = relEmbTable.getElementMapping();
                                    continue;
                                }
                                relTable = this.storeMgr.getDatastoreClass(mmd.getArray().getElementType(), this.clr);
                                relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                                if (mmd.getJoinMetaData() != null || relMmd.getJoinMetaData() != null) {
                                    joinTbl = (ElementContainerTable)this.storeMgr.getTable(mmd);
                                    joinSqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null, true);
                                    sqlTbl = this.stmt.join(joinType, joinSqlTbl, joinTbl.getElementMapping(), relTable, aliasForJoin, relTable.getIdMapping(), null, joinTableGroupName, true);
                                } else {
                                    sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), relTable, aliasForJoin, relTable.getMemberMapping(relMmd), null, joinTableGroupName, true);
                                }
                                tblIdMapping = sqlTbl.getTable().getIdMapping();
                                tblMappingSqlTbl = sqlTbl;
                                continue;
                            }
                            if (relationType == RelationType.ONE_TO_MANY_UNI) {
                                previousMapping = null;
                                if (mmd.hasCollection()) {
                                    cmd = mmd.getCollection().getElementClassMetaData(this.clr);
                                    if (mmd.getCollection().isEmbeddedElement() && mmd.getJoinMetaData() != null) {
                                        relEmbTable = (CollectionTable)this.storeMgr.getTable(mmd);
                                        relOwnerMapping = relEmbTable.getOwnerMapping();
                                        tblMappingSqlTbl = sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), relEmbTable, aliasForJoin, relOwnerMapping, null, joinTableGroupName, true);
                                        tblIdMapping = relEmbTable.getElementMapping();
                                        continue;
                                    }
                                    relTable = this.storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
                                    if (mmd.getJoinMetaData() != null) {
                                        joinTbl = (ElementContainerTable)this.storeMgr.getTable(mmd);
                                        joinSqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null, true);
                                        sqlTbl = this.stmt.join(joinType, joinSqlTbl, joinTbl.getElementMapping(), relTable, aliasForJoin, relTable.getIdMapping(), null, joinTableGroupName, true);
                                    } else {
                                        relMapping = relTable.getExternalMapping(mmd, 5);
                                        sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), relTable, aliasForJoin, relMapping, null, joinTableGroupName, true);
                                    }
                                    tblMappingSqlTbl = sqlTbl;
                                    tblIdMapping = tblMappingSqlTbl.getTable().getIdMapping();
                                    continue;
                                }
                                if (mmd.hasMap()) {
                                    mapmd = mmd.getMap();
                                    cmd = mapmd.getValueClassMetaData(this.clr);
                                    tblMmd = mmd;
                                    v3 = mapKey ? mapmd.isEmbeddedKey() || mapmd.isSerializedKey() : (embedded = mapmd.isEmbeddedValue() != false || mapmd.isSerializedValue() != false);
                                    if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
                                        joinTbl = (MapTable)this.storeMgr.getTable(mmd);
                                        aliasForMap = embedded != false || mapKey != false ? aliasForJoin : aliasForJoin + "_MAP";
                                        sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, aliasForMap, joinTbl.getOwnerMapping(), null, null, true);
                                        if (embedded) {
                                            tblMappingSqlTbl = sqlTbl;
                                            tblIdMapping = mapKey != false ? joinTbl.getKeyMapping() : joinTbl.getValueMapping();
                                            continue;
                                        }
                                        if (mapKey) {
                                            relTable = this.storeMgr.getDatastoreClass(mapmd.getKeyType(), this.clr);
                                            sqlTbl = this.stmt.join(joinType, sqlTbl, joinTbl.getKeyMapping(), relTable, aliasForJoin, relTable.getIdMapping(), null, joinTableGroupName, true);
                                        } else {
                                            relTable = this.storeMgr.getDatastoreClass(mapmd.getValueType(), this.clr);
                                            sqlTbl = this.stmt.join(joinType, sqlTbl, joinTbl.getValueMapping(), relTable, aliasForJoin, relTable.getIdMapping(), null, joinTableGroupName, true);
                                        }
                                        tblMappingSqlTbl = sqlTbl;
                                        tblIdMapping = tblMappingSqlTbl.getTable().getIdMapping();
                                        continue;
                                    }
                                    if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
                                        valTable = this.storeMgr.getDatastoreClass(mapmd.getValueType(), this.clr);
                                        mapTblOwnerMapping = mmd.getMappedBy() != null ? valTable.getMemberMapping(mapmd.getValueClassMetaData(this.clr).getMetaDataForMember(mmd.getMappedBy())) : valTable.getExternalMapping(mmd, 5);
                                        aliasForMap = embedded != false || mapKey == false ? aliasForJoin : aliasForJoin + "_MAP";
                                        sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), valTable, aliasForMap, mapTblOwnerMapping, null, null, true);
                                        if (!embedded && mapKey) {
                                            keyMapping = valTable.getMemberMapping(mmd.getKeyMetaData().getMappedBy());
                                            relTable = this.storeMgr.getDatastoreClass(mapmd.getKeyType(), this.clr);
                                            sqlTbl = this.stmt.join(joinType, sqlTbl, keyMapping, relTable, aliasForJoin, relTable.getIdMapping(), null, joinTableGroupName, true);
                                        }
                                        tblMappingSqlTbl = sqlTbl;
                                        tblIdMapping = tblMappingSqlTbl.getTable().getIdMapping();
                                        continue;
                                    }
                                    if (mapmd.getMapType() != MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) continue;
                                    keyTable = this.storeMgr.getDatastoreClass(mapmd.getKeyType(), this.clr);
                                    mapTblOwnerMapping = mmd.getMappedBy() != null ? keyTable.getMemberMapping(mapmd.getKeyClassMetaData(this.clr).getMetaDataForMember(mmd.getMappedBy())) : keyTable.getExternalMapping(mmd, 5);
                                    aliasForMap = embedded != false || mapKey != false ? aliasForJoin : aliasForJoin + "_MAP";
                                    sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), keyTable, aliasForMap, mapTblOwnerMapping, null, null, true);
                                    if (!embedded && !mapKey) {
                                        valueMapping = keyTable.getMemberMapping(mmd.getValueMetaData().getMappedBy());
                                        relTable = this.storeMgr.getDatastoreClass(mapmd.getValueType(), this.clr);
                                        sqlTbl = this.stmt.join(joinType, sqlTbl, valueMapping, relTable, aliasForJoin, relTable.getIdMapping(), null, joinTableGroupName, true);
                                    }
                                    tblMappingSqlTbl = sqlTbl;
                                    tblIdMapping = tblMappingSqlTbl.getTable().getIdMapping();
                                    continue;
                                }
                                if (!mmd.hasArray()) continue;
                                cmd = mmd.getArray().getElementClassMetaData(this.clr);
                                if (mmd.getArray().isEmbeddedElement() && mmd.getJoinMetaData() != null) {
                                    relEmbTable = (ArrayTable)this.storeMgr.getTable(mmd);
                                    relOwnerMapping = relEmbTable.getOwnerMapping();
                                    tblMappingSqlTbl = sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), relEmbTable, aliasForJoin, relOwnerMapping, null, joinTableGroupName, true);
                                    tblIdMapping = relEmbTable.getElementMapping();
                                    continue;
                                }
                                relTable = this.storeMgr.getDatastoreClass(mmd.getArray().getElementType(), this.clr);
                                if (mmd.getJoinMetaData() != null) {
                                    joinTbl = (ElementContainerTable)this.storeMgr.getTable(mmd);
                                    joinSqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null, true);
                                    sqlTbl = this.stmt.join(joinType, joinSqlTbl, joinTbl.getElementMapping(), relTable, aliasForJoin, relTable.getIdMapping(), null, joinTableGroupName, true);
                                } else {
                                    relMapping = relTable.getExternalMapping(mmd, 5);
                                    sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), relTable, aliasForJoin, relMapping, null, joinTableGroupName, true);
                                }
                                tblMappingSqlTbl = sqlTbl;
                                tblIdMapping = tblMappingSqlTbl.getTable().getIdMapping();
                                continue;
                            }
                            if (relationType == RelationType.MANY_TO_MANY_BI) {
                                previousMapping = null;
                                relTable = this.storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
                                cmd = mmd.getCollection().getElementClassMetaData(this.clr);
                                relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                                if (mmd.hasCollection()) {
                                    joinTbl = (CollectionTable)this.storeMgr.getTable(mmd);
                                    joinSqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null, true);
                                    sqlTbl = this.stmt.join(joinType, joinSqlTbl, joinTbl.getElementMapping(), relTable, aliasForJoin, relTable.getIdMapping(), null, joinTableGroupName, true);
                                } else if (mmd.hasMap()) {
                                    NucleusLogger.QUERY.warn((Object)("We do not support joining across a M-N MAP field : " + mmd.getFullFieldName()));
                                } else if (mmd.hasArray()) {
                                    NucleusLogger.QUERY.warn((Object)("We do not support joining across a M-N ARRAY field : " + mmd.getFullFieldName()));
                                }
                                tblMappingSqlTbl = sqlTbl;
                                tblIdMapping = tblMappingSqlTbl.getTable().getIdMapping();
                                continue;
                            }
                            if (relationType == RelationType.MANY_TO_ONE_BI) {
                                previousMapping = null;
                                relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                                castDiscrimValues = null;
                                if (castCls != null && lastComponent) {
                                    cmd = mmgr.getMetaDataForClass(castCls, this.clr);
                                    if (cmd.hasDiscriminatorStrategy()) {
                                        castDiscrimValues = this.getDiscriminatorValuesForCastClass(cmd);
                                    }
                                } else {
                                    cmd = mmgr.getMetaDataForClass(mmd.getType(), this.clr);
                                }
                                relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                                if (mmd.getJoinMetaData() != null || relMmd.getJoinMetaData() != null) {
                                    if (mmd.hasCollection()) {
                                        joinTbl = (CollectionTable)this.storeMgr.getTable(relMmd);
                                        joinSqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null, true);
                                        sqlTbl = this.stmt.join(joinType, joinSqlTbl, joinTbl.getOwnerMapping(), relTable, aliasForJoin, relTable.getIdMapping(), castDiscrimValues, joinTableGroupName, true);
                                    } else if (mmd.hasMap()) {
                                        NucleusLogger.QUERY.warn((Object)("We do not support joining across a N-1 MAP field : " + mmd.getFullFieldName()));
                                    } else if (mmd.hasArray()) {
                                        NucleusLogger.QUERY.warn((Object)("We do not support joining across a N-1 ARRAY field : " + mmd.getFullFieldName()));
                                    }
                                } else {
                                    fkMapping = sqlTbl.getTable().getMemberMapping(mmd);
                                    sqlTbl = this.stmt.join(joinType, sqlTbl, fkMapping, relTable, aliasForJoin, relTable.getIdMapping(), castDiscrimValues, joinTableGroupName, true);
                                }
                                tblMappingSqlTbl = sqlTbl;
                                tblIdMapping = tblMappingSqlTbl.getTable().getIdMapping();
                                continue;
                            }
                            previousMapping = null;
                            if (mmd.hasCollection()) {
                                cmd = null;
                                if (mmd.getJoinMetaData() != null) {
                                    joinTbl = (MapTable)this.storeMgr.getTable(mmd);
                                    tblMappingSqlTbl = sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, aliasForJoin, joinTbl.getOwnerMapping(), null, null, true);
                                    tblIdMapping = tblMappingSqlTbl.getTable().getIdMapping();
                                    continue;
                                }
                                throw new NucleusUserException("FROM clause contains join to Collection field at " + mmd.getFullFieldName() + " yet this has no join table");
                            }
                            if (mmd.hasMap()) {
                                mapmd = mmd.getMap();
                                cmd = mapmd.getValueClassMetaData(this.clr);
                                tblMmd = mmd;
                                if (mapmd.getMapType() != MapMetaData.MapType.MAP_TYPE_JOIN) continue;
                                joinTbl = (MapTable)this.storeMgr.getTable(mmd);
                                aliasForMap = aliasForJoin;
                                tblMappingSqlTbl = sqlTbl = this.stmt.join(joinType, sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, aliasForMap, joinTbl.getOwnerMapping(), null, null, true);
                                tblIdMapping = joinTbl.getValueMapping();
                                continue;
                            }
                            if (!mmd.hasArray()) continue;
                        }
                    }
                    if (joinAlias != null) {
                        if (this.explicitJoinPrimaryByAlias == null) {
                            this.explicitJoinPrimaryByAlias = new HashMap<String, String>();
                        }
                        this.explicitJoinPrimaryByAlias.put(joinAlias, joinPrimExpr.getId());
                        tblMapping = null;
                        tblMapping = tblMmd != null ? new SQLTableMapping(tblMappingSqlTbl, cmd, tblMmd, tblIdMapping) : new SQLTableMapping(tblMappingSqlTbl, cmd, tblIdMapping);
                        this.setSQLTableMappingForAlias(joinAlias, tblMapping);
                    }
                    if (joinOnExpr != null) {
                        this.processingOnClause = true;
                        joinOnExpr.evaluate((ExpressionEvaluator)this);
                        joinOnSqlExpr = (BooleanExpression)this.stack.pop();
                        this.processingOnClause = false;
                        join = this.stmt.getJoinForTable(sqlTbl);
                        join.addAndCondition(joinOnSqlExpr);
                    }
                    break block119;
                }
                previousMapping = null;
            }
            rightExpr = rightExpr.getRight();
        }
    }

    private Object[] getDiscriminatorValuesForCastClass(AbstractClassMetaData cmd) {
        Collection castSubclassNames = this.storeMgr.getSubClassesForClass(cmd.getFullClassName(), true, this.clr);
        Object[] castDiscrimValues = new Object[1 + (castSubclassNames != null ? castSubclassNames.size() : 0)];
        int discNo = 0;
        castDiscrimValues[discNo++] = cmd.getDiscriminatorValue();
        if (castSubclassNames != null && !castSubclassNames.isEmpty()) {
            for (String castSubClassName : castSubclassNames) {
                AbstractClassMetaData castSubCmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(castSubClassName, this.clr);
                castDiscrimValues[discNo++] = castSubCmd.getDiscriminatorValue();
            }
        }
        return castDiscrimValues;
    }

    @Override
    public boolean processingOnClause() {
        return this.processingOnClause;
    }

    protected void processFromClauseSubquery(ClassExpression clsExpr, SQLTable candSqlTbl, MetaDataManager mmgr) {
        String[] tokens = StringUtils.split((String)clsExpr.getCandidateExpression(), (String)".");
        String leftAlias = tokens[0];
        SQLTableMapping outerSqlTblMapping = this.parentMapper.getSQLTableMappingForAlias(leftAlias);
        AbstractClassMetaData leftCmd = outerSqlTblMapping.cmd;
        AbstractMemberMetaData[] leftMmds = new AbstractMemberMetaData[tokens.length - 1];
        AbstractMemberMetaData[] rightMmds = new AbstractMemberMetaData[tokens.length - 1];
        for (int i = 0; i < tokens.length - 1; ++i) {
            String joinedField = tokens[i + 1];
            AbstractMemberMetaData leftMmd = leftCmd.getMetaDataForMember(joinedField);
            AbstractMemberMetaData rightMmd = null;
            AbstractClassMetaData rightCmd = null;
            RelationType relationType = leftMmd.getRelationType(this.clr);
            if (RelationType.isBidirectional((RelationType)relationType)) {
                rightMmd = leftMmd.getRelatedMemberMetaData(this.clr)[0];
                rightCmd = rightMmd.getAbstractClassMetaData();
            } else if (relationType == RelationType.ONE_TO_ONE_UNI) {
                rightCmd = mmgr.getMetaDataForClass(leftMmd.getType(), this.clr);
            } else if (relationType == RelationType.ONE_TO_MANY_UNI) {
                if (leftMmd.hasCollection()) {
                    rightCmd = mmgr.getMetaDataForClass(leftMmd.getCollection().getElementType(), this.clr);
                } else if (leftMmd.hasMap()) {
                    rightCmd = mmgr.getMetaDataForClass(leftMmd.getMap().getValueType(), this.clr);
                }
            } else {
                throw new NucleusUserException("Subquery has been specified with a candidate-expression that includes \"" + tokens[i] + "\" that isnt a relation field!!");
            }
            leftMmds[i] = leftMmd;
            rightMmds[i] = rightMmd;
            leftCmd = rightCmd;
        }
        SQLTable rSqlTbl = candSqlTbl;
        SQLTable outerSqlTbl = outerSqlTblMapping.table;
        SQLJoin.JoinType joinType = SQLJoin.JoinType.INNER_JOIN;
        for (int i = leftMmds.length - 1; i >= 0; --i) {
            SQLExpression joinExpr;
            SQLExpression outerExpr;
            SQLTable joinSqlTbl;
            JoinTable joinTbl;
            SQLExpression rightExpr;
            SQLExpression outerExpr2;
            AbstractMemberMetaData leftMmd = leftMmds[i];
            AbstractMemberMetaData rightMmd = rightMmds[i];
            DatastoreClass leftTbl = this.storeMgr.getDatastoreClass(leftMmd.getClassName(true), this.clr);
            SQLTable lSqlTbl = null;
            RelationType relationType = leftMmd.getRelationType(this.clr);
            if (relationType == RelationType.ONE_TO_ONE_UNI) {
                if (i == 0) {
                    outerExpr2 = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getMemberMapping(leftMmd));
                    rightExpr = this.exprFactory.newExpression(this.stmt, rSqlTbl, rSqlTbl.getTable().getIdMapping());
                    this.stmt.whereAnd(outerExpr2.eq(rightExpr), false);
                } else {
                    JavaTypeMapping leftMapping = leftTbl.getMemberMapping(leftMmd);
                    lSqlTbl = this.stmt.join(joinType, rSqlTbl, rSqlTbl.getTable().getIdMapping(), leftTbl, null, leftMapping, null, null, true);
                }
            } else if (relationType == RelationType.ONE_TO_ONE_BI) {
                if (leftMmd.getMappedBy() != null) {
                    JavaTypeMapping rightMapping = rSqlTbl.getTable().getMemberMapping(rightMmd);
                    if (i == 0) {
                        SQLExpression outerExpr3 = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getIdMapping());
                        SQLExpression rightExpr2 = this.exprFactory.newExpression(this.stmt, rSqlTbl, rightMapping);
                        this.stmt.whereAnd(outerExpr3.eq(rightExpr2), false);
                    } else {
                        lSqlTbl = this.stmt.join(joinType, rSqlTbl, rightMapping, leftTbl, null, leftTbl.getIdMapping(), null, null, true);
                    }
                } else if (i == 0) {
                    outerExpr2 = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getMemberMapping(leftMmd));
                    rightExpr = this.exprFactory.newExpression(this.stmt, rSqlTbl, rSqlTbl.getTable().getIdMapping());
                    this.stmt.whereAnd(outerExpr2.eq(rightExpr), false);
                } else {
                    lSqlTbl = this.stmt.join(joinType, rSqlTbl, rSqlTbl.getTable().getIdMapping(), leftTbl, null, leftTbl.getMemberMapping(leftMmd), null, null, true);
                }
            } else if (relationType == RelationType.ONE_TO_MANY_UNI) {
                if (leftMmd.getJoinMetaData() != null || rightMmd.getJoinMetaData() != null) {
                    joinTbl = (JoinTable)this.storeMgr.getTable(leftMmd);
                    joinSqlTbl = null;
                    if (leftMmd.hasCollection()) {
                        joinSqlTbl = this.stmt.join(joinType, rSqlTbl, rSqlTbl.getTable().getIdMapping(), joinTbl, null, ((ElementContainerTable)joinTbl).getElementMapping(), null, null, true);
                    } else if (leftMmd.hasMap()) {
                        joinSqlTbl = this.stmt.join(joinType, rSqlTbl, rSqlTbl.getTable().getIdMapping(), joinTbl, null, ((MapTable)joinTbl).getValueMapping(), null, null, true);
                    }
                    if (i == 0) {
                        outerExpr = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getIdMapping());
                        joinExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getOwnerMapping());
                        this.stmt.whereAnd(outerExpr.eq(joinExpr), false);
                    } else {
                        lSqlTbl = this.stmt.join(joinType, joinSqlTbl, joinTbl.getOwnerMapping(), leftTbl, null, leftTbl.getIdMapping(), null, null, true);
                    }
                } else if (i == 0) {
                    outerExpr2 = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getMemberMapping(leftMmd));
                    rightExpr = this.exprFactory.newExpression(this.stmt, rSqlTbl, rSqlTbl.getTable().getMemberMapping(rightMmd));
                    this.stmt.whereAnd(outerExpr2.eq(rightExpr), false);
                } else {
                    lSqlTbl = this.stmt.join(joinType, rSqlTbl, rSqlTbl.getTable().getMemberMapping(rightMmd), leftTbl, null, leftTbl.getIdMapping(), null, null, true);
                }
            } else if (relationType == RelationType.ONE_TO_MANY_BI) {
                if (leftMmd.getJoinMetaData() != null || rightMmd.getJoinMetaData() != null) {
                    joinTbl = (JoinTable)this.storeMgr.getTable(leftMmd);
                    joinSqlTbl = null;
                    if (leftMmd.hasCollection()) {
                        joinSqlTbl = this.stmt.join(joinType, rSqlTbl, rSqlTbl.getTable().getIdMapping(), joinTbl, null, ((ElementContainerTable)joinTbl).getElementMapping(), null, null, true);
                    } else if (leftMmd.hasMap()) {
                        joinSqlTbl = this.stmt.join(joinType, rSqlTbl, rSqlTbl.getTable().getIdMapping(), joinTbl, null, ((MapTable)joinTbl).getValueMapping(), null, null, true);
                    }
                    if (i == 0) {
                        outerExpr = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getIdMapping());
                        joinExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getOwnerMapping());
                        this.stmt.whereAnd(outerExpr.eq(joinExpr), false);
                    } else {
                        lSqlTbl = this.stmt.join(joinType, joinSqlTbl, joinTbl.getOwnerMapping(), leftTbl, null, leftTbl.getIdMapping(), null, null, true);
                    }
                } else if (i == 0) {
                    outerExpr2 = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getIdMapping());
                    rightExpr = this.exprFactory.newExpression(this.stmt, rSqlTbl, rSqlTbl.getTable().getMemberMapping(rightMmd));
                    this.stmt.whereAnd(outerExpr2.eq(rightExpr), false);
                } else {
                    lSqlTbl = this.stmt.join(joinType, rSqlTbl, rSqlTbl.getTable().getMemberMapping(rightMmd), leftTbl, null, leftTbl.getIdMapping(), null, null, true);
                }
            } else if (relationType == RelationType.MANY_TO_ONE_BI) {
                if (leftMmd.getJoinMetaData() != null || rightMmd.getJoinMetaData() != null) {
                    joinTbl = (JoinTable)this.storeMgr.getTable(leftMmd);
                    joinSqlTbl = this.stmt.join(joinType, rSqlTbl, rSqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null, true);
                    if (leftMmd.hasCollection()) {
                        if (i == 0) {
                            outerExpr = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getIdMapping());
                            joinExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, ((ElementContainerTable)joinTbl).getElementMapping());
                            this.stmt.whereAnd(outerExpr.eq(joinExpr), false);
                        } else {
                            lSqlTbl = this.stmt.join(joinType, joinSqlTbl, ((ElementContainerTable)joinTbl).getElementMapping(), leftTbl, null, leftTbl.getIdMapping(), null, null, true);
                        }
                    } else if (leftMmd.hasMap()) {
                        if (i == 0) {
                            outerExpr = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getIdMapping());
                            joinExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, ((MapTable)joinTbl).getValueMapping());
                            this.stmt.whereAnd(outerExpr.eq(joinExpr), false);
                        } else {
                            lSqlTbl = this.stmt.join(joinType, joinSqlTbl, ((MapTable)joinTbl).getValueMapping(), leftTbl, null, leftTbl.getIdMapping(), null, null, true);
                        }
                    }
                } else if (i == 0) {
                    outerExpr2 = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getMemberMapping(leftMmd));
                    rightExpr = this.exprFactory.newExpression(this.stmt, rSqlTbl, rSqlTbl.getTable().getIdMapping());
                    this.stmt.whereAnd(outerExpr2.eq(rightExpr), false);
                } else {
                    lSqlTbl = this.stmt.join(joinType, rSqlTbl, rSqlTbl.getTable().getIdMapping(), leftTbl, null, leftTbl.getMemberMapping(leftMmd), null, null, true);
                }
            }
            rSqlTbl = lSqlTbl;
        }
    }

    protected StatementNewObjectMapping getStatementMappingForNewObjectExpression(NewObjectExpression expr, SelectStatement stmt) {
        List<SQLExpression> argExprs = expr.getConstructorArgExpressions();
        StatementNewObjectMapping stmtMap = new StatementNewObjectMapping(expr.getNewClass());
        if (argExprs != null) {
            Iterator<SQLExpression> argIter = argExprs.iterator();
            int j = 0;
            while (argIter.hasNext()) {
                SQLExpression argExpr = argIter.next();
                if (argExpr instanceof SQLLiteral) {
                    stmtMap.addConstructorArgMapping(j, ((SQLLiteral)((Object)argExpr)).getValue());
                } else if (argExpr instanceof NewObjectExpression) {
                    stmtMap.addConstructorArgMapping(j, this.getStatementMappingForNewObjectExpression((NewObjectExpression)argExpr, stmt));
                } else {
                    StatementMappingIndex idx = new StatementMappingIndex(argExpr.getJavaTypeMapping());
                    int[] cols = stmt.select(argExpr, null);
                    idx.setColumnPositions(cols);
                    stmtMap.addConstructorArgMapping(j, idx);
                }
                ++j;
            }
        }
        return stmtMap;
    }

    protected Object processAndExpression(Expression expr) {
        SQLExpression rightExpr = this.stack.pop();
        SQLExpression leftExpr = this.stack.pop();
        if (!(rightExpr instanceof BooleanExpression)) {
            throw new NucleusUserException("Query has clause " + rightExpr + " used with AND. This is illegal, and should be a boolean expression");
        }
        if (!(leftExpr instanceof BooleanExpression)) {
            throw new NucleusUserException("Query has clause " + leftExpr + " used with AND. This is illegal, and should be a boolean expression");
        }
        BooleanExpression right = (BooleanExpression)rightExpr;
        BooleanExpression left = (BooleanExpression)leftExpr;
        if (left.getSQLStatement() != null && right.getSQLStatement() != null && left.getSQLStatement() != right.getSQLStatement()) {
            if (left.getSQLStatement() == this.stmt && right.getSQLStatement().isChildStatementOf(this.stmt)) {
                right.getSQLStatement().whereAnd(right, true);
                this.stack.push(left);
                return left;
            }
            if (right.getSQLStatement() == this.stmt && left.getSQLStatement().isChildStatementOf(this.stmt)) {
                left.getSQLStatement().whereAnd(left, true);
                this.stack.push(right);
                return right;
            }
        }
        if (this.compileComponent == CompilationComponent.FILTER) {
            left = this.getBooleanExpressionForUseInFilter(left);
            right = this.getBooleanExpressionForUseInFilter(right);
        }
        BooleanExpression opExpr = left.and(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processOrExpression(Expression expr) {
        SQLExpression rightExpr = this.stack.pop();
        SQLExpression leftExpr = this.stack.pop();
        if (!(rightExpr instanceof BooleanExpression)) {
            throw new NucleusUserException("Query has clause " + rightExpr + " used with AND. This is illegal, and should be a boolean expression");
        }
        if (!(leftExpr instanceof BooleanExpression)) {
            throw new NucleusUserException("Query has clause " + leftExpr + " used with AND. This is illegal, and should be a boolean expression");
        }
        BooleanExpression right = (BooleanExpression)rightExpr;
        BooleanExpression left = (BooleanExpression)leftExpr;
        if (left.getSQLStatement() != null && right.getSQLStatement() != null && left.getSQLStatement() != right.getSQLStatement()) {
            if (left.getSQLStatement() == this.stmt && right.getSQLStatement().isChildStatementOf(this.stmt)) {
                right.getSQLStatement().whereAnd(right, true);
                this.stack.push(left);
                return left;
            }
            if (right.getSQLStatement() == this.stmt && left.getSQLStatement().isChildStatementOf(this.stmt)) {
                left.getSQLStatement().whereAnd(left, true);
                this.stack.push(right);
                return right;
            }
        }
        if (this.compileComponent == CompilationComponent.FILTER) {
            left = this.getBooleanExpressionForUseInFilter(left);
            right = this.getBooleanExpressionForUseInFilter(right);
        }
        left.encloseInParentheses();
        right.encloseInParentheses();
        BooleanExpression opExpr = left.ior(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processBitAndExpression(Expression expr) {
        SQLExpression rightExpr = this.stack.pop();
        SQLExpression leftExpr = this.stack.pop();
        if (rightExpr instanceof BooleanExpression && leftExpr instanceof BooleanExpression) {
            this.stack.push(leftExpr);
            this.stack.push(rightExpr);
            return this.processAndExpression(expr);
        }
        if (rightExpr instanceof NumericExpression && leftExpr instanceof NumericExpression && this.storeMgr.getDatastoreAdapter().supportsOption("BitwiseAndOperator")) {
            SQLExpression bitAndExpr = new NumericExpression(leftExpr, Expression.OP_BIT_AND, rightExpr).encloseInParentheses();
            this.stack.push(bitAndExpr);
            return bitAndExpr;
        }
        throw new NucleusUserException("Operation BITWISE AND is not supported for " + leftExpr + " and " + rightExpr + " for this datastore");
    }

    protected Object processBitOrExpression(Expression expr) {
        SQLExpression rightExpr = this.stack.pop();
        SQLExpression leftExpr = this.stack.pop();
        if (rightExpr instanceof BooleanExpression && leftExpr instanceof BooleanExpression) {
            this.stack.push(leftExpr);
            this.stack.push(rightExpr);
            return this.processOrExpression(expr);
        }
        if (rightExpr instanceof NumericExpression && leftExpr instanceof NumericExpression && this.storeMgr.getDatastoreAdapter().supportsOption("BitwiseOrOperator")) {
            SQLExpression bitExpr = new NumericExpression(leftExpr, Expression.OP_BIT_OR, rightExpr).encloseInParentheses();
            this.stack.push(bitExpr);
            return bitExpr;
        }
        throw new NucleusUserException("Operation BITWISE OR is not supported for " + leftExpr + " and " + rightExpr + " is not supported by this datastore");
    }

    protected Object processBitXorExpression(Expression expr) {
        SQLExpression rightExpr = this.stack.pop();
        SQLExpression leftExpr = this.stack.pop();
        if (rightExpr instanceof BooleanExpression && leftExpr instanceof BooleanExpression) {
            this.stack.push(leftExpr);
            this.stack.push(rightExpr);
            return this.processOrExpression(expr);
        }
        if (rightExpr instanceof NumericExpression && leftExpr instanceof NumericExpression && this.storeMgr.getDatastoreAdapter().supportsOption("BitwiseXOrOperator")) {
            SQLExpression bitExpr = new NumericExpression(leftExpr, Expression.OP_BIT_XOR, rightExpr).encloseInParentheses();
            this.stack.push(bitExpr);
            return bitExpr;
        }
        throw new NucleusUserException("Operation BITWISE XOR is not supported for " + leftExpr + " and " + rightExpr + " is not supported by this datastore");
    }

    protected Object processEqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        if (left.isParameter() && right.isParameter()) {
            if (left.isParameter() && left instanceof SQLLiteral && ((SQLLiteral)((Object)left)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)left));
            }
            if (right.isParameter() && right instanceof SQLLiteral && ((SQLLiteral)((Object)right)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)right));
            }
        }
        ExpressionUtils.checkAndCorrectExpressionMappingsForBooleanComparison(left, right);
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        if (!this.options.contains(OPTION_EXPLICIT_JOINS)) {
            String varName;
            SQLJoin.JoinType joinType;
            boolean rightIsCrossJoin;
            boolean leftIsCrossJoin = this.stmt.getJoinTypeForTable(left.getSQLTable()) == SQLJoin.JoinType.CROSS_JOIN;
            boolean bl = rightIsCrossJoin = this.stmt.getJoinTypeForTable(right.getSQLTable()) == SQLJoin.JoinType.CROSS_JOIN;
            if (leftIsCrossJoin && !rightIsCrossJoin && !(right instanceof SQLLiteral)) {
                String varName2 = this.getAliasForSQLTable(left.getSQLTable());
                SQLJoin.JoinType joinType2 = this.getRequiredJoinTypeForAlias(varName2);
                if (joinType2 != null) {
                    NucleusLogger.QUERY.debug((Object)("QueryToSQL.eq variable " + varName2 + " is mapped to table " + left.getSQLTable() + " was previously bound as CROSS JOIN but changing to " + (Object)((Object)joinType2)));
                    String leftTblAlias = this.stmt.removeCrossJoin(left.getSQLTable());
                    if (joinType2 == SQLJoin.JoinType.LEFT_OUTER_JOIN) {
                        this.stmt.join(SQLJoin.JoinType.LEFT_OUTER_JOIN, right.getSQLTable(), right.getJavaTypeMapping(), left.getSQLTable().getTable(), leftTblAlias, left.getJavaTypeMapping(), null, left.getSQLTable().getGroupName(), true);
                    } else {
                        this.stmt.join(SQLJoin.JoinType.INNER_JOIN, right.getSQLTable(), right.getJavaTypeMapping(), left.getSQLTable().getTable(), leftTblAlias, left.getJavaTypeMapping(), null, left.getSQLTable().getGroupName(), true);
                    }
                    JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
                    BooleanExpression opExpr = this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, true));
                    this.stack.push(opExpr);
                    return opExpr;
                }
            } else if (!leftIsCrossJoin && rightIsCrossJoin && !(left instanceof SQLLiteral) && (joinType = this.getRequiredJoinTypeForAlias(varName = this.getAliasForSQLTable(right.getSQLTable()))) != null) {
                NucleusLogger.QUERY.debug((Object)("QueryToSQL.eq variable " + varName + " is mapped to table " + right.getSQLTable() + " was previously bound as CROSS JOIN but changing to " + (Object)((Object)joinType)));
                String rightTblAlias = this.stmt.removeCrossJoin(right.getSQLTable());
                if (joinType == SQLJoin.JoinType.LEFT_OUTER_JOIN) {
                    this.stmt.join(SQLJoin.JoinType.LEFT_OUTER_JOIN, left.getSQLTable(), left.getJavaTypeMapping(), right.getSQLTable().getTable(), rightTblAlias, right.getJavaTypeMapping(), null, right.getSQLTable().getGroupName(), true);
                } else {
                    this.stmt.join(SQLJoin.JoinType.INNER_JOIN, left.getSQLTable(), left.getJavaTypeMapping(), right.getSQLTable().getTable(), rightTblAlias, right.getJavaTypeMapping(), null, right.getSQLTable().getGroupName(), true);
                }
                JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
                BooleanExpression opExpr = this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, true));
                this.stack.push(opExpr);
                return opExpr;
            }
        }
        BooleanExpression opExpr = left.eq(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processNoteqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        if (left.isParameter() && right.isParameter()) {
            if (left.isParameter() && left instanceof SQLLiteral && ((SQLLiteral)((Object)left)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)left));
            }
            if (right.isParameter() && right instanceof SQLLiteral && ((SQLLiteral)((Object)right)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)right));
            }
        }
        ExpressionUtils.checkAndCorrectExpressionMappingsForBooleanComparison(left, right);
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.ne(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processGteqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        ExpressionUtils.checkAndCorrectExpressionMappingsForBooleanComparison(left, right);
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.ge(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processGtExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        ExpressionUtils.checkAndCorrectExpressionMappingsForBooleanComparison(left, right);
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.gt(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processLteqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        ExpressionUtils.checkAndCorrectExpressionMappingsForBooleanComparison(left, right);
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.le(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processLtExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        ExpressionUtils.checkAndCorrectExpressionMappingsForBooleanComparison(left, right);
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.lt(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processLiteral(Literal expr) {
        SQLExpression sqlExpr = this.getSQLLiteralForLiteralValue(expr.getLiteral());
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected SQLExpression getSQLLiteralForLiteralValue(Object litValue) {
        String litStr;
        if (litValue instanceof Class) {
            litValue = ((Class)litValue).getName();
        } else if (litValue instanceof String && ((litStr = (String)litValue).startsWith("{d ") || litStr.startsWith("{t ") || litStr.startsWith("{ts "))) {
            JavaTypeMapping m = this.exprFactory.getMappingForType(Date.class, false);
            return this.exprFactory.newLiteral(this.stmt, m, litValue);
        }
        JavaTypeMapping m = litValue != null ? this.exprFactory.getMappingForType(litValue.getClass(), false) : null;
        return this.exprFactory.newLiteral(this.stmt, m, litValue);
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        SQLExpression sqlExpr = null;
        if (expr.getLeft() != null) {
            if (expr.getLeft() instanceof DyadicExpression && expr.getLeft().getOperator() == Expression.OP_CAST) {
                String exprCastName = null;
                if (expr.getLeft().getLeft() instanceof PrimaryExpression) {
                    exprCastName = "CAST_" + ((PrimaryExpression)expr.getLeft().getLeft()).getId();
                } else if (expr.getLeft().getLeft() instanceof VariableExpression) {
                    exprCastName = "CAST_" + ((VariableExpression)expr.getLeft().getLeft()).getId();
                } else if (expr.getLeft().getLeft() instanceof InvokeExpression) {
                    exprCastName = "CAST_" + expr.getLeft().getLeft();
                } else {
                    throw new NucleusException("Don't currently support cast of " + expr.getLeft().getLeft());
                }
                expr.getLeft().getLeft().evaluate((ExpressionEvaluator)this);
                sqlExpr = this.stack.pop();
                JavaTypeMapping mapping = sqlExpr.getJavaTypeMapping();
                if (mapping instanceof EmbeddedMapping) {
                    Literal castLitExpr = (Literal)expr.getLeft().getRight();
                    Class castType = this.resolveClass((String)castLitExpr.getLiteral());
                    AbstractClassMetaData castCmd = this.ec.getMetaDataManager().getMetaDataForClass(castType, this.clr);
                    JavaTypeMapping discMapping = ((EmbeddedMapping)mapping).getDiscriminatorMapping();
                    if (discMapping != null) {
                        SQLExpression discExpr = this.exprFactory.newExpression(this.stmt, sqlExpr.getSQLTable(), discMapping);
                        Object discVal = castCmd.getDiscriminatorValue();
                        SQLExpression discValExpr = this.exprFactory.newLiteral(this.stmt, discMapping, discVal);
                        BooleanExpression discRestrictExpr = discExpr.eq(discValExpr);
                        for (String subclassName : this.storeMgr.getSubClassesForClass(castType.getName(), true, this.clr)) {
                            AbstractClassMetaData subtypeCmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(subclassName, this.clr);
                            discVal = subtypeCmd.getDiscriminatorValue();
                            discValExpr = this.exprFactory.newLiteral(this.stmt, discMapping, discVal);
                            BooleanExpression subtypeExpr = discExpr.eq(discValExpr);
                            discRestrictExpr = discRestrictExpr.ior(subtypeExpr);
                        }
                        this.stmt.whereAnd(discRestrictExpr, true);
                    }
                    SQLTableMapping tblMapping = new SQLTableMapping(sqlExpr.getSQLTable(), castCmd, sqlExpr.getJavaTypeMapping());
                    this.setSQLTableMappingForAlias(exprCastName, tblMapping);
                    SQLTableMapping sqlMapping = this.getSQLTableMappingForPrimaryExpression(this.stmt, exprCastName, expr, Boolean.FALSE);
                    if (sqlMapping == null) {
                        throw new NucleusException("PrimaryExpression " + expr + " is not yet supported");
                    }
                    sqlExpr = this.exprFactory.newExpression(this.stmt, sqlMapping.table, sqlMapping.mapping);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                expr.getLeft().evaluate((ExpressionEvaluator)this);
                sqlExpr = this.stack.pop();
                Literal castLitExpr = (Literal)expr.getLeft().getRight();
                AbstractClassMetaData castCmd = this.ec.getMetaDataManager().getMetaDataForClass(this.resolveClass((String)castLitExpr.getLiteral()), this.clr);
                SQLTableMapping tblMapping = new SQLTableMapping(sqlExpr.getSQLTable(), castCmd, sqlExpr.getJavaTypeMapping());
                this.setSQLTableMappingForAlias(exprCastName, tblMapping);
                SQLTableMapping sqlMapping = this.getSQLTableMappingForPrimaryExpression(this.stmt, exprCastName, expr, Boolean.FALSE);
                if (sqlMapping == null) {
                    throw new NucleusException("PrimaryExpression " + expr + " is not yet supported");
                }
                sqlExpr = this.exprFactory.newExpression(this.stmt, sqlMapping.table, sqlMapping.mapping);
                this.stack.push(sqlExpr);
                return sqlExpr;
            }
            if (expr.getLeft() instanceof ParameterExpression) {
                this.setNotPrecompilable();
                ParameterExpression paramExpr = (ParameterExpression)expr.getLeft();
                Symbol paramSym = this.compilation.getSymbolTable().getSymbol(paramExpr.getId());
                if (paramSym.getValueType() != null && paramSym.getValueType().isArray()) {
                    String first = (String)expr.getTuples().get(0);
                    this.processParameterExpression(paramExpr, true);
                    SQLExpression paramSqlExpr = this.stack.pop();
                    sqlExpr = this.exprFactory.invokeMethod(this.stmt, "ARRAY", first, paramSqlExpr, null);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                this.processParameterExpression(paramExpr, true);
                SQLExpression paramSqlExpr = this.stack.pop();
                SQLLiteral lit = (SQLLiteral)((Object)paramSqlExpr);
                Object paramValue = lit.getValue();
                List tuples = expr.getTuples();
                Iterator tuplesIter = tuples.iterator();
                Object objValue = paramValue;
                while (tuplesIter.hasNext()) {
                    String fieldName = (String)tuplesIter.next();
                    if (objValue == null) {
                        NucleusLogger.QUERY.warn((Object)(">> Compilation of " + expr + " : need to direct through field \"" + fieldName + "\" on null value, hence not compilable!"));
                        break;
                    }
                    objValue = this.getValueForObjectField(objValue, fieldName);
                    this.setNotPrecompilable();
                }
                if (objValue == null) {
                    sqlExpr = this.exprFactory.newLiteral(this.stmt, null, null);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                JavaTypeMapping m = this.exprFactory.getMappingForType(objValue.getClass(), false);
                sqlExpr = this.exprFactory.newLiteral(this.stmt, m, objValue);
                this.stack.push(sqlExpr);
                return sqlExpr;
            }
            if (expr.getLeft() instanceof VariableExpression) {
                VariableExpression varExpr = (VariableExpression)expr.getLeft();
                this.processVariableExpression(varExpr);
                SQLExpression varSqlExpr = this.stack.pop();
                if (varSqlExpr instanceof UnboundExpression) {
                    this.processUnboundExpression((UnboundExpression)varSqlExpr);
                    varSqlExpr = this.stack.pop();
                }
                Class varType = this.clr.classForName(varSqlExpr.getJavaTypeMapping().getType());
                if (varSqlExpr.getSQLStatement() == this.stmt.getParentStatement()) {
                    SQLTableMapping sqlMapping = this.parentMapper.getSQLTableMappingForPrimaryExpression(this.stmt, null, expr, Boolean.FALSE);
                    if (sqlMapping == null) {
                        throw new NucleusException("PrimaryExpression " + expr.getId() + " is not yet supported");
                    }
                    sqlExpr = this.exprFactory.newExpression(varSqlExpr.getSQLStatement(), sqlMapping.table, sqlMapping.mapping);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                SQLTableMapping varTblMapping = this.getSQLTableMappingForAlias(varExpr.getId());
                if (varTblMapping == null) {
                    throw new NucleusUserException("Variable " + varExpr.getId() + " is not yet bound, so cannot get field " + expr.getId());
                }
                if (varTblMapping.cmd == null) {
                    throw new NucleusUserException("Variable " + varExpr.getId() + " of type " + varType.getName() + " cannot evaluate " + expr.getId());
                }
                SQLTableMapping sqlMapping = this.getSQLTableMappingForPrimaryExpression(varSqlExpr.getSQLStatement(), varExpr.getId(), expr, Boolean.FALSE);
                sqlExpr = this.exprFactory.newExpression(sqlMapping.table.getSQLStatement(), sqlMapping.table, sqlMapping.mapping);
                this.stack.push(sqlExpr);
                return sqlExpr;
            }
            if (expr.getLeft() instanceof InvokeExpression) {
                OptionalMapping opMapping;
                InvokeExpression invokeExpr = (InvokeExpression)expr.getLeft();
                SQLExpression invokedSqlExpr = this.getInvokedSqlExpressionForInvokeExpression(invokeExpr);
                this.processInvokeExpression(invokeExpr, invokedSqlExpr);
                SQLExpression invokeSqlExpr = this.stack.pop();
                Table tbl = invokeSqlExpr.getSQLTable().getTable();
                if (expr.getTuples().size() > 1) {
                    throw new NucleusUserException("Dont currently support evaluating " + expr.getId() + " on " + invokeSqlExpr);
                }
                SQLTable invokeSqlTbl = invokeSqlExpr.getSQLTable();
                if (invokedSqlExpr.getJavaTypeMapping() instanceof OptionalMapping && invokeExpr.getOperation().equals("get") && expr.getTuples().size() == 1 && (opMapping = (OptionalMapping)invokedSqlExpr.getJavaTypeMapping()).getWrappedMapping() instanceof PersistableMapping) {
                    AbstractMemberMetaData mmd = invokedSqlExpr.getJavaTypeMapping().getMemberMetaData();
                    AbstractClassMetaData otherCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getCollection().getElementType(), this.clr);
                    DatastoreClass otherTbl = this.storeMgr.getDatastoreClass(otherCmd.getFullClassName(), this.clr);
                    invokeSqlTbl = this.stmt.join(SQLJoin.JoinType.LEFT_OUTER_JOIN, invokeSqlExpr.getSQLTable(), opMapping.getWrappedMapping(), otherTbl, null, otherTbl.getIdMapping(), null, null, true);
                    tbl = invokeSqlTbl.getTable();
                }
                if (tbl instanceof DatastoreClass) {
                    JavaTypeMapping mapping = ((DatastoreClass)tbl).getMemberMapping(expr.getId());
                    if (mapping == null) {
                        throw new NucleusUserException("Dont currently support evaluating " + expr.getId() + " on " + invokeSqlExpr + ". The field " + expr.getId() + " doesnt exist in table " + tbl);
                    }
                    sqlExpr = this.exprFactory.newExpression(this.stmt, invokeSqlTbl, mapping);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                if (tbl instanceof JoinTable && invokeSqlExpr.getJavaTypeMapping() instanceof EmbeddedMapping) {
                    EmbeddedMapping embMapping = (EmbeddedMapping)invokeSqlExpr.getJavaTypeMapping();
                    JavaTypeMapping mapping = embMapping.getJavaTypeMapping(expr.getId());
                    if (mapping == null) {
                        throw new NucleusUserException("Dont currently support evaluating " + expr.getId() + " on " + invokeSqlExpr + ". The field " + expr.getId() + " doesnt exist in table " + tbl);
                    }
                    sqlExpr = this.exprFactory.newExpression(this.stmt, invokeSqlTbl, mapping);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                throw new NucleusUserException("Dont currently support evaluating " + expr.getId() + " on " + invokeSqlExpr + " with invoke having table of " + tbl);
            }
            throw new NucleusUserException("Dont currently support PrimaryExpression with 'left' of " + expr.getLeft());
        }
        SQLTableMapping sqlMapping = this.getSQLTableMappingForPrimaryExpression(this.stmt, null, expr, null);
        if (sqlMapping == null) {
            throw new NucleusException("PrimaryExpression " + expr.getId() + " is not yet supported");
        }
        sqlExpr = this.exprFactory.newExpression(this.stmt, sqlMapping.table, sqlMapping.mapping);
        if (sqlMapping.mmd != null && sqlExpr instanceof MapExpression) {
            String alias = this.getAliasForSQLTableMapping(sqlMapping);
            if (alias == null && this.parentMapper != null) {
                alias = this.parentMapper.getAliasForSQLTableMapping(sqlMapping);
            }
            ((MapExpression)sqlExpr).setAliasForMapTable(alias);
        }
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    private SQLTableMapping getSQLTableMappingForPrimaryExpression(SQLStatement theStmt, String exprName, PrimaryExpression primExpr, Boolean forceJoin) {
        if (forceJoin == null && primExpr.getParent() != null && (primExpr.getParent().getOperator() == Expression.OP_IS || primExpr.getParent().getOperator() == Expression.OP_ISNOT)) {
            forceJoin = Boolean.TRUE;
        }
        SQLTableMapping sqlMapping = null;
        List tuples = primExpr.getTuples();
        ListIterator iter = tuples.listIterator();
        String first = (String)tuples.get(0);
        boolean mapKey = false;
        boolean mapValue = false;
        if (first.endsWith("#KEY")) {
            first = first.substring(0, first.length() - 4);
            mapKey = true;
        } else if (first.endsWith("#VALUE")) {
            first = first.substring(0, first.length() - 6);
            mapValue = true;
        }
        String primaryName = null;
        if (exprName != null) {
            sqlMapping = this.getSQLTableMappingForAlias(exprName);
            primaryName = exprName;
        } else {
            SQLTable firstSqlTbl;
            if (this.hasSQLTableMappingForAlias(first)) {
                sqlMapping = this.getSQLTableMappingForAlias(first);
                primaryName = first;
                iter.next();
            }
            if (sqlMapping != null && first.equals(this.candidateAlias) && this.candidateCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE && (firstSqlTbl = this.stmt.getTable(first.toUpperCase())) != null && firstSqlTbl.getTable() != sqlMapping.table.getTable()) {
                sqlMapping = new SQLTableMapping(firstSqlTbl, sqlMapping.cmd, firstSqlTbl.getTable().getIdMapping());
            }
            if (sqlMapping == null && this.parentMapper != null) {
                QueryToSQLMapper theParentMapper = this.parentMapper;
                while (theParentMapper != null) {
                    if (theParentMapper.hasSQLTableMappingForAlias(first)) {
                        sqlMapping = theParentMapper.getSQLTableMappingForAlias(first);
                        primaryName = first;
                        iter.next();
                        theStmt = sqlMapping.table.getSQLStatement();
                        break;
                    }
                    theParentMapper = theParentMapper.parentMapper;
                }
            }
            if (sqlMapping == null) {
                sqlMapping = this.getSQLTableMappingForAlias(this.candidateAlias);
                primaryName = this.candidateAlias;
            }
        }
        AbstractClassMetaData cmd = sqlMapping.cmd;
        JavaTypeMapping mapping = sqlMapping.mapping;
        if (sqlMapping.mmd != null && (mapKey || mapValue)) {
            SQLTable sqlTbl = sqlMapping.table;
            AbstractMemberMetaData mmd = sqlMapping.mmd;
            MapMetaData mapmd = mmd.getMap();
            if (mapKey) {
                SQLTable mapSqlTbl = this.stmt.getTable(first + "_MAP");
                if (mapSqlTbl == null && (mapSqlTbl = this.stmt.getTable((first + "_MAP").toUpperCase())) == null) {
                    mapSqlTbl = this.stmt.getTable((first + "_MAP").toLowerCase());
                }
                if (mapSqlTbl != null) {
                    sqlTbl = mapSqlTbl;
                }
            }
            if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
                if (sqlTbl.getTable() instanceof MapTable) {
                    MapTable mapTable = (MapTable)sqlTbl.getTable();
                    if (mapKey) {
                        cmd = mapmd.getKeyClassMetaData(this.clr);
                        if (!mapmd.isEmbeddedKey() && !mapmd.isSerializedKey()) {
                            DatastoreClass keyTable = this.storeMgr.getDatastoreClass(mapmd.getKeyType(), this.clr);
                            sqlTbl = this.stmt.join(this.getDefaultJoinTypeForNavigation(), sqlMapping.table, mapTable.getKeyMapping(), keyTable, null, keyTable.getIdMapping(), null, null, true);
                            mapping = keyTable.getIdMapping();
                        } else {
                            mapping = mapTable.getKeyMapping();
                        }
                    } else {
                        cmd = mapmd.getValueClassMetaData(this.clr);
                        if (!mapmd.isEmbeddedValue() && !mapmd.isSerializedValue()) {
                            DatastoreClass valueTable = this.storeMgr.getDatastoreClass(mapmd.getValueType(), this.clr);
                            sqlTbl = this.stmt.join(this.getDefaultJoinTypeForNavigation(), sqlMapping.table, mapTable.getValueMapping(), valueTable, null, valueTable.getIdMapping(), null, null, true);
                            mapping = valueTable.getIdMapping();
                        } else {
                            mapping = mapTable.getValueMapping();
                        }
                    }
                } else if (!mapmd.isEmbeddedValue() && !mapmd.isSerializedValue()) {
                    mapping = sqlTbl.getTable().getIdMapping();
                }
            } else if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
                if (mapKey) {
                    AbstractClassMetaData keyCmd = mapmd.getKeyClassMetaData(this.clr);
                    String keyMappedBy = mmd.getKeyMetaData().getMappedBy();
                    mapping = ((DatastoreClass)sqlTbl.getTable()).getMemberMapping(keyMappedBy);
                    if (keyCmd != null) {
                        DatastoreClass keyTable = this.storeMgr.getDatastoreClass(mapmd.getKeyType(), this.clr);
                        sqlTbl = this.stmt.join(this.getDefaultJoinTypeForNavigation(), sqlMapping.table, mapping, keyTable, null, keyTable.getIdMapping(), null, null, true);
                        mapping = keyTable.getIdMapping();
                    }
                }
            } else if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY && !mapKey) {
                AbstractClassMetaData valCmd = mapmd.getValueClassMetaData(this.clr);
                String valMappedBy = mmd.getValueMetaData().getMappedBy();
                mapping = ((DatastoreClass)sqlTbl.getTable()).getMemberMapping(valMappedBy);
                if (valCmd != null) {
                    DatastoreClass valueTable = this.storeMgr.getDatastoreClass(mapmd.getValueType(), this.clr);
                    sqlTbl = this.stmt.join(this.getDefaultJoinTypeForNavigation(), sqlMapping.table, mapping, valueTable, null, valueTable.getIdMapping(), null, null, true);
                    mapping = valueTable.getIdMapping();
                }
            }
            sqlMapping = new SQLTableMapping(sqlTbl, cmd, mapping);
        }
        while (iter.hasNext()) {
            String component = (String)iter.next();
            SQLTableMapping sqlMappingNew = this.getSQLTableMappingForAlias(primaryName = primaryName + "." + component);
            if (sqlMappingNew == null) {
                DatastoreClass relTable;
                AbstractMemberMetaData relMmd;
                AbstractMemberMetaData mmd = cmd.getMetaDataForMember(component);
                if (mmd == null) {
                    throw new NucleusUserException(Localiser.msg((String)"021062", (Object[])new Object[]{component, cmd.getFullClassName()}));
                }
                if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " is not marked as persistent so cannot be queried");
                }
                RelationType relationType = mmd.getRelationType(this.clr);
                SQLTable sqlTbl = null;
                if (mapping instanceof EmbeddedMapping) {
                    sqlTbl = sqlMapping.table;
                    mapping = ((EmbeddedMapping)mapping).getJavaTypeMapping(component);
                } else if (mapping instanceof PersistableMapping && cmd.isEmbeddedOnly()) {
                    sqlTbl = sqlMapping.table;
                    JavaTypeMapping[] subMappings = ((PersistableMapping)mapping).getJavaTypeMapping();
                    if (subMappings.length == 1 && subMappings[0] instanceof EmbeddedPCMapping) {
                        mapping = ((EmbeddedPCMapping)subMappings[0]).getJavaTypeMapping(component);
                    }
                } else {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(cmd.getFullClassName(), this.clr);
                    if (table == null && cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE && this.candidateCmd.getFullClassName().equals(cmd.getFullClassName())) {
                        table = this.storeMgr.getDatastoreClass(this.stmt.getCandidateClassName(), this.clr);
                    }
                    if (table == null) {
                        AbstractClassMetaData[] subCmds = this.storeMgr.getClassesManagingTableForClass(cmd, this.clr);
                        if (subCmds.length == 1) {
                            table = this.storeMgr.getDatastoreClass(subCmds[0].getFullClassName(), this.clr);
                        } else {
                            throw new NucleusUserException("Unable to find table for primary " + primaryName + " since the class " + cmd.getFullClassName() + " is managed in multiple tables");
                        }
                    }
                    if (table == null) {
                        throw new NucleusUserException("Unable to find table for primary " + primaryName + ". Table for class=" + cmd.getFullClassName() + " is null : is the field correct? or using some inheritance pattern?");
                    }
                    mapping = table.getMemberMapping(mmd);
                    sqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(theStmt, sqlMapping.table, mapping);
                }
                if (relationType == RelationType.NONE) {
                    sqlMappingNew = new SQLTableMapping(sqlTbl, cmd, mapping);
                    cmd = sqlMappingNew.cmd;
                    this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                } else if (relationType == RelationType.ONE_TO_ONE_UNI || relationType == RelationType.ONE_TO_ONE_BI) {
                    if (mmd.getMappedBy() != null) {
                        relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                        if (relMmd.getAbstractClassMetaData().isEmbeddedOnly()) {
                            sqlMappingNew = sqlMapping;
                            cmd = relMmd.getAbstractClassMetaData();
                        } else {
                            relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                            JavaTypeMapping relMapping = relTable.getMemberMapping(relMmd);
                            sqlTbl = theStmt.getTable(relTable, primaryName);
                            if (sqlTbl == null) {
                                sqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(theStmt, sqlMapping.table.getTable().getIdMapping(), sqlMapping.table, relMapping, relTable, null, null, primaryName, this.getDefaultJoinTypeForNavigation());
                            }
                            if (iter.hasNext()) {
                                sqlMappingNew = new SQLTableMapping(sqlTbl, relMmd.getAbstractClassMetaData(), relTable.getIdMapping());
                                cmd = sqlMappingNew.cmd;
                            } else {
                                sqlMappingNew = new SQLTableMapping(sqlTbl, cmd, relTable.getIdMapping());
                                cmd = sqlMappingNew.cmd;
                            }
                        }
                    } else {
                        AbstractClassMetaData relCmd;
                        if (forceJoin == null) {
                            if (!iter.hasNext()) {
                                if (primExpr.getParent() != null && primExpr.getParent().getOperator() == Expression.OP_CAST && !(mapping instanceof ReferenceMapping)) {
                                    relCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.clr);
                                    if (relCmd != null && !relCmd.isEmbeddedOnly()) {
                                        relTable = this.storeMgr.getDatastoreClass(relCmd.getFullClassName(), this.clr);
                                        if (relTable != null) {
                                            forceJoin = Boolean.TRUE;
                                        }
                                    } else {
                                        forceJoin = Boolean.TRUE;
                                    }
                                }
                            } else if (iter.hasNext()) {
                                AbstractMemberMetaData mmdOfRelCmd;
                                AbstractClassMetaData relCmd2;
                                String next = (String)iter.next();
                                if (!iter.hasNext() && (relCmd2 = this.storeMgr.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.clr)) != null && (mmdOfRelCmd = relCmd2.getMetaDataForMember(next)) != null && mmdOfRelCmd.isPrimaryKey() && relCmd2.getNoOfPrimaryKeyMembers() == 1 && !this.storeMgr.getMetaDataManager().isClassPersistable(mmdOfRelCmd.getTypeName())) {
                                    NucleusLogger.QUERY.debug((Object)("Found implicit join to member=" + mmdOfRelCmd.getFullFieldName() + " which is PK of the other type but FK is in this table so avoiding the join"));
                                    JavaTypeMapping subMapping = ((PersistableMapping)mapping).getJavaTypeMapping()[0];
                                    subMapping.setTable(mapping.getTable());
                                    return new SQLTableMapping(sqlMapping.table, relCmd2, subMapping);
                                }
                                iter.previous();
                            }
                        }
                        if (iter.hasNext() || Boolean.TRUE.equals(forceJoin)) {
                            relCmd = null;
                            JavaTypeMapping relMapping = null;
                            DatastoreClass relTable2 = null;
                            if (relationType == RelationType.ONE_TO_ONE_BI) {
                                AbstractMemberMetaData relMmd2 = mmd.getRelatedMemberMetaData(this.clr)[0];
                                relCmd = relMmd2.getAbstractClassMetaData();
                            } else {
                                String typeName = mmd.isSingleCollection() ? mmd.getCollection().getElementType() : mmd.getTypeName();
                                relCmd = this.ec.getMetaDataManager().getMetaDataForClass(typeName, this.clr);
                            }
                            if (relCmd != null && relCmd.isEmbeddedOnly()) {
                                sqlMappingNew = new SQLTableMapping(sqlTbl, relCmd, mapping);
                                cmd = relCmd;
                            } else {
                                relTable2 = this.storeMgr.getDatastoreClass(relCmd.getFullClassName(), this.clr);
                                if (relTable2 == null) {
                                    String relSubclassName;
                                    Collection relSubclassNames = this.storeMgr.getSubClassesForClass(relCmd.getFullClassName(), false, this.clr);
                                    if (relSubclassNames != null && relSubclassNames.size() == 1 && (relTable2 = this.storeMgr.getDatastoreClass(relSubclassName = (String)relSubclassNames.iterator().next(), this.clr)) != null) {
                                        relCmd = this.ec.getMetaDataManager().getMetaDataForClass(relSubclassName, this.clr);
                                    }
                                    if (relTable2 == null) {
                                        throw new NucleusUserException("Reference to PrimaryExpression " + primExpr + " yet this needs to join relation " + mmd.getFullFieldName() + " and the other type has no table (subclass-table?). Maybe use a CAST to the appropriate subclass?");
                                    }
                                }
                                relMapping = relTable2.getIdMapping();
                                sqlTbl = theStmt.getTable(relTable2, primaryName);
                                if (sqlTbl == null) {
                                    sqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(theStmt, mapping, sqlMapping.table, relMapping, relTable2, null, null, primaryName, this.getDefaultJoinTypeForNavigation());
                                }
                                sqlMappingNew = new SQLTableMapping(sqlTbl, relCmd, relMapping);
                                cmd = sqlMappingNew.cmd;
                                this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                            }
                        } else {
                            sqlMappingNew = new SQLTableMapping(sqlTbl, cmd, mapping);
                            cmd = sqlMappingNew.cmd;
                        }
                    }
                } else if (relationType == RelationType.MANY_TO_ONE_BI) {
                    SQLJoin.JoinType defJoinType;
                    relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                    relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                    if (mmd.getJoinMetaData() != null || relMmd.getJoinMetaData() != null) {
                        sqlTbl = theStmt.getTable(relTable, primaryName);
                        if (sqlTbl == null) {
                            SQLTable joinSqlTbl;
                            CollectionTable joinTbl = (CollectionTable)this.storeMgr.getTable(relMmd);
                            defJoinType = this.getDefaultJoinTypeForNavigation();
                            if (defJoinType == SQLJoin.JoinType.INNER_JOIN) {
                                joinSqlTbl = theStmt.join(SQLJoin.JoinType.INNER_JOIN, sqlMapping.table, sqlMapping.table.getTable().getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null, true);
                                sqlTbl = theStmt.join(SQLJoin.JoinType.INNER_JOIN, joinSqlTbl, joinTbl.getOwnerMapping(), relTable, null, relTable.getIdMapping(), null, primaryName, true);
                            } else if (defJoinType == SQLJoin.JoinType.LEFT_OUTER_JOIN || defJoinType == null) {
                                joinSqlTbl = theStmt.join(SQLJoin.JoinType.LEFT_OUTER_JOIN, sqlMapping.table, sqlMapping.table.getTable().getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null, true);
                                sqlTbl = theStmt.join(SQLJoin.JoinType.LEFT_OUTER_JOIN, joinSqlTbl, joinTbl.getOwnerMapping(), relTable, null, relTable.getIdMapping(), null, primaryName, true);
                            }
                        }
                        sqlMappingNew = new SQLTableMapping(sqlTbl, relMmd.getAbstractClassMetaData(), relTable.getIdMapping());
                        cmd = sqlMappingNew.cmd;
                        this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                    } else {
                        sqlTbl = theStmt.getTable(relTable, primaryName);
                        if (sqlTbl == null) {
                            Expression.Operator op;
                            if (mmd.getMappedBy() == null && iter.hasNext()) {
                                AbstractClassMetaData relCmd;
                                AbstractMemberMetaData mmdOfRelCmd;
                                String next = (String)iter.next();
                                if (!iter.hasNext() && (mmdOfRelCmd = (relCmd = relMmd.getAbstractClassMetaData()).getMetaDataForMember(next)) != null && mmdOfRelCmd.isPrimaryKey() && relCmd.getNoOfPrimaryKeyMembers() == 1 && !this.storeMgr.getMetaDataManager().isClassPersistable(mmdOfRelCmd.getTypeName())) {
                                    NucleusLogger.QUERY.debug((Object)("Found implicit join to member=" + mmdOfRelCmd.getFullFieldName() + " which is PK of the other type but FK is in this table so avoiding the join"));
                                    JavaTypeMapping subMapping = ((PersistableMapping)mapping).getJavaTypeMapping()[0];
                                    subMapping.setTable(mapping.getTable());
                                    return new SQLTableMapping(sqlMapping.table, relCmd, subMapping);
                                }
                                iter.previous();
                            }
                            Expression.Operator operator = op = primExpr.getParent() != null ? primExpr.getParent().getOperator() : null;
                            if (!(iter.hasNext() || op != Expression.OP_EQ && op != Expression.OP_GT && op != Expression.OP_LT && op != Expression.OP_GTEQ && op != Expression.OP_LTEQ && op != Expression.OP_NOTEQ)) {
                                sqlMappingNew = new SQLTableMapping(sqlMapping.table, relMmd.getAbstractClassMetaData(), mapping);
                            } else {
                                defJoinType = this.getDefaultJoinTypeForNavigation();
                                if (defJoinType == SQLJoin.JoinType.INNER_JOIN) {
                                    sqlTbl = theStmt.join(SQLJoin.JoinType.INNER_JOIN, sqlMapping.table, mapping, relTable, null, relTable.getIdMapping(), null, primaryName, true);
                                } else if (defJoinType == SQLJoin.JoinType.LEFT_OUTER_JOIN || defJoinType == null) {
                                    sqlTbl = theStmt.join(SQLJoin.JoinType.LEFT_OUTER_JOIN, sqlMapping.table, mapping, relTable, null, relTable.getIdMapping(), null, primaryName, true);
                                }
                                sqlMappingNew = new SQLTableMapping(sqlTbl, relMmd.getAbstractClassMetaData(), relTable.getIdMapping());
                                cmd = sqlMappingNew.cmd;
                                this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                            }
                        } else {
                            sqlMappingNew = new SQLTableMapping(sqlTbl, relMmd.getAbstractClassMetaData(), relTable.getIdMapping());
                            cmd = sqlMappingNew.cmd;
                            this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                        }
                    }
                } else if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                    sqlMappingNew = new SQLTableMapping(sqlTbl, cmd, mapping);
                    cmd = sqlMappingNew.cmd;
                    this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                }
            } else {
                cmd = sqlMappingNew.cmd;
            }
            sqlMapping = sqlMappingNew;
        }
        return sqlMapping;
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        return this.processParameterExpression(expr, false);
    }

    protected Object processParameterExpression(ParameterExpression expr, boolean asLiteral) {
        JavaTypeMapping m;
        if (this.compileComponent == CompilationComponent.ORDERING || this.compileComponent == CompilationComponent.RESULT) {
            asLiteral = true;
        }
        if (expr.getPosition() >= 0) {
            if (this.paramNameByPosition == null) {
                this.paramNameByPosition = new HashMap<Integer, String>();
            }
            this.paramNameByPosition.put(expr.getPosition(), expr.getId());
        }
        Object paramValue = null;
        boolean paramValueSet = false;
        if (this.parameters != null && this.parameters.size() > 0) {
            if (this.parameters.containsKey(expr.getId())) {
                paramValue = this.parameters.get(expr.getId());
                paramValueSet = true;
            } else if (this.parameterValueByName != null && this.parameterValueByName.containsKey(expr.getId())) {
                paramValue = this.parameterValueByName.get(expr.getId());
                paramValueSet = true;
            } else {
                int position = this.positionalParamNumber;
                if (this.positionalParamNumber < 0) {
                    position = 0;
                }
                if (this.parameters.containsKey(position)) {
                    paramValue = this.parameters.get(position);
                    paramValueSet = true;
                    this.positionalParamNumber = position + 1;
                    if (this.parameterValueByName == null) {
                        this.parameterValueByName = new HashMap<String, Object>();
                    }
                    this.parameterValueByName.put(expr.getId(), paramValue);
                }
            }
        }
        if ((m = this.paramMappingForName.get(expr.getId())) == null) {
            if (paramValue != null) {
                AbstractClassMetaData cmd;
                String className = this.storeMgr.getClassNameForObjectID(paramValue, this.clr, this.ec);
                if (className != null && (cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, this.clr)).getIdentityType() == IdentityType.APPLICATION) {
                    Class cls = this.clr.classForName(className);
                    m = this.exprFactory.getMappingForType(cls, false);
                    m = new PersistableIdMapping((PersistableMapping)m);
                }
                if (m == null) {
                    try {
                        m = this.exprFactory.getMappingForType(paramValue.getClass(), false);
                    }
                    catch (NucleusUserException nue) {
                        m = this.exprFactory.getMappingForType(expr.getSymbol().getValueType(), false);
                    }
                }
                if (expr.getSymbol() != null && expr.getSymbol().getValueType() != null) {
                    if (!QueryUtils.queryParameterTypesAreCompatible((Class)expr.getSymbol().getValueType(), paramValue.getClass())) {
                        throw new QueryCompilerSyntaxException(Localiser.msg((String)"021118", (Object[])new Object[]{expr.getId(), expr.getSymbol().getValueType().getName(), paramValue.getClass().getName()}));
                    }
                    if (expr.getSymbol().getValueType() != paramValue.getClass()) {
                        this.setNotPrecompilable();
                    }
                }
            } else if (expr.getSymbol() != null && expr.getSymbol().getValueType() != null) {
                String[] implNames;
                Class valueType = expr.getSymbol().getValueType();
                if (!paramValueSet && valueType.isInterface() && (implNames = this.storeMgr.getMetaDataManager().getClassesImplementingInterface(valueType.getName(), this.clr)) != null && implNames.length > 0) {
                    valueType = this.clr.classForName(implNames[0]);
                    this.setNotPrecompilable();
                }
                m = this.exprFactory.getMappingForType(valueType, false);
            }
        }
        if (asLiteral && m != null && !m.representableAsStringLiteralInStatement()) {
            asLiteral = false;
        }
        if (asLiteral) {
            if (this.isPrecompilable()) {
                NucleusLogger.QUERY.debug((Object)("Parameter " + expr + " is being resolved as a literal, so the query is no longer precompilable"));
            }
            this.setNotPrecompilable();
        } else if (paramValue == null && expr.getSymbol() != null) {
            if (this.isPrecompilable()) {
                NucleusLogger.QUERY.debug((Object)("Parameter " + expr + " is set to null so this has to be resolved as a NullLiteral, and the query is no longer precompilable"));
            }
            this.setNotPrecompilable();
        }
        SQLExpression sqlExpr = null;
        if (paramValueSet && paramValue == null && this.options.contains(OPTION_NULL_PARAM_USE_IS_NULL)) {
            sqlExpr = this.exprFactory.newLiteral(this.stmt, null, null);
        } else if (asLiteral) {
            sqlExpr = this.exprFactory.newLiteral(this.stmt, m, paramValue);
        } else {
            sqlExpr = this.exprFactory.newLiteralParameter(this.stmt, m, paramValue, expr.getId());
            if (sqlExpr instanceof ParameterLiteral) {
                ((ParameterLiteral)sqlExpr).setName(expr.getId());
            }
            if (this.expressionForParameter == null) {
                this.expressionForParameter = new HashMap<Object, SQLExpression>();
            }
            this.expressionForParameter.put(expr.getId(), sqlExpr);
            this.paramMappingForName.put(expr.getId(), m);
        }
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected SQLExpression getInvokedSqlExpressionForInvokeExpression(InvokeExpression expr) {
        Expression invokedExpr = expr.getLeft();
        SQLExpression invokedSqlExpr = null;
        if (invokedExpr != null) {
            if (invokedExpr instanceof PrimaryExpression) {
                this.processPrimaryExpression((PrimaryExpression)invokedExpr);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof Literal) {
                this.processLiteral((Literal)invokedExpr);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof ParameterExpression) {
                this.processParameterExpression((ParameterExpression)invokedExpr, true);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof InvokeExpression) {
                this.processInvokeExpression((InvokeExpression)invokedExpr);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof VariableExpression) {
                this.processVariableExpression((VariableExpression)invokedExpr);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof ArrayExpression) {
                ArrayExpression arrExpr = (ArrayExpression)invokedExpr;
                SQLExpression[] arrSqlExprs = new SQLExpression[arrExpr.getArraySize()];
                for (int i = 0; i < arrExpr.getArraySize(); ++i) {
                    Expression arrElemExpr = arrExpr.getElement(i);
                    arrElemExpr.evaluate((ExpressionEvaluator)this);
                    arrSqlExprs[i] = this.stack.pop();
                }
                JavaTypeMapping m = this.exprFactory.getMappingForType(Object[].class, false);
                invokedSqlExpr = new org.datanucleus.store.rdbms.sql.expression.ArrayExpression(this.stmt, m, arrSqlExprs);
            } else if (invokedExpr instanceof DyadicExpression) {
                DyadicExpression dyExpr = (DyadicExpression)invokedExpr;
                dyExpr.evaluate((ExpressionEvaluator)this);
                invokedSqlExpr = this.stack.pop();
            } else {
                throw new NucleusException("Dont currently support invoke expression " + invokedExpr);
            }
        }
        return invokedSqlExpr;
    }

    protected Object processInvokeExpression(InvokeExpression expr) {
        SQLExpression invokedSqlExpr = this.getInvokedSqlExpressionForInvokeExpression(expr);
        return this.processInvokeExpression(expr, invokedSqlExpr);
    }

    protected SQLExpression processInvokeExpression(InvokeExpression expr, SQLExpression invokedSqlExpr) {
        if (invokedSqlExpr instanceof NullLiteral) {
            NucleusLogger.QUERY.warn((Object)("Compilation of InvokeExpression needs to invoke method \"" + expr.getOperation() + "\" on " + invokedSqlExpr + " but not possible"));
        }
        String operation = expr.getOperation();
        if (invokedSqlExpr instanceof MapExpression && operation.equals("contains") && this.compilation.getQueryLanguage().equalsIgnoreCase("JPQL")) {
            operation = "containsValue";
        }
        List args = expr.getArguments();
        ArrayList<SQLExpression> sqlExprArgs = null;
        if (args != null) {
            sqlExprArgs = new ArrayList<SQLExpression>();
            for (Expression argExpr : args) {
                if (argExpr instanceof PrimaryExpression) {
                    this.processPrimaryExpression((PrimaryExpression)argExpr);
                    SQLExpression argSqlExpr = this.stack.pop();
                    if (this.compileComponent == CompilationComponent.RESULT && operation.equalsIgnoreCase("count") && this.stmt.getNumberOfTableGroups() > 1 && argSqlExpr.getSQLTable() == this.stmt.getPrimaryTable() && argSqlExpr.getJavaTypeMapping() == this.stmt.getPrimaryTable().getTable().getIdMapping()) {
                        argSqlExpr.distinct();
                    }
                    sqlExprArgs.add(argSqlExpr);
                    continue;
                }
                if (argExpr instanceof ParameterExpression) {
                    this.processParameterExpression((ParameterExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof InvokeExpression) {
                    this.processInvokeExpression((InvokeExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof Literal) {
                    this.processLiteral((Literal)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof DyadicExpression) {
                    argExpr.evaluate((ExpressionEvaluator)this);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof VariableExpression) {
                    this.processVariableExpression((VariableExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof org.datanucleus.query.expression.CaseExpression) {
                    this.processCaseExpression((org.datanucleus.query.expression.CaseExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                throw new NucleusException("Dont currently support invoke expression argument " + argExpr);
            }
            if (operation.equals("INDEX")) {
                String joinAlias;
                List indexArgs = expr.getArguments();
                if (indexArgs == null || indexArgs.size() > 1) {
                    throw new NucleusException("Can only use INDEX with single argument");
                }
                PrimaryExpression indexExpr = (PrimaryExpression)indexArgs.get(0);
                String collExprName = joinAlias = indexExpr.getId();
                if (this.explicitJoinPrimaryByAlias != null && (collExprName = this.explicitJoinPrimaryByAlias.get(joinAlias)) == null) {
                    throw new NucleusException("Unable to locate primary expression for alias " + joinAlias);
                }
                ArrayList<String> tuples = new ArrayList<String>();
                StringTokenizer primTokenizer = new StringTokenizer(collExprName, ".");
                while (primTokenizer.hasMoreTokens()) {
                    String token = primTokenizer.nextToken();
                    tuples.add(token);
                }
                PrimaryExpression collPrimExpr = new PrimaryExpression(tuples);
                this.processPrimaryExpression(collPrimExpr);
                SQLExpression collSqlExpr = this.stack.pop();
                sqlExprArgs.add(collSqlExpr);
            }
        }
        SQLExpression sqlExpr = null;
        if (invokedSqlExpr instanceof org.datanucleus.store.rdbms.sql.expression.SubqueryExpression) {
            if (operation.equalsIgnoreCase("isEmpty")) {
                org.datanucleus.store.rdbms.sql.expression.SubqueryExpression subquerySqlExpr = (org.datanucleus.store.rdbms.sql.expression.SubqueryExpression)invokedSqlExpr;
                SQLStatement subStmt = subquerySqlExpr.getSubqueryStatement();
                BooleanExpression subqueryNotExistsExpr = new BooleanSubqueryExpression(this.stmt, "EXISTS", subStmt).not();
                this.stack.push(subqueryNotExistsExpr);
                return subqueryNotExistsExpr;
            }
            throw new NucleusUserException("Attempt to invoke method " + operation + " on Subquery. This is not supported");
        }
        sqlExpr = invokedSqlExpr != null ? invokedSqlExpr.invoke(operation, sqlExprArgs) : this.exprFactory.invokeMethod(this.stmt, null, operation, null, sqlExprArgs);
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processSubqueryExpression(SubqueryExpression expr) {
        String keyword = expr.getKeyword();
        Expression subqueryExpr = expr.getRight();
        if (subqueryExpr instanceof VariableExpression) {
            this.processVariableExpression((VariableExpression)subqueryExpr);
            SQLExpression subquerySqlExpr = this.stack.pop();
            if (keyword != null && keyword.equals("EXISTS")) {
                if (subquerySqlExpr instanceof org.datanucleus.store.rdbms.sql.expression.SubqueryExpression) {
                    SQLStatement subStmt = ((org.datanucleus.store.rdbms.sql.expression.SubqueryExpression)subquerySqlExpr).getSubqueryStatement();
                    subquerySqlExpr = new BooleanSubqueryExpression(this.stmt, keyword, subStmt);
                } else {
                    SQLStatement subStmt = ((SubqueryExpressionComponent)((Object)subquerySqlExpr)).getSubqueryStatement();
                    subquerySqlExpr = new BooleanSubqueryExpression(this.stmt, keyword, subStmt);
                }
            } else if (subquerySqlExpr instanceof org.datanucleus.store.rdbms.sql.expression.SubqueryExpression) {
                SQLStatement subStmt = ((org.datanucleus.store.rdbms.sql.expression.SubqueryExpression)subquerySqlExpr).getSubqueryStatement();
                subquerySqlExpr = new BooleanSubqueryExpression(this.stmt, keyword, subStmt);
            } else if (subquerySqlExpr instanceof NumericSubqueryExpression) {
                if ((keyword.equalsIgnoreCase("SOME") || keyword.equalsIgnoreCase("ALL") || keyword.equalsIgnoreCase("ANY")) && !this.storeMgr.getDatastoreAdapter().supportsOption("SomeAllAnySubqueries")) {
                    throw new NucleusException("'SOME|ALL|ANY{subquery}' is not supported by this datastore");
                }
                ((NumericSubqueryExpression)subquerySqlExpr).setKeyword(keyword);
            }
            this.stack.push(subquerySqlExpr);
            return subquerySqlExpr;
        }
        throw new NucleusException("Dont currently support SubqueryExpression " + keyword + " for type " + subqueryExpr);
    }

    protected Object processAddExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        SQLExpression resultExpr = left.add(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processDivExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression resultExpr = left.div(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processMulExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression resultExpr = left.mul(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processSubExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        SQLExpression resultExpr = left.sub(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processDistinctExpression(Expression expr) {
        SQLExpression sqlExpr = this.stack.pop();
        sqlExpr.distinct();
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processComExpression(Expression expr) {
        SQLExpression sqlExpr = this.stack.pop();
        SQLExpression resultExpr = sqlExpr.com();
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processModExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression resultExpr = left.mod(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processNegExpression(Expression expr) {
        SQLExpression sqlExpr = this.stack.pop();
        SQLExpression resultExpr = sqlExpr.neg();
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processNotExpression(Expression expr) {
        SQLExpression sqlExpr = this.stack.pop();
        BooleanExpression resultExpr = sqlExpr.not();
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processCastExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression castExpr = left.cast(right);
        this.stack.push(castExpr);
        return castExpr;
    }

    protected Object processCaseExpression(org.datanucleus.query.expression.CaseExpression expr) {
        boolean numericCase = false;
        boolean booleanCase = false;
        boolean stringCase = false;
        List conditions = expr.getConditions();
        Iterator whenExprIter = conditions.iterator();
        SQLExpression[] whenSqlExprs = new SQLExpression[conditions.size()];
        SQLExpression[] actionSqlExprs = new SQLExpression[conditions.size()];
        int i = 0;
        while (whenExprIter.hasNext()) {
            CaseExpression.ExpressionPair pair = (CaseExpression.ExpressionPair)whenExprIter.next();
            Expression whenExpr = pair.getWhenExpression();
            whenExpr.evaluate((ExpressionEvaluator)this);
            whenSqlExprs[i] = this.stack.pop();
            if (!(whenSqlExprs[i] instanceof BooleanExpression)) {
                throw new QueryCompilerSyntaxException("IF/ELSE conditional expression should return boolean but doesn't : " + expr);
            }
            Expression actionExpr = pair.getActionExpression();
            actionExpr.evaluate((ExpressionEvaluator)this);
            actionSqlExprs[i] = this.stack.pop();
            if (actionSqlExprs[i] instanceof NumericExpression) {
                numericCase = true;
            } else if (actionSqlExprs[i] instanceof BooleanExpression) {
                booleanCase = true;
            } else if (actionSqlExprs[i] instanceof StringExpression) {
                stringCase = true;
            }
            ++i;
        }
        Expression elseExpr = expr.getElseExpression();
        elseExpr.evaluate((ExpressionEvaluator)this);
        SQLExpression elseActionSqlExpr = this.stack.pop();
        for (int j = 1; j < actionSqlExprs.length; ++j) {
            if (this.checkCaseExpressionsConsistent(actionSqlExprs[0], actionSqlExprs[j])) continue;
            throw new QueryCompilerSyntaxException("IF/ELSE action expression " + actionSqlExprs[j] + " is of different type to first action " + actionSqlExprs[0] + " - must be consistent");
        }
        if (!this.checkCaseExpressionsConsistent(actionSqlExprs[0], elseActionSqlExpr)) {
            throw new QueryCompilerSyntaxException("IF/ELSE action expression " + elseActionSqlExpr + " is of different type to first action " + actionSqlExprs[0] + " - must be consistent");
        }
        SQLExpression caseSqlExpr = null;
        caseSqlExpr = numericCase ? new CaseNumericExpression(whenSqlExprs, actionSqlExprs, elseActionSqlExpr) : (booleanCase ? new CaseBooleanExpression(whenSqlExprs, actionSqlExprs, elseActionSqlExpr) : (stringCase ? new CaseStringExpression(whenSqlExprs, actionSqlExprs, elseActionSqlExpr) : new CaseExpression(whenSqlExprs, actionSqlExprs, elseActionSqlExpr)));
        this.stack.push(caseSqlExpr);
        return caseSqlExpr;
    }

    private boolean checkCaseExpressionsConsistent(SQLExpression expr1, SQLExpression expr2) {
        if (expr1 instanceof NumericExpression && expr2 instanceof NumericExpression) {
            return true;
        }
        if (expr1 instanceof StringExpression && expr2 instanceof StringExpression) {
            return true;
        }
        if (expr1 instanceof BooleanExpression && expr2 instanceof BooleanExpression) {
            return true;
        }
        if (expr1 instanceof TemporalExpression && expr2 instanceof TemporalExpression) {
            return true;
        }
        return expr1.getClass().isAssignableFrom(expr2.getClass()) || expr2.getClass().isAssignableFrom(expr1.getClass());
    }

    protected Object processIsExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        BooleanExpression instanceofExpr = left.is(right, false);
        this.stack.push(instanceofExpr);
        return instanceofExpr;
    }

    protected Object processIsnotExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        BooleanExpression instanceofExpr = left.is(right, true);
        this.stack.push(instanceofExpr);
        return instanceofExpr;
    }

    protected Object processInExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (right instanceof CollectionExpression || right instanceof org.datanucleus.store.rdbms.sql.expression.ArrayExpression) {
            if (right.getParameterName() != null) {
                this.setNotPrecompilable();
            }
            ArrayList<SQLExpression> sqlExprArgs = new ArrayList<SQLExpression>();
            sqlExprArgs.add(left);
            SQLExpression sqlExpr = right.invoke("contains", sqlExprArgs);
            this.stack.push(sqlExpr);
            return sqlExpr;
        }
        if (right.getParameterName() != null) {
            this.setNotPrecompilable();
            BooleanExpression inExpr = new BooleanExpression(left, Expression.OP_EQ, right);
            this.stack.push(inExpr);
            return inExpr;
        }
        BooleanExpression inExpr = left.in(right, false);
        this.stack.push(inExpr);
        return inExpr;
    }

    protected Object processNotInExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (right instanceof CollectionExpression) {
            if (right.getParameterName() != null) {
                this.setNotPrecompilable();
            }
            ArrayList<SQLExpression> sqlExprArgs = new ArrayList<SQLExpression>();
            sqlExprArgs.add(left);
            SQLExpression sqlExpr = right.invoke("contains", sqlExprArgs);
            sqlExpr.not();
            this.stack.push(sqlExpr);
            return sqlExpr;
        }
        if (right.getParameterName() != null) {
            BooleanExpression inExpr = new BooleanExpression(left, Expression.OP_NOTEQ, right);
            this.stack.push(inExpr);
            return inExpr;
        }
        BooleanExpression inExpr = left.in(right, true);
        this.stack.push(inExpr);
        return inExpr;
    }

    protected Object processCreatorExpression(CreatorExpression expr) {
        Class cls;
        String className;
        block5: {
            className = expr.getId();
            cls = null;
            try {
                cls = this.clr.classForName(className);
            }
            catch (ClassNotResolvedException cnre) {
                if (this.importsDefinition == null) break block5;
                cls = this.importsDefinition.resolveClassDeclaration(className, this.clr, null);
            }
        }
        ArrayList<SQLExpression> ctrArgExprs = null;
        List args = expr.getArguments();
        if (args != null) {
            Object[] ctrArgTypes = new Class[args.size()];
            ctrArgExprs = new ArrayList<SQLExpression>(args.size());
            Iterator iter = args.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Expression argExpr = (Expression)iter.next();
                SQLExpression sqlExpr = (SQLExpression)this.evaluate(argExpr);
                ctrArgExprs.add(sqlExpr);
                ctrArgTypes[i] = sqlExpr instanceof NewObjectExpression ? ((NewObjectExpression)sqlExpr).getNewClass() : (sqlExpr.getJavaTypeMapping() instanceof DatastoreIdMapping || sqlExpr.getJavaTypeMapping() instanceof PersistableMapping ? this.clr.classForName(sqlExpr.getJavaTypeMapping().getType()) : sqlExpr.getJavaTypeMapping().getJavaType());
                ++i;
            }
            Constructor ctr = ClassUtils.getConstructorWithArguments((Class)cls, (Class[])ctrArgTypes);
            if (ctr == null) {
                throw new NucleusUserException(Localiser.msg((String)"021033", (Object[])new Object[]{className, StringUtils.objectArrayToString((Object[])ctrArgTypes)}));
            }
        }
        NewObjectExpression newExpr = new NewObjectExpression(this.stmt, cls, ctrArgExprs);
        this.stack.push(newExpr);
        return newExpr;
    }

    protected Object processLikeExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        ArrayList<SQLExpression> args = new ArrayList<SQLExpression>();
        args.add(right);
        SQLExpression likeExpr = this.exprFactory.invokeMethod(this.stmt, String.class.getName(), "like", left, args);
        this.stack.push(likeExpr);
        return likeExpr;
    }

    protected Object processVariableExpression(VariableExpression expr) {
        String varName = expr.getId();
        Symbol varSym = expr.getSymbol();
        if (varSym != null) {
            varName = varSym.getQualifiedName();
        }
        if (this.hasSQLTableMappingForAlias(varName)) {
            SQLTableMapping tblMapping = this.getSQLTableMappingForAlias(varName);
            SQLExpression sqlExpr = this.exprFactory.newExpression(tblMapping.table.getSQLStatement(), tblMapping.table, tblMapping.mapping);
            this.stack.push(sqlExpr);
            return sqlExpr;
        }
        if (this.compilation.getCompilationForSubquery(varName) != null) {
            QueryCompilation subCompilation = this.compilation.getCompilationForSubquery(varName);
            AbstractClassMetaData subCmd = this.ec.getMetaDataManager().getMetaDataForClass(subCompilation.getCandidateClass(), this.ec.getClassLoaderResolver());
            String subAlias = null;
            if (subCompilation.getCandidateAlias() != null && !subCompilation.getCandidateAlias().equals(this.candidateAlias)) {
                subAlias = subCompilation.getCandidateAlias();
            }
            StatementResultMapping subqueryResultMapping = new StatementResultMapping();
            SelectStatement subStmt = RDBMSQueryUtils.getStatementForCandidates(this.storeMgr, this.stmt, subCmd, null, this.ec, subCompilation.getCandidateClass(), true, "avg(something)", subAlias, null);
            QueryToSQLMapper sqlMapper = new QueryToSQLMapper(subStmt, subCompilation, this.parameters, null, subqueryResultMapping, subCmd, true, this.fetchPlan, this.ec, this.importsDefinition, this.options, this.extensionsByName);
            sqlMapper.setDefaultJoinType(this.defaultJoinType);
            sqlMapper.setDefaultJoinTypeFilter(this.defaultJoinTypeFilter);
            sqlMapper.setParentMapper(this);
            sqlMapper.compile();
            if (subqueryResultMapping.getNumberOfResultExpressions() > 1) {
                throw new NucleusUserException("Number of result expressions in subquery should be 1");
            }
            SQLExpression subExpr = null;
            if (subqueryResultMapping.getNumberOfResultExpressions() == 0) {
                subExpr = new org.datanucleus.store.rdbms.sql.expression.SubqueryExpression(this.stmt, subStmt);
            } else {
                JavaTypeMapping subMapping = ((StatementMappingIndex)subqueryResultMapping.getMappingForResultExpression(0)).getMapping();
                subExpr = subMapping instanceof TemporalMapping ? new TemporalSubqueryExpression(this.stmt, subStmt) : (subMapping instanceof StringMapping ? new StringSubqueryExpression(this.stmt, subStmt) : new NumericSubqueryExpression(this.stmt, subStmt));
                if (subExpr.getJavaTypeMapping() == null) {
                    subExpr.setJavaTypeMapping(subMapping);
                }
            }
            this.stack.push(subExpr);
            return subExpr;
        }
        if (this.stmt.getParentStatement() != null && this.parentMapper != null && this.parentMapper.candidateAlias != null && this.parentMapper.candidateAlias.equals(varName)) {
            SQLExpression varExpr = this.exprFactory.newExpression(this.stmt.getParentStatement(), this.stmt.getParentStatement().getPrimaryTable(), this.stmt.getParentStatement().getPrimaryTable().getTable().getIdMapping());
            this.stack.push(varExpr);
            return varExpr;
        }
        NucleusLogger.QUERY.debug((Object)("QueryToSQL.processVariable (unbound) variable=" + varName + " is not yet bound so returning UnboundExpression"));
        UnboundExpression unbExpr = new UnboundExpression(this.stmt, varName);
        this.stack.push(unbExpr);
        return unbExpr;
    }

    protected SQLExpression processUnboundExpression(UnboundExpression expr) {
        String varName = expr.getVariableName();
        Symbol varSym = this.compilation.getSymbolTable().getSymbol(varName);
        SQLExpression sqlExpr = this.bindVariable(expr, varSym.getValueType());
        if (sqlExpr != null) {
            this.stack.push(sqlExpr);
            return sqlExpr;
        }
        throw new NucleusUserException("Variable '" + varName + "' is unbound and cannot be determined (is it a misspelled field name? or is not intended to be a variable?)");
    }

    protected SQLExpression replaceParameterLiteral(ParameterLiteral paramLit, JavaTypeMapping mapping) {
        return this.exprFactory.newLiteralParameter(this.stmt, mapping, paramLit.getValue(), paramLit.getParameterName());
    }

    @Override
    public void useParameterExpressionAsLiteral(SQLLiteral paramLiteral) {
        paramLiteral.setNotParameter();
        this.setNotPrecompilable();
    }

    @Override
    public boolean hasExtension(String key) {
        return this.extensionsByName == null ? false : this.extensionsByName.containsKey(key);
    }

    @Override
    public Object getValueForExtension(String key) {
        return this.extensionsByName == null ? null : this.extensionsByName.get(key);
    }

    public SQLJoin.JoinType getRequiredJoinTypeForAlias(String alias) {
        if (alias == null) {
            return null;
        }
        if (alias.equals(this.candidateAlias)) {
            return null;
        }
        String extensionName = "datanucleus.query.jdoql." + alias + ".join";
        SQLJoin.JoinType joinType = null;
        if (this.hasExtension(extensionName)) {
            String joinValue = (String)this.getValueForExtension(extensionName);
            if (joinValue.equalsIgnoreCase("INNERJOIN")) {
                joinType = SQLJoin.JoinType.INNER_JOIN;
            } else if (joinValue.equalsIgnoreCase("LEFTOUTERJOIN")) {
                joinType = SQLJoin.JoinType.LEFT_OUTER_JOIN;
            }
        }
        return joinType;
    }

    private SQLJoin.JoinType getDefaultJoinTypeForNavigation() {
        if (this.compileComponent == CompilationComponent.FILTER && this.defaultJoinTypeFilter != null) {
            return this.defaultJoinTypeFilter;
        }
        return this.defaultJoinType;
    }

    protected Object getValueForObjectField(Object obj, String fieldName) {
        if (obj != null) {
            Object paramFieldValue = null;
            if (this.ec.getApiAdapter().isPersistable(obj)) {
                ObjectProvider paramOP = this.ec.findObjectProvider(obj);
                AbstractClassMetaData paramCmd = this.ec.getMetaDataManager().getMetaDataForClass(obj.getClass(), this.clr);
                AbstractMemberMetaData paramFieldMmd = paramCmd.getMetaDataForMember(fieldName);
                if (paramOP != null) {
                    paramOP.isLoaded(paramFieldMmd.getAbsoluteFieldNumber());
                    paramFieldValue = paramOP.provideField(paramFieldMmd.getAbsoluteFieldNumber());
                } else {
                    paramFieldValue = ClassUtils.getValueOfFieldByReflection((Object)obj, (String)fieldName);
                }
            } else {
                paramFieldValue = ClassUtils.getValueOfFieldByReflection((Object)obj, (String)fieldName);
            }
            return paramFieldValue;
        }
        return null;
    }

    protected SQLTableMapping getSQLTableMappingForAlias(String alias) {
        if (alias == null) {
            return null;
        }
        if (this.options.contains(OPTION_CASE_INSENSITIVE)) {
            return this.sqlTableByPrimary.get(alias.toUpperCase());
        }
        return this.sqlTableByPrimary.get(alias);
    }

    public String getAliasForSQLTableMapping(SQLTableMapping tblMapping) {
        for (Map.Entry<String, SQLTableMapping> entry : this.sqlTableByPrimary.entrySet()) {
            if (entry.getValue() != tblMapping) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getAliasForSQLTable(SQLTable tbl) {
        Iterator<Map.Entry<String, SQLTableMapping>> iter = this.sqlTableByPrimary.entrySet().iterator();
        String alias = null;
        while (iter.hasNext()) {
            Map.Entry<String, SQLTableMapping> entry = iter.next();
            if (entry.getValue().table != tbl) continue;
            if (alias == null) {
                alias = entry.getKey();
                continue;
            }
            if (entry.getKey().length() >= alias.length()) continue;
            alias = entry.getKey();
        }
        return alias;
    }

    protected void setSQLTableMappingForAlias(String alias, SQLTableMapping mapping) {
        if (alias == null) {
            return;
        }
        this.sqlTableByPrimary.put(this.options.contains(OPTION_CASE_INSENSITIVE) ? alias.toUpperCase() : alias, mapping);
    }

    protected boolean hasSQLTableMappingForAlias(String alias) {
        return this.sqlTableByPrimary.containsKey(this.options.contains(OPTION_CASE_INSENSITIVE) ? alias.toUpperCase() : alias);
    }

    @Override
    public void bindVariable(String varName, AbstractClassMetaData cmd, SQLTable sqlTbl, JavaTypeMapping mapping) {
        SQLTableMapping m = this.getSQLTableMappingForAlias(varName);
        if (m != null) {
            throw new NucleusException("Variable " + varName + " is already bound to " + m.table + " yet attempting to bind to " + sqlTbl);
        }
        NucleusLogger.QUERY.debug((Object)("QueryToSQL.bindVariable variable " + varName + " being bound to table=" + sqlTbl + " mapping=" + mapping));
        m = new SQLTableMapping(sqlTbl, cmd, mapping);
        this.setSQLTableMappingForAlias(varName, m);
    }

    @Override
    public SQLExpression bindVariable(UnboundExpression expr, Class type) {
        AbstractClassMetaData cmd;
        String varName = expr.getVariableName();
        Symbol varSym = this.compilation.getSymbolTable().getSymbol(varName);
        if (varSym.getValueType() == null) {
            varSym.setValueType(type);
        }
        if ((cmd = this.ec.getMetaDataManager().getMetaDataForClass(type, this.clr)) != null) {
            DatastoreClass varTable = this.storeMgr.getDatastoreClass(varSym.getValueType().getName(), this.clr);
            SQLTable varSqlTbl = this.stmt.crossJoin(varTable, "VAR_" + varName, null);
            SQLTableMapping varSqlTblMapping = new SQLTableMapping(varSqlTbl, cmd, varTable.getIdMapping());
            this.setSQLTableMappingForAlias(varName, varSqlTblMapping);
            return this.exprFactory.newExpression(this.stmt, varSqlTbl, varTable.getIdMapping());
        }
        return null;
    }

    @Override
    public void bindParameter(String paramName, Class type) {
        Symbol paramSym = this.compilation.getSymbolTable().getSymbol(paramName);
        if (paramSym != null && paramSym.getValueType() == null) {
            paramSym.setValueType(type);
        }
    }

    @Override
    public Class getTypeOfVariable(String varName) {
        Symbol sym = this.compilation.getSymbolTable().getSymbol(varName);
        if (sym != null && sym.getValueType() != null) {
            return sym.getValueType();
        }
        return null;
    }

    @Override
    public boolean hasExplicitJoins() {
        return this.options.contains(OPTION_EXPLICIT_JOINS);
    }

    protected BooleanExpression getBooleanExpressionForUseInFilter(BooleanExpression expr) {
        if (this.compileComponent != CompilationComponent.FILTER) {
            return expr;
        }
        if (!expr.hasClosure()) {
            return new BooleanExpression(expr, Expression.OP_EQ, new BooleanLiteral(this.stmt, expr.getJavaTypeMapping(), Boolean.TRUE, null));
        }
        return expr;
    }

    @Override
    public Class resolveClass(String className) {
        AbstractClassMetaData cmd;
        Class cls;
        block3: {
            cls = null;
            try {
                cls = this.clr.classForName(className);
            }
            catch (ClassNotResolvedException cnre) {
                if (this.importsDefinition == null) break block3;
                cls = this.importsDefinition.resolveClassDeclaration(className, this.clr, null);
            }
        }
        if (cls == null && this.compilation.getQueryLanguage().equalsIgnoreCase("JPQL") && (cmd = this.ec.getMetaDataManager().getMetaDataForEntityName(className)) != null) {
            return this.clr.classForName(cmd.getFullClassName());
        }
        return cls;
    }

    static class SQLTableMapping {
        SQLTable table;
        JavaTypeMapping mapping;
        AbstractClassMetaData cmd;
        AbstractMemberMetaData mmd;

        public SQLTableMapping(SQLTable tbl, AbstractClassMetaData cmd, JavaTypeMapping m) {
            this.table = tbl;
            this.cmd = cmd;
            this.mmd = null;
            this.mapping = m;
        }

        public SQLTableMapping(SQLTable tbl, AbstractClassMetaData cmd, AbstractMemberMetaData mmd, JavaTypeMapping m) {
            this.table = tbl;
            this.cmd = cmd;
            this.mmd = mmd;
            this.mapping = m;
        }

        public String toString() {
            if (this.mmd != null) {
                return "SQLTableMapping: tbl=" + this.table + " class=" + (this.cmd != null ? this.cmd.getFullClassName() : "null") + " mapping=" + this.mapping + " member=" + this.mmd.getFullFieldName();
            }
            return "SQLTableMapping: tbl=" + this.table + " class=" + (this.cmd != null ? this.cmd.getFullClassName() : "null") + " mapping=" + this.mapping;
        }
    }
}

