/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.datastore;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;

public class ArrayRDBMSMapping
extends AbstractDatastoreMapping {
    String arrayElemType = null;

    public ArrayRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column column) {
        super(storeMgr, mapping);
        this.column = column;
        this.initialize();
        String arrayTypeName = column.getTypeName();
        if (arrayTypeName.indexOf("array") > 0) {
            this.arrayElemType = arrayTypeName.substring(0, arrayTypeName.indexOf("array")).trim();
        } else if (arrayTypeName.indexOf("ARRAY") > 0) {
            this.arrayElemType = arrayTypeName.substring(0, arrayTypeName.indexOf("ARRAY")).trim();
        } else {
            throw new NucleusUserException("Do not support handling of type=" + arrayTypeName + " for member=" + mapping.getMemberMetaData().getFullFieldName());
        }
    }

    private void initialize() {
        this.initTypeInfo();
    }

    @Override
    public int getJDBCType() {
        return 2003;
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        try {
            if (value == null) {
                ps.setNull(param, this.getJDBCType());
            } else {
                java.sql.Array array = null;
                if (value.getClass().isArray()) {
                    int numElems = Array.getLength(value);
                    Object[] elems = new Object[numElems];
                    for (int i = 0; i < numElems; ++i) {
                        elems[i] = Array.get(value, i);
                    }
                    array = ps.getConnection().createArrayOf(this.arrayElemType, elems);
                } else if (value instanceof Collection) {
                    Collection coll = (Collection)value;
                    Object[] elems = new Object[coll.size()];
                    int i = 0;
                    for (Object elem : coll) {
                        elems[i++] = elem;
                    }
                    array = ps.getConnection().createArrayOf(this.arrayElemType, elems);
                } else {
                    throw new NucleusUserException("We do not support persisting values of type " + value.getClass().getName() + " as an ARRAY." + " Member=" + this.mapping.getMemberMetaData().getFullFieldName());
                }
                ps.setArray(param, array);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Object", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        Object value;
        block7: {
            value = null;
            try {
                java.sql.Array arr = rs.getArray(param);
                if (rs.wasNull()) break block7;
                AbstractMemberMetaData mmd = this.mapping.getMemberMetaData();
                if (mmd.getType().isArray()) {
                    value = arr.getArray();
                    break block7;
                }
                if (Collection.class.isAssignableFrom(mmd.getType())) {
                    Collection coll;
                    Object javaArray = arr.getArray();
                    try {
                        Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                        coll = (Collection)instanceType.newInstance();
                    }
                    catch (Exception e) {
                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    }
                    for (int i = 0; i < Array.getLength(javaArray); ++i) {
                        coll.add(Array.get(javaArray, i));
                    }
                    value = coll;
                    break block7;
                }
                throw new NucleusUserException("We do not support retrieving values of type " + mmd.getTypeName() + " as an ARRAY." + " Member=" + this.mapping.getMemberMetaData().getFullFieldName());
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Object", "" + param, this.column, e.getMessage()}), (Throwable)e);
            }
        }
        return value;
    }
}

