/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.mapping.datastore.DatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.QueryGenerator;
import org.datanucleus.store.rdbms.sql.SQLColumn;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLTableGroup;
import org.datanucleus.store.rdbms.sql.SQLTableNamer;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.expression.AggregateExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.ResultAliasExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class SQLStatement {
    protected static final Map<String, SQLTableNamer> tableNamerByName = new ConcurrentHashMap<String, SQLTableNamer>();
    protected SQLText sql = null;
    protected RDBMSStoreManager rdbmsMgr;
    protected ClassLoaderResolver clr;
    protected QueryGenerator queryGenerator = null;
    protected String candidateClassName = null;
    protected boolean distinct = false;
    protected Map<String, Object> extensions;
    protected SQLStatement parent = null;
    protected List<SQLStatement> unions = null;
    protected List<SelectedItem> selectedItems = new ArrayList<SelectedItem>();
    protected SQLExpression[] updates = null;
    protected boolean aggregated = false;
    protected SQLTable primaryTable;
    protected List<SQLJoin> joins;
    protected boolean requiresJoinReorder = false;
    protected Map<String, SQLTable> tables;
    protected Map<String, SQLTableGroup> tableGroups = new HashMap<String, SQLTableGroup>();
    protected BooleanExpression where;
    protected List<SQLExpression> groupingExpressions = null;
    protected BooleanExpression having;
    protected SQLExpression[] orderingExpressions = null;
    protected boolean[] orderingDirections = null;
    protected String[] orderNullDirectives = null;
    protected long rangeOffset = -1L;
    protected long rangeCount = -1L;
    private int[] orderingColumnIndexes;

    public SQLStatement(RDBMSStoreManager rdbmsMgr, Table table, DatastoreIdentifier alias, String tableGroupName) {
        this(null, rdbmsMgr, table, alias, tableGroupName);
    }

    public SQLStatement(SQLStatement parentStmt, RDBMSStoreManager rdbmsMgr, Table table, DatastoreIdentifier alias, String tableGroupName) {
        String tableGrpName;
        this.parent = parentStmt;
        this.rdbmsMgr = rdbmsMgr;
        String namerStrategy = rdbmsMgr.getStringProperty("datanucleus.rdbms.sqlTableNamingStrategy");
        this.addExtension("datanucleus.sqlTableNamingStrategy", namerStrategy);
        String string = tableGrpName = tableGroupName != null ? tableGroupName : "Group0";
        if (alias == null) {
            alias = rdbmsMgr.getIdentifierFactory().newTableIdentifier(this.generateTableAlias(table, tableGrpName));
        }
        this.primaryTable = new SQLTable(this, table, alias, tableGrpName);
        this.putSQLTableInGroup(this.primaryTable, tableGrpName, null);
        if (parentStmt != null) {
            this.queryGenerator = parentStmt.getQueryGenerator();
        }
    }

    public RDBMSStoreManager getRDBMSManager() {
        return this.rdbmsMgr;
    }

    public void setClassLoaderResolver(ClassLoaderResolver clr) {
        this.clr = clr;
    }

    public ClassLoaderResolver getClassLoaderResolver() {
        if (this.clr == null) {
            this.clr = this.rdbmsMgr.getNucleusContext().getClassLoaderResolver(null);
        }
        return this.clr;
    }

    public void setCandidateClassName(String name) {
        this.candidateClassName = name;
    }

    public String getCandidateClassName() {
        return this.candidateClassName;
    }

    public QueryGenerator getQueryGenerator() {
        return this.queryGenerator;
    }

    public void setQueryGenerator(QueryGenerator gen) {
        this.queryGenerator = gen;
    }

    public SQLExpressionFactory getSQLExpressionFactory() {
        return this.rdbmsMgr.getSQLExpressionFactory();
    }

    public DatastoreAdapter getDatastoreAdapter() {
        return this.rdbmsMgr.getDatastoreAdapter();
    }

    public SQLStatement getParentStatement() {
        return this.parent;
    }

    public boolean isChildStatementOf(SQLStatement stmt) {
        if (stmt == null || this.parent == null) {
            return false;
        }
        if (stmt == this.parent) {
            return true;
        }
        return this.isChildStatementOf(this.parent);
    }

    public void addExtension(String key, Object value) {
        this.invalidateStatement();
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(key, value);
    }

    public Object getValueForExtension(String key) {
        if (this.extensions == null) {
            return this.extensions;
        }
        return this.extensions.get(key);
    }

    public void union(SQLStatement stmt) {
        this.invalidateStatement();
        if (this.unions == null) {
            this.unions = new ArrayList<SQLStatement>();
        }
        this.unions.add(stmt);
    }

    public int getNumberOfUnions() {
        if (this.unions == null) {
            return 0;
        }
        int number = this.unions.size();
        for (SQLStatement unioned : this.unions) {
            number += unioned.getNumberOfUnions();
        }
        return number;
    }

    public List<SQLStatement> getUnions() {
        return this.unions;
    }

    public boolean allUnionsForSamePrimaryTable() {
        if (this.unions != null) {
            for (SQLStatement unionStmt : this.unions) {
                if (unionStmt.getPrimaryTable().equals(this.primaryTable)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.invalidateStatement();
        this.distinct = distinct;
    }

    public int getNumberOfSelects() {
        return this.selectedItems.size();
    }

    public int[] select(SQLExpression expr, String alias) {
        if (expr == null) {
            throw new NucleusException("Expression to select is null");
        }
        this.invalidateStatement();
        if (expr instanceof AggregateExpression) {
            this.aggregated = true;
        }
        int[] selected = new int[expr.getNumberOfSubExpressions()];
        if (expr.getNumberOfSubExpressions() > 1) {
            for (int i = 0; i < expr.getNumberOfSubExpressions(); ++i) {
                selected[i] = this.selectItem(expr.getSubExpression(i).toSQLText(), alias != null ? alias + i : null);
            }
        } else {
            selected[0] = this.selectItem(expr.toSQLText(), alias);
        }
        if (this.unions != null) {
            for (SQLStatement stmt : this.unions) {
                stmt.select(expr, alias);
            }
        }
        return selected;
    }

    public int[] select(SQLTable table, JavaTypeMapping mapping, String alias, boolean applyToUnions) {
        if (mapping == null) {
            throw new NucleusException("Mapping to select is null");
        }
        if (table == null) {
            table = this.primaryTable;
        }
        if (mapping.getTable() != table.getTable()) {
            throw new NucleusException("Table being selected from (\"" + table.getTable() + "\") is inconsistent with the column selected (\"" + mapping.getTable() + "\")");
        }
        this.invalidateStatement();
        DatastoreMapping[] mappings = mapping.getDatastoreMappings();
        int[] selected = new int[mappings.length];
        for (int i = 0; i < selected.length; ++i) {
            DatastoreIdentifier colAlias = null;
            if (alias != null) {
                String name = selected.length > 1 ? alias + "_" + i : alias;
                colAlias = this.rdbmsMgr.getIdentifierFactory().newColumnIdentifier(name);
            }
            SQLColumn col = new SQLColumn(table, mappings[i].getColumn(), colAlias);
            selected[i] = this.selectItem(new SQLText(col.getColumnSelectString()), alias != null ? colAlias.toString() : null);
        }
        if (applyToUnions && this.unions != null) {
            for (SQLStatement stmt : this.unions) {
                stmt.select(table, mapping, alias);
            }
        }
        return selected;
    }

    public int[] select(SQLTable table, JavaTypeMapping mapping, String alias) {
        return this.select(table, mapping, alias, true);
    }

    public int select(SQLTable table, Column column, String alias) {
        if (column == null) {
            throw new NucleusException("Column to select is null");
        }
        if (table == null) {
            table = this.primaryTable;
        }
        if (column.getTable() != table.getTable()) {
            throw new NucleusException("Table being selected from (\"" + table.getTable() + "\") is inconsistent with the column selected (\"" + column.getTable() + "\")");
        }
        this.invalidateStatement();
        DatastoreIdentifier colAlias = null;
        if (alias != null) {
            colAlias = this.rdbmsMgr.getIdentifierFactory().newColumnIdentifier(alias);
        }
        SQLColumn col = new SQLColumn(table, column, colAlias);
        int position = this.selectItem(new SQLText(col.getColumnSelectString()), alias != null ? colAlias.toString() : null);
        if (this.unions != null) {
            for (SQLStatement stmt : this.unions) {
                stmt.select(table, column, alias);
            }
        }
        return position;
    }

    private int selectItem(SQLText st, String alias) {
        SelectedItem item = new SelectedItem(st, alias);
        if (this.selectedItems.contains(item)) {
            return this.selectedItems.indexOf(item) + 1;
        }
        int numberSelected = this.selectedItems.size();
        for (int i = 0; i < numberSelected; ++i) {
            SelectedItem selectedItem = this.selectedItems.get(i);
            if (!selectedItem.getSQLText().equals(st)) continue;
            return i + 1;
        }
        this.selectedItems.add(item);
        return this.selectedItems.indexOf(item) + 1;
    }

    public void setUpdates(SQLExpression[] exprs) {
        this.invalidateStatement();
        this.updates = exprs;
    }

    public boolean hasUpdates() {
        if (this.updates == null) {
            return false;
        }
        for (int i = 0; i < this.updates.length; ++i) {
            if (this.updates[i] == null) continue;
            return true;
        }
        return false;
    }

    public SQLTable getPrimaryTable() {
        return this.primaryTable;
    }

    public SQLTable getTable(String alias) {
        if (alias.equals(this.primaryTable.alias.getName())) {
            return this.primaryTable;
        }
        if (this.tables != null) {
            return this.tables.get(alias);
        }
        return null;
    }

    public SQLTable getTableForDatastoreContainer(Table table) {
        for (SQLTableGroup grp : this.tableGroups.values()) {
            SQLTable[] tbls = grp.getTables();
            for (int i = 0; i < tbls.length; ++i) {
                if (tbls[i].getTable() != table) continue;
                return tbls[i];
            }
        }
        return null;
    }

    public SQLTable getTable(Table table, String groupName) {
        if (groupName == null) {
            return null;
        }
        SQLTableGroup tableGrp = this.tableGroups.get(groupName);
        if (tableGrp == null) {
            return null;
        }
        SQLTable[] tables = tableGrp.getTables();
        for (int i = 0; i < tables.length; ++i) {
            if (tables[i].getTable() != table) continue;
            return tables[i];
        }
        return null;
    }

    public SQLTableGroup getTableGroup(String groupName) {
        return this.tableGroups.get(groupName);
    }

    public int getNumberOfTableGroups() {
        return this.tableGroups.size();
    }

    public int getNumberOfTables() {
        return this.tables != null ? this.tables.size() : -1;
    }

    public SQLTable innerJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, Object[] discrimValues, String tableGrpName) {
        return this.innerJoin(sourceTable, sourceMapping, null, target, targetAlias, targetMapping, null, discrimValues, tableGrpName);
    }

    public SQLTable innerJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, JavaTypeMapping sourceParentMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, JavaTypeMapping targetParentMapping, Object[] discrimValues, String tableGrpName) {
        this.invalidateStatement();
        if (this.tables == null) {
            this.tables = new HashMap<String, SQLTable>();
        }
        if (tableGrpName == null) {
            tableGrpName = "Group" + this.tableGroups.size();
        }
        if (targetAlias == null) {
            targetAlias = this.generateTableAlias(target, tableGrpName);
        }
        if (sourceTable == null) {
            sourceTable = this.primaryTable;
        }
        DatastoreIdentifier targetId = this.rdbmsMgr.getIdentifierFactory().newTableIdentifier(targetAlias);
        SQLTable targetTbl = new SQLTable(this, target, targetId, tableGrpName);
        this.putSQLTableInGroup(targetTbl, tableGrpName, SQLJoin.JoinType.INNER_JOIN);
        this.join(SQLJoin.JoinType.INNER_JOIN, sourceTable, sourceMapping, sourceParentMapping, targetTbl, targetMapping, targetParentMapping, discrimValues);
        if (this.unions != null) {
            for (SQLStatement stmt : this.unions) {
                stmt.innerJoin(sourceTable, sourceMapping, sourceParentMapping, target, targetAlias, targetMapping, targetParentMapping, discrimValues, tableGrpName);
            }
        }
        return targetTbl;
    }

    public SQLTable leftOuterJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, Object[] discrimValues, String tableGrpName) {
        return this.leftOuterJoin(sourceTable, sourceMapping, null, target, targetAlias, targetMapping, null, discrimValues, tableGrpName);
    }

    public SQLTable leftOuterJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, JavaTypeMapping sourceParentMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, JavaTypeMapping targetParentMapping, Object[] discrimValues, String tableGrpName) {
        this.invalidateStatement();
        if (this.tables == null) {
            this.tables = new HashMap<String, SQLTable>();
        }
        if (tableGrpName == null) {
            tableGrpName = "Group" + this.tableGroups.size();
        }
        if (targetAlias == null) {
            targetAlias = this.generateTableAlias(target, tableGrpName);
        }
        if (sourceTable == null) {
            sourceTable = this.primaryTable;
        }
        DatastoreIdentifier targetId = this.rdbmsMgr.getIdentifierFactory().newTableIdentifier(targetAlias);
        SQLTable targetTbl = new SQLTable(this, target, targetId, tableGrpName);
        this.putSQLTableInGroup(targetTbl, tableGrpName, SQLJoin.JoinType.LEFT_OUTER_JOIN);
        this.join(SQLJoin.JoinType.LEFT_OUTER_JOIN, sourceTable, sourceMapping, sourceParentMapping, targetTbl, targetMapping, targetParentMapping, discrimValues);
        if (this.unions != null) {
            for (SQLStatement stmt : this.unions) {
                stmt.leftOuterJoin(sourceTable, sourceMapping, sourceParentMapping, target, targetAlias, targetMapping, targetParentMapping, discrimValues, tableGrpName);
            }
        }
        return targetTbl;
    }

    public SQLTable rightOuterJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, Object[] discrimValues, String tableGrpName) {
        return this.rightOuterJoin(sourceTable, sourceMapping, null, target, targetAlias, targetMapping, null, discrimValues, tableGrpName);
    }

    public SQLTable rightOuterJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, JavaTypeMapping sourceParentMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, JavaTypeMapping targetParentMapping, Object[] discrimValues, String tableGrpName) {
        this.invalidateStatement();
        if (this.tables == null) {
            this.tables = new HashMap<String, SQLTable>();
        }
        if (tableGrpName == null) {
            tableGrpName = "Group" + this.tableGroups.size();
        }
        if (targetAlias == null) {
            targetAlias = this.generateTableAlias(target, tableGrpName);
        }
        if (sourceTable == null) {
            sourceTable = this.primaryTable;
        }
        DatastoreIdentifier targetId = this.rdbmsMgr.getIdentifierFactory().newTableIdentifier(targetAlias);
        SQLTable targetTbl = new SQLTable(this, target, targetId, tableGrpName);
        this.putSQLTableInGroup(targetTbl, tableGrpName, SQLJoin.JoinType.RIGHT_OUTER_JOIN);
        this.join(SQLJoin.JoinType.RIGHT_OUTER_JOIN, sourceTable, sourceMapping, sourceParentMapping, targetTbl, targetMapping, targetParentMapping, discrimValues);
        if (this.unions != null) {
            for (SQLStatement stmt : this.unions) {
                stmt.rightOuterJoin(sourceTable, sourceMapping, sourceParentMapping, target, targetAlias, targetMapping, targetParentMapping, discrimValues, tableGrpName);
            }
        }
        return targetTbl;
    }

    public SQLTable crossJoin(Table target, String targetAlias, String tableGrpName) {
        this.invalidateStatement();
        if (this.tables == null) {
            this.tables = new HashMap<String, SQLTable>();
        }
        if (tableGrpName == null) {
            tableGrpName = "Group" + this.tableGroups.size();
        }
        if (targetAlias == null) {
            targetAlias = this.generateTableAlias(target, tableGrpName);
        }
        DatastoreIdentifier targetId = this.rdbmsMgr.getIdentifierFactory().newTableIdentifier(targetAlias);
        SQLTable targetTbl = new SQLTable(this, target, targetId, tableGrpName);
        this.putSQLTableInGroup(targetTbl, tableGrpName, SQLJoin.JoinType.CROSS_JOIN);
        this.join(SQLJoin.JoinType.CROSS_JOIN, this.primaryTable, null, null, targetTbl, null, null, null);
        if (this.unions != null) {
            for (SQLStatement stmt : this.unions) {
                stmt.crossJoin(target, targetAlias, tableGrpName);
            }
        }
        return targetTbl;
    }

    public SQLJoin.JoinType getJoinTypeForTable(SQLTable sqlTbl) {
        if (this.joins == null) {
            return null;
        }
        for (SQLJoin join : this.joins) {
            if (!join.getTable().equals(sqlTbl)) continue;
            return join.getType();
        }
        return null;
    }

    public SQLJoin getJoinForTable(SQLTable sqlTbl) {
        if (this.joins == null) {
            return null;
        }
        for (SQLJoin join : this.joins) {
            if (!join.getTable().equals(sqlTbl)) continue;
            return join;
        }
        return null;
    }

    public String removeCrossJoin(SQLTable targetSqlTbl) {
        if (this.joins == null) {
            return null;
        }
        Iterator<SQLJoin> joinIter = this.joins.iterator();
        while (joinIter.hasNext()) {
            SQLJoin join = joinIter.next();
            if (!join.getTable().equals(targetSqlTbl) || join.getType() != SQLJoin.JoinType.CROSS_JOIN) continue;
            joinIter.remove();
            this.requiresJoinReorder = true;
            this.tables.remove(join.getTable().alias.getName());
            String removedAliasName = join.getTable().alias.getName();
            if (this.unions != null) {
                for (SQLStatement stmt : this.unions) {
                    stmt.removeCrossJoin(targetSqlTbl);
                }
            }
            return removedAliasName;
        }
        return null;
    }

    private void putSQLTableInGroup(SQLTable sqlTbl, String groupName, SQLJoin.JoinType joinType) {
        SQLTableGroup tableGrp = this.tableGroups.get(groupName);
        if (tableGrp == null) {
            tableGrp = new SQLTableGroup(groupName, joinType);
        }
        tableGrp.addTable(sqlTbl);
        this.tableGroups.put(groupName, tableGrp);
    }

    protected void join(SQLJoin.JoinType joinType, SQLTable sourceTable, JavaTypeMapping sourceMapping, JavaTypeMapping sourceParentMapping, SQLTable targetTable, JavaTypeMapping targetMapping, JavaTypeMapping targetParentMapping, Object[] discrimValues) {
        if (this.tables == null) {
            throw new NucleusException("tables not set in statement!");
        }
        if (this.tables.containsValue(targetTable)) {
            NucleusLogger.DATASTORE.debug((Object)("Attempt to join to " + targetTable + " but join already exists"));
            return;
        }
        this.tables.put(targetTable.alias.getName(), targetTable);
        BooleanExpression joinCondition = this.getJoinConditionForJoin(sourceTable, sourceMapping, sourceParentMapping, targetTable, targetMapping, targetParentMapping, discrimValues);
        if (this.rdbmsMgr.getDatastoreAdapter().supportsOption("ANSI_Join_Syntax")) {
            SQLJoin join = new SQLJoin(joinType, targetTable, sourceTable, joinCondition);
            if (this.joins == null) {
                this.joins = new ArrayList<SQLJoin>();
            }
            int position = -1;
            if (this.queryGenerator != null && this.queryGenerator.processingOnClause()) {
                if (this.primaryTable == sourceTable) {
                    if (this.joins.size() > 0) {
                        position = 0;
                    }
                } else {
                    int i = 1;
                    for (SQLJoin sqlJoin : this.joins) {
                        if (sqlJoin.getJoinedTable() == sourceTable) {
                            position = i;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (position >= 0) {
                this.joins.add(position, join);
            } else {
                this.joins.add(join);
            }
        } else {
            SQLJoin join = new SQLJoin(SQLJoin.JoinType.NON_ANSI_JOIN, targetTable, sourceTable, null);
            if (this.joins == null) {
                this.joins = new ArrayList<SQLJoin>();
            }
            this.joins.add(join);
            this.whereAnd(joinCondition, false);
        }
    }

    protected BooleanExpression getJoinConditionForJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, JavaTypeMapping sourceParentMapping, SQLTable targetTable, JavaTypeMapping targetMapping, JavaTypeMapping targetParentMapping, Object[] discrimValues) {
        BooleanExpression joinCondition = null;
        if (sourceMapping != null && targetMapping != null) {
            if (sourceMapping.getNumberOfDatastoreMappings() != targetMapping.getNumberOfDatastoreMappings()) {
                throw new NucleusException("Cannot join from " + sourceMapping + " to " + targetMapping + " since they have different numbers of datastore columns!");
            }
            SQLExpressionFactory factory = this.rdbmsMgr.getSQLExpressionFactory();
            SQLExpression sourceExpr = null;
            sourceExpr = sourceParentMapping == null ? factory.newExpression(this, sourceTable != null ? sourceTable : this.primaryTable, sourceMapping) : factory.newExpression(this, sourceTable != null ? sourceTable : this.primaryTable, sourceMapping, sourceParentMapping);
            SQLExpression targetExpr = null;
            targetExpr = targetParentMapping == null ? factory.newExpression(this, targetTable, targetMapping) : factory.newExpression(this, targetTable, targetMapping, targetParentMapping);
            joinCondition = sourceExpr.eq(targetExpr);
            JavaTypeMapping discrimMapping = targetTable.getTable().getDiscriminatorMapping(false);
            if (discrimMapping != null && discrimValues != null) {
                SQLExpression discrimExpr = factory.newExpression(this, targetTable, discrimMapping);
                SQLExpression discrimCondition = null;
                for (int i = 0; i < discrimValues.length; ++i) {
                    SQLExpression discrimVal = factory.newLiteral(this, discrimMapping, discrimValues[i]);
                    BooleanExpression condition = discrimExpr.eq(discrimVal);
                    discrimCondition = discrimCondition == null ? condition : ((BooleanExpression)discrimCondition).ior(condition);
                }
                if (discrimCondition != null) {
                    discrimCondition.encloseInParentheses();
                    joinCondition = joinCondition.and(discrimCondition);
                }
            }
        }
        return joinCondition;
    }

    protected synchronized String generateTableAlias(Table tbl, String groupName) {
        SQLTableNamer namer;
        String namingSchema = null;
        if (this.extensions != null) {
            namingSchema = (String)this.extensions.get("datanucleus.sqlTableNamingStrategy");
        }
        if (namingSchema == null) {
            namingSchema = "alpha-scheme";
        }
        if ((namer = tableNamerByName.get(namingSchema)) == null) {
            try {
                namer = (SQLTableNamer)this.rdbmsMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.sql_tablenamer", "name", namingSchema, "class", null, null);
            }
            catch (Exception e) {
                throw new NucleusException("Attempt to find/instantiate SQL table namer " + namingSchema + " threw an exception", (Throwable)e);
            }
            tableNamerByName.put(namingSchema, namer);
        }
        return namer.getAliasForTable(this, tbl, groupName);
    }

    public void whereAnd(BooleanExpression expr, boolean applyToUnions) {
        this.invalidateStatement();
        if (expr instanceof BooleanLiteral && !expr.isParameter() && ((Boolean)((BooleanLiteral)expr).getValue()).booleanValue()) {
            return;
        }
        this.where = this.where == null ? expr : this.where.and(expr);
        if (this.unions != null && applyToUnions) {
            for (SQLStatement stmt : this.unions) {
                stmt.whereAnd(expr, true);
            }
        }
    }

    public void whereOr(BooleanExpression expr, boolean applyToUnions) {
        this.invalidateStatement();
        this.where = this.where == null ? expr : this.where.ior(expr);
        if (this.unions != null && applyToUnions) {
            for (SQLStatement stmt : this.unions) {
                stmt.whereOr(expr, true);
            }
        }
    }

    public void addGroupingExpression(SQLExpression expr) {
        this.invalidateStatement();
        if (this.groupingExpressions == null) {
            this.groupingExpressions = new ArrayList<SQLExpression>();
        }
        this.groupingExpressions.add(expr);
        this.aggregated = true;
        if (this.unions != null) {
            Iterator<SQLStatement> i = this.unions.iterator();
            while (i.hasNext()) {
                i.next().addGroupingExpression(expr);
            }
        }
    }

    public void setHaving(BooleanExpression expr) {
        this.invalidateStatement();
        this.having = expr;
        this.aggregated = true;
        if (this.unions != null) {
            Iterator<SQLStatement> i = this.unions.iterator();
            while (i.hasNext()) {
                i.next().setHaving(expr);
            }
        }
    }

    public void setOrdering(SQLExpression[] exprs, boolean[] descending) {
        this.setOrdering(exprs, descending, null);
    }

    public void setOrdering(SQLExpression[] exprs, boolean[] descending, String[] nullOrders) {
        if (exprs != null && descending != null && exprs.length != descending.length) {
            throw new NucleusException(Localiser.msg((String)"052503", (Object[])new Object[]{"" + exprs.length, "" + descending.length})).setFatal();
        }
        this.invalidateStatement();
        this.orderingExpressions = exprs;
        this.orderingDirections = descending;
        this.orderNullDirectives = nullOrders;
    }

    public void setRange(long offset, long count) {
        this.invalidateStatement();
        this.rangeOffset = offset;
        this.rangeCount = count;
    }

    public synchronized SQLText getSelectStatement() {
        String limitClause;
        SQLText orderStmt;
        if (this.sql != null) {
            return this.sql;
        }
        DatastoreAdapter dba = this.getDatastoreAdapter();
        boolean lock = false;
        Boolean val = (Boolean)this.getValueForExtension("lock-for-update");
        if (val != null) {
            lock = val;
        }
        boolean addAliasToAllSelects = false;
        if ((this.rangeOffset > 0L || this.rangeCount > -1L) && dba.getRangeByRowNumberColumn2().length() > 0) {
            addAliasToAllSelects = true;
        }
        this.sql = new SQLText("SELECT ");
        if (this.distinct) {
            this.sql.append("DISTINCT ");
        }
        this.addOrderingColumnsToSelect();
        if (this.selectedItems.isEmpty()) {
            this.sql.append("*");
        } else {
            int autoAliasNum = 0;
            Iterator<SelectedItem> selectItemIter = this.selectedItems.iterator();
            while (selectItemIter.hasNext()) {
                SelectedItem selectedItem = selectItemIter.next();
                SQLText selectedST = selectedItem.getSQLText();
                this.sql.append(selectedST);
                if (selectedItem.getAlias() != null) {
                    this.sql.append(" AS " + selectedItem.getAlias());
                } else if (addAliasToAllSelects) {
                    this.sql.append(" AS DN_" + autoAliasNum);
                    ++autoAliasNum;
                }
                if (!selectItemIter.hasNext()) continue;
                this.sql.append(',');
            }
            if ((this.rangeOffset > -1L || this.rangeCount > -1L) && dba.getRangeByRowNumberColumn().length() > 0) {
                this.sql.append(',').append(dba.getRangeByRowNumberColumn()).append(" rn");
            }
        }
        this.sql.append(" FROM ");
        this.sql.append(this.primaryTable.toString());
        if (lock && dba.supportsOption("LockOptionAfterFromClause")) {
            this.sql.append(" WITH ").append(dba.getSelectWithLockOption());
        }
        if (this.joins != null) {
            this.sql.append(this.getSqlForJoins(lock));
        }
        if (this.where != null) {
            this.sql.append(" WHERE ").append(this.where.toSQLText());
        }
        if (this.groupingExpressions != null) {
            ArrayList<String> groupBy = new ArrayList<String>();
            for (SQLExpression expr : this.groupingExpressions) {
                String exprText = expr.toSQLText().toSQL();
                if (groupBy.contains(exprText)) continue;
                groupBy.add(exprText);
            }
            if (groupBy.size() > 0 && this.aggregated) {
                this.sql.append(" GROUP BY ");
                for (int i = 0; i < groupBy.size(); ++i) {
                    if (i > 0) {
                        this.sql.append(',');
                    }
                    this.sql.append((String)groupBy.get(i));
                }
            }
        }
        if (this.having != null) {
            this.sql.append(" HAVING ").append(this.having.toSQLText());
        }
        if (this.unions != null) {
            if (!dba.supportsOption("Union_Syntax")) {
                throw new NucleusException(Localiser.msg((String)"052504", (Object[])new Object[]{"UNION"})).setFatal();
            }
            Iterator<SQLStatement> unionIter = this.unions.iterator();
            while (unionIter.hasNext()) {
                if (dba.supportsOption("UseUnionAll")) {
                    this.sql.append(" UNION ALL ");
                } else {
                    this.sql.append(" UNION ");
                }
                SQLStatement stmt = unionIter.next();
                SQLText unionSql = stmt.getSelectStatement();
                this.sql.append(unionSql);
            }
        }
        if ((orderStmt = this.generateOrderingStatement()) != null) {
            this.sql.append(" ORDER BY ").append(orderStmt);
        }
        if ((this.rangeOffset > -1L || this.rangeCount > -1L) && (limitClause = dba.getRangeByLimitEndOfStatementClause(this.rangeOffset, this.rangeCount)).length() > 0) {
            this.sql.append(" ").append(limitClause);
        }
        if (lock && dba.supportsOption("LockWithSelectForUpdate")) {
            if (this.distinct && !dba.supportsOption("DistinctWithSelectForUpdate")) {
                NucleusLogger.QUERY.warn((Object)Localiser.msg((String)"052502"));
            } else if (this.groupingExpressions != null && !dba.supportsOption("GroupingWithSelectForUpdate")) {
                NucleusLogger.QUERY.warn((Object)Localiser.msg((String)"052506"));
            } else if (this.having != null && !dba.supportsOption("HavingWithSelectForUpdate")) {
                NucleusLogger.QUERY.warn((Object)Localiser.msg((String)"052507"));
            } else if (this.orderingExpressions != null && !dba.supportsOption("OrderingWithSelectForUpdate")) {
                NucleusLogger.QUERY.warn((Object)Localiser.msg((String)"052508"));
            } else if (this.joins != null && !this.joins.isEmpty() && !dba.supportsOption("MultipleTablesWithSelectForUpdate")) {
                NucleusLogger.QUERY.warn((Object)Localiser.msg((String)"052509"));
            } else {
                Boolean nowait;
                this.sql.append(" " + dba.getSelectForUpdateText());
                if (dba.supportsOption("SelectForUpdateNoWait") && (nowait = (Boolean)this.getValueForExtension("for-update-nowait")) != null) {
                    this.sql.append(" NOWAIT");
                }
            }
        }
        if (lock && !dba.supportsOption("LockWithSelectForUpdate") && !dba.supportsOption("LockOptionAfterFromClause") && !dba.supportsOption("LockOptionWithinJoinClause")) {
            NucleusLogger.QUERY.warn((Object)"Requested locking of query statement, but this RDBMS doesn't support a convenient mechanism");
        }
        if (this.rangeOffset > 0L || this.rangeCount > -1L) {
            SQLText userSql;
            if (dba.getRangeByRowNumberColumn2().length() > 0) {
                userSql = this.sql;
                SQLText innerSql = new SQLText("SELECT subq.*");
                innerSql.append(',').append(dba.getRangeByRowNumberColumn2()).append(" rn");
                innerSql.append(" FROM (").append(userSql).append(") subq ");
                SQLText outerSql = new SQLText("SELECT * FROM (").append(innerSql).append(") ");
                outerSql.append("WHERE ");
                if (this.rangeOffset > 0L) {
                    outerSql.append("rn > " + this.rangeOffset);
                    if (this.rangeCount > -1L) {
                        outerSql.append(" AND rn <= " + (this.rangeCount + this.rangeOffset));
                    }
                } else {
                    outerSql.append(" rn <= " + this.rangeCount);
                }
                this.sql = outerSql;
            } else if (dba.getRangeByRowNumberColumn().length() > 0) {
                userSql = this.sql;
                this.sql = new SQLText("SELECT ");
                Iterator<SelectedItem> selectedItemIter = this.selectedItems.iterator();
                while (selectedItemIter.hasNext()) {
                    SelectedItem selectedItemExpr = selectedItemIter.next();
                    this.sql.append("subq.");
                    String selectedCol = selectedItemExpr.getSQLText().toSQL();
                    if (selectedItemExpr.getAlias() != null) {
                        selectedCol = selectedItemExpr.getAlias();
                    } else {
                        int dotIndex = selectedCol.indexOf(".");
                        if (dotIndex > 0) {
                            selectedCol = selectedCol.substring(dotIndex + 1);
                        }
                    }
                    this.sql.append(selectedCol);
                    if (!selectedItemIter.hasNext()) continue;
                    this.sql.append(',');
                }
                this.sql.append(" FROM (").append(userSql).append(") subq WHERE ");
                if (this.rangeOffset > 0L) {
                    this.sql.append("subq.rn").append(">").append("" + this.rangeOffset);
                }
                if (this.rangeCount > 0L) {
                    if (this.rangeOffset > 0L) {
                        this.sql.append(" AND ");
                    }
                    this.sql.append("subq.rn").append("<=").append("" + (this.rangeCount + this.rangeOffset));
                }
            }
        }
        return this.sql;
    }

    private void reorderJoins(List knownJoins, List joinsToAdd) {
        if (joinsToAdd == null) {
            this.requiresJoinReorder = false;
            return;
        }
        while (joinsToAdd.size() > 0) {
            Iterator joinIter = joinsToAdd.iterator();
            int origSize = joinsToAdd.size();
            while (joinIter.hasNext()) {
                SQLJoin join = (SQLJoin)joinIter.next();
                if (join.getType() == SQLJoin.JoinType.CROSS_JOIN) {
                    knownJoins.add(join);
                    joinIter.remove();
                    continue;
                }
                if (join.getType() == SQLJoin.JoinType.NON_ANSI_JOIN) {
                    knownJoins.add(join);
                    joinIter.remove();
                    continue;
                }
                if (join.getJoinedTable().equals(this.primaryTable)) {
                    knownJoins.add(join);
                    joinIter.remove();
                    continue;
                }
                Iterator knownJoinIter = knownJoins.iterator();
                boolean valid = false;
                while (knownJoinIter.hasNext()) {
                    SQLJoin currentJoin = (SQLJoin)knownJoinIter.next();
                    if (!join.getJoinedTable().equals(currentJoin.getTable())) continue;
                    valid = true;
                    break;
                }
                if (!valid) continue;
                knownJoins.add(join);
                joinIter.remove();
            }
            if (joinsToAdd.size() != origSize) continue;
            throw new NucleusException("Unable to reorder joins for SQL statement since circular! Consider reordering the components in the WHERE clause : affected joins - " + StringUtils.collectionToString((Collection)joinsToAdd));
        }
        this.requiresJoinReorder = false;
    }

    private SQLText getSqlForJoins(boolean lock) {
        SQLText sql = new SQLText();
        DatastoreAdapter dba = this.getDatastoreAdapter();
        if (this.requiresJoinReorder) {
            ArrayList<SQLJoin> theJoins = new ArrayList<SQLJoin>(this.joins.size());
            this.reorderJoins(theJoins, this.joins);
            this.joins = theJoins;
        }
        for (SQLJoin join : this.joins) {
            if (join.getType() == SQLJoin.JoinType.CROSS_JOIN) {
                if (dba.supportsOption("ANSI_CrossJoin_Syntax")) {
                    sql.append(" ").append(join.toSQLText(dba, lock));
                    continue;
                }
                if (dba.supportsOption("ANSI_CrossJoinAsInner11_Syntax")) {
                    sql.append(" INNER JOIN " + join.getTable() + " ON 1=1");
                    continue;
                }
                sql.append(",").append(join.getTable().toString());
                continue;
            }
            if (dba.supportsOption("ANSI_Join_Syntax")) {
                sql.append(" ").append(join.toSQLText(dba, lock));
                continue;
            }
            sql.append(",").append(join.toSQLText(dba, lock));
        }
        return sql;
    }

    public synchronized SQLText getUpdateStatement() {
        if (this.sql != null) {
            return this.sql;
        }
        SQLText setSQL = new SQLText("SET ");
        if (this.updates != null && this.updates.length > 0) {
            for (int i = 0; i < this.updates.length; ++i) {
                if (this.updates[i] == null) continue;
                if (i != 0) {
                    setSQL.append(",");
                }
                setSQL.append(this.updates[i].toSQLText());
            }
        }
        this.sql = this.rdbmsMgr.getDatastoreAdapter().getUpdateTableStatement(this.primaryTable, setSQL);
        if (this.joins != null) {
            Iterator<SQLJoin> joinIter = this.joins.iterator();
            SQLJoin subJoin = joinIter.next();
            SQLStatement subStmt = new SQLStatement(this, this.rdbmsMgr, subJoin.getTable().getTable(), subJoin.getTable().getAlias(), subJoin.getTable().getGroupName());
            subStmt.whereAnd(subJoin.getCondition(), false);
            if (this.where != null) {
                subStmt.whereAnd(this.where, false);
            }
            while (joinIter.hasNext()) {
                SQLJoin join = joinIter.next();
                subStmt.joins.add(join);
            }
            BooleanSubqueryExpression existsExpr = new BooleanSubqueryExpression(this, "EXISTS", subStmt);
            this.where = existsExpr;
        }
        if (this.where != null) {
            this.sql.append(" WHERE ").append(this.where.toSQLText());
        }
        return this.sql;
    }

    public synchronized SQLText getDeleteStatement() {
        if (this.sql != null) {
            return this.sql;
        }
        this.sql = new SQLText(this.rdbmsMgr.getDatastoreAdapter().getDeleteTableStatement(this.primaryTable));
        if (this.joins != null) {
            Iterator<SQLJoin> joinIter = this.joins.iterator();
            SQLJoin subJoin = joinIter.next();
            SQLStatement subStmt = new SQLStatement(this, this.rdbmsMgr, subJoin.getTable().getTable(), subJoin.getTable().getAlias(), subJoin.getTable().getGroupName());
            subStmt.whereAnd(subJoin.getCondition(), false);
            if (this.where != null) {
                subStmt.whereAnd(this.where, false);
            }
            while (joinIter.hasNext()) {
                SQLJoin join = joinIter.next();
                subStmt.joins.add(join);
            }
            BooleanSubqueryExpression existsExpr = new BooleanSubqueryExpression(this, "EXISTS", subStmt);
            this.where = existsExpr;
        }
        if (this.where != null) {
            this.sql.append(" WHERE ").append(this.where.toSQLText());
        }
        return this.sql;
    }

    protected SQLText generateOrderingStatement() {
        SQLText orderStmt;
        block18: {
            orderStmt = null;
            if (this.orderingExpressions == null || this.orderingExpressions.length <= 0) break block18;
            DatastoreAdapter dba = this.getDatastoreAdapter();
            if (dba.supportsOption("OrderByUsingSelectColumnIndex")) {
                orderStmt = new SQLText();
                for (int i = 0; i < this.orderingExpressions.length; ++i) {
                    if (i > 0) {
                        orderStmt.append(',');
                    }
                    orderStmt.append(Integer.toString(this.orderingColumnIndexes[i]));
                    if (this.orderingDirections[i]) {
                        orderStmt.append(" DESC");
                    }
                    if (this.orderNullDirectives == null || this.orderNullDirectives[i] == null) continue;
                    orderStmt.append(" " + this.orderNullDirectives[i]);
                }
            } else {
                orderStmt = new SQLText();
                boolean needsSelect = dba.supportsOption("IncludeOrderByColumnsInSelect");
                if (this.parent != null) {
                    needsSelect = false;
                }
                for (int i = 0; i < this.orderingExpressions.length; ++i) {
                    if (i > 0) {
                        orderStmt.append(',');
                    }
                    if (needsSelect && !this.aggregated) {
                        if (this.orderingExpressions[i] instanceof ResultAliasExpression) {
                            orderStmt.append(dba.getOrderString((StoreManager)this.rdbmsMgr, ((ResultAliasExpression)this.orderingExpressions[i]).getResultAlias(), this.orderingExpressions[i]));
                        } else {
                            String orderString = "NUCORDER" + i;
                            if (this.orderingExpressions[i].getNumberOfSubExpressions() == 1) {
                                orderStmt.append(dba.getOrderString((StoreManager)this.rdbmsMgr, orderString, this.orderingExpressions[i]));
                            } else {
                                DatastoreMapping[] mappings = this.orderingExpressions[i].getJavaTypeMapping().getDatastoreMappings();
                                for (int j = 0; j < mappings.length; ++j) {
                                    String alias = orderString + "_" + j;
                                    orderStmt.append(dba.getOrderString((StoreManager)this.rdbmsMgr, alias, this.orderingExpressions[i]));
                                    if (j >= mappings.length - 1) continue;
                                    orderStmt.append(',');
                                }
                            }
                        }
                    } else if (this.orderingExpressions[i] instanceof ResultAliasExpression) {
                        orderStmt.append(dba.getOrderString((StoreManager)this.rdbmsMgr, ((ResultAliasExpression)this.orderingExpressions[i]).getResultAlias(), this.orderingExpressions[i]));
                    } else {
                        orderStmt.append(dba.getOrderString((StoreManager)this.rdbmsMgr, this.orderingExpressions[i].toSQLText().toSQL(), this.orderingExpressions[i]));
                    }
                    if (this.orderingDirections[i]) {
                        orderStmt.append(" DESC");
                    }
                    if (this.orderNullDirectives == null || this.orderNullDirectives[i] == null) continue;
                    orderStmt.append(" " + this.orderNullDirectives[i]);
                }
            }
        }
        return orderStmt;
    }

    protected void addOrderingColumnsToSelect() {
        block8: {
            DatastoreAdapter dba;
            block9: {
                if (this.orderingExpressions == null || this.parent != null) break block8;
                dba = this.getDatastoreAdapter();
                if (!dba.supportsOption("OrderByUsingSelectColumnIndex")) break block9;
                this.orderingColumnIndexes = new int[this.orderingExpressions.length];
                for (int i = 0; i < this.orderingExpressions.length; ++i) {
                    this.orderingColumnIndexes[i] = this.selectItem(this.orderingExpressions[i].toSQLText(), null);
                    if (this.unions == null) continue;
                    for (SQLStatement stmt : this.unions) {
                        stmt.selectItem(this.orderingExpressions[i].toSQLText(), null);
                    }
                }
                break block8;
            }
            if (!dba.supportsOption("IncludeOrderByColumnsInSelect")) break block8;
            for (int i = 0; i < this.orderingExpressions.length; ++i) {
                String orderExprAlias = "NUCORDER" + i;
                if (this.orderingExpressions[i] instanceof ResultAliasExpression) continue;
                if (this.orderingExpressions[i].getNumberOfSubExpressions() == 1 || this.aggregated) {
                    if (this.unions != null) {
                        for (SQLStatement stmt : this.unions) {
                            stmt.selectItem(this.orderingExpressions[i].toSQLText(), this.aggregated ? null : orderExprAlias);
                        }
                    }
                    this.selectItem(this.orderingExpressions[i].toSQLText(), this.aggregated ? null : orderExprAlias);
                    continue;
                }
                JavaTypeMapping m = this.orderingExpressions[i].getJavaTypeMapping();
                DatastoreMapping[] mappings = m.getDatastoreMappings();
                for (int j = 0; j < mappings.length; ++j) {
                    String alias = orderExprAlias + "_" + j;
                    DatastoreIdentifier aliasId = this.rdbmsMgr.getIdentifierFactory().newColumnIdentifier(alias);
                    SQLColumn col = new SQLColumn(this.orderingExpressions[i].getSQLTable(), mappings[j].getColumn(), aliasId);
                    this.selectItem(new SQLText(col.getColumnSelectString()), alias);
                    if (this.unions == null) continue;
                    for (SQLStatement stmt : this.unions) {
                        stmt.selectItem(new SQLText(col.getColumnSelectString()), alias);
                    }
                }
            }
        }
    }

    protected void invalidateStatement() {
        this.sql = null;
    }

    public void log(NucleusLogger logger) {
        if (this.updates != null) {
            logger.debug((Object)("SQLStatement : " + this.getUpdateStatement().toSQL()));
        } else {
            logger.debug((Object)("SQLStatement : " + this.getSelectStatement().toSQL()));
        }
        for (String grpName : this.tableGroups.keySet()) {
            logger.debug((Object)("SQLStatement : TableGroup=" + this.tableGroups.get(grpName)));
        }
    }

    protected class SelectedItem {
        SQLText sqlText;
        String alias;

        public SelectedItem(SQLText st, String alias) {
            this.sqlText = st;
            this.alias = alias;
        }

        public SQLText getSQLText() {
            return this.sqlText;
        }

        public String getAlias() {
            return this.alias;
        }

        public int hashCode() {
            return this.sqlText.hashCode() ^ (this.alias != null ? this.alias.hashCode() : 0);
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof SelectedItem)) {
                return false;
            }
            SelectedItem otherItem = (SelectedItem)other;
            if (!this.sqlText.equals(otherItem.sqlText)) {
                return false;
            }
            return (this.alias == null || this.alias.equals(otherItem.alias)) && (otherItem.alias == null || otherItem.alias.equals(this.alias));
        }
    }
}

