/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.query.AbstractQueryResultIterator;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.store.rdbms.query.ResultObjectFactory;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public final class ForwardQueryResult<E>
extends AbstractRDBMSQueryResult<E>
implements Serializable {
    protected boolean moreResultSetRows;
    protected List<E> resultObjs = new ArrayList();
    protected List resultIds = null;
    private Collection candidates;
    private boolean applyRangeChecks = false;

    public ForwardQueryResult(Query query, ResultObjectFactory<E> rof, ResultSet rs, Collection candidates) throws SQLException {
        super(query, rof, rs);
        if (query.useResultsCaching()) {
            this.resultIds = new ArrayList();
        }
        boolean bl = this.applyRangeChecks = !query.processesRangeInDatastoreQuery();
        if (candidates != null) {
            this.candidates = new ArrayList(candidates);
        }
    }

    @Override
    public void initialise() throws SQLException {
        this.moreResultSetRows = this.rs.next();
        if (this.applyRangeChecks) {
            int i = 0;
            while ((long)i < this.query.getRangeFromIncl()) {
                this.moreResultSetRows = this.rs.next();
                if (!this.moreResultSetRows) break;
                ++i;
            }
        }
        int fetchSize = this.query.getFetchPlan().getFetchSize();
        if (!this.moreResultSetRows) {
            this.closeResults();
        } else if (fetchSize == -1) {
            this.advanceToEndOfResultSet();
        } else if (fetchSize > 0) {
            this.processNumberOfResults(fetchSize);
        }
    }

    private void processNumberOfResults(int number) {
        Iterator<E> iter = this.iterator();
        if (number < 0) {
            while (iter.hasNext()) {
                iter.next();
            }
        } else {
            for (int i = 0; i < number; ++i) {
                if (!iter.hasNext()) continue;
                iter.next();
            }
        }
    }

    private void advanceToEndOfResultSet() {
        this.processNumberOfResults(-1);
    }

    protected E nextResultSetElement() {
        Map memberValues;
        if (this.rof == null) {
            return null;
        }
        ExecutionContext ec = this.query.getExecutionContext();
        Object nextElement = this.rof.getObject(ec, this.rs);
        JDBCUtils.logWarnings(this.rs);
        this.resultObjs.add(nextElement);
        if (this.resultIds != null) {
            this.resultIds.add(this.api.getIdForObject(nextElement));
        }
        if (this.bulkLoadedValueByMemberNumber != null && (memberValues = (Map)this.bulkLoadedValueByMemberNumber.get(this.api.getIdForObject(nextElement))) != null) {
            ObjectProvider op = ec.findObjectProvider(nextElement);
            for (Map.Entry memberValueEntry : memberValues.entrySet()) {
                op.replaceField(((Integer)memberValueEntry.getKey()).intValue(), memberValueEntry.getValue());
            }
            op.replaceAllLoadedSCOFieldsWithWrappers();
        }
        if (this.rs == null) {
            throw new NucleusUserException("Results for query have already been closed. Perhaps you called flush(), closed the query, or ended a transaction");
        }
        try {
            this.moreResultSetRows = this.rs.next();
            if (this.applyRangeChecks) {
                int maxElements = (int)(this.query.getRangeToExcl() - this.query.getRangeFromIncl());
                if (this.resultObjs.size() == maxElements) {
                    this.moreResultSetRows = false;
                }
            }
            if (!this.moreResultSetRows) {
                this.closeResults();
            }
        }
        catch (SQLException e) {
            throw this.api.getDataStoreExceptionForException(Localiser.msg((String)"052601", (Object[])new Object[]{e.getMessage()}), (Exception)e);
        }
        return (E)nextElement;
    }

    @Override
    protected void closeResults() {
        super.closeResults();
        if (this.resultIds != null) {
            this.query.getQueryManager().addQueryResult(this.query, this.query.getInputParameters(), this.resultIds);
            this.resultIds = null;
        }
    }

    @Override
    public synchronized void close() {
        this.moreResultSetRows = false;
        this.resultObjs.clear();
        if (this.resultIds != null) {
            this.resultIds.clear();
        }
        super.close();
    }

    protected void closingConnection() {
        if (this.loadResultsAtCommit && this.isOpen() && this.moreResultSetRows) {
            NucleusLogger.QUERY.info((Object)Localiser.msg((String)"052606", (Object[])new Object[]{this.query.toString()}));
            try {
                this.advanceToEndOfResultSet();
            }
            catch (RuntimeException re) {
                if (re instanceof NucleusUserException) {
                    NucleusLogger.QUERY.warn((Object)("Exception thrown while loading remaining rows of query : " + re.getMessage()));
                }
                throw this.api.getUserExceptionForException("Exception thrown while loading remaining rows of query", (Exception)re);
            }
        }
    }

    public Iterator<E> iterator() {
        return new QueryResultIterator();
    }

    public ListIterator<E> listIterator() {
        return new QueryResultIterator();
    }

    public synchronized boolean contains(Object o) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.contains(o);
    }

    public synchronized boolean containsAll(Collection c) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof ForwardQueryResult)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public synchronized E get(int index) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        if (index < 0 || index >= this.resultObjs.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.resultObjs.get(index);
    }

    public synchronized boolean isEmpty() {
        this.assertIsOpen();
        return this.resultObjs.isEmpty() && !this.moreResultSetRows;
    }

    protected int getSizeUsingMethod() {
        if (this.resultSizeMethod.equalsIgnoreCase("LAST")) {
            this.advanceToEndOfResultSet();
            return this.resultObjs.size();
        }
        return super.getSizeUsingMethod();
    }

    public synchronized Object[] toArray() {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.toArray(a);
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.disconnect();
        return new ArrayList<E>(this.resultObjs);
    }

    private class QueryResultIterator
    extends AbstractQueryResultIterator<E> {
        private int nextRowNum = 0;
        E currentElement = null;

        private QueryResultIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            ForwardQueryResult forwardQueryResult = ForwardQueryResult.this;
            synchronized (forwardQueryResult) {
                int maxElements;
                if (!ForwardQueryResult.this.isOpen()) {
                    return false;
                }
                if (ForwardQueryResult.this.applyRangeChecks && this.nextRowNum == (maxElements = (int)(ForwardQueryResult.this.query.getRangeToExcl() - ForwardQueryResult.this.query.getRangeFromIncl()))) {
                    ForwardQueryResult.this.moreResultSetRows = false;
                    ForwardQueryResult.this.closeResults();
                    return false;
                }
                if (this.nextRowNum < ForwardQueryResult.this.resultObjs.size()) {
                    return true;
                }
                if (ForwardQueryResult.this.candidates != null && this.currentElement != null && !ForwardQueryResult.this.moreResultSetRows) {
                    return ForwardQueryResult.this.candidates.contains(this.currentElement);
                }
                return ForwardQueryResult.this.moreResultSetRows;
            }
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public E next() {
            ForwardQueryResult forwardQueryResult = ForwardQueryResult.this;
            synchronized (forwardQueryResult) {
                if (!ForwardQueryResult.this.isOpen()) {
                    throw new NoSuchElementException(Localiser.msg((String)"052600"));
                }
                if (ForwardQueryResult.this.candidates != null && this.currentElement != null && ForwardQueryResult.this.candidates.remove(this.currentElement)) {
                    ForwardQueryResult.this.resultObjs.add(this.currentElement);
                    return this.currentElement;
                }
                if (this.nextRowNum < ForwardQueryResult.this.resultObjs.size()) {
                    this.currentElement = ForwardQueryResult.this.resultObjs.get(this.nextRowNum);
                    ++this.nextRowNum;
                    return this.currentElement;
                }
                if (ForwardQueryResult.this.moreResultSetRows) {
                    this.currentElement = ForwardQueryResult.this.nextResultSetElement();
                    ++this.nextRowNum;
                    if (ForwardQueryResult.this.candidates != null) {
                        ForwardQueryResult.this.candidates.remove(this.currentElement);
                    }
                    return this.currentElement;
                }
                throw new NoSuchElementException(Localiser.msg((String)"052602"));
            }
        }

        public int nextIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public E previous() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public int previousIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }
}

