/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.StatementClassMapping;
import org.datanucleus.store.rdbms.mapping.StatementMappingIndex;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ResultMetaDataROF
implements ResultObjectFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    RDBMSStoreManager storeMgr;
    QueryResultMetaData queryResultMetaData = null;
    String[] columnNames = null;
    private boolean ignoreCache = false;

    public ResultMetaDataROF(RDBMSStoreManager storeMgr, QueryResultMetaData qrmd) {
        this.storeMgr = storeMgr;
        this.queryResultMetaData = qrmd;
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet rs) {
        String[] columns;
        QueryResultMetaData.PersistentTypeMapping[] persistentTypes;
        int i;
        ArrayList<Object> returnObjects = new ArrayList<Object>();
        if (this.columnNames == null) {
            try {
                ResultSetMetaData rsmd = rs.getMetaData();
                int columnCount = rsmd.getColumnCount();
                this.columnNames = new String[columnCount];
                for (i = 0; i < columnCount; ++i) {
                    String colName = rsmd.getColumnName(i + 1);
                    String colLabel = rsmd.getColumnLabel(i + 1);
                    this.columnNames[i] = StringUtils.isWhitespace((String)colLabel) ? colName : colLabel;
                }
            }
            catch (SQLException ex) {
                throw new NucleusDataStoreException("Error obtaining objects", (Throwable)ex);
            }
        }
        if ((persistentTypes = this.queryResultMetaData.getPersistentTypeMappings()) != null) {
            int startColumnIndex = 0;
            for (i = 0; i < persistentTypes.length; ++i) {
                HashSet<String> columnsInThisType = new HashSet<String>();
                AbstractMemberMetaData[] fmds = new AbstractMemberMetaData[this.columnNames.length];
                HashMap<String, AbstractMemberMetaData> fieldColumns = new HashMap<String, AbstractMemberMetaData>();
                DatastoreClass dc = this.storeMgr.getDatastoreClass(persistentTypes[i].getClassName(), ec.getClassLoaderResolver());
                AbstractClassMetaData acmd = ec.getMetaDataManager().getMetaDataForClass(persistentTypes[i].getClassName(), ec.getClassLoaderResolver());
                Object id = null;
                for (int j = startColumnIndex; j < this.columnNames.length; ++j) {
                    Column df;
                    if (columnsInThisType.contains(this.columnNames[j])) {
                        startColumnIndex = j;
                        break;
                    }
                    boolean found = false;
                    if (acmd.getIdentityType() == IdentityType.DATASTORE && (df = dc.getDatastoreObjectIdMapping().getDatastoreMapping(0).getColumn()).getIdentifier().getIdentifierName().equals(this.columnNames[j])) {
                        int datastoreIdentityExpressionIndex = j + 1;
                        if (dc.getDatastoreObjectIdMapping() != null) {
                            id = dc.getDatastoreObjectIdMapping().getObject(ec, rs, new int[]{datastoreIdentityExpressionIndex});
                        }
                        found = true;
                    }
                    for (int k = 0; k < acmd.getNoOfManagedMembers() + acmd.getNoOfInheritedManagedMembers() && !found; ++k) {
                        AbstractMemberMetaData apmd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(k);
                        if (persistentTypes[i].getColumnForField(apmd.getName()) != null) {
                            if (!persistentTypes[i].getColumnForField(apmd.getName()).equals(this.columnNames[j])) continue;
                            fieldColumns.put(this.columnNames[j], apmd);
                            columnsInThisType.add(this.columnNames[j]);
                            fmds[j] = apmd;
                            found = true;
                            continue;
                        }
                        JavaTypeMapping mapping = dc.getMemberMapping(apmd);
                        for (int l = 0; l < mapping.getDatastoreMappings().length && !found; ++l) {
                            Column df2 = mapping.getDatastoreMapping(l).getColumn();
                            if (!df2.getIdentifier().getIdentifierName().equals(this.columnNames[j])) continue;
                            fieldColumns.put(this.columnNames[j], apmd);
                            columnsInThisType.add(this.columnNames[j]);
                            fmds[j] = apmd;
                            found = true;
                        }
                    }
                    if (columnsInThisType.contains(this.columnNames[j])) continue;
                    startColumnIndex = j;
                    break;
                }
                StatementMappingIndex[] stmtMappings = new StatementMappingIndex[acmd.getNoOfManagedMembers() + acmd.getNoOfInheritedManagedMembers()];
                HashSet fields = new HashSet();
                fields.addAll(fieldColumns.values());
                int[] fieldNumbers = new int[fields.size()];
                Iterator it = fields.iterator();
                int j = 0;
                while (it.hasNext()) {
                    AbstractMemberMetaData apmd = (AbstractMemberMetaData)it.next();
                    StatementMappingIndex stmtMapping = new StatementMappingIndex(dc.getMemberMapping(apmd));
                    fieldNumbers[j] = apmd.getAbsoluteFieldNumber();
                    ArrayList<Integer> indexes = new ArrayList<Integer>();
                    for (int k = 0; k < fmds.length; ++k) {
                        if (fmds == null || fmds[k] != apmd) continue;
                        indexes.add(k);
                    }
                    int[] indxs = new int[indexes.size()];
                    for (int k = 0; k < indxs.length; ++k) {
                        indxs[k] = (Integer)indexes.get(k) + 1;
                    }
                    stmtMapping.setColumnPositions(indxs);
                    stmtMappings[fieldNumbers[j]] = stmtMapping;
                    ++j;
                }
                Object obj = null;
                Class type = ec.getClassLoaderResolver().classForName(persistentTypes[i].getClassName());
                if (acmd.getIdentityType() == IdentityType.APPLICATION) {
                    obj = this.getObjectForApplicationId(ec, rs, fieldNumbers, acmd, type, false, stmtMappings);
                } else if (acmd.getIdentityType() == IdentityType.DATASTORE) {
                    obj = this.getObjectForDatastoreId(ec, rs, fieldNumbers, acmd, id, type, stmtMappings);
                }
                returnObjects.add(obj);
            }
        }
        if ((columns = this.queryResultMetaData.getScalarColumns()) != null) {
            for (i = 0; i < columns.length; ++i) {
                try {
                    Object obj = this.getResultObject(rs, columns[i]);
                    returnObjects.add(obj);
                    continue;
                }
                catch (SQLException sqe) {
                    String msg = LOCALISER.msg("059027", (Object)sqe.getMessage());
                    NucleusLogger.QUERY.error((Object)msg);
                    throw new NucleusUserException(msg, (Throwable)sqe);
                }
            }
        }
        if (returnObjects.size() == 0) {
            return null;
        }
        if (returnObjects.size() == 1) {
            return returnObjects.get(0);
        }
        return returnObjects.toArray(new Object[returnObjects.size()]);
    }

    private Object getResultObject(ResultSet rs, String columnName) throws SQLException {
        return rs.getObject(columnName);
    }

    private Object getObjectForApplicationId(ExecutionContext ec, final ResultSet rs, final int[] fieldNumbers, AbstractClassMetaData cmd, Class pcClass, boolean requiresInheritanceCheck, StatementMappingIndex[] stmtMappings) {
        final StatementClassMapping resultMappings = new StatementClassMapping();
        for (int i = 0; i < fieldNumbers.length; ++i) {
            resultMappings.addMappingForMember(fieldNumbers[i], stmtMappings[fieldNumbers[i]]);
        }
        Object id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)requiresInheritanceCheck, (FieldManager)this.storeMgr.getFieldManagerForResultProcessing(ec, rs, resultMappings, cmd));
        return ec.findObject(id, new FieldValues(){

            public void fetchFields(ObjectProvider sm) {
                FieldManager fm = ResultMetaDataROF.this.storeMgr.getFieldManagerForResultProcessing(sm, rs, resultMappings);
                sm.replaceFields(fieldNumbers, fm, false);
            }

            public void fetchNonLoadedFields(ObjectProvider sm) {
                FieldManager fm = ResultMetaDataROF.this.storeMgr.getFieldManagerForResultProcessing(sm, rs, resultMappings);
                sm.replaceNonLoadedFields(fieldNumbers, fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, pcClass, this.ignoreCache, false);
    }

    private Object getObjectForDatastoreId(final ExecutionContext ec, final ResultSet rs, final int[] fieldNumbers, AbstractClassMetaData cmd, Object oid, Class pcClass, StatementMappingIndex[] stmtMappings) {
        final StatementClassMapping resultMappings = new StatementClassMapping();
        for (int i = 0; i < fieldNumbers.length; ++i) {
            resultMappings.addMappingForMember(fieldNumbers[i], stmtMappings[fieldNumbers[i]]);
        }
        return ec.findObject(oid, new FieldValues(){

            public void fetchFields(ObjectProvider sm) {
                FieldManager fm = ResultMetaDataROF.this.storeMgr.getFieldManagerForResultProcessing(sm, rs, resultMappings);
                sm.replaceFields(fieldNumbers, fm, false);
            }

            public void fetchNonLoadedFields(ObjectProvider sm) {
                FieldManager fm = ResultMetaDataROF.this.storeMgr.getFieldManagerForResultProcessing(sm, rs, resultMappings);
                sm.replaceNonLoadedFields(fieldNumbers, fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return ec.getFetchPlan();
            }
        }, pcClass, this.ignoreCache, false);
    }
}

