/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.fieldmanager.DynamicSchemaFieldManager;
import org.datanucleus.store.rdbms.request.DeleteRequest;
import org.datanucleus.store.rdbms.request.FetchRequest;
import org.datanucleus.store.rdbms.request.InsertRequest;
import org.datanucleus.store.rdbms.request.LocateBulkRequest;
import org.datanucleus.store.rdbms.request.LocateRequest;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.request.RequestIdentifier;
import org.datanucleus.store.rdbms.request.RequestType;
import org.datanucleus.store.rdbms.request.UpdateRequest;
import org.datanucleus.store.rdbms.table.ClassView;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.SoftValueMap;

public class RDBMSPersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected final MappedStoreManager storeMgr;
    private Map<RequestIdentifier, Request> requestsByID = Collections.synchronizedMap(new SoftValueMap());

    public RDBMSPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (MappedStoreManager)storeMgr;
    }

    public void close() {
        this.requestsByID.clear();
        this.requestsByID = null;
    }

    public boolean useReferentialIntegrity() {
        return true;
    }

    public void insertObject(ObjectProvider op) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(op);
        this.checkForSchemaUpdatesForFieldsOfObject(op, op.getLoadedFieldNumbers());
        ExecutionContext ec = op.getExecutionContext();
        ClassLoaderResolver clr = op.getExecutionContext().getClassLoaderResolver();
        String className = op.getClassMetaData().getFullClassName();
        DatastoreClass dc = this.storeMgr.getDatastoreClass(className, clr);
        if (dc == null) {
            if (op.getClassMetaData().getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                throw new NucleusUserException(LOCALISER.msg("032013", (Object)className));
            }
            throw new NucleusException(LOCALISER.msg("032014", (Object)className, (Object)op.getClassMetaData().getInheritanceMetaData().getStrategy())).setFatal();
        }
        if (ec.getStatistics() != null) {
            ec.getStatistics().incrementInsertCount();
        }
        this.insertTable(dc, op, clr);
    }

    private void insertTable(DatastoreClass table, ObjectProvider op, ClassLoaderResolver clr) {
        if (table instanceof ClassView) {
            throw new NucleusUserException("Cannot perform InsertRequest on RDBMS view " + table);
        }
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.insertTable(supertable, op, clr);
        }
        this.getInsertRequest(table, op.getClassMetaData(), clr).execute(op);
        Collection secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            Iterator tablesIter = secondaryTables.iterator();
            while (tablesIter.hasNext()) {
                this.insertTable((DatastoreClass)tablesIter.next(), op, clr);
            }
        }
    }

    private Request getInsertRequest(DatastoreClass table, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestType.INSERT, cmd.getFullClassName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            req = new InsertRequest(table, cmd, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void fetchObject(ObjectProvider op, int[] memberNumbers) {
        AbstractMemberMetaData[] mmds = null;
        if (memberNumbers != null && memberNumbers.length > 0) {
            int i;
            int[] memberNumbersToProcess = memberNumbers;
            AbstractClassMetaData cmd = op.getClassMetaData();
            ExecutionContext ec = op.getExecutionContext();
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            if (this.storeMgr.getBooleanProperty("datanucleus.rdbms.fetchUnloadedAutomatically") && !op.getLifecycleState().isDeleted()) {
                boolean fetchPerformsSelect = false;
                for (i = 0; i < memberNumbers.length; ++i) {
                    AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberNumbers[i]);
                    int relationType = mmd.getRelationType(clr);
                    if (relationType == 3 || relationType == 4 || relationType == 5) continue;
                    fetchPerformsSelect = true;
                    break;
                }
                if (fetchPerformsSelect) {
                    int i2;
                    ArrayList<Integer> memberNumberList = new ArrayList<Integer>();
                    for (int i3 = 0; i3 < memberNumbers.length; ++i3) {
                        memberNumberList.add(memberNumbers[i3]);
                    }
                    boolean[] loadedFlags = op.getLoadedFields();
                    for (i2 = 0; i2 < loadedFlags.length; ++i2) {
                        AbstractMemberMetaData mmd;
                        int relType;
                        boolean requested = false;
                        for (int j = 0; j < memberNumbers.length; ++j) {
                            if (memberNumbers[j] != i2) continue;
                            requested = true;
                            break;
                        }
                        if (requested || loadedFlags[i2] || (relType = (mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(i2)).getRelationType(clr)) != 0 && relType != 2 && relType != 1) continue;
                        memberNumberList.add(i2);
                    }
                    memberNumbersToProcess = new int[memberNumberList.size()];
                    i2 = 0;
                    Iterator fieldNumberIter = memberNumberList.iterator();
                    while (fieldNumberIter.hasNext()) {
                        memberNumbersToProcess[i2++] = (Integer)fieldNumberIter.next();
                    }
                }
            }
            mmds = new AbstractMemberMetaData[memberNumbersToProcess.length];
            for (int i4 = 0; i4 < mmds.length; ++i4) {
                mmds[i4] = cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberNumbersToProcess[i4]);
            }
            if (op.isEmbedded()) {
                StringBuffer str = new StringBuffer();
                for (i = 0; i < mmds.length; ++i) {
                    if (i > 0) {
                        str.append(',');
                    }
                    str.append(mmds[i].getName());
                }
                NucleusLogger.PERSISTENCE.info((Object)("Request to load fields \"" + str.toString() + "\" of class " + op.getClassMetaData().getFullClassName() + " but object is embedded, so ignored"));
            } else {
                if (ec.getStatistics() != null) {
                    ec.getStatistics().incrementFetchCount();
                }
                DatastoreClass table = this.storeMgr.getDatastoreClass(op.getClassMetaData().getFullClassName(), clr);
                Request req = this.getFetchRequest(table, mmds, op.getClassMetaData(), clr);
                req.execute(op);
            }
        }
    }

    private Request getFetchRequest(DatastoreClass table, AbstractMemberMetaData[] mmds, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, mmds, RequestType.FETCH, cmd.getFullClassName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            req = new FetchRequest(table, mmds, cmd, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(op);
        this.checkForSchemaUpdatesForFieldsOfObject(op, fieldNumbers);
        AbstractMemberMetaData[] fmds = null;
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            ExecutionContext ec = op.getExecutionContext();
            fmds = new AbstractMemberMetaData[fieldNumbers.length];
            for (int i = 0; i < fmds.length; ++i) {
                fmds[i] = op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementUpdateCount();
            }
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            DatastoreClass dc = this.storeMgr.getDatastoreClass(op.getObject().getClass().getName(), clr);
            this.updateTable(dc, op, clr, fmds);
        }
    }

    private void updateTable(DatastoreClass table, ObjectProvider op, ClassLoaderResolver clr, AbstractMemberMetaData[] fieldMetaData) {
        if (table instanceof ClassView) {
            throw new NucleusUserException("Cannot perform UpdateRequest on RDBMS view " + table);
        }
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.updateTable(supertable, op, clr, fieldMetaData);
        }
        this.getUpdateRequest(table, fieldMetaData, op.getClassMetaData(), clr).execute(op);
        Collection secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            Iterator tablesIter = secondaryTables.iterator();
            while (tablesIter.hasNext()) {
                this.updateTable((DatastoreClass)tablesIter.next(), op, clr, fieldMetaData);
            }
        }
    }

    private Request getUpdateRequest(DatastoreClass table, AbstractMemberMetaData[] mmds, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, mmds, RequestType.UPDATE, cmd.getFullClassName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            req = new UpdateRequest(table, mmds, cmd, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void deleteObject(ObjectProvider op) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        if (ec.getStatistics() != null) {
            ec.getStatistics().incrementDeleteCount();
        }
        ClassLoaderResolver clr = op.getExecutionContext().getClassLoaderResolver();
        DatastoreClass dc = this.storeMgr.getDatastoreClass(op.getClassMetaData().getFullClassName(), clr);
        this.deleteTable(dc, op, clr);
    }

    private void deleteTable(DatastoreClass table, ObjectProvider sm, ClassLoaderResolver clr) {
        if (table instanceof ClassView) {
            throw new NucleusUserException("Cannot perform DeleteRequest on RDBMS view " + table);
        }
        Collection secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            Iterator tablesIter = secondaryTables.iterator();
            while (tablesIter.hasNext()) {
                this.deleteTable((DatastoreClass)tablesIter.next(), sm, clr);
            }
        }
        this.getDeleteRequest(table, sm.getClassMetaData(), clr).execute(sm);
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.deleteTable(supertable, sm, clr);
        }
    }

    private Request getDeleteRequest(DatastoreClass table, AbstractClassMetaData acmd, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestType.DELETE, acmd.getFullClassName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            req = new DeleteRequest(table, acmd, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void locateObjects(ObjectProvider[] ops) {
        DatastoreClass table;
        if (ops == null || ops.length == 0) {
            return;
        }
        ClassLoaderResolver clr = ops[0].getExecutionContext().getClassLoaderResolver();
        HashMap<DatastoreClass, ArrayList<ObjectProvider>> opsByTable = new HashMap<DatastoreClass, ArrayList<ObjectProvider>>();
        for (int i = 0; i < ops.length; ++i) {
            AbstractClassMetaData cmd = ops[i].getClassMetaData();
            table = this.storeMgr.getDatastoreClass(cmd.getFullClassName(), clr);
            ArrayList<ObjectProvider> opList = (ArrayList<ObjectProvider>)opsByTable.get(table = table.getBaseDatastoreClass());
            if (opList == null) {
                opList = new ArrayList<ObjectProvider>();
            }
            opList.add(ops[i]);
            opsByTable.put(table, opList);
        }
        for (Map.Entry entry : opsByTable.entrySet()) {
            table = (DatastoreClass)entry.getKey();
            List tableOps = (List)entry.getValue();
            LocateBulkRequest req = new LocateBulkRequest(table);
            req.execute(tableOps.toArray(new ObjectProvider[tableOps.size()]));
        }
    }

    public void locateObject(ObjectProvider op) {
        ClassLoaderResolver clr = op.getExecutionContext().getClassLoaderResolver();
        DatastoreClass table = this.storeMgr.getDatastoreClass(op.getObject().getClass().getName(), clr);
        this.getLocateRequest(table, op.getObject().getClass().getName()).execute(op);
    }

    private Request getLocateRequest(DatastoreClass table, String className) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestType.LOCATE, className);
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            req = new LocateRequest(table);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRequests() {
        Map<RequestIdentifier, Request> map = this.requestsByID;
        synchronized (map) {
            this.requestsByID.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestsForTable(DatastoreClass table) {
        Map<RequestIdentifier, Request> map = this.requestsByID;
        synchronized (map) {
            HashSet<RequestIdentifier> keySet = new HashSet<RequestIdentifier>(this.requestsByID.keySet());
            for (RequestIdentifier reqId : keySet) {
                if (reqId.getTable() != table) continue;
                this.requestsByID.remove(reqId);
            }
        }
    }

    private void checkForSchemaUpdatesForFieldsOfObject(ObjectProvider sm, int[] fieldNumbers) {
        if (this.storeMgr.getBooleanObjectProperty("datanucleus.rdbms.dynamicSchemaUpdates").booleanValue()) {
            DynamicSchemaFieldManager dynamicSchemaFM = new DynamicSchemaFieldManager((RDBMSStoreManager)this.storeMgr, sm);
            sm.provideFields(fieldNumbers, (FieldManager)dynamicSchemaFM);
            if (dynamicSchemaFM.hasPerformedSchemaUpdates()) {
                this.requestsByID.clear();
            }
        }
    }
}

