/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.mapped.ColumnCreator;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.util.NucleusLogger;

public class PersistableJoinTable
extends JoinTable {
    protected JavaTypeMapping relatedMapping;

    public PersistableJoinTable(DatastoreIdentifier tableName, AbstractMemberMetaData mmd, RDBMSStoreManager storeMgr) {
        super(tableName, mmd, storeMgr);
    }

    public JavaTypeMapping getMemberMapping(AbstractMemberMetaData mmd) {
        return null;
    }

    public void initialize(ClassLoaderResolver clr) {
        boolean pkRequired = this.requiresPrimaryKey();
        ColumnMetaData[] ownerColmd = null;
        if (this.mmd.getColumnMetaData() != null && this.mmd.getColumnMetaData().length > 0) {
            ownerColmd = this.mmd.getColumnMetaData();
        }
        this.ownerMapping = ColumnCreator.createColumnsForJoinTables((Class)clr.classForName(this.mmd.getClassName(true)), (AbstractMemberMetaData)this.mmd, (ColumnMetaData[])ownerColmd, (MappedStoreManager)this.storeMgr, (DatastoreContainerObject)this, (boolean)pkRequired, (boolean)false, (int)1, (ClassLoaderResolver)clr);
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            this.debugMapping(this.ownerMapping);
        }
        ColumnMetaData[] relatedColmd = null;
        if (this.mmd.getJoinMetaData().getColumnMetaData() != null && this.mmd.getJoinMetaData().getColumnMetaData().length > 0) {
            relatedColmd = this.mmd.getJoinMetaData().getColumnMetaData();
        }
        this.relatedMapping = ColumnCreator.createColumnsForJoinTables((Class)this.mmd.getType(), (AbstractMemberMetaData)this.mmd, (ColumnMetaData[])relatedColmd, (MappedStoreManager)this.storeMgr, (DatastoreContainerObject)this, (boolean)pkRequired, (boolean)false, (int)8, (ClassLoaderResolver)clr);
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            this.debugMapping(this.relatedMapping);
        }
        this.state = 2;
    }

    public List getExpectedForeignKeys(ClassLoaderResolver clr) {
        this.assertIsInitialized();
        boolean autoMode = false;
        if (this.storeMgr.getStringProperty("datanucleus.rdbms.constraintCreateMode").equals("DataNucleus")) {
            autoMode = true;
        }
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        try {
            ForeignKeyMetaData fkmd;
            ForeignKey fk;
            DatastoreClass referencedTable = this.storeMgr.getDatastoreClass(this.mmd.getClassName(true), clr);
            if (referencedTable != null) {
                fk = null;
                if (referencedTable != null) {
                    fkmd = null;
                    if (this.mmd.getJoinMetaData() != null) {
                        fkmd = this.mmd.getJoinMetaData().getForeignKeyMetaData();
                    }
                    if (fkmd != null || autoMode) {
                        fk = new ForeignKey(this.ownerMapping, this.dba, referencedTable, true);
                        fk.setForMetaData(fkmd);
                    }
                    if (fk != null) {
                        foreignKeys.add(fk);
                    }
                }
            }
            if ((referencedTable = this.storeMgr.getDatastoreClass(this.mmd.getTypeName(), clr)) != null) {
                fk = null;
                fkmd = this.mmd.getForeignKeyMetaData();
                if (fkmd != null || autoMode) {
                    fk = new ForeignKey(this.relatedMapping, this.dba, referencedTable, true);
                    fk.setForMetaData(fkmd);
                }
                if (fk != null) {
                    foreignKeys.add(fk);
                }
            }
        }
        catch (NoTableManagedException e) {
            // empty catch block
        }
        return foreignKeys;
    }

    protected Set getExpectedIndices(ClassLoaderResolver clr) {
        Set indices = super.getExpectedIndices(clr);
        return indices;
    }

    protected List getExpectedCandidateKeys() {
        UniqueMetaData unimd;
        ColumnMetaData[] colmds;
        List candidateKeys = super.getExpectedCandidateKeys();
        if (this.mmd.getJoinMetaData() != null && this.mmd.getJoinMetaData().getUniqueMetaData() != null && (colmds = (unimd = this.mmd.getJoinMetaData().getUniqueMetaData()).getColumnMetaData()) != null) {
            CandidateKey uniKey = new CandidateKey(this);
            IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
            for (int i = 0; i < colmds.length; ++i) {
                DatastoreField col = this.getDatastoreField(idFactory.newDatastoreFieldIdentifier(colmds[i].getName()));
                if (col == null) {
                    throw new NucleusUserException("Unique key on join-table " + this + " has column " + colmds[i].getName() + " that is not found");
                }
                uniKey.addDatastoreField(col);
            }
            candidateKeys.add(uniKey);
        }
        return candidateKeys;
    }

    public JavaTypeMapping getRelatedMapping() {
        this.assertIsInitialized();
        return this.relatedMapping;
    }
}

