/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.ActivityState;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.VersionHelper;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.SecondaryTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.NucleusLogger;

public class InsertRequest
extends Request {
    private static final int IDPARAMNUMBER = 1;
    private final MappingCallbacks[] callbacks;
    private final int[] insertFieldNumbers;
    private final int[] pkFieldNumbers;
    private final int[] reachableFieldNumbers;
    private final int[] relationFieldNumbers;
    private final String insertStmt;
    private boolean hasIdentityColumn = false;
    private StatementMappingIndex[] stmtMappings;
    private StatementMappingIndex[] retrievedStmtMappings;
    private StatementMappingIndex versionStmtMapping;
    private StatementMappingIndex discriminatorStmtMapping;
    private StatementMappingIndex[] externalFKStmtMappings;
    private StatementMappingIndex[] externalFKDiscrimStmtMappings;
    private StatementMappingIndex[] externalOrderStmtMappings;
    private boolean batch = false;

    public InsertRequest(DatastoreClass table, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        super(table);
        InsertMappingConsumer consumer = new InsertMappingConsumer(clr, cmd, 1);
        table.provideDatastoreIdMappings((MappingConsumer)consumer);
        table.provideNonPrimaryKeyMappings((MappingConsumer)consumer);
        table.providePrimaryKeyMappings((MappingConsumer)consumer);
        table.provideVersionMappings((MappingConsumer)consumer);
        table.provideDiscriminatorMappings((MappingConsumer)consumer);
        table.provideExternalMappings((MappingConsumer)consumer, 5);
        table.provideExternalMappings((MappingConsumer)consumer, 6);
        table.provideExternalMappings((MappingConsumer)consumer, 4);
        table.provideUnmappedDatastoreFields((MappingConsumer)consumer);
        this.callbacks = consumer.getMappingCallbacks().toArray(new MappingCallbacks[consumer.getMappingCallbacks().size()]);
        this.stmtMappings = consumer.getStatementMappings();
        this.versionStmtMapping = consumer.getVersionStatementMapping();
        this.discriminatorStmtMapping = consumer.getDiscriminatorStatementMapping();
        this.externalFKStmtMappings = consumer.getExternalFKStatementMapping();
        this.externalFKDiscrimStmtMappings = consumer.getExternalFKDiscrimStatementMapping();
        this.externalOrderStmtMappings = consumer.getExternalOrderStatementMapping();
        this.pkFieldNumbers = consumer.getPrimaryKeyFieldNumbers();
        if (table.getIdentityType() == IdentityType.APPLICATION && this.pkFieldNumbers.length < 1 && !this.hasIdentityColumn) {
            throw new NucleusException(LOCALISER.msg("052200", (Object)cmd.getFullClassName())).setFatal();
        }
        this.insertFieldNumbers = consumer.getInsertFieldNumbers();
        this.retrievedStmtMappings = consumer.getReachableStatementMappings();
        this.reachableFieldNumbers = consumer.getReachableFieldNumbers();
        this.relationFieldNumbers = consumer.getRelationFieldNumbers();
        this.insertStmt = consumer.getInsertStmt();
        if (!this.hasIdentityColumn && !cmd.hasRelations(clr, table.getStoreManager().getMetaDataManager()) && this.externalFKStmtMappings == null) {
            this.batch = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ObjectProvider sm) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("052207", (Object)sm.toPrintableID(), (Object)this.table));
        }
        try {
            VersionMetaData vermd = this.table.getVersionMetaData();
            ExecutionContext ec = sm.getExecutionContext();
            RDBMSStoreManager storeMgr = (RDBMSStoreManager)ec.getStoreManager();
            if (vermd != null && vermd.getFieldName() != null) {
                AbstractMemberMetaData verfmd = ((AbstractClassMetaData)vermd.getParent()).getMetaDataForMember(vermd.getFieldName());
                Object currentVersion = ec.getApiAdapter().getVersion(sm);
                if (currentVersion instanceof Number) {
                    currentVersion = ((Number)currentVersion).longValue();
                }
                Object nextOptimisticVersion = VersionHelper.getNextVersion((VersionStrategy)this.table.getVersionMetaData().getVersionStrategy(), (Object)currentVersion);
                if (verfmd.getType() == Integer.class || verfmd.getType() == Integer.TYPE) {
                    nextOptimisticVersion = ((Long)nextOptimisticVersion).intValue();
                }
                sm.replaceField(verfmd.getAbsoluteFieldNumber(), nextOptimisticVersion);
            }
            sm.changeActivityState(ActivityState.INSERTING);
            SQLController sqlControl = storeMgr.getSQLController();
            ManagedConnection mconn = storeMgr.getConnection(ec);
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.insertStmt, this.batch);
                try {
                    int i;
                    int i2;
                    int k;
                    Object nextOptimisticVersion;
                    StatementClassMapping mappingDefinition = new StatementClassMapping();
                    StatementMappingIndex[] idxs = this.stmtMappings;
                    for (int i3 = 0; i3 < idxs.length; ++i3) {
                        if (idxs[i3] == null) continue;
                        mappingDefinition.addMappingForMember(i3, idxs[i3]);
                    }
                    if (this.table.getIdentityType() == IdentityType.DATASTORE) {
                        if (!this.table.isObjectIdDatastoreAttributed() || !this.table.isBaseDatastoreClass()) {
                            int[] paramNumber = new int[]{1};
                            this.table.getDatastoreObjectIdMapping().setObject(ec, (Object)ps, paramNumber, sm.getInternalObjectId());
                        }
                    } else if (this.table.getIdentityType() == IdentityType.APPLICATION) {
                        sm.provideFields(this.pkFieldNumbers, storeMgr.getFieldManagerForStatementGeneration(sm, ps, mappingDefinition, true));
                    }
                    int numberOfFieldsToProvide = 0;
                    for (int i4 = 0; i4 < this.insertFieldNumbers.length; ++i4) {
                        if (this.insertFieldNumbers[i4] >= sm.getClassMetaData().getMemberCount()) continue;
                        ++numberOfFieldsToProvide;
                    }
                    int j = 0;
                    int[] classFieldNumbers = new int[numberOfFieldsToProvide];
                    for (int i5 = 0; i5 < this.insertFieldNumbers.length; ++i5) {
                        if (this.insertFieldNumbers[i5] >= sm.getClassMetaData().getMemberCount()) continue;
                        classFieldNumbers[j++] = this.insertFieldNumbers[i5];
                    }
                    sm.provideFields(classFieldNumbers, storeMgr.getFieldManagerForStatementGeneration(sm, ps, mappingDefinition, true));
                    if (this.table.getVersionMapping(false) != null) {
                        Object currentVersion = ec.getApiAdapter().getVersion(sm);
                        nextOptimisticVersion = VersionHelper.getNextVersion((VersionStrategy)this.table.getVersionMetaData().getVersionStrategy(), (Object)currentVersion);
                        for (k = 0; k < this.versionStmtMapping.getNumberOfParameterOccurrences(); ++k) {
                            this.table.getVersionMapping(false).setObject(ec, (Object)ps, this.versionStmtMapping.getParameterPositionsForOccurrence(k), nextOptimisticVersion);
                        }
                        sm.setTransactionalVersion(nextOptimisticVersion);
                    } else if (vermd != null && vermd.getFieldName() != null) {
                        Object currentVersion = ec.getApiAdapter().getVersion(sm);
                        nextOptimisticVersion = VersionHelper.getNextVersion((VersionStrategy)this.table.getVersionMetaData().getVersionStrategy(), (Object)currentVersion);
                        sm.setTransactionalVersion(nextOptimisticVersion);
                    }
                    if (this.table.getDiscriminatorMapping(false) != null) {
                        DiscriminatorMetaData dismd = this.table.getDiscriminatorMetaData();
                        if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                            for (int k2 = 0; k2 < this.discriminatorStmtMapping.getNumberOfParameterOccurrences(); ++k2) {
                                this.table.getDiscriminatorMapping(false).setObject(ec, (Object)ps, this.discriminatorStmtMapping.getParameterPositionsForOccurrence(k2), (Object)sm.getObject().getClass().getName());
                            }
                        } else if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                            dismd = sm.getClassMetaData().getInheritanceMetaData().getDiscriminatorMetaData();
                            for (int k3 = 0; k3 < this.discriminatorStmtMapping.getNumberOfParameterOccurrences(); ++k3) {
                                this.table.getDiscriminatorMapping(false).setObject(ec, (Object)ps, this.discriminatorStmtMapping.getParameterPositionsForOccurrence(k3), (Object)dismd.getValue());
                            }
                        }
                    }
                    if (this.externalFKStmtMappings != null) {
                        for (int i6 = 0; i6 < this.externalFKStmtMappings.length; ++i6) {
                            Object fkValue = sm.getAssociatedValue((Object)this.externalFKStmtMappings[i6].getMapping());
                            if (fkValue != null) {
                                AbstractMemberMetaData ownerFmd = this.table.getMetaDataForExternalMapping(this.externalFKStmtMappings[i6].getMapping(), 5);
                                for (int k4 = 0; k4 < this.externalFKStmtMappings[i6].getNumberOfParameterOccurrences(); ++k4) {
                                    this.externalFKStmtMappings[i6].getMapping().setObject(ec, (Object)ps, this.externalFKStmtMappings[i6].getParameterPositionsForOccurrence(k4), fkValue, null, ownerFmd.getAbsoluteFieldNumber());
                                }
                                continue;
                            }
                            for (k = 0; k < this.externalFKStmtMappings[i6].getNumberOfParameterOccurrences(); ++k) {
                                this.externalFKStmtMappings[i6].getMapping().setObject(ec, (Object)ps, this.externalFKStmtMappings[i6].getParameterPositionsForOccurrence(k), null);
                            }
                        }
                    }
                    if (this.externalFKDiscrimStmtMappings != null) {
                        for (int i7 = 0; i7 < this.externalFKDiscrimStmtMappings.length; ++i7) {
                            Object discrimValue = sm.getAssociatedValue((Object)this.externalFKDiscrimStmtMappings[i7].getMapping());
                            for (k = 0; k < this.externalFKDiscrimStmtMappings[i7].getNumberOfParameterOccurrences(); ++k) {
                                this.externalFKDiscrimStmtMappings[i7].getMapping().setObject(ec, (Object)ps, this.externalFKDiscrimStmtMappings[i7].getParameterPositionsForOccurrence(k), discrimValue);
                            }
                        }
                    }
                    if (this.externalOrderStmtMappings != null) {
                        for (int i8 = 0; i8 < this.externalOrderStmtMappings.length; ++i8) {
                            Object orderValue = sm.getAssociatedValue((Object)this.externalOrderStmtMappings[i8].getMapping());
                            if (orderValue == null) {
                                orderValue = -1;
                            }
                            for (k = 0; k < this.externalOrderStmtMappings[i8].getNumberOfParameterOccurrences(); ++k) {
                                this.externalOrderStmtMappings[i8].getMapping().setObject(ec, (Object)ps, this.externalOrderStmtMappings[i8].getParameterPositionsForOccurrence(k), orderValue);
                            }
                        }
                    }
                    sqlControl.executeStatementUpdate(mconn, this.insertStmt, ps, !this.batch);
                    if (this.hasIdentityColumn) {
                        Object newId = this.getInsertedDatastoreIdentity(ec, sqlControl, sm, mconn, ps);
                        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                            NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("052206", (Object)sm.toPrintableID(), newId));
                        }
                        sm.setPostStoreNewObjectId(newId);
                    }
                    for (i2 = 0; i2 < this.callbacks.length; ++i2) {
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("052222", (Object)sm.toPrintableID(), (Object)((JavaTypeMapping)this.callbacks[i2]).getMemberMetaData().getFullFieldName()));
                        }
                        this.callbacks[i2].insertPostProcessing(sm);
                    }
                    storeMgr.setObjectIsInsertedToLevel(sm, this.table);
                    for (i2 = 0; i2 < this.relationFieldNumbers.length; ++i2) {
                        Object value = sm.provideField(this.relationFieldNumbers[i2]);
                        if (value == null || !ec.getApiAdapter().isDetached(value)) continue;
                        Object valueAttached = ec.persistObjectInternal(value, null, -1, 0);
                        sm.replaceField(this.relationFieldNumbers[i2], valueAttached);
                    }
                    int numberOfReachableFields = 0;
                    for (i = 0; i < this.reachableFieldNumbers.length; ++i) {
                        if (this.reachableFieldNumbers[i] >= sm.getClassMetaData().getMemberCount()) continue;
                        ++numberOfReachableFields;
                    }
                    classFieldNumbers = new int[numberOfReachableFields];
                    j = 0;
                    for (i = 0; i < this.reachableFieldNumbers.length; ++i) {
                        if (this.reachableFieldNumbers[i] >= sm.getClassMetaData().getMemberCount()) continue;
                        classFieldNumbers[j++] = this.reachableFieldNumbers[i];
                    }
                    mappingDefinition = new StatementClassMapping();
                    idxs = this.retrievedStmtMappings;
                    for (i = 0; i < idxs.length; ++i) {
                        if (idxs[i] == null) continue;
                        mappingDefinition.addMappingForMember(i, idxs[i]);
                    }
                    sm.provideFields(classFieldNumbers, storeMgr.getFieldManagerForStatementGeneration(sm, ps, mappingDefinition, true));
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            String msg = LOCALISER.msg("052208", (Object)sm.toPrintableID(), (Object)this.insertStmt, (Object)e.getMessage());
            NucleusLogger.DATASTORE_PERSIST.warn((Object)msg);
            ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
            exceptions.add(e);
            while ((e = e.getNextException()) != null) {
                exceptions.add(e);
            }
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
        }
        for (int i = 0; i < this.callbacks.length; ++i) {
            try {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("052209", (Object)sm.toPrintableID(), (Object)((JavaTypeMapping)this.callbacks[i]).getMemberMetaData().getFullFieldName()));
                }
                this.callbacks[i].postInsert(sm);
                continue;
            }
            catch (NotYetFlushedException e) {
                sm.updateFieldAfterInsert(e.getPersistable(), ((JavaTypeMapping)this.callbacks[i]).getMemberMetaData().getAbsoluteFieldNumber());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getInsertedDatastoreIdentity(ExecutionContext ec, SQLController sqlControl, ObjectProvider sm, ManagedConnection mconn, PreparedStatement ps) throws SQLException {
        Object datastoreId = null;
        MappedStoreManager storeMgr = (MappedStoreManager)ec.getStoreManager();
        if (((RDBMSAdapter)storeMgr.getDatastoreAdapter()).supportsOption("GetGeneratedKeysStatement")) {
            ResultSet rs = null;
            try {
                rs = ps.getGeneratedKeys();
                if (rs != null && rs.next()) {
                    datastoreId = rs.getObject(1);
                }
            }
            catch (Throwable e) {
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        if (datastoreId == null) {
            String columnName = null;
            JavaTypeMapping idMapping = this.table.getIdMapping();
            if (idMapping != null) {
                for (int i = 0; i < idMapping.getNumberOfDatastoreMappings(); ++i) {
                    Column col = (Column)idMapping.getDatastoreMapping(i).getDatastoreField();
                    if (!col.isIdentity()) continue;
                    columnName = col.getIdentifier().toString();
                    break;
                }
            }
            String autoIncStmt = ((RDBMSAdapter)storeMgr.getDatastoreAdapter()).getAutoIncrementStmt((Table)this.table, columnName);
            PreparedStatement psAutoIncrement = sqlControl.getStatementForQuery(mconn, autoIncStmt);
            ResultSet rs = null;
            try {
                rs = sqlControl.executeStatementQuery(mconn, autoIncStmt, psAutoIncrement);
                if (rs.next()) {
                    datastoreId = rs.getObject(1);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (psAutoIncrement != null) {
                    psAutoIncrement.close();
                }
            }
        }
        if (datastoreId == null) {
            throw new NucleusDataStoreException(LOCALISER.msg("052205", (Object)this.table));
        }
        return datastoreId;
    }

    private class InsertMappingConsumer
    implements MappingConsumer {
        List insertFields = new ArrayList();
        List pkFields = new ArrayList();
        List reachableFields = new ArrayList();
        List relationFields = new ArrayList();
        StringBuffer columnNames = new StringBuffer();
        StringBuffer columnValues = new StringBuffer();
        Map assignedColumns = new HashMap();
        List mc = new ArrayList();
        boolean initialized = false;
        int paramIndex;
        private StatementMappingIndex[] statementMappings;
        private StatementMappingIndex[] retrievedStatementMappings;
        private StatementMappingIndex versionStatementMapping;
        private StatementMappingIndex discriminatorStatementMapping;
        private StatementMappingIndex[] externalFKStmtExprIndex;
        private StatementMappingIndex[] externalFKDiscrimStmtExprIndex;
        private StatementMappingIndex[] externalOrderStmtExprIndex;
        private final ClassLoaderResolver clr;
        private final AbstractClassMetaData cmd;

        public InsertMappingConsumer(ClassLoaderResolver clr, AbstractClassMetaData cmd, int initialParamIndex) {
            this.clr = clr;
            this.cmd = cmd;
            this.paramIndex = initialParamIndex;
        }

        public void preConsumeMapping(int highestFieldNumber) {
            if (!this.initialized) {
                this.statementMappings = new StatementMappingIndex[highestFieldNumber];
                this.retrievedStatementMappings = new StatementMappingIndex[highestFieldNumber];
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
            if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                return;
            }
            if (m.includeInInsertStatement()) {
                if (m.getNumberOfDatastoreMappings() == 0 && (m instanceof PersistableMapping || m instanceof ReferenceMapping)) {
                    this.retrievedStatementMappings[fmd.getAbsoluteFieldNumber()] = new StatementMappingIndex(m);
                    int relationType = fmd.getRelationType(this.clr);
                    if (relationType == 2) {
                        if (fmd.getMappedBy() != null) {
                            this.reachableFields.add(fmd.getAbsoluteFieldNumber());
                        }
                    } else if (relationType == 6) {
                        AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(this.clr);
                        if (fmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) {
                            this.reachableFields.add(fmd.getAbsoluteFieldNumber());
                        }
                    }
                } else {
                    int relationType;
                    if (fmd.hasExtension("insertable") && fmd.getValueForExtension("insertable").equalsIgnoreCase("false")) {
                        return;
                    }
                    ColumnMetaData[] colmds = fmd.getColumnMetaData();
                    if (colmds != null && colmds.length > 0) {
                        for (int i = 0; i < colmds.length; ++i) {
                            if (colmds[i].getInsertable()) continue;
                            return;
                        }
                    }
                    if ((relationType = fmd.getRelationType(this.clr)) == 2) {
                        if (fmd.getMappedBy() == null) {
                            // empty if block
                        }
                    } else if (relationType == 6) {
                        AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(this.clr);
                        if (fmd.getJoinMetaData() == null && relatedMmds[0].getJoinMetaData() == null) {
                            this.relationFields.add(fmd.getAbsoluteFieldNumber());
                        }
                    }
                    this.statementMappings[fmd.getAbsoluteFieldNumber()] = new StatementMappingIndex(m);
                    int[] parametersIndex = new int[m.getNumberOfDatastoreMappings()];
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        Column c = (Column)m.getDatastoreMapping(j).getDatastoreField();
                        DatastoreIdentifier columnId = c.getIdentifier();
                        boolean columnExists = this.assignedColumns.containsKey(columnId.toString());
                        if (columnExists) {
                            parametersIndex[j] = (Integer)this.assignedColumns.get(c.getIdentifier().toString());
                        }
                        if (InsertRequest.this.table instanceof SecondaryTable || !InsertRequest.this.table.isBaseDatastoreClass() || !InsertRequest.this.table.getStoreManager().isStrategyDatastoreAttributed(fmd.getValueStrategy(), false) && !c.isIdentity()) {
                            if (!columnExists) {
                                if (this.columnNames.length() > 0) {
                                    this.columnNames.append(',');
                                    this.columnValues.append(',');
                                }
                                this.columnNames.append(columnId);
                                this.columnValues.append(((RDBMSMapping)m.getDatastoreMapping(j)).getInsertionInputParameter());
                            }
                            if (((RDBMSMapping)m.getDatastoreMapping(j)).insertValuesOnInsert()) {
                                Integer abs_field_num = fmd.getAbsoluteFieldNumber();
                                if (fmd.isPrimaryKey()) {
                                    if (!this.pkFields.contains(abs_field_num)) {
                                        this.pkFields.add(abs_field_num);
                                    }
                                } else if (!this.insertFields.contains(abs_field_num)) {
                                    this.insertFields.add(abs_field_num);
                                }
                                if (columnExists) {
                                    parametersIndex[j] = (Integer)this.assignedColumns.get(c.getIdentifier().toString());
                                } else {
                                    ++this.paramIndex;
                                }
                            }
                            if (columnExists) continue;
                            this.assignedColumns.put(c.getIdentifier().toString(), fmd.getAbsoluteFieldNumber());
                            continue;
                        }
                        InsertRequest.this.hasIdentityColumn = true;
                    }
                    this.statementMappings[fmd.getAbsoluteFieldNumber()].addParameterOccurrence(parametersIndex);
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mc.add(m);
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 1) {
                if (InsertRequest.this.table.getVersionMapping(false) != null) {
                    String val = ((RDBMSMapping)InsertRequest.this.table.getVersionMapping(false).getDatastoreMapping(0)).getUpdateInputParameter();
                    if (this.columnNames.length() > 0) {
                        this.columnNames.append(',');
                        this.columnValues.append(',');
                    }
                    this.columnNames.append(((Column)InsertRequest.this.table.getVersionMapping(false).getDatastoreMapping(0).getDatastoreField()).getIdentifier());
                    this.columnValues.append(val);
                    this.versionStatementMapping = new StatementMappingIndex(InsertRequest.this.table.getVersionMapping(false));
                    int[] param = new int[]{this.paramIndex++};
                    this.versionStatementMapping.addParameterOccurrence(param);
                } else {
                    this.versionStatementMapping = null;
                }
            } else if (mappingType == 3) {
                if (InsertRequest.this.table.getDiscriminatorMapping(false) != null) {
                    String val = ((RDBMSMapping)InsertRequest.this.table.getDiscriminatorMapping(false).getDatastoreMapping(0)).getUpdateInputParameter();
                    if (this.columnNames.length() > 0) {
                        this.columnNames.append(',');
                        this.columnValues.append(',');
                    }
                    this.columnNames.append(((Column)InsertRequest.this.table.getDiscriminatorMapping(false).getDatastoreMapping(0).getDatastoreField()).getIdentifier());
                    this.columnValues.append(val);
                    this.discriminatorStatementMapping = new StatementMappingIndex(InsertRequest.this.table.getDiscriminatorMapping(false));
                    int[] param = new int[]{this.paramIndex++};
                    this.discriminatorStatementMapping.addParameterOccurrence(param);
                } else {
                    this.discriminatorStatementMapping = null;
                }
            } else if (mappingType == 2) {
                if (InsertRequest.this.table.getIdentityType() == IdentityType.DATASTORE) {
                    if (!InsertRequest.this.table.isObjectIdDatastoreAttributed() || !InsertRequest.this.table.isBaseDatastoreClass()) {
                        Iterator iterator = InsertRequest.this.key.getColumns().iterator();
                        if (this.columnNames.length() > 0) {
                            this.columnNames.append(',');
                            this.columnValues.append(',');
                        }
                        this.columnNames.append(((Column)iterator.next()).getIdentifier().toString());
                        this.columnValues.append("?");
                        ++this.paramIndex;
                    } else {
                        InsertRequest.this.hasIdentityColumn = true;
                    }
                }
            } else if (mappingType == 5) {
                this.externalFKStmtExprIndex = this.processExternalMapping(m, this.statementMappings, this.externalFKStmtExprIndex);
            } else if (mappingType == 6) {
                this.externalFKDiscrimStmtExprIndex = this.processExternalMapping(m, this.statementMappings, this.externalFKDiscrimStmtExprIndex);
            } else if (mappingType == 4) {
                this.externalOrderStmtExprIndex = this.processExternalMapping(m, this.statementMappings, this.externalOrderStmtExprIndex);
            }
        }

        public void consumeUnmappedDatastoreField(DatastoreField fld) {
            if (this.columnNames.length() > 0) {
                this.columnNames.append(',');
                this.columnValues.append(',');
            }
            Column col = (Column)fld;
            this.columnNames.append(fld.getIdentifier());
            ColumnMetaData colmd = col.getColumnMetaData();
            String value = colmd.getInsertValue();
            if (value != null && value.equalsIgnoreCase("#NULL")) {
                value = null;
            }
            if (colmd.getJdbcType().equals("VARCHAR") || colmd.getJdbcType().equals("CHAR")) {
                if (value != null) {
                    value = "'" + value + "'";
                } else if (!fld.isNullable()) {
                    value = "''";
                }
            }
            this.columnValues.append(value);
        }

        private StatementMappingIndex[] processExternalMapping(JavaTypeMapping mapping, StatementMappingIndex[] fieldStmtExprIndex, StatementMappingIndex[] stmtExprIndex) {
            int i;
            for (int i2 = 0; i2 < fieldStmtExprIndex.length; ++i2) {
                if (fieldStmtExprIndex[i2] == null || fieldStmtExprIndex[i2].getMapping() != mapping) continue;
                return stmtExprIndex;
            }
            int pos = 0;
            if (stmtExprIndex == null) {
                stmtExprIndex = new StatementMappingIndex[1];
                pos = 0;
            } else {
                for (int i3 = 0; i3 < stmtExprIndex.length; ++i3) {
                    if (stmtExprIndex[i3].getMapping() != mapping) continue;
                    return stmtExprIndex;
                }
                StatementMappingIndex[] tmpStmtExprIndex = stmtExprIndex;
                stmtExprIndex = new StatementMappingIndex[tmpStmtExprIndex.length + 1];
                for (i = 0; i < tmpStmtExprIndex.length; ++i) {
                    stmtExprIndex[i] = tmpStmtExprIndex[i];
                }
                pos = tmpStmtExprIndex.length;
            }
            stmtExprIndex[pos] = new StatementMappingIndex(mapping);
            int[] param = new int[mapping.getNumberOfDatastoreMappings()];
            for (i = 0; i < mapping.getNumberOfDatastoreMappings(); ++i) {
                if (this.columnNames.length() > 0) {
                    this.columnNames.append(',');
                    this.columnValues.append(',');
                }
                this.columnNames.append(((Column)mapping.getDatastoreMapping(i).getDatastoreField()).getIdentifier());
                this.columnValues.append(((RDBMSMapping)mapping.getDatastoreMapping(i)).getUpdateInputParameter());
                ++this.paramIndex;
            }
            stmtExprIndex[pos].addParameterOccurrence(param);
            return stmtExprIndex;
        }

        public List getMappingCallbacks() {
            return this.mc;
        }

        public int[] getInsertFieldNumbers() {
            int[] fieldNumbers = new int[this.insertFields.size()];
            for (int i = 0; i < this.insertFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.insertFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getPrimaryKeyFieldNumbers() {
            int[] fieldNumbers = new int[this.pkFields.size()];
            for (int i = 0; i < this.pkFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.pkFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getReachableFieldNumbers() {
            int[] fieldNumbers = new int[this.reachableFields.size()];
            for (int i = 0; i < this.reachableFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.reachableFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getRelationFieldNumbers() {
            int[] fieldNumbers = new int[this.relationFields.size()];
            for (int i = 0; i < this.relationFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.relationFields.get(i);
            }
            return fieldNumbers;
        }

        public StatementMappingIndex[] getStatementMappings() {
            return this.statementMappings;
        }

        public StatementMappingIndex[] getReachableStatementMappings() {
            return this.retrievedStatementMappings;
        }

        public StatementMappingIndex getVersionStatementMapping() {
            return this.versionStatementMapping;
        }

        public StatementMappingIndex getDiscriminatorStatementMapping() {
            return this.discriminatorStatementMapping;
        }

        public StatementMappingIndex[] getExternalFKStatementMapping() {
            return this.externalFKStmtExprIndex;
        }

        public StatementMappingIndex[] getExternalFKDiscrimStatementMapping() {
            return this.externalFKDiscrimStmtExprIndex;
        }

        public StatementMappingIndex[] getExternalOrderStatementMapping() {
            return this.externalOrderStmtExprIndex;
        }

        public String getInsertStmt() {
            if (this.columnNames.length() > 0 && this.columnValues.length() > 0) {
                return "INSERT INTO " + InsertRequest.this.table.toString() + " (" + this.columnNames + ") VALUES (" + this.columnValues + ")";
            }
            return ((RDBMSAdapter)InsertRequest.this.table.getStoreManager().getDatastoreAdapter()).getInsertStatementForNoColumns((Table)InsertRequest.this.table);
        }
    }
}

