/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.datasource;

import com.jolbox.bonecp.BoneCPDataSource;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.datasource.AbstractDataSourceFactory;
import org.datanucleus.store.rdbms.datasource.DataNucleusDataSourceFactory;
import org.datanucleus.util.ClassUtils;

public class BoneCPDataSourceFactory
extends AbstractDataSourceFactory
implements DataNucleusDataSourceFactory {
    public DataSource makePooledDataSource(StoreManager storeMgr) {
        int value;
        int size;
        String dbDriver = storeMgr.getConnectionDriverName();
        String dbURL = storeMgr.getConnectionURL();
        String dbUser = storeMgr.getConnectionUserName();
        String dbPassword = storeMgr.getConnectionPassword();
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        this.loadDriver(dbDriver, clr);
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.jolbox.bonecp.BoneCPDataSource", (String)"bonecp.jar");
        BoneCPDataSource ds = new BoneCPDataSource();
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxStatements") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.maxStatements")) >= 0) {
            ds.setStatementsCacheSize(size);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxPoolSize") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.maxPoolSize")) >= 0) {
            ds.setMaxConnectionsPerPartition(size);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.minPoolSize") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.minPoolSize")) >= 0) {
            ds.setMinConnectionsPerPartition(size);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxIdle") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.maxIdle")) > 0) {
            ds.setIdleMaxAge((long)value);
        }
        ds.setJdbcUrl(dbURL);
        ds.setUsername(dbUser);
        ds.setPassword(dbPassword);
        return ds;
    }
}

