/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLTableGroup;
import org.datanucleus.store.rdbms.sql.SQLTableNamer;

public class SQLTableAlphaNamer
implements SQLTableNamer {
    static String[] CHARS = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public String getAliasForTable(SQLStatement stmt, DatastoreContainerObject table, String groupName) {
        SQLTableGroup tableGrp = stmt.tableGroups.get(groupName);
        String groupLetters = null;
        int numTablesInGroup = 0;
        if (tableGrp == null || tableGrp.getNumberOfTables() == 0) {
            if (stmt.tableGroups.size() >= CHARS.length) {
                groupLetters = CHARS[stmt.tableGroups.size() / 26] + CHARS[stmt.tableGroups.size() % 26];
                numTablesInGroup = 0;
            } else {
                groupLetters = CHARS[stmt.tableGroups.size()];
            }
            numTablesInGroup = 0;
        } else {
            SQLTable refSqlTbl = tableGrp.getTables()[0];
            String baseTableAlias = refSqlTbl.getAlias().toString();
            String quote = stmt.getRDBMSManager().getDatastoreAdapter().getIdentifierQuoteString();
            int lettersStartPoint = 0;
            if (baseTableAlias.startsWith(quote)) {
                lettersStartPoint = quote.length();
            }
            int lettersLength = 1;
            if (Character.isLetter(lettersStartPoint + 1)) {
                lettersLength = 2;
            }
            groupLetters = baseTableAlias.substring(lettersStartPoint, lettersStartPoint + lettersLength);
            numTablesInGroup = tableGrp.getNumberOfTables();
        }
        if (stmt.parent != null) {
            return groupLetters + numTablesInGroup + "_SUB";
        }
        return groupLetters + numTablesInGroup;
    }
}

