/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.MapExpression;
import org.datanucleus.store.rdbms.sql.expression.MapLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.UnboundExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.util.NucleusLogger;

public class MapContainsValueMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        AbstractMemberMetaData mmd;
        if (args == null || args.size() == 0 || args.size() > 1) {
            throw new NucleusException(LOCALISER.msg("060016", (Object)"containsValue", (Object)"MapExpression", (Object)1));
        }
        MapExpression mapExpr = (MapExpression)expr;
        SQLExpression valExpr = (SQLExpression)args.get(0);
        if (valExpr.isParameter() && (mmd = mapExpr.getJavaTypeMapping().getMemberMetaData()) != null && mmd.getMap() != null) {
            Class valCls = this.stmt.getQueryGenerator().getClassLoaderResolver().classForName(mmd.getMap().getValueType());
            this.stmt.getQueryGenerator().bindParameter(valExpr.getParameterName(), valCls);
        }
        if (mapExpr instanceof MapLiteral) {
            MapLiteral lit = (MapLiteral)mapExpr;
            Map map = (Map)lit.getValue();
            if (map == null || map.size() == 0) {
                return new BooleanLiteral(this.stmt, expr.getJavaTypeMapping(), Boolean.FALSE, null);
            }
            MapLiteral.MapValueLiteral mapValueLiteral = lit.getValueLiteral();
            SQLExpression bExpr = null;
            List<SQLExpression> elementExprs = mapValueLiteral.getValueExpressions();
            for (int i = 0; i < elementExprs.size(); ++i) {
                bExpr = bExpr == null ? elementExprs.get(i).eq(valExpr) : ((BooleanExpression)bExpr).ior(elementExprs.get(i).eq(valExpr));
            }
            bExpr.encloseInParentheses();
            return bExpr;
        }
        if (this.stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.FILTER) {
            boolean needsSubquery = this.getNeedsSubquery();
            if (needsSubquery) {
                NucleusLogger.QUERY.debug((Object)("MapContainsValue on " + mapExpr + "(" + valExpr + ") using SUBQUERY"));
                return this.containsAsSubquery(mapExpr, valExpr);
            }
            NucleusLogger.QUERY.debug((Object)("MapContainsValue on " + mapExpr + "(" + valExpr + ") using INNERJOIN"));
            return this.containsAsInnerJoin(mapExpr, valExpr);
        }
        return this.containsAsSubquery(mapExpr, valExpr);
    }

    protected boolean getNeedsSubquery() {
        Boolean hasNOT;
        boolean needsSubquery = false;
        Boolean hasOR = (Boolean)this.stmt.getQueryGenerator().getProperty("Filter.OR");
        if (hasOR != null && hasOR.booleanValue()) {
            needsSubquery = true;
        }
        if ((hasNOT = (Boolean)this.stmt.getQueryGenerator().getProperty("Filter.NOT")) != null && hasNOT.booleanValue()) {
            needsSubquery = true;
        }
        return needsSubquery;
    }

    protected SQLExpression containsAsInnerJoin(MapExpression mapExpr, SQLExpression valExpr) {
        boolean valIsUnbound = valExpr instanceof UnboundExpression;
        String varName = null;
        if (valIsUnbound) {
            varName = ((UnboundExpression)valExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)(">> Map.containsValue binding unbound variable " + varName + " using INNER JOIN"));
        }
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        MetaDataManager mmgr = storeMgr.getMetaDataManager();
        AbstractMemberMetaData mmd = mapExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(this.clr, mmgr);
        if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
            MapTable mapTbl = (MapTable)storeMgr.getDatastoreContainerObject(mmd);
            SQLTable joinSqlTbl = this.stmt.innerJoin(mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), mapTbl, null, mapTbl.getOwnerMapping(), null, null);
            if (valCmd != null) {
                DatastoreClass valTbl = storeMgr.getDatastoreClass(valCmd.getFullClassName(), this.clr);
                SQLTable valSqlTbl = this.stmt.innerJoin(joinSqlTbl, mapTbl.getValueMapping(), (DatastoreContainerObject)valTbl, null, valTbl.getIdMapping(), null, null);
                if (valIsUnbound) {
                    valExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, valTbl.getIdMapping());
                    this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    SQLExpression valIdExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, valTbl.getIdMapping());
                    this.stmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            } else if (valIsUnbound) {
                valExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, mapTbl.getValueMapping());
                this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
            } else {
                SQLExpression valIdExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, mapTbl.getValueMapping());
                this.stmt.whereAnd(valIdExpr.eq(valExpr), true);
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            DatastoreClass valTbl = storeMgr.getDatastoreClass(valCmd.getFullClassName(), this.clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? valTbl.getMemberMapping(valCmd.getMetaDataForMember(mmd.getMappedBy())) : valTbl.getExternalMapping(mmd, 5);
            SQLTable valSqlTbl = this.stmt.innerJoin(mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), (DatastoreContainerObject)valTbl, null, ownerMapping, null, null);
            if (valIsUnbound) {
                valExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, valTbl.getIdMapping());
                this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
            } else {
                SQLExpression valIdExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, valTbl.getIdMapping());
                this.stmt.whereAnd(valIdExpr.eq(valExpr), true);
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(this.clr, mmgr);
            DatastoreClass keyTbl = storeMgr.getDatastoreClass(keyCmd.getFullClassName(), this.clr);
            AbstractMemberMetaData keyValMmd = keyCmd.getMetaDataForMember(mmd.getValueMetaData().getMappedBy());
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? keyTbl.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getMappedBy())) : keyTbl.getExternalMapping(mmd, 5);
            SQLTable keySqlTbl = this.stmt.innerJoin(mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), (DatastoreContainerObject)keyTbl, null, ownerMapping, null, null);
            if (valCmd != null) {
                DatastoreClass valTbl = storeMgr.getDatastoreClass(valCmd.getFullClassName(), this.clr);
                SQLTable valSqlTbl = this.stmt.innerJoin(keySqlTbl, keyTbl.getMemberMapping(keyValMmd), (DatastoreContainerObject)valTbl, null, valTbl.getIdMapping(), null, null);
                if (valIsUnbound) {
                    valExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, valTbl.getIdMapping());
                    this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    SQLExpression valIdExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, valTbl.getIdMapping());
                    this.stmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            } else if (valIsUnbound) {
                valExpr = this.exprFactory.newExpression(this.stmt, keySqlTbl, keyTbl.getMemberMapping(keyValMmd));
                this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
            } else {
                SQLExpression valIdExpr = this.exprFactory.newExpression(this.stmt, keySqlTbl, keyTbl.getMemberMapping(keyValMmd));
                this.stmt.whereAnd(valIdExpr.eq(valExpr), true);
            }
        }
        JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
        return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, true));
    }

    protected SQLExpression containsAsSubquery(MapExpression mapExpr, SQLExpression valExpr) {
        boolean valIsUnbound = valExpr instanceof UnboundExpression;
        String varName = null;
        if (valIsUnbound) {
            varName = ((UnboundExpression)valExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)(">> Map.containsValue binding unbound variable " + varName + " using SUBQUERY"));
        }
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        MetaDataManager mmgr = storeMgr.getMetaDataManager();
        AbstractMemberMetaData mmd = mapExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(this.clr, mmgr);
        MapTable joinTbl = (MapTable)storeMgr.getDatastoreContainerObject(mmd);
        SQLStatement subStmt = null;
        if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
            if (valCmd == null) {
                subStmt = new SQLStatement(this.stmt, storeMgr, joinTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (valIsUnbound) {
                    valExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), joinTbl.getValueMapping());
                    this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    SQLExpression valIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), joinTbl.getValueMapping());
                    subStmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            } else {
                DatastoreClass valTbl = storeMgr.getDatastoreClass(mmd.getMap().getValueType(), this.clr);
                subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)valTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable joinSqlTbl = subStmt.innerJoin(subStmt.getPrimaryTable(), valTbl.getIdMapping(), joinTbl, null, joinTbl.getValueMapping(), null, null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, joinSqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (valIsUnbound) {
                    valExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getIdMapping());
                    this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    SQLExpression valIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getIdMapping());
                    subStmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            DatastoreClass valTbl = storeMgr.getDatastoreClass(mmd.getMap().getValueType(), this.clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? valTbl.getMemberMapping(valCmd.getMetaDataForMember(mmd.getMappedBy())) : valTbl.getExternalMapping(mmd, 5);
            subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)valTbl, null, null);
            subStmt.setClassLoaderResolver(this.clr);
            JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
            subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
            SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
            SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
            subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
            if (valIsUnbound) {
                valExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getIdMapping());
                this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
            } else {
                JavaTypeMapping valMapping = valTbl.getIdMapping();
                SQLExpression valIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valMapping);
                subStmt.whereAnd(valIdExpr.eq(valExpr), true);
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(this.clr, mmgr);
            DatastoreClass keyTbl = storeMgr.getDatastoreClass(mmd.getMap().getKeyType(), this.clr);
            JavaTypeMapping ownerMapping = keyTbl.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getMappedBy()));
            AbstractMemberMetaData keyValMmd = keyCmd.getMetaDataForMember(mmd.getValueMetaData().getMappedBy());
            if (valCmd == null) {
                subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)keyTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (valIsUnbound) {
                    valExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyTbl.getMemberMapping(keyValMmd));
                    this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    JavaTypeMapping valMapping = keyTbl.getMemberMapping(keyValMmd);
                    SQLExpression valIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valMapping);
                    subStmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            } else {
                DatastoreClass valTbl = storeMgr.getDatastoreClass(mmd.getMap().getValueType(), this.clr);
                subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)valTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable keySqlTbl = subStmt.innerJoin(subStmt.getPrimaryTable(), valTbl.getIdMapping(), (DatastoreContainerObject)keyTbl, null, keyTbl.getMemberMapping(keyValMmd), null, null);
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, keySqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (valIsUnbound) {
                    valExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getIdMapping());
                    this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    SQLExpression valIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getIdMapping());
                    subStmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            }
        }
        return new BooleanSubqueryExpression(this.stmt, "EXISTS", subStmt);
    }
}

