/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.schema;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.schema.RDBMSTableInfo;
import org.datanucleus.store.schema.MapStoreSchemaData;
import org.datanucleus.store.schema.StoreSchemaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDBMSSchemaInfo
implements MapStoreSchemaData {
    private int hash = 0;
    Map properties = new HashMap();
    Map<String, StoreSchemaData> tables = new HashMap<String, StoreSchemaData>();

    public RDBMSSchemaInfo(String catalog, String schema) {
        this.addProperty("catalog", catalog);
        this.addProperty("schema", schema);
    }

    public void addChild(StoreSchemaData data) {
        RDBMSTableInfo table = (RDBMSTableInfo)data;
        String tableKey = (String)data.getProperty("table_key");
        if (tableKey == null) {
            throw new NucleusException("Attempt to add RDBMSTableInfo to RDBMSSchemaInfo with null table key! tableName=" + data.getProperty("table_name"));
        }
        this.tables.put(tableKey, (StoreSchemaData)table);
    }

    public void clearChildren() {
        this.tables.clear();
    }

    public StoreSchemaData getChild(String key) {
        return this.tables.get(key);
    }

    public Map<String, StoreSchemaData> getChildren() {
        return this.tables;
    }

    public int getNumberOfChildren() {
        return this.tables.size();
    }

    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public StoreSchemaData getParent() {
        return null;
    }

    public void setParent(StoreSchemaData parent) {
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RDBMSSchemaInfo)) {
            return false;
        }
        RDBMSSchemaInfo other = (RDBMSSchemaInfo)obj;
        String cat1 = (String)this.getProperty("table_cat");
        String sch1 = (String)this.getProperty("table_schem");
        String cat2 = (String)other.getProperty("table_cat");
        String sch2 = (String)other.getProperty("table_schem");
        return (cat1 == null ? cat2 == null : cat1.equals(cat2)) && (sch1 == null ? sch2 == null : sch1.equals(sch2));
    }

    public final int hashCode() {
        if (this.hash == 0) {
            String cat = (String)this.getProperty("table_cat");
            String sch = (String)this.getProperty("table_schem");
            this.hash = (cat == null ? 0 : cat.hashCode()) ^ (sch == null ? 0 : sch.hashCode());
        }
        return this.hash;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("RDBMSSchemaInfo : ");
        Iterator iter = this.properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            str.append(entry.getKey() + " = " + entry.getValue());
            if (!iter.hasNext()) continue;
            str.append(", ");
        }
        str.append(", numTables=" + this.tables.size());
        return str.toString();
    }
}

