/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query.legacy;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.legacy.AbstractIteratorStatement;
import org.datanucleus.store.rdbms.table.ClassTable;

public class DiscriminatorIteratorStatement
extends AbstractIteratorStatement {
    private boolean selectDiscriminator;
    private boolean restrictDiscriminator = true;
    private boolean allowNulls = false;
    private DatastoreContainerObject selectTable;
    private JavaTypeMapping selectCandidateMapping;
    private DatastoreIdentifier candidateTableIdentifier;
    private Class[] candidateTypes;

    public DiscriminatorIteratorStatement(ClassLoaderResolver clr, Class[] candidateTypes, boolean includeSubclasses, StoreManager storeMgr, boolean selectDiscriminator) {
        super(candidateTypes[0], clr, includeSubclasses, storeMgr);
        this.selectDiscriminator = selectDiscriminator;
        this.candidateTypes = candidateTypes;
    }

    public DiscriminatorIteratorStatement(ClassLoaderResolver clr, Class[] candidateType, boolean includeSubclasses, StoreManager storeMgr, boolean selectDiscriminator, boolean allowNulls, DatastoreContainerObject selectTable, JavaTypeMapping selectCandidateMapping, DatastoreIdentifier candidateTableIdentifier) {
        this(clr, candidateType, includeSubclasses, storeMgr, selectDiscriminator);
        this.selectTable = selectTable;
        this.selectCandidateMapping = selectCandidateMapping;
        this.candidateTableIdentifier = candidateTableIdentifier;
        this.allowNulls = allowNulls;
    }

    public void setRestrictDiscriminator(boolean restrict) {
        this.restrictDiscriminator = restrict;
    }

    public QueryExpression getQueryStatement(DatastoreIdentifier candidateAlias) {
        String[] managedClasses;
        QueryExpression stmt = null;
        DiscriminatorMetaData dismd = this.candidateTable.getDiscriminatorMetaData();
        JavaTypeMapping discriminatorMapping = this.candidateTable.getDiscriminatorMapping(true);
        if (discriminatorMapping != null) {
            dismd = discriminatorMapping.getDatastoreContainer().getDiscriminatorMetaData();
        }
        boolean hasDiscriminator = discriminatorMapping != null && dismd.getStrategy() != DiscriminatorStrategy.NONE;
        LogicSetExpression discrimTableExpr = null;
        if (this.selectTable != null) {
            stmt = this.dba.newQueryStatement(this.selectTable, candidateAlias, this.clr);
            ScalarExpression selectExpression = this.selectCandidateMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
            LogicSetExpression candidateTableExpression = stmt.newTableExpression((DatastoreContainerObject)this.candidateTable, this.candidateTableIdentifier);
            ScalarExpression candidateExpression = this.candidateTable.getIDMapping().newScalarExpression(stmt, candidateTableExpression);
            if (this.allowNulls) {
                stmt.leftOuterJoin(selectExpression, candidateExpression, candidateTableExpression, true);
            } else {
                stmt.innerJoin(selectExpression, candidateExpression, candidateTableExpression, true);
            }
            discrimTableExpr = stmt.getTableExpression(this.candidateTableIdentifier);
            if (hasDiscriminator && this.selectDiscriminator) {
                stmt.selectScalarExpression(this.candidateTable.getDiscriminatorMapping(true).newScalarExpression(stmt, candidateTableExpression));
            }
        } else {
            stmt = this.dba.newQueryStatement((DatastoreContainerObject)this.candidateTable, candidateAlias, this.clr);
            discrimTableExpr = stmt.getMainTableExpression();
            if (hasDiscriminator && this.selectDiscriminator) {
                stmt.select(discriminatorMapping);
            }
        }
        if (this.includeSubclasses && hasDiscriminator && this.candidateTable.getDiscriminatorMapping(false) != null && !this.storeMgr.getOMFContext().getMetaDataManager().isPersistentDefinitionImplementation(this.candidateFullClassName) && (managedClasses = this.getCandidateTableManagedClasses()).length == 1) {
            this.restrictDiscriminator = false;
        }
        if (hasDiscriminator && this.restrictDiscriminator) {
            boolean multipleDiscriminatorValues = this.candidateTypes.length > 1;
            BooleanExpression discExpr = null;
            for (int i = 0; i < this.candidateTypes.length; ++i) {
                String candidateName = this.candidateTypes[i].getName();
                BooleanExpression discExprCand = DiscriminatorIteratorStatement.getExpressionForDiscriminatorForClass(stmt, candidateName, dismd, discriminatorMapping, discrimTableExpr, (StoreManager)this.storeMgr);
                discExpr = discExpr != null ? discExpr.ior((ScalarExpression)discExprCand) : discExprCand;
                if (!this.includeSubclasses) continue;
                for (String subCandidateType : this.storeMgr.getSubClassesForClass(candidateName, true, this.clr)) {
                    BooleanExpression discExprSub = DiscriminatorIteratorStatement.getExpressionForDiscriminatorForClass(stmt, subCandidateType, dismd, discriminatorMapping, discrimTableExpr, (StoreManager)this.storeMgr);
                    discExpr = discExpr.ior((ScalarExpression)discExprSub);
                    if (multipleDiscriminatorValues) continue;
                    multipleDiscriminatorValues = true;
                }
            }
            if (this.allowNulls) {
                ScalarExpression expr = discriminatorMapping.newScalarExpression(stmt, discrimTableExpr);
                NullLiteral val = new NullLiteral(stmt);
                BooleanExpression nullDiscExpr = expr.eq((ScalarExpression)val);
                discExpr = discExpr.ior((ScalarExpression)nullDiscExpr);
                if (!multipleDiscriminatorValues) {
                    multipleDiscriminatorValues = true;
                }
            }
            if (multipleDiscriminatorValues) {
                discExpr.encloseWithInParentheses();
            }
            stmt.andCondition(discExpr);
        }
        return stmt;
    }

    private static BooleanExpression getExpressionForDiscriminatorForClass(QueryExpression stmt, String className, DiscriminatorMetaData dismd, JavaTypeMapping discriminatorMapping, LogicSetExpression discrimTableExpr, StoreManager storeMgr) {
        String discriminatorValue = className;
        if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
            AbstractClassMetaData targetCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(className, stmt.getClassLoaderResolver());
            discriminatorValue = targetCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
        }
        ScalarExpression discrExpr = discriminatorMapping.newScalarExpression(stmt, discrimTableExpr);
        ScalarExpression discrVal = discriminatorMapping.newLiteral(stmt, (Object)discriminatorValue);
        return discrExpr.eq(discrVal);
    }

    protected String[] getCandidateTableManagedClasses() {
        return ((ClassTable)this.candidateTable).getManagedClasses();
    }
}

