/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.AbstractStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.util.StringUtils;

public class UnionStatementGenerator
extends AbstractStatementGenerator {
    public static final String NUC_TYPE_COLUMN = "NUCLEUS_TYPE";
    private int maxClassNameLength = -1;

    public UnionStatementGenerator(RDBMSStoreManager storeMgr, Class candidateType, boolean includeSubclasses, DatastoreIdentifier candidateTableAlias, String candidateTableGroupName) {
        super(storeMgr, candidateType, includeSubclasses, candidateTableAlias, candidateTableGroupName);
    }

    public UnionStatementGenerator(RDBMSStoreManager storeMgr, Class candidateType, boolean includeSubclasses, DatastoreIdentifier candidateTableAlias, String candidateTableGroupName, DatastoreContainerObject joinTable, DatastoreIdentifier joinTableAlias, JavaTypeMapping joinElementMapping) {
        super(storeMgr, candidateType, includeSubclasses, candidateTableAlias, candidateTableGroupName, joinTable, joinTableAlias, joinElementMapping);
    }

    public void setParentStatement(SQLStatement stmt) {
        this.parentStmt = stmt;
    }

    public SQLStatement getStatement() {
        ClassLoaderResolver clr = this.storeMgr.getOMFContext().getClassLoaderResolver(null);
        ArrayList<String> candidateClassNames = new ArrayList<String>();
        candidateClassNames.add(this.candidateType.getName());
        if (this.includeSubclasses) {
            HashSet subclasses = this.storeMgr.getSubClassesForClass(this.candidateType.getName(), true, clr);
            candidateClassNames.addAll(subclasses);
        }
        Iterator iter = candidateClassNames.iterator();
        while (iter.hasNext()) {
            String className = (String)iter.next();
            try {
                Class cls = clr.classForName(className);
                if (!Modifier.isAbstract(cls.getModifiers())) continue;
                iter.remove();
            }
            catch (Exception e) {
                iter.remove();
            }
        }
        if (this.hasOption("selectNucleusType")) {
            for (String className : candidateClassNames) {
                if (className.length() <= this.maxClassNameLength) continue;
                this.maxClassNameLength = className.length();
            }
        }
        if (candidateClassNames.isEmpty()) {
            throw new NucleusException("Attempt to generate SQL statement using UNIONs for " + this.candidateType.getName() + " yet there are no concrete classes with their own table available");
        }
        SQLStatement stmt = null;
        for (String candidateClassName : candidateClassNames) {
            SQLStatement candidateStmt = null;
            candidateStmt = this.joinTable == null ? this.getSQLStatementForCandidate(candidateClassName) : this.getSQLStatementForCandidateViaJoin(candidateClassName);
            if (stmt == null) {
                stmt = candidateStmt;
                continue;
            }
            stmt.union(candidateStmt);
        }
        return stmt;
    }

    protected SQLStatement getSQLStatementForCandidate(String className) {
        ClassLoaderResolver clr = this.storeMgr.getOMFContext().getClassLoaderResolver(null);
        DatastoreClass table = this.storeMgr.getDatastoreClass(className, clr);
        if (table == null) {
            // empty if block
        }
        SQLStatement stmt = new SQLStatement(this.storeMgr, (DatastoreContainerObject)this.candidateTable, this.candidateTableAlias, this.candidateTableGroupName);
        stmt.setCandidateClassName(className);
        if (table != this.candidateTable) {
            JavaTypeMapping candidateIdMapping = this.candidateTable.getIDMapping();
            JavaTypeMapping tableIdMapping = table.getIDMapping();
            stmt.innerJoin(null, candidateIdMapping, (DatastoreContainerObject)table, null, tableIdMapping, null, stmt.getPrimaryTable().getGroupName());
        }
        SQLExpressionFactory factory = this.storeMgr.getSQLExpressionFactory();
        JavaTypeMapping discriminatorMapping = table.getDiscriminatorMapping(false);
        DiscriminatorMetaData discriminatorMetaData = table.getDiscriminatorMetaData();
        if (discriminatorMapping != null && discriminatorMetaData.getStrategy() != DiscriminatorStrategy.NONE) {
            String discriminatorValue = className;
            if (discriminatorMetaData.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                AbstractClassMetaData targetCmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(className, clr);
                discriminatorValue = targetCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
            }
            SQLExpression discExpr = factory.newExpression(stmt, stmt.getPrimaryTable(), discriminatorMapping);
            SQLExpression discVal = factory.newLiteral(stmt, discriminatorMapping, discriminatorValue);
            stmt.whereAnd(discExpr.eq(discVal), false);
        }
        for (String subclassName : this.storeMgr.getSubClassesForClass(className, false, clr)) {
            DatastoreClass[] subclassTables = null;
            DatastoreClass subclassTable = this.storeMgr.getDatastoreClass(subclassName, clr);
            if (subclassTable == null) {
                AbstractClassMetaData targetSubCmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(subclassName, clr);
                AbstractClassMetaData[] targetSubCmds = this.storeMgr.getClassesManagingTableForClass(targetSubCmd, clr);
                subclassTables = new DatastoreClass[targetSubCmds.length];
                for (int i = 0; i < targetSubCmds.length; ++i) {
                    subclassTables[i] = this.storeMgr.getDatastoreClass(targetSubCmds[i].getFullClassName(), clr);
                }
            } else {
                subclassTables = new DatastoreClass[]{subclassTable};
            }
            for (int i = 0; i < subclassTables.length; ++i) {
                if (subclassTables[i] == table) continue;
                JavaTypeMapping tableIdMapping = table.getIDMapping();
                JavaTypeMapping subclassIdMapping = subclassTables[i].getIDMapping();
                SQLTable sqlTableSubclass = stmt.leftOuterJoin(null, tableIdMapping, (DatastoreContainerObject)subclassTables[i], null, subclassIdMapping, null, stmt.getPrimaryTable().getGroupName());
                SQLExpression subclassIdExpr = factory.newExpression(stmt, sqlTableSubclass, subclassIdMapping);
                NullLiteral nullExpr = new NullLiteral(stmt, null, null, false);
                stmt.whereAnd(subclassIdExpr.eq(nullExpr), false);
            }
        }
        if (this.hasOption("selectNucleusType")) {
            this.addTypeSelectForClass(stmt, className);
        }
        return stmt;
    }

    protected SQLStatement getSQLStatementForCandidateViaJoin(String className) {
        ClassLoaderResolver clr = this.storeMgr.getOMFContext().getClassLoaderResolver(null);
        DatastoreClass table = this.storeMgr.getDatastoreClass(className, clr);
        if (table == null) {
            // empty if block
        }
        SQLStatement stmt = new SQLStatement(this.storeMgr, this.joinTable, this.joinTableAlias, this.candidateTableGroupName);
        stmt.setCandidateClassName(className);
        JavaTypeMapping candidateIdMapping = this.candidateTable.getIDMapping();
        SQLTable candidateSQLTable = null;
        candidateSQLTable = this.hasOption("allowNulls") ? stmt.leftOuterJoin(null, this.joinElementMapping, (DatastoreContainerObject)this.candidateTable, null, candidateIdMapping, null, stmt.getPrimaryTable().getGroupName()) : stmt.innerJoin(null, this.joinElementMapping, (DatastoreContainerObject)this.candidateTable, null, candidateIdMapping, null, stmt.getPrimaryTable().getGroupName());
        if (table != this.candidateTable) {
            JavaTypeMapping tableIdMapping = table.getIDMapping();
            stmt.innerJoin(candidateSQLTable, candidateIdMapping, (DatastoreContainerObject)table, null, tableIdMapping, null, stmt.getPrimaryTable().getGroupName());
        }
        SQLExpressionFactory factory = this.storeMgr.getSQLExpressionFactory();
        JavaTypeMapping discriminatorMapping = table.getDiscriminatorMapping(false);
        DiscriminatorMetaData discriminatorMetaData = table.getDiscriminatorMetaData();
        if (discriminatorMapping != null && discriminatorMetaData.getStrategy() != DiscriminatorStrategy.NONE) {
            BooleanExpression discExpr = SQLStatementHelper.getExpressionForDiscriminatorForClass(stmt, className, discriminatorMetaData, discriminatorMapping, stmt.getPrimaryTable());
            stmt.whereAnd(discExpr, false);
        }
        for (String subclassName : this.storeMgr.getSubClassesForClass(className, false, clr)) {
            DatastoreClass[] subclassTables = null;
            DatastoreClass subclassTable = this.storeMgr.getDatastoreClass(subclassName, clr);
            if (subclassTable == null) {
                AbstractClassMetaData targetSubCmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(subclassName, clr);
                AbstractClassMetaData[] targetSubCmds = this.storeMgr.getClassesManagingTableForClass(targetSubCmd, clr);
                subclassTables = new DatastoreClass[targetSubCmds.length];
                for (int i = 0; i < targetSubCmds.length; ++i) {
                    subclassTables[i] = this.storeMgr.getDatastoreClass(targetSubCmds[i].getFullClassName(), clr);
                }
            } else {
                subclassTables = new DatastoreClass[]{subclassTable};
            }
            for (int i = 0; i < subclassTables.length; ++i) {
                if (subclassTables[i] == table) continue;
                JavaTypeMapping subclassIdMapping = subclassTables[i].getIDMapping();
                SQLTable sqlTableSubclass = stmt.leftOuterJoin(null, this.joinElementMapping, (DatastoreContainerObject)subclassTables[i], null, subclassIdMapping, null, stmt.getPrimaryTable().getGroupName());
                SQLExpression subclassIdExpr = factory.newExpression(stmt, sqlTableSubclass, subclassIdMapping);
                NullLiteral nullExpr = new NullLiteral(stmt, null, null, false);
                stmt.whereAnd(subclassIdExpr.eq(nullExpr), false);
            }
        }
        if (this.hasOption("selectNucleusType")) {
            this.addTypeSelectForClass(stmt, className);
        }
        return stmt;
    }

    private void addTypeSelectForClass(SQLStatement stmt, String className) {
        if (this.hasOption("selectNucleusType")) {
            if (this.hasOption("allowNulls")) {
                NullLiteral nullLtl = new NullLiteral(stmt, null, null, false);
                stmt.select(nullLtl, NUC_TYPE_COLUMN);
            } else {
                JavaTypeMapping m = this.storeMgr.getMappingManager().getMapping(String.class);
                String nuctypeName = className;
                if (this.maxClassNameLength > nuctypeName.length()) {
                    nuctypeName = StringUtils.leftAlignedPaddedString((String)nuctypeName, (int)this.maxClassNameLength);
                }
                StringLiteral lit = new StringLiteral(stmt, m, nuctypeName, false);
                stmt.select(lit, NUC_TYPE_COLUMN);
            }
        }
    }
}

