/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.StatementParameterMapping;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.SerialisedMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.mapped.scostore.AbstractMapStore;
import org.datanucleus.store.mapped.scostore.AbstractMapStoreSpecialization;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.JoinMapStore;
import org.datanucleus.store.mapped.scostore.MapEntrySetStore;
import org.datanucleus.store.mapped.scostore.MapKeySetStore;
import org.datanucleus.store.mapped.scostore.MapValueSetStore;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.RDBMSAbstractMapStoreSpecialization;
import org.datanucleus.store.rdbms.scostore.RDBMSMapEntrySetStore;
import org.datanucleus.store.rdbms.scostore.RDBMSMapKeySetStore;
import org.datanucleus.store.rdbms.scostore.RDBMSMapValueSetStore;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.scostore.MapStore;

public class RDBMSJoinMapStore
extends JoinMapStore {
    private String putStmt;
    private String updateStmt;
    private String removeStmt;
    private String clearStmt;
    private String getStmtLocked = null;
    private String getStmtUnlocked = null;
    private StatementClassMapping getMappingDef = null;
    private StatementParameterMapping getMappingParams = null;

    public RDBMSJoinMapStore(MapTable mapTable, ClassLoaderResolver clr) {
        super((DatastoreContainerObject)mapTable, clr, mapTable.getOwnerMapping(), mapTable.getKeyMapping(), mapTable.getValueMapping(), mapTable.getOrderMapping(), mapTable.getKeyType(), mapTable.isEmbeddedKey(), mapTable.isSerialisedKey(), mapTable.getValueType(), mapTable.isEmbeddedValue(), mapTable.isSerialisedValue(), mapTable.getOwnerMemberMetaData(), (AbstractMapStoreSpecialization)new RDBMSAbstractMapStoreSpecialization(LOCALISER, clr, (RDBMSStoreManager)mapTable.getStoreManager()));
        this.specialization.initialise((AbstractMapStore)this);
        this.putStmt = this.getPutStmt();
        this.updateStmt = this.getUpdateStmt();
        this.removeStmt = this.getRemoveStmt();
        this.clearStmt = this.getClearStmt();
    }

    private RDBMSStoreManager getStoreMgr() {
        return (RDBMSStoreManager)this.storeMgr;
    }

    private String getPutStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("INSERT INTO ");
        stmt.append(this.mapTable.toString());
        stmt.append(" (");
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
        }
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
        }
        if (this.adapterMapping != null) {
            for (i = 0; i < this.adapterMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(this.adapterMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            }
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
        }
        stmt.append(") VALUES (");
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((RDBMSMapping)this.valueMapping.getDataStoreMapping(i)).getInsertionInputParameter());
        }
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getInsertionInputParameter());
        }
        if (this.adapterMapping != null) {
            for (i = 0; i < this.adapterMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((RDBMSMapping)this.adapterMapping.getDataStoreMapping(i)).getInsertionInputParameter());
            }
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getInsertionInputParameter());
        }
        stmt.append(") ");
        return stmt.toString();
    }

    private String getUpdateStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.mapTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.valueMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    private String getRemoveStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    private String getClearStmt() {
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        for (int i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue(StateManager ownerSM, Object key) throws NoSuchElementException {
        Transaction tx;
        if (!this.validateKeyForReading(ownerSM, key)) {
            return null;
        }
        ObjectManager om = ownerSM.getObjectManager();
        if (this.getStmtLocked == null) {
            RDBMSJoinMapStore rDBMSJoinMapStore = this;
            synchronized (rDBMSJoinMapStore) {
                SQLStatement sqlStmt = this.getSQLStatementForGet(ownerSM);
                this.getStmtUnlocked = sqlStmt.getSelectStatement().toSQL();
                sqlStmt.addExtension("lock-for-update", true);
                this.getStmtLocked = sqlStmt.getSelectStatement().toSQL();
            }
        }
        String stmt = (tx = om.getTransaction()).lockReadObjects() ? this.getStmtLocked : this.getStmtUnlocked;
        Object value = null;
        try {
            RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.storeMgr;
            ManagedConnection mconn = storeMgr.getConnection(om);
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                StatementMappingIndex ownerIdx = this.getMappingParams.getMappingForParameter("owner");
                int numParams = ownerIdx.getNumberOfParameterOccurrences();
                for (int paramInstance = 0; paramInstance < numParams; ++paramInstance) {
                    ownerIdx.getMapping().setObject(om, (Object)ps, ownerIdx.getParameterPositionsForOccurrence(paramInstance), ownerSM.getObject());
                }
                StatementMappingIndex keyIdx = this.getMappingParams.getMappingForParameter("key");
                numParams = keyIdx.getNumberOfParameterOccurrences();
                for (int paramInstance = 0; paramInstance < numParams; ++paramInstance) {
                    keyIdx.getMapping().setObject(om, (Object)ps, keyIdx.getParameterPositionsForOccurrence(paramInstance), key);
                }
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        boolean found = rs.next();
                        if (!found) {
                            throw new NoSuchElementException();
                        }
                        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
                            int[] param = new int[this.valueMapping.getNumberOfDatastoreFields()];
                            for (int i = 0; i < param.length; ++i) {
                                param[i] = i + 1;
                            }
                            if (this.valueMapping instanceof SerialisedPCMapping || this.valueMapping instanceof SerialisedReferenceMapping || this.valueMapping instanceof EmbeddedKeyPCMapping) {
                                int ownerFieldNumber = ((JoinTable)this.mapTable).getOwnerMemberMetaData().getAbsoluteFieldNumber();
                                value = this.valueMapping.getObject(om, (Object)rs, param, ownerSM, ownerFieldNumber);
                            } else {
                                value = this.valueMapping.getObject(om, (Object)rs, param);
                            }
                        } else if (this.valueMapping instanceof ReferenceMapping) {
                            int[] param = new int[this.valueMapping.getNumberOfDatastoreFields()];
                            for (int i = 0; i < param.length; ++i) {
                                param[i] = i + 1;
                            }
                            value = this.valueMapping.getObject(om, (Object)rs, param);
                        } else {
                            ResultObjectFactory rof = storeMgr.newResultObjectFactory(this.vmd, this.getMappingDef, false, null, this.clr.classForName(this.valueType));
                            value = rof.getObject(om, (Object)rs);
                        }
                        JDBCUtils.logWarnings(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056014", (Object)stmt), (Throwable)e);
        }
        return value;
    }

    protected SQLStatement getSQLStatementForGet(StateManager ownerSM) {
        SQLExpression keyVal;
        SQLExpression keyExpr;
        SQLStatement sqlStmt = null;
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        Class valueCls = clr.classForName(this.valueType);
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.storeMgr;
        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
            sqlStmt = new SQLStatement(storeMgr, this.mapTable, null, null);
            sqlStmt.select(sqlStmt.getPrimaryTable(), this.valueMapping, null);
        } else {
            this.getMappingDef = new StatementClassMapping();
            UnionStatementGenerator stmtGen = new UnionStatementGenerator(storeMgr, valueCls, true, null, null, this.mapTable, null, this.valueMapping);
            stmtGen.setOption("selectNucleusType");
            this.getMappingDef.setNucleusTypeColumnName("NUCLEUS_TYPE");
            sqlStmt = stmtGen.getStatement();
            SQLTable valueSqlTbl = sqlStmt.getTable((DatastoreContainerObject)this.valueTable, sqlStmt.getPrimaryTable().getGroupName());
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.getMappingDef, ownerSM.getObjectManager().getFetchPlan(), valueSqlTbl, this.vmd, 0);
        }
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
        SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
        SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null);
        sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        if (this.keyMapping instanceof SerialisedMapping) {
            keyExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.keyMapping);
            keyVal = exprFactory.newLiteralParameter(sqlStmt, this.keyMapping, null);
            sqlStmt.whereAnd(new BooleanExpression(keyExpr, Expression.OP_LIKE, keyVal), true);
        } else {
            keyExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.keyMapping);
            keyVal = exprFactory.newLiteralParameter(sqlStmt, this.keyMapping, null);
            sqlStmt.whereAnd(keyExpr.eq(keyVal), true);
        }
        int inputParamNum = 1;
        StatementMappingIndex ownerIdx = new StatementMappingIndex(this.ownerMapping);
        StatementMappingIndex keyIdx = new StatementMappingIndex(this.keyMapping);
        if (sqlStmt.getNumberOfUnions() > 0) {
            for (int j = 0; j < sqlStmt.getNumberOfUnions() + 1; ++j) {
                int[] ownerPositions = new int[this.ownerMapping.getNumberOfDatastoreFields()];
                for (int k = 0; k < ownerPositions.length; ++k) {
                    ownerPositions[k] = inputParamNum++;
                }
                ownerIdx.addParameterOccurrence(ownerPositions);
                int[] keyPositions = new int[this.keyMapping.getNumberOfDatastoreFields()];
                for (int k = 0; k < keyPositions.length; ++k) {
                    keyPositions[k] = inputParamNum++;
                }
                keyIdx.addParameterOccurrence(keyPositions);
            }
        } else {
            int[] ownerPositions = new int[this.ownerMapping.getNumberOfDatastoreFields()];
            for (int k = 0; k < ownerPositions.length; ++k) {
                ownerPositions[k] = inputParamNum++;
            }
            ownerIdx.addParameterOccurrence(ownerPositions);
            int[] keyPositions = new int[this.keyMapping.getNumberOfDatastoreFields()];
            for (int k = 0; k < keyPositions.length; ++k) {
                keyPositions[k] = inputParamNum++;
            }
            keyIdx.addParameterOccurrence(keyPositions);
        }
        this.getMappingParams = new StatementParameterMapping();
        this.getMappingParams.addMappingForParameter("owner", ownerIdx);
        this.getMappingParams.addMappingForParameter("key", keyIdx);
        return sqlStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearInternal(StateManager ownerSM) {
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.getStoreMgr().getConnection(om);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, (BaseContainerStore)this);
                    sqlControl.executeStatementUpdate(mconn, this.clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056013", (Object)this.clearStmt), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInternal(StateManager sm, Object key) {
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.getStoreMgr().getConnection(om);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.removeStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)this);
                    jdbcPosition = BackingStoreHelper.populateKeyInStatement(om, ps, key, jdbcPosition, this.keyMapping);
                    sqlControl.executeStatementUpdate(mconn, this.removeStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056012", (Object)this.removeStmt), (Throwable)e);
        }
    }

    protected MapKeySetStore newMapKeySetStore() {
        return new RDBMSMapKeySetStore((MapTable)this.mapTable, (MapStore)this, this.clr);
    }

    protected MapValueSetStore newMapValueSetStore() {
        return new RDBMSMapValueSetStore((MapTable)this.mapTable, (MapStore)this, this.clr);
    }

    protected MapEntrySetStore newMapEntrySetStore() {
        return new RDBMSMapEntrySetStore((MapTable)this.mapTable, (MapStore)this, this.clr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalUpdate(StateManager ownerSM, ManagedConnection conn, boolean batched, Object key, Object value, boolean executeNow) throws MappedDatastoreException {
        ObjectManager om = ownerSM.getObjectManager();
        SQLController sqlControl = this.getStoreMgr().getSQLController();
        try {
            PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.updateStmt, false);
            try {
                int jdbcPosition = 1;
                jdbcPosition = this.valueMapping != null ? BackingStoreHelper.populateValueInStatement(om, ps, value, jdbcPosition, this.valueMapping) : BackingStoreHelper.populateEmbeddedValueFieldsInStatement(ownerSM, value, ps, jdbcPosition, (JoinTable)this.mapTable, (AbstractMapStore)this);
                jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, (BaseContainerStore)this);
                jdbcPosition = BackingStoreHelper.populateKeyInStatement(om, ps, key, jdbcPosition, this.keyMapping);
                if (batched) {
                    ps.addBatch();
                } else {
                    sqlControl.executeStatementUpdate(conn, this.updateStmt, ps, true);
                }
            }
            finally {
                sqlControl.closeStatement(conn, ps);
            }
        }
        catch (SQLException e) {
            throw new MappedDatastoreException(this.getUpdateStmt(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] internalPut(StateManager ownerSM, ManagedConnection conn, boolean batched, Object key, Object value, boolean executeNow) throws MappedDatastoreException {
        int[] nArray;
        ObjectManager om = ownerSM.getObjectManager();
        SQLController sqlControl = this.getStoreMgr().getSQLController();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.putStmt, false);
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.valueMapping != null ? BackingStoreHelper.populateValueInStatement(om, ps, value, jdbcPosition, this.valueMapping) : BackingStoreHelper.populateEmbeddedValueFieldsInStatement(ownerSM, value, ps, jdbcPosition, (JoinTable)this.mapTable, (AbstractMapStore)this);
            jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, (BaseContainerStore)this);
            if (this.adapterMapping != null) {
                long nextIDAdapter = this.getNextIDForAdapterColumn(ownerSM);
                this.adapterMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)this.adapterMapping), (Object)new Long(nextIDAdapter));
                jdbcPosition += this.adapterMapping.getNumberOfDatastoreFields();
            }
            jdbcPosition = BackingStoreHelper.populateKeyInStatement(om, ps, key, jdbcPosition, this.keyMapping);
            nArray = sqlControl.executeStatementUpdate(conn, this.putStmt, ps, true);
        }
        catch (Throwable throwable) {
            try {
                sqlControl.closeStatement(conn, ps);
                throw throwable;
            }
            catch (SQLException e) {
                throw new MappedDatastoreException(this.getPutStmt(), (Throwable)e);
            }
        }
        sqlControl.closeStatement(conn, ps);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextIDForAdapterColumn(StateManager sm) {
        int nextID;
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.getStoreMgr().getConnection(om);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                String stmt = this.getMaxAdapterColumnIdStmt();
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)this);
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        nextID = !rs.next() ? 1 : rs.getInt(1) + 1;
                        JDBCUtils.logWarnings(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056020", (Object)this.getMaxAdapterColumnIdStmt()), (Throwable)e);
        }
        return nextID;
    }

    private String getMaxAdapterColumnIdStmt() {
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT MAX(" + this.adapterMapping.getDataStoreMapping(0).getDatastoreField().getIdentifier().toString() + ")");
        stmt.append(" FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        for (int i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }
}

