/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.EmbeddedElementPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedValuePCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.mapped.scostore.AbstractMapStore;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.table.JoinTable;

public class BackingStoreHelper {
    public static int populateOwnerInStatement(StateManager sm, ObjectManager om, Object ps, int jdbcPosition, BaseContainerStore bcs) {
        MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
        if (!storeMgr.insertValuesOnInsert(bcs.getOwnerMapping().getDataStoreMapping(0))) {
            return jdbcPosition;
        }
        if (bcs.getOwnerMemberMetaData() != null) {
            bcs.getOwnerMapping().setObject(om, ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)bcs.getOwnerMapping()), sm.getObject(), sm, bcs.getOwnerMemberMetaData().getAbsoluteFieldNumber());
        } else {
            bcs.getOwnerMapping().setObject(om, ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)bcs.getOwnerMapping()), sm.getObject());
        }
        return jdbcPosition + bcs.getOwnerMapping().getNumberOfDatastoreFields();
    }

    public static int populateRelationDiscriminatorInStatement(ObjectManager om, PreparedStatement ps, int jdbcPosition, ElementContainerStore ecs) {
        ecs.getRelationDiscriminatorMapping().setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)ecs.getRelationDiscriminatorMapping()), (Object)ecs.getRelationDiscriminatorValue());
        return jdbcPosition + ecs.getRelationDiscriminatorMapping().getNumberOfDatastoreFields();
    }

    public static int populateOrderInStatement(ObjectManager om, Object ps, int idx, int jdbcPosition, JavaTypeMapping orderMapping) {
        orderMapping.setObject(om, ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)orderMapping), (Object)new Integer(idx));
        return jdbcPosition + orderMapping.getNumberOfDatastoreFields();
    }

    public static int populateElementInStatement(ObjectManager om, Object ps, Object element, int jdbcPosition, JavaTypeMapping elementMapping) {
        MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
        if (!storeMgr.insertValuesOnInsert(elementMapping.getDataStoreMapping(0))) {
            return jdbcPosition;
        }
        elementMapping.setObject(om, ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)elementMapping), element);
        return jdbcPosition + elementMapping.getNumberOfDatastoreFields();
    }

    public static int populateKeyInStatement(ObjectManager om, PreparedStatement ps, Object key, int jdbcPosition, JavaTypeMapping keyMapping) {
        if (!((RDBMSMapping)keyMapping.getDataStoreMapping(0)).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        keyMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)keyMapping), key);
        return jdbcPosition + keyMapping.getNumberOfDatastoreFields();
    }

    public static int populateValueInStatement(ObjectManager om, PreparedStatement ps, Object value, int jdbcPosition, JavaTypeMapping valueMapping) {
        if (!((RDBMSMapping)valueMapping.getDataStoreMapping(0)).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        valueMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)valueMapping), value);
        return jdbcPosition + valueMapping.getNumberOfDatastoreFields();
    }

    public static int populateElementDiscriminatorInStatement(ObjectManager om, PreparedStatement ps, int jdbcPosition, boolean includeSubclasses, ElementContainerStore.ElementInfo info, ClassLoaderResolver clr) {
        HashSet subclasses;
        MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
        DiscriminatorStrategy strategy = info.getDiscriminatorStrategy();
        JavaTypeMapping discrimMapping = info.getDiscriminatorMapping();
        if (strategy == DiscriminatorStrategy.CLASS_NAME) {
            discrimMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)discrimMapping), (Object)info.getClassName());
            jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
        } else if (strategy == DiscriminatorStrategy.VALUE_MAP) {
            discrimMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)discrimMapping), (Object)info.getAbstractClassMetaData().getInheritanceMetaData().getDiscriminatorMetaData().getValue());
            jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
        }
        if (includeSubclasses && (subclasses = storeMgr.getSubClassesForClass(info.getClassName(), true, clr)) != null && subclasses.size() > 0) {
            for (String subclass : subclasses) {
                if (strategy == DiscriminatorStrategy.CLASS_NAME) {
                    discrimMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)discrimMapping), (Object)subclass);
                    jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
                    continue;
                }
                if (strategy != DiscriminatorStrategy.VALUE_MAP) continue;
                AbstractClassMetaData subclassCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(subclass, clr);
                discrimMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)discrimMapping), (Object)subclassCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue());
                jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
            }
        }
        return jdbcPosition;
    }

    public static int populateEmbeddedElementFieldsInStatement(StateManager sm, Object element, Object ps, int jdbcPosition, AbstractMemberMetaData ownerFieldMetaData, JavaTypeMapping elementMapping, AbstractClassMetaData emd, BaseContainerStore bcs) {
        MappedStoreManager storeMgr = (MappedStoreManager)sm.getObjectManager().getStoreManager();
        EmbeddedElementPCMapping embeddedMapping = (EmbeddedElementPCMapping)elementMapping;
        StatementClassMapping mappingDefinition = new StatementClassMapping();
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = emd.getAbsolutePositionOfMember(fieldMapping.getMemberMetaData().getName());
            if (fieldMapping == null) continue;
            StatementMappingIndex stmtMapping = new StatementMappingIndex(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < fieldMapping.getNumberOfDatastoreFields(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            stmtMapping.addParameterOccurrence(jdbcParamPositions);
            mappingDefinition.addMappingForMember(absFieldNum, stmtMapping);
        }
        StateManager elementSM = bcs.getStateManagerForEmbeddedPCObject(sm, element, ownerFieldMetaData);
        elementSM.setPcObjectType(2);
        FieldManager fm = storeMgr.getFieldManagerForStatementGeneration(elementSM, ps, mappingDefinition, true);
        elementSM.provideFields(elementFieldNumbers, fm);
        return jdbcPosition;
    }

    public static int populateEmbeddedKeyFieldsInStatement(StateManager sm, Object key, PreparedStatement ps, int jdbcPosition, JoinTable joinTable, AbstractMapStore mapStore) {
        MappedStoreManager storeMgr = (MappedStoreManager)sm.getObjectManager().getStoreManager();
        AbstractClassMetaData kmd = mapStore.getKmd();
        EmbeddedKeyPCMapping embeddedMapping = (EmbeddedKeyPCMapping)mapStore.getKeyMapping();
        StatementClassMapping mappingDefinition = new StatementClassMapping();
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = kmd.getAbsolutePositionOfMember(fieldMapping.getMemberMetaData().getName());
            if (fieldMapping == null) continue;
            StatementMappingIndex stmtMapping = new StatementMappingIndex(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < fieldMapping.getNumberOfDatastoreFields(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            stmtMapping.addParameterOccurrence(jdbcParamPositions);
            mappingDefinition.addMappingForMember(absFieldNum, stmtMapping);
        }
        StateManager elementSM = mapStore.getStateManagerForEmbeddedPCObject(sm, key, joinTable.getOwnerMemberMetaData());
        elementSM.setPcObjectType(3);
        elementSM.provideFields(elementFieldNumbers, storeMgr.getFieldManagerForStatementGeneration(elementSM, (Object)ps, mappingDefinition, true));
        return jdbcPosition;
    }

    public static int populateEmbeddedValueFieldsInStatement(StateManager sm, Object value, PreparedStatement ps, int jdbcPosition, JoinTable joinTable, AbstractMapStore mapStore) {
        MappedStoreManager storeMgr = (MappedStoreManager)sm.getObjectManager().getStoreManager();
        AbstractClassMetaData vmd = mapStore.getVmd();
        EmbeddedValuePCMapping embeddedMapping = (EmbeddedValuePCMapping)mapStore.getValueMapping();
        StatementClassMapping mappingDefinition = new StatementClassMapping();
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = vmd.getAbsolutePositionOfMember(fieldMapping.getMemberMetaData().getName());
            if (fieldMapping == null) continue;
            StatementMappingIndex stmtMapping = new StatementMappingIndex(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < fieldMapping.getNumberOfDatastoreFields(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            stmtMapping.addParameterOccurrence(jdbcParamPositions);
            mappingDefinition.addMappingForMember(absFieldNum, stmtMapping);
        }
        StateManager elementSM = mapStore.getStateManagerForEmbeddedPCObject(sm, value, joinTable.getOwnerMemberMetaData());
        elementSM.setPcObjectType(4);
        elementSM.provideFields(elementFieldNumbers, storeMgr.getFieldManagerForStatementGeneration(elementSM, (Object)ps, mappingDefinition, true));
        return jdbcPosition;
    }
}

