/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.io.Reader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.StatementNewObjectMapping;
import org.datanucleus.store.mapped.StatementResultMapping;
import org.datanucleus.store.mapped.expression.NewObjectExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.query.PersistentIDROF;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ResultClassROF
implements ResultObjectFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ObjectManagerFactoryImpl.class.getClassLoader());
    private final Class resultClass;
    private final StatementMappingIndex[] stmtMappings;
    private StatementResultMapping resultDefinition;
    private final ScalarExpression[] expressions;
    private final String[] resultFieldNames;
    private final Map resultClassFieldsByName = new HashMap();
    private static Map resultSetGetters = new HashMap(20);

    public ResultClassROF(Class cls, StatementResultMapping resultDefinition) {
        Class tmpClass = null;
        tmpClass = cls != null && cls.getName().equals("java.util.Map") ? HashMap.class : (cls == null ? (resultDefinition.getNumberOfResultExpressions() == 1 ? Object.class : Object[].class) : cls);
        this.resultClass = tmpClass;
        this.resultDefinition = resultDefinition;
        this.expressions = null;
        this.stmtMappings = null;
        if (resultDefinition != null) {
            this.resultFieldNames = new String[resultDefinition.getNumberOfResultExpressions()];
            for (int i = 0; i < this.resultFieldNames.length; ++i) {
                Object stmtMap = resultDefinition.getMappingForResultExpression(i);
                if (stmtMap instanceof StatementMappingIndex) {
                    StatementMappingIndex idx = (StatementMappingIndex)stmtMap;
                    this.resultFieldNames[i] = idx.getColumnAlias();
                    continue;
                }
                if (stmtMap instanceof StatementNewObjectMapping || stmtMap instanceof StatementClassMapping) continue;
                throw new NucleusUserException("Unsupported component " + stmtMap.getClass().getName() + " found in results");
            }
        } else {
            this.resultFieldNames = null;
        }
    }

    public ResultClassROF(Class cls, StatementClassMapping classDefinition) {
        Class tmpClass = null;
        tmpClass = cls != null && cls.getName().equals("java.util.Map") ? HashMap.class : (cls == null ? (this.resultDefinition.getNumberOfResultExpressions() == 1 ? Object.class : Object[].class) : cls);
        this.resultClass = tmpClass;
        this.resultDefinition = null;
        this.resultFieldNames = null;
        this.expressions = null;
        int[] memberNumbers = classDefinition.getMemberNumbers();
        this.stmtMappings = new StatementMappingIndex[memberNumbers.length];
        for (int i = 0; i < this.stmtMappings.length; ++i) {
            this.stmtMappings[i] = classDefinition.getMappingForMemberPosition(memberNumbers[i]);
        }
    }

    public ResultClassROF(Class cls, StatementMappingIndex[] resultMappings, ScalarExpression[] expressions) {
        Class<HashMap> tmpClass = null;
        tmpClass = cls != null && cls.getName().equals("java.util.Map") ? HashMap.class : cls;
        this.resultClass = tmpClass;
        if (expressions == null && QueryUtils.resultClassIsSimple((String)this.resultClass.getName()) && resultMappings.length != 1) {
            String msg = LOCALISER.msg("021201", (Object)this.resultClass.getName());
            NucleusLogger.QUERY.error((Object)msg);
            throw new NucleusUserException(msg);
        }
        if (expressions != null && QueryUtils.resultClassIsSimple((String)this.resultClass.getName()) && expressions.length != 1) {
            String msg = LOCALISER.msg("021201", (Object)this.resultClass.getName());
            NucleusLogger.QUERY.error((Object)msg);
            throw new NucleusUserException(msg);
        }
        if (QueryUtils.resultClassIsUserType((String)this.resultClass.getName())) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ResultClassROF.this.populateDeclaredFieldsForUserType(ResultClassROF.this.resultClass);
                    return null;
                }
            });
        }
        this.stmtMappings = resultMappings;
        this.expressions = expressions;
        this.resultFieldNames = new String[this.stmtMappings.length];
        for (int i = 0; i < this.stmtMappings.length; ++i) {
            this.resultFieldNames[i] = this.stmtMappings[i] != null ? this.stmtMappings[i].getColumnAlias() : null;
        }
    }

    public ResultClassROF(Class cls, String[] resultFieldNames) {
        Class<HashMap> tmpClass = null;
        tmpClass = cls != null && cls.getName().equals("java.util.Map") ? HashMap.class : cls;
        this.resultClass = tmpClass;
        if (QueryUtils.resultClassIsUserType((String)this.resultClass.getName())) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ResultClassROF.this.populateDeclaredFieldsForUserType(ResultClassROF.this.resultClass);
                    return null;
                }
            });
        }
        this.stmtMappings = null;
        this.expressions = null;
        this.resultFieldNames = resultFieldNames == null ? new String[0] : resultFieldNames;
    }

    public Object getObject(ObjectManager om, Object rs) {
        Object[] fieldValues = null;
        if (this.resultDefinition != null) {
            fieldValues = new Object[this.resultDefinition.getNumberOfResultExpressions()];
            for (int i = 0; i < this.resultDefinition.getNumberOfResultExpressions(); ++i) {
                Object stmtMap = this.resultDefinition.getMappingForResultExpression(i);
                if (stmtMap instanceof StatementMappingIndex) {
                    StatementMappingIndex idx = (StatementMappingIndex)stmtMap;
                    fieldValues[i] = idx.getMapping().getObject(om, rs, idx.getColumnPositions());
                    continue;
                }
                if (stmtMap instanceof StatementNewObjectMapping) {
                    StatementNewObjectMapping newIdx = (StatementNewObjectMapping)stmtMap;
                    fieldValues[i] = this.getValueForNewObject(newIdx, om, rs);
                    continue;
                }
                if (!(stmtMap instanceof StatementClassMapping)) continue;
                StatementClassMapping classMap = (StatementClassMapping)stmtMap;
                Class cls = om.getClassLoaderResolver().classForName(classMap.getClassName());
                AbstractClassMetaData acmd = om.getMetaDataManager().getMetaDataForClass(cls, om.getClassLoaderResolver());
                PersistentIDROF rof = new PersistentIDROF(acmd, classMap, false, om.getFetchPlan(), cls);
                fieldValues[i] = rof.getObject(om, rs);
            }
        } else if (this.stmtMappings != null) {
            if (this.expressions != null) {
                fieldValues = new Object[this.expressions.length];
                StatementExpressionIterator stmtExprIterator = new StatementExpressionIterator();
                for (int i = 0; i < this.expressions.length; ++i) {
                    fieldValues[i] = this.processScalarExpression(om, rs, stmtExprIterator, this.expressions[i]);
                }
            } else {
                fieldValues = new Object[this.stmtMappings.length];
                for (int i = 0; i < this.stmtMappings.length; ++i) {
                    fieldValues[i] = this.stmtMappings[i] != null ? this.stmtMappings[i].getMapping().getObject(om, rs, this.stmtMappings[i].getColumnPositions()) : null;
                }
            }
        } else {
            try {
                fieldValues = new Object[this.resultFieldNames.length];
                for (int i = 0; i < fieldValues.length; ++i) {
                    fieldValues[i] = this.getResultObject((ResultSet)rs, i + 1);
                }
            }
            catch (SQLException sqe) {
                String msg = LOCALISER.msg("021043", (Object)sqe.getMessage());
                NucleusLogger.QUERY.error((Object)msg);
                throw new NucleusUserException(msg);
            }
        }
        if (this.resultClass == Object[].class) {
            return fieldValues;
        }
        if (QueryUtils.resultClassIsSimple((String)this.resultClass.getName())) {
            if (fieldValues.length == 1 && (fieldValues[0] == null || this.resultClass.isAssignableFrom(fieldValues[0].getClass()))) {
                return fieldValues[0];
            }
            if (fieldValues.length == 1 && !this.resultClass.isAssignableFrom(fieldValues[0].getClass())) {
                String msg = LOCALISER.msg("021202", (Object)this.resultClass.getName(), (Object)fieldValues[0].getClass().getName());
                NucleusLogger.QUERY.error((Object)msg);
                throw new NucleusUserException(msg);
            }
        } else {
            Object obj = QueryUtils.createResultObjectUsingArgumentedConstructor((Class)this.resultClass, (Object[])fieldValues);
            if (obj != null) {
                return obj;
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                Object[] ctr_arg_types = new Class[this.resultFieldNames.length];
                for (int i = 0; i < this.resultFieldNames.length; ++i) {
                    ctr_arg_types[i] = fieldValues[i] != null ? fieldValues[i].getClass() : null;
                }
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021206", (Object)this.resultClass.getName(), (Object)StringUtils.objectArrayToString((Object[])ctr_arg_types)));
            }
            obj = QueryUtils.createResultObjectUsingDefaultConstructorAndSetters((Class)this.resultClass, (String[])this.resultFieldNames, (Map)this.resultClassFieldsByName, (Object[])fieldValues);
            return obj;
        }
        String msg = LOCALISER.msg("021203", (Object)this.resultClass.getName());
        NucleusLogger.QUERY.error((Object)msg);
        throw new NucleusUserException(msg);
    }

    protected Object getValueForNewObject(StatementNewObjectMapping newMap, ObjectManager om, Object results) {
        Object value = null;
        if (newMap.getNumberOfConstructorArgMappings() == 0) {
            try {
                value = newMap.getObjectClass().newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            int numArgs = newMap.getNumberOfConstructorArgMappings();
            Class[] ctrArgTypes = new Class[numArgs];
            Object[] ctrArgValues = new Object[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                Object obj = newMap.getConstructorArgMapping(i);
                if (obj instanceof StatementMappingIndex) {
                    StatementMappingIndex idx = (StatementMappingIndex)obj;
                    ctrArgValues[i] = idx.getMapping().getObject(om, results, idx.getColumnPositions());
                } else {
                    ctrArgValues[i] = obj instanceof StatementNewObjectMapping ? this.getValueForNewObject((StatementNewObjectMapping)obj, om, results) : obj;
                }
                ctrArgTypes[i] = ctrArgValues[i] != null ? ctrArgValues[i].getClass() : null;
            }
            Constructor ctr = ClassUtils.getConstructorWithArguments((Class)newMap.getObjectClass(), (Class[])ctrArgTypes);
            if (ctr == null) {
                StringBuffer str = new StringBuffer(newMap.getObjectClass().getName() + "(");
                for (int i = 0; i < ctrArgTypes.length; ++i) {
                    str.append(ctrArgTypes[i].getName());
                    if (i == ctrArgTypes.length - 1) continue;
                    str.append(',');
                }
                str.append(")");
                throw new NucleusUserException(LOCALISER.msg("037013", (Object)str.toString()));
            }
            try {
                value = ctr.newInstance(ctrArgValues);
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("037015", (Object)newMap.getObjectClass().getName(), (Object)e));
            }
        }
        return value;
    }

    private void populateDeclaredFieldsForUserType(Class cls) {
        for (int i = 0; i < cls.getDeclaredFields().length; ++i) {
            if (this.resultClassFieldsByName.put(cls.getDeclaredFields()[i].getName().toUpperCase(), cls.getDeclaredFields()[i]) == null) continue;
            throw new NucleusUserException(LOCALISER.msg("021210", (Object)cls.getDeclaredFields()[i].getName()));
        }
        if (cls.getSuperclass() != null) {
            this.populateDeclaredFieldsForUserType(cls.getSuperclass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processScalarExpression(ObjectManager om, Object rs, StatementExpressionIterator stmtExprIterator, ScalarExpression expr1) {
        if (expr1 instanceof NewObjectExpression) {
            return this.processNewObjectExpression(om, rs, stmtExprIterator, expr1);
        }
        try {
            Object object = stmtExprIterator.current().getMapping().getObject(om, rs, stmtExprIterator.current().getColumnPositions());
            return object;
        }
        finally {
            if (stmtExprIterator.hasNext()) {
                stmtExprIterator.next();
            }
        }
    }

    private Object processNewObjectExpression(ObjectManager om, Object rs, StatementExpressionIterator stmtExprIterator, ScalarExpression expr1) {
        NewObjectExpression newObjectExpr = (NewObjectExpression)expr1;
        int numberOfArgs = newObjectExpr.getArgumentExpressions().size();
        ArrayList<Object> argValues = new ArrayList<Object>();
        for (int j = 0; j < numberOfArgs; ++j) {
            ScalarExpression expr = (ScalarExpression)newObjectExpr.getArgumentExpressions().get(j);
            argValues.add(this.processScalarExpression(om, rs, stmtExprIterator, expr));
        }
        return newObjectExpr.createNewObject(argValues.toArray(new Object[argValues.size()]));
    }

    private Object getResultObject(ResultSet rs, int columnNumber) throws SQLException {
        ResultSetGetter getter = (ResultSetGetter)resultSetGetters.get(this.resultClass);
        if (getter != null) {
            return getter.getValue(rs, columnNumber);
        }
        return rs.getObject(columnNumber);
    }

    static {
        resultSetGetters.put(Boolean.class, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return new Boolean(rs.getBoolean(i));
            }
        });
        resultSetGetters.put(Byte.class, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return new Byte(rs.getByte(i));
            }
        });
        resultSetGetters.put(Short.class, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return new Short(rs.getShort(i));
            }
        });
        resultSetGetters.put(Integer.class, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return new Integer(rs.getInt(i));
            }
        });
        resultSetGetters.put(Long.class, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return new Long(rs.getLong(i));
            }
        });
        resultSetGetters.put(Float.class, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return new Float(rs.getFloat(i));
            }
        });
        resultSetGetters.put(Double.class, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return new Double(rs.getDouble(i));
            }
        });
        resultSetGetters.put(BigDecimal.class, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getBigDecimal(i);
            }
        });
        resultSetGetters.put(byte[].class, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getBytes(i);
            }
        });
        ResultSetGetter timestampGetter = new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getTimestamp(i);
            }
        };
        resultSetGetters.put(Timestamp.class, timestampGetter);
        resultSetGetters.put(java.util.Date.class, timestampGetter);
        resultSetGetters.put(Date.class, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getDate(i);
            }
        });
        resultSetGetters.put(String.class, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getString(i);
            }
        });
        resultSetGetters.put(Reader.class, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getCharacterStream(i);
            }
        });
        resultSetGetters.put(Array.class, new ResultSetGetter(){

            public Object getValue(ResultSet rs, int i) throws SQLException {
                return rs.getArray(i);
            }
        });
    }

    private static interface ResultSetGetter {
        public Object getValue(ResultSet var1, int var2) throws SQLException;
    }

    private class StatementExpressionIterator {
        int index = 0;

        private StatementExpressionIterator() {
        }

        boolean hasNext() {
            return this.index < ResultClassROF.this.stmtMappings.length - 1;
        }

        StatementMappingIndex next() {
            ++this.index;
            return ResultClassROF.this.stmtMappings[this.index];
        }

        StatementMappingIndex current() {
            return ResultClassROF.this.stmtMappings[this.index];
        }
    }
}

