/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;

public class TemporalLiteral
extends TemporalExpression
implements SQLLiteral {
    private final Date value;

    public TemporalLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, boolean parameter) {
        super(stmt, null, mapping);
        this.isParameter = parameter;
        if (value == null) {
            this.value = null;
        } else if (value instanceof Date) {
            this.value = (Date)value;
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        if (this.isParameter) {
            this.st.appendParameter(mapping, this.value);
        } else {
            this.setStatement();
        }
    }

    public String toString() {
        return super.toString() + " = " + this.value.toString();
    }

    public SQLExpression invoke(String methodName, List args) {
        if (!this.isParameter) {
            if (methodName.equals("getDay")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.value);
                JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
                return new IntegerLiteral(this.stmt, m, new Integer(cal.get(5)), false);
            }
            if (methodName.equals("getMonth")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.value);
                JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
                return new IntegerLiteral(this.stmt, m, new Integer(cal.get(2)), false);
            }
            if (methodName.equals("getYear")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.value);
                JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
                return new IntegerLiteral(this.stmt, m, new Integer(cal.get(1)), false);
            }
            if (methodName.equals("getHour")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.value);
                JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
                return new IntegerLiteral(this.stmt, m, new Integer(cal.get(11)), false);
            }
            if (methodName.equals("getMinutes")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.value);
                JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
                return new IntegerLiteral(this.stmt, m, new Integer(cal.get(12)), false);
            }
            if (methodName.equals("getSeconds")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.value);
                JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
                return new IntegerLiteral(this.stmt, m, new Integer(cal.get(13)), false);
            }
        }
        return super.invoke(methodName, args);
    }

    public Object getValue() {
        return this.value;
    }

    public void setNotParameter() {
        if (!this.isParameter) {
            return;
        }
        this.isParameter = false;
        this.st.clearStatement();
        this.setStatement();
    }

    protected void setStatement() {
        this.st.append(this.value.toString());
    }
}

