/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.ParamLoggingPreparedStatement;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class SQLController {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    protected boolean supportsBatching = false;
    protected int maxBatchSize = -1;
    protected int queryTimeout = 0;
    Map connectionStatements = new HashMap();

    public SQLController(boolean supportsBatching, int maxBatchSize, int queryTimeout) {
        this.supportsBatching = supportsBatching;
        this.maxBatchSize = maxBatchSize;
        this.queryTimeout = queryTimeout;
        if (maxBatchSize == 0) {
            this.supportsBatching = false;
        }
    }

    public PreparedStatement getStatementForUpdate(ManagedConnection conn, String stmtText, boolean batchable) throws SQLException {
        ConnectionStatementState state;
        Connection c = (Connection)conn.getConnection();
        if (this.supportsBatching && (state = this.getConnectionStatementState(conn)) != null) {
            if (state.processable) {
                if (!batchable) {
                    this.processConnectionStatement(conn);
                } else if (state.stmtText.equals(stmtText)) {
                    if (this.maxBatchSize == -1 || state.batchSize < this.maxBatchSize) {
                        ++state.batchSize;
                        state.processable = false;
                        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                            NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("052100", (Object)stmtText, (Object)("" + state.batchSize)));
                        }
                        return state.stmt;
                    }
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("052101", (Object)state.stmtText));
                    }
                    this.processConnectionStatement(conn);
                } else {
                    this.processConnectionStatement(conn);
                }
            } else if (batchable) {
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("052102", (Object)state.stmtText, (Object)stmtText));
                }
                batchable = false;
            }
        }
        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
            NucleusLogger.DATASTORE_PERSIST.debug((Object)("Retrieving PreparedStatement for connection " + c));
        }
        PreparedStatement ps = c.prepareStatement(stmtText);
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            ps = new ParamLoggingPreparedStatement(ps, stmtText);
        }
        if (batchable && this.supportsBatching) {
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("052103", (Object)stmtText));
            }
            ConnectionStatementState state2 = new ConnectionStatementState();
            state2.stmt = ps;
            state2.stmtText = stmtText;
            state2.batchSize = 1;
            this.setConnectionStatementState(conn, state2);
        }
        return ps;
    }

    public PreparedStatement getStatementForQuery(ManagedConnection conn, String stmtText) throws SQLException {
        return this.getStatementForQuery(conn, stmtText, null, null);
    }

    public PreparedStatement getStatementForQuery(ManagedConnection conn, String stmtText, String resultSetType, String resultSetConcurrency) throws SQLException {
        ConnectionStatementState state;
        Connection c = (Connection)conn.getConnection();
        if (this.supportsBatching && (state = this.getConnectionStatementState(conn)) != null && state.processable) {
            this.processConnectionStatement(conn);
        }
        PreparedStatement ps = null;
        if (resultSetType != null || resultSetConcurrency != null) {
            int rsTypeValue = 1003;
            if (resultSetType.equals("scroll-sensitive")) {
                rsTypeValue = 1005;
            } else if (resultSetType.equals("scroll-insensitive")) {
                rsTypeValue = 1004;
            }
            int rsConcurrencyValue = 1007;
            if (resultSetConcurrency.equals("updateable")) {
                rsConcurrencyValue = 1008;
            }
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)("Retrieving PreparedStatement for connection " + c));
            }
            ps = c.prepareStatement(stmtText, rsTypeValue, rsConcurrencyValue);
        } else {
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)("Retrieving PreparedStatement for connection " + c));
            }
            ps = c.prepareStatement(stmtText);
        }
        if (this.queryTimeout > 0) {
            ps.setQueryTimeout(this.queryTimeout / 1000);
        }
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            ps = new ParamLoggingPreparedStatement(ps, stmtText);
        }
        return ps;
    }

    public int[] executeStatementUpdate(ManagedConnection conn, String stmt, PreparedStatement ps, boolean processNow) throws SQLException {
        ConnectionStatementState state = this.getConnectionStatementState(conn);
        if (state != null && state.stmt == ps) {
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("052104", (Object)state.stmtText, (Object)("" + state.batchSize)));
            }
            state.processable = true;
            state.stmt.addBatch();
            if (processNow) {
                state.closeStatementOnProcess = false;
                return this.processConnectionStatement(conn);
            }
            return null;
        }
        long startTime = 0L;
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            if (ps instanceof ParamLoggingPreparedStatement) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)((ParamLoggingPreparedStatement)ps).getStatementWithParamsReplaced());
            } else {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)stmt);
            }
            startTime = System.currentTimeMillis();
        }
        int ind = ps.executeUpdate();
        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
            NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("045001", (Object)("" + (System.currentTimeMillis() - startTime)), (Object)("" + ind)));
        }
        return new int[]{ind};
    }

    public ResultSet executeStatementQuery(ManagedConnection conn, String stmt, PreparedStatement ps) throws SQLException {
        ConnectionStatementState state;
        if (this.supportsBatching && (state = this.getConnectionStatementState(conn)) != null) {
            if (state.processable) {
                this.processConnectionStatement(conn);
            } else if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("052106", (Object)state.stmtText, (Object)stmt));
            }
        }
        long startTime = 0L;
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            if (ps instanceof ParamLoggingPreparedStatement) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)((ParamLoggingPreparedStatement)ps).getStatementWithParamsReplaced());
            } else {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)stmt);
            }
            startTime = System.currentTimeMillis();
        }
        ResultSet rs = ps.executeQuery();
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("045000", System.currentTimeMillis() - startTime));
        }
        return rs;
    }

    public void abortStatementForConnection(ManagedConnection conn, PreparedStatement ps) {
        ConnectionStatementState state = this.getConnectionStatementState(conn);
        if (state != null && state.stmt == ps) {
            try {
                this.removeConnectionStatementState(conn);
                ps.close();
            }
            catch (SQLException sqe) {
                // empty catch block
            }
        }
    }

    public void closeStatement(ManagedConnection conn, PreparedStatement ps) throws SQLException {
        block5: {
            ConnectionStatementState state = this.getConnectionStatementState(conn);
            if (state != null && state.stmt == ps) {
                state.closeStatementOnProcess = true;
            } else {
                try {
                    if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_RETRIEVE.debug((Object)("Closing PreparedStatement " + ps));
                    }
                    ps.close();
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().equals("Already closed")) break block5;
                    throw sqle;
                }
            }
        }
    }

    public void processStatementsForConnection(ManagedConnection conn) throws SQLException {
        if (!this.supportsBatching || this.getConnectionStatementState(conn) == null) {
            return;
        }
        this.processConnectionStatement(conn);
    }

    protected int[] processConnectionStatement(ManagedConnection conn) throws SQLException {
        ConnectionStatementState state = this.getConnectionStatementState(conn);
        if (state == null || !state.processable) {
            return null;
        }
        long startTime = 0L;
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("052105", (Object)state.stmtText, (Object)("" + state.batchSize)));
            startTime = System.currentTimeMillis();
        }
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            if (state.stmt instanceof ParamLoggingPreparedStatement) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)((ParamLoggingPreparedStatement)state.stmt).getStatementWithParamsReplaced());
            } else {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)state.stmtText);
            }
        }
        int[] ind = state.stmt.executeBatch();
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("045001", (Object)("" + (System.currentTimeMillis() - startTime)), (Object)StringUtils.intArrayToString((int[])ind)));
        }
        this.removeConnectionStatementState(conn);
        if (state.closeStatementOnProcess) {
            state.stmt.close();
        }
        return ind;
    }

    protected void removeConnectionStatementState(ManagedConnection conn) {
        this.connectionStatements.remove(conn);
    }

    protected ConnectionStatementState getConnectionStatementState(ManagedConnection conn) {
        return (ConnectionStatementState)this.connectionStatements.get(conn);
    }

    protected void setConnectionStatementState(final ManagedConnection conn, ConnectionStatementState state) {
        this.connectionStatements.put(conn, state);
        conn.addListener(new ManagedConnectionResourceListener(){

            public void managedConnectionFlushed() {
                try {
                    SQLController.this.processStatementsForConnection(conn);
                }
                catch (SQLException e) {
                    ConnectionStatementState state = SQLController.this.getConnectionStatementState(conn);
                    if (state != null) {
                        SQLController.this.removeConnectionStatementState(conn);
                        if (state.closeStatementOnProcess) {
                            try {
                                state.stmt.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                    }
                    throw new NucleusDataStoreException("Exception thrown flushing changes to datastore", (Throwable)e);
                }
            }

            public void managedConnectionPreClose() {
            }

            public void managedConnectionPostClose() {
            }

            public void resourcePostClose() {
            }
        });
    }

    class ConnectionStatementState {
        PreparedStatement stmt = null;
        String stmtText = null;
        int batchSize = 0;
        boolean processable = false;
        boolean closeStatementOnProcess = false;

        ConnectionStatementState() {
        }
    }
}

