/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.StatementText;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;

public class RDBMSQueryUtils
extends QueryUtils {
    public static String getClassNameFromDiscriminatorResultSetRow(JavaTypeMapping discrimMapping, DiscriminatorMetaData dismd, ResultSet rs, ObjectManager om) {
        String rowClassName = null;
        if (discrimMapping != null && dismd.getStrategy() != DiscriminatorStrategy.NONE) {
            try {
                String discriminatorColName = discrimMapping.getDataStoreMapping(0).getDatastoreField().getIdentifier().getIdentifierName();
                String discriminatorValue = rs.getString(discriminatorColName);
                rowClassName = RDBMSQueryUtils.getClassNameFromDiscriminatorValue(discriminatorValue, dismd, om);
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        return rowClassName;
    }

    public static String getClassNameFromDiscriminatorValue(String discrimValue, DiscriminatorMetaData dismd, ObjectManager om) {
        if (discrimValue == null) {
            return null;
        }
        String rowClassName = null;
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        AbstractClassMetaData baseCmd = (AbstractClassMetaData)((InheritanceMetaData)dismd.getParent()).getParent();
        if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
            rowClassName = discrimValue;
        } else if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
            String className2 = baseCmd.getFullClassName();
            if (dismd.getValue().equals(discrimValue)) {
                rowClassName = className2;
            } else {
                for (String className2 : om.getStoreManager().getSubClassesForClass(baseCmd.getFullClassName(), true, clr)) {
                    AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(className2, clr);
                    if (!discrimValue.equals(cmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue())) continue;
                    rowClassName = className2;
                    break;
                }
            }
        }
        return rowClassName;
    }

    public static String getResultSetTypeForQuery(Query query) {
        String propName = "datanucleus.rdbms.query.resultSetType";
        String rsTypeString = query.getObjectManager().getOMFContext().getPersistenceConfiguration().getStringProperty(propName);
        Object rsTypeExt = query.getExtension(propName);
        if (rsTypeExt != null) {
            rsTypeString = (String)rsTypeExt;
        }
        return rsTypeString;
    }

    public static String getResultSetConcurrencyForQuery(Query query) {
        String propName = "datanucleus.rdbms.query.resultSetConcurrency";
        String rsConcurrencyString = query.getObjectManager().getOMFContext().getPersistenceConfiguration().getStringProperty(propName);
        Object rsConcurrencyExt = query.getExtension(propName);
        if (rsConcurrencyExt != null) {
            rsConcurrencyString = (String)rsConcurrencyExt;
        }
        return rsConcurrencyString;
    }

    public static boolean useUpdateLockForQuery(Query query) {
        Object useUpdateLockExt;
        boolean useUpdateLock = query.getObjectManager().getTransaction().lockReadObjects();
        Boolean queryLock = query.getSerializeRead();
        if (queryLock != null) {
            useUpdateLock = queryLock;
        }
        if ((useUpdateLockExt = query.getExtension("datanucleus.rdbms.query.useUpdateLock")) != null) {
            useUpdateLock = Boolean.valueOf((String)useUpdateLockExt);
        }
        return useUpdateLock;
    }

    public static PreparedStatement getPreparedStatementForQuery(ManagedConnection conn, String queryStmt, Query query) throws SQLException {
        ObjectManager om = query.getObjectManager();
        String rsTypeString = RDBMSQueryUtils.getResultSetTypeForQuery(query);
        if (!(rsTypeString == null || rsTypeString.equals("scroll-sensitive") || rsTypeString.equals("forward-only") || rsTypeString.equals("scroll-insensitive"))) {
            throw new NucleusUserException("Query extension 'datanucleus.rdbms.query.resultSetType' has valid values of scroll-sensitive,scroll-insensitive,forward-only only.");
        }
        String rsConcurrencyString = RDBMSQueryUtils.getResultSetConcurrencyForQuery(query);
        if (rsConcurrencyString != null && !rsConcurrencyString.equals("read-only") && !rsConcurrencyString.equals("updateable")) {
            throw new NucleusUserException("Query extension 'datanucleus.rdbms.query.resultSetConcurrency' has valid values of read-only,updateable only.");
        }
        SQLController sqlControl = ((RDBMSManager)om.getStoreManager()).getSQLController();
        PreparedStatement ps = sqlControl.getStatementForQuery(conn, queryStmt, rsTypeString, rsConcurrencyString);
        return ps;
    }

    public static PreparedStatement getPreparedStatementForQuery(ManagedConnection conn, StatementText stmtText, Query query) throws SQLException {
        ObjectManager om = query.getObjectManager();
        String rsTypeString = RDBMSQueryUtils.getResultSetTypeForQuery(query);
        if (!(rsTypeString == null || rsTypeString.equals("scroll-sensitive") || rsTypeString.equals("forward-only") || rsTypeString.equals("scroll-insensitive"))) {
            throw new NucleusUserException("Query extension 'datanucleus.rdbms.query.resultSetType' has valid values of scroll-sensitive,scroll-insensitive,forward-only only.");
        }
        String rsConcurrencyString = RDBMSQueryUtils.getResultSetConcurrencyForQuery(query);
        if (rsConcurrencyString != null && !rsConcurrencyString.equals("read-only") && !rsConcurrencyString.equals("updateable")) {
            throw new NucleusUserException("Query extension 'datanucleus.rdbms.query.resultSetConcurrency' has valid values of read-only,updateable only.");
        }
        SQLController sqlControl = ((RDBMSManager)om.getStoreManager()).getSQLController();
        PreparedStatement ps = sqlControl.getStatementForQuery(conn, stmtText.toString(), rsTypeString, rsConcurrencyString);
        stmtText.applyParametersToStatement(om, (Object)ps);
        return ps;
    }

    public static void prepareStatementForExecution(PreparedStatement ps, Query query, boolean applyTimeout) throws SQLException {
        Integer timeout;
        OMFContext omfCtx = query.getObjectManager().getOMFContext();
        MappedStoreManager storeMgr = (MappedStoreManager)omfCtx.getStoreManager();
        PersistenceConfiguration conf = omfCtx.getPersistenceConfiguration();
        if (applyTimeout && (timeout = query.getTimeoutMillis()) != null && timeout > 0) {
            ps.setQueryTimeout(timeout / 1000);
        }
        int fetchSize = 0;
        if (query.getFetchPlan().getFetchSize() > 0) {
            fetchSize = query.getFetchPlan().getFetchSize();
        }
        if (storeMgr.getDatastoreAdapter().supportsQueryFetchSize(fetchSize)) {
            ps.setFetchSize(fetchSize);
        }
        String propName = "datanucleus.rdbms.query.fetchDirection";
        String fetchDir = conf.getStringProperty(propName);
        Object fetchDirExt = query.getExtension(propName);
        if (!(fetchDirExt == null || (fetchDir = (String)fetchDirExt).equals("forward") || fetchDir.equals("reverse") || fetchDir.equals("unknown"))) {
            throw new NucleusUserException("Query extension \"datanucleus.rdbms.query.fetchDirection\" has valid values of forward,reverse,unknown only");
        }
        if (fetchDir.equals("reverse")) {
            ps.setFetchDirection(1001);
        } else if (fetchDir.equals("unknown")) {
            ps.setFetchDirection(1002);
        }
        long toExclNo = query.getRangeToExcl();
        if (toExclNo != 0L && toExclNo != Long.MAX_VALUE) {
            if (toExclNo > Integer.MAX_VALUE) {
                ps.setMaxRows(Integer.MAX_VALUE);
            } else {
                ps.setMaxRows((int)toExclNo);
            }
        }
    }
}

