/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.util.NucleusLogger;

public abstract class JoinTable
extends TableImpl
implements DatastoreContainerObject {
    protected final AbstractMemberMetaData fmd;
    protected JavaTypeMapping ownerMapping;
    protected final String ownerType;

    protected JoinTable(DatastoreIdentifier tableName, AbstractMemberMetaData fmd, RDBMSManager storeMgr) {
        super(tableName, storeMgr);
        this.fmd = fmd;
        this.ownerType = fmd.getClassName(true);
        if (fmd.getPersistenceModifier() == FieldPersistenceModifier.NONE) {
            throw new NucleusException(LOCALISER.msg("057006", (Object)fmd.getName())).setFatal();
        }
    }

    public PrimaryKey getPrimaryKey() {
        PrimaryKeyMetaData pkmd;
        PrimaryKey pk = super.getPrimaryKey();
        if (this.fmd.getJoinMetaData() != null && (pkmd = this.fmd.getJoinMetaData().getPrimaryKeyMetaData()) != null && pkmd.getName() != null) {
            pk.setName(pkmd.getName());
        }
        return pk;
    }

    protected boolean requiresPrimaryKey() {
        boolean pkRequired = true;
        if (this.fmd.getJoinMetaData() != null && this.fmd.getJoinMetaData().hasExtension("primary-key") && this.fmd.getJoinMetaData().getValueForExtension("primary-key").equalsIgnoreCase("false")) {
            pkRequired = false;
        }
        return pkRequired;
    }

    public JavaTypeMapping getOwnerMapping() {
        this.assertIsInitialized();
        return this.ownerMapping;
    }

    public AbstractMemberMetaData getOwnerFieldMetaData() {
        return this.fmd;
    }

    public JavaTypeMapping getIDMapping() {
        throw new NucleusException("Unsupported ID mapping in join table").setFatal();
    }

    protected void debugMapping(JavaTypeMapping mapping) {
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            StringBuffer columnsStr = new StringBuffer();
            for (int i = 0; i < mapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    columnsStr.append(",");
                }
                columnsStr.append(mapping.getDataStoreMapping(i).getDatastoreField());
            }
            if (mapping.getNumberOfDatastoreFields() == 0) {
                columnsStr.append("[none]");
            }
            StringBuffer datastoreMappingTypes = new StringBuffer();
            for (int i = 0; i < mapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    datastoreMappingTypes.append(',');
                }
                datastoreMappingTypes.append(mapping.getDataStoreMapping(i).getClass().getName());
            }
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("057010", (Object)this.fmd.getFullFieldName(), (Object)columnsStr.toString(), (Object)mapping.getClass().getName(), (Object)datastoreMappingTypes.toString()));
        }
    }
}

