/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

public class BooleanLiteral
extends BooleanExpression
implements SQLLiteral {
    private final boolean value;
    Object rawValue;

    public BooleanLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
        super(stmt, null, mapping);
        if (!(value instanceof Boolean)) {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        this.value = (Boolean)value;
        DatastoreMapping datastoreMapping = mapping.getDataStoreMapping(0);
        if (datastoreMapping.isStringBased()) {
            this.st.append(this.value ? "'Y'" : "'N'");
        } else if ((datastoreMapping.isBitBased() || datastoreMapping.isIntegerBased()) && !stmt.getDatabaseAdapter().supportsOption("BitIsReallyBoolean")) {
            this.st.append(this.value ? "1" : "0");
        } else {
            this.st.append(this.value ? "TRUE" : "(1=0)");
        }
    }

    public Object getValue() {
        return new Boolean(this.value);
    }

    public BooleanExpression and(SQLExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value ? (BooleanExpression)expr : this;
        }
        return super.and(expr);
    }

    public BooleanExpression eor(SQLExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value ? expr.not() : (BooleanExpression)expr;
        }
        return super.eor(expr);
    }

    public BooleanExpression ior(SQLExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value ? this : (BooleanExpression)expr;
        }
        return super.ior(expr);
    }

    public BooleanExpression not() {
        return new BooleanLiteral(this.stmt, this.mapping, !this.value);
    }

    public BooleanExpression eq(SQLExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value ? (BooleanExpression)expr : expr.not();
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value ? expr.not() : (BooleanExpression)expr;
        }
        return super.ne(expr);
    }

    public void setRawValue(Object val) {
        this.rawValue = val;
    }

    public Object getRawValue() {
        return this.rawValue;
    }
}

