/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.sql.AbstractStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.table.ClassTable;

public class DiscriminatorStatementGenerator
extends AbstractStatementGenerator {
    public DiscriminatorStatementGenerator(RDBMSManager storeMgr, Class candidateType, boolean includeSubclasses, DatastoreIdentifier candidateTableAlias) {
        super(storeMgr, candidateType, includeSubclasses, candidateTableAlias);
        this.setOption("restrictDiscriminator");
    }

    public DiscriminatorStatementGenerator(RDBMSManager storeMgr, Class candidateType, boolean includeSubclasses, DatastoreIdentifier candidateTableAlias, DatastoreContainerObject joinTable, DatastoreIdentifier joinTableAlias, JavaTypeMapping joinElementMapping) {
        super(storeMgr, candidateType, includeSubclasses, candidateTableAlias, joinTable, joinTableAlias, joinElementMapping);
        this.setOption("restrictDiscriminator");
    }

    public SQLStatement getStatement() {
        String[] managedClasses;
        SQLStatement stmt = null;
        SQLTable candidateSQLTable = null;
        if (this.joinTable == null) {
            stmt = new SQLStatement(this.storeMgr, this.candidateTable, this.candidateTableAlias);
            candidateSQLTable = stmt.getPrimaryTable();
        } else {
            stmt = new SQLStatement(this.storeMgr, this.joinTable, this.joinTableAlias);
            JavaTypeMapping candidateIdMapping = this.candidateTable.getIDMapping();
            candidateSQLTable = this.hasOption("allowNulls") ? stmt.leftOuterJoin(null, this.joinElementMapping, this.candidateTable, null, candidateIdMapping, null) : stmt.innerJoin(null, this.joinElementMapping, this.candidateTable, null, candidateIdMapping, null);
        }
        ClassLoaderResolver clr = this.storeMgr.getOMFContext().getClassLoaderResolver(null);
        DiscriminatorMetaData dismd = this.candidateTable.getDiscriminatorMetaData();
        JavaTypeMapping discriminatorMapping = this.candidateTable.getDiscriminatorMapping(true);
        boolean hasDiscriminator = discriminatorMapping != null && dismd.getStrategy() != DiscriminatorStrategy.NONE;
        boolean restrictDiscriminator = this.hasOption("restrictDiscriminator");
        if (this.includeSubclasses && hasDiscriminator && this.candidateTable.getDiscriminatorMapping(false) != null && !this.storeMgr.getOMFContext().getMetaDataManager().isPersistentDefinitionImplementation(this.candidateType.getName()) && (managedClasses = ((ClassTable)this.candidateTable).getManagedClasses()).length == 1) {
            restrictDiscriminator = false;
        }
        if (hasDiscriminator && restrictDiscriminator) {
            boolean multipleCandidates = false;
            SQLExpression discExpr = null;
            if (this.includeSubclasses) {
                HashSet subclassNames = this.storeMgr.getSubClassesForClass(this.candidateType.getName(), false, clr);
                Iterator subclassIter = subclassNames.iterator();
                boolean bl = multipleCandidates = subclassNames.size() > 0;
                while (subclassIter.hasNext()) {
                    String subclassName = (String)subclassIter.next();
                    BooleanExpression discExprCand = DiscriminatorStatementGenerator.getExpressionForDiscriminatorForClass(stmt, subclassName, dismd, discriminatorMapping, candidateSQLTable, this.storeMgr);
                    if (discExpr != null) {
                        discExpr = ((BooleanExpression)discExpr).ior(discExprCand);
                        continue;
                    }
                    discExpr = discExprCand;
                }
            }
            if (this.hasOption("allowNulls")) {
                SQLExpression expr = stmt.getSQLExpressionFactory().newExpression(stmt, candidateSQLTable, discriminatorMapping);
                NullLiteral val = new NullLiteral(stmt, null, (Object)null);
                BooleanExpression nullDiscExpr = expr.eq(val);
                discExpr = ((BooleanExpression)discExpr).ior(nullDiscExpr);
                if (!multipleCandidates) {
                    multipleCandidates = true;
                }
            }
            if (multipleCandidates) {
                discExpr.encloseInParentheses();
            }
            stmt.whereAnd((BooleanExpression)discExpr, false);
        }
        if (hasDiscriminator && this.hasOption("selectDiscriminator")) {
            stmt.select(candidateSQLTable, discriminatorMapping, null);
        }
        return stmt;
    }

    private static BooleanExpression getExpressionForDiscriminatorForClass(SQLStatement stmt, String className, DiscriminatorMetaData dismd, JavaTypeMapping discriminatorMapping, SQLTable sqlDiscrimTable, RDBMSManager storeMgr) {
        String discriminatorValue = className;
        if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
            AbstractClassMetaData targetCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(className, storeMgr.getOMFContext().getClassLoaderResolver(null));
            discriminatorValue = targetCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
        }
        SQLExpression discrExpr = stmt.getSQLExpressionFactory().newExpression(stmt, sqlDiscrimTable, discriminatorMapping);
        SQLExpression discrVal = stmt.getSQLExpressionFactory().newLiteral(stmt, discriminatorMapping, discriminatorValue);
        return discrExpr.eq(discrVal);
    }
}

