/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.FetchStatement;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public class RDBMSFetchStatement
implements FetchStatement {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    protected final DatastoreContainerObject mainTable;
    protected final ArrayList selected = new ArrayList();
    protected StringBuffer conditionList = new StringBuffer();
    protected final Map innerTableMappings = new HashMap();
    protected final Map outerTableMappings = new HashMap();

    public RDBMSFetchStatement(DatastoreContainerObject mainTable) {
        this.mainTable = mainTable;
    }

    public int[] selectOuterJoin(JavaTypeMapping refMapping, JavaTypeMapping selectMapping, JavaTypeMapping refDiscrimMapping, Object[] discrimValues, boolean useExistingJoinIfPossible) {
        if (this.mainTable.getIDMapping().getNumberOfDatastoreFields() != refMapping.getNumberOfDatastoreFields()) {
            throw new NucleusException(LOCALISER.msg("052221", (Object)("" + this.mainTable.getIDMapping().getNumberOfDatastoreFields()), (Object)("" + refMapping.getNumberOfDatastoreFields()))).setFatal();
        }
        String alias = null;
        if (useExistingJoinIfPossible) {
            for (Map.Entry entry : this.outerTableMappings.entrySet()) {
                OuterJoinDefinition join = (OuterJoinDefinition)entry.getValue();
                if (!join.getReferenceMapping().equals(refMapping)) continue;
                alias = (String)entry.getKey();
                int[] refColumnIds = new int[selectMapping.getNumberOfDatastoreFields()];
                int countReferenceFields = selectMapping.getNumberOfDatastoreFields();
                for (int i = 0; i < countReferenceFields; ++i) {
                    String column_ref = this.getColumnReference(alias, selectMapping.getDataStoreMapping(i).getDatastoreField());
                    this.selected.add(column_ref);
                    refColumnIds[i] = this.selected.indexOf(column_ref) + 1;
                }
                return refColumnIds;
            }
        }
        if (alias == null) {
            alias = "OUTER" + (this.outerTableMappings.size() + 1);
            this.outerTableMappings.put(alias, new OuterJoinDefinition(refMapping, refDiscrimMapping, discrimValues));
            int[] refColumnIds = new int[selectMapping.getNumberOfDatastoreFields()];
            int countReferenceFields = selectMapping.getNumberOfDatastoreFields();
            for (int i = 0; i < countReferenceFields; ++i) {
                String column_ref = this.getColumnReference(alias, selectMapping.getDataStoreMapping(i).getDatastoreField());
                this.selected.add(column_ref);
                refColumnIds[i] = this.selected.indexOf(column_ref) + 1;
            }
            return refColumnIds;
        }
        return null;
    }

    public int[] selectOuterJoin(JavaTypeMapping refMapping, JavaTypeMapping selectMapping, JavaTypeMapping refTypeMapping) {
        if (this.mainTable.getIDMapping().getNumberOfDatastoreFields() != refMapping.getNumberOfDatastoreFields()) {
            throw new NucleusException(LOCALISER.msg("052221", (Object)("" + this.mainTable.getIDMapping().getNumberOfDatastoreFields()), (Object)("" + refMapping.getNumberOfDatastoreFields()))).setFatal();
        }
        String alias = "OUTER" + (this.outerTableMappings.size() + 1);
        this.outerTableMappings.put(alias, new OuterJoinDefinition(refMapping, refTypeMapping));
        int[] refColumnIds = new int[selectMapping.getNumberOfDatastoreFields()];
        int countReferenceFields = selectMapping.getNumberOfDatastoreFields();
        for (int i = 0; i < countReferenceFields; ++i) {
            String column_ref = this.getColumnReference(alias, selectMapping.getDataStoreMapping(i).getDatastoreField());
            this.selected.add(column_ref);
            refColumnIds[i] = this.selected.indexOf(column_ref) + 1;
        }
        return refColumnIds;
    }

    public int select(DatastoreField col) {
        String columnID = this.referenceDatastoreField(col);
        if (!this.selected.contains(columnID)) {
            this.selected.add(columnID);
        }
        return this.selected.indexOf(columnID) + 1;
    }

    public int select(String expr) {
        if (!this.selected.contains(expr)) {
            this.selected.add(expr);
        }
        return this.selected.indexOf(expr) + 1;
    }

    public String referenceDatastoreField(DatastoreField col) {
        DatastoreContainerObject t = col.getDatastoreContainerObject();
        String alias = null;
        if (t.equals(this.mainTable)) {
            alias = "THIS";
        } else if (alias == null) {
            for (Map.Entry entry : this.innerTableMappings.entrySet()) {
                InnerJoinDefinition join = (InnerJoinDefinition)entry.getValue();
                if (!t.equals(join.getTable())) continue;
                alias = (String)entry.getKey();
                break;
            }
        }
        if (alias == null) {
            alias = "INNER" + (this.innerTableMappings.size() + 1);
            this.innerTableMappings.put(alias, new InnerJoinDefinition(t, t.getIDMapping()));
        }
        return col.applySelectFunction(alias + '.' + ((Object)col.getIdentifier()).toString());
    }

    private String getColumnReference(String alias, DatastoreField col) {
        return col.applySelectFunction(alias + '.' + ((Object)col.getIdentifier()).toString());
    }

    public void andCondition(String condition) {
        if (this.conditionList.length() > 0) {
            this.conditionList.append(" AND ");
        }
        this.conditionList.append('(').append(condition).append(')');
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean lock) {
        String alias;
        JavaTypeMapping mainIdMapping;
        RDBMSAdapter rdba = (RDBMSAdapter)this.mainTable.getStoreManager().getDatastoreAdapter();
        StringBuffer stmt = new StringBuffer("SELECT ");
        Iterator<Object> iter = this.selected.iterator();
        while (iter.hasNext()) {
            stmt.append(iter.next());
            if (!iter.hasNext()) continue;
            stmt.append(',');
        }
        String[] mainTableColumnID = new String[this.mainTable.getIDMapping().getNumberOfDatastoreFields()];
        int countIdFields = this.mainTable.getIDMapping().getNumberOfDatastoreFields();
        for (int j = 0; j < countIdFields; ++j) {
            mainTableColumnID[j] = this.referenceDatastoreField(this.mainTable.getIDMapping().getDataStoreMapping(j).getDatastoreField());
        }
        stmt.append(" FROM ").append(this.mainTable.toString()).append(" ").append("THIS");
        if (lock && rdba.getSelectWithLockOption() != null && rdba.supportsOption("LockOptionAfterFromClause")) {
            stmt.append(" WITH ").append(rdba.getSelectWithLockOption());
        }
        StringBuffer joinConditions = new StringBuffer();
        RDBMSAdapter dba = (RDBMSAdapter)this.mainTable.getStoreManager().getDatastoreAdapter();
        if (!this.outerTableMappings.isEmpty()) {
            mainIdMapping = this.mainTable.getIDMapping();
            for (Map.Entry entry : this.outerTableMappings.entrySet()) {
                int i;
                JavaTypeMapping refIdMapping;
                int countRefTypeTableFields;
                int countMainIdFields;
                alias = (String)entry.getKey();
                OuterJoinDefinition def = (OuterJoinDefinition)entry.getValue();
                JavaTypeMapping refMapping = def.getReferenceMapping();
                JavaTypeMapping refDiscrimMapping = def.getReferenceDiscrimMapping();
                Object[] refDiscrimValues = def.getDiscriminatorValues();
                JavaTypeMapping refTypeMapping = def.getReferenceTypeMapping();
                String refTableName = ((Column)refMapping.getDataStoreMapping(0).getDatastoreField()).getDatastoreContainerObject().toString();
                if (dba.supportsOption("ANSI_Join_Syntax")) {
                    stmt.append(" LEFT OUTER JOIN ").append(refTableName).append(" ").append(alias);
                    if (rdba.supportsOption("LockOptionWithinJoinClause")) {
                        stmt.append(" WITH ").append(rdba.getSelectWithLockOption());
                    }
                    stmt.append(" ON ");
                    if (refDiscrimMapping != null && refDiscrimValues != null) {
                        stmt.append("(");
                    }
                    countMainIdFields = mainIdMapping.getNumberOfDatastoreFields();
                    for (int i3 = 0; i3 < countMainIdFields; ++i3) {
                        if (i3 > 0) {
                            stmt.append(" AND ");
                        }
                        stmt.append(this.getColumnReference("THIS", mainIdMapping.getDataStoreMapping(i3).getDatastoreField()));
                        stmt.append(" = ");
                        stmt.append(this.getColumnReference(alias, refMapping.getDataStoreMapping(i3).getDatastoreField()));
                    }
                    if (refDiscrimMapping != null && refDiscrimValues != null) {
                        stmt.append(" AND (");
                        for (int i2 = 0; i2 < refDiscrimValues.length; ++i2) {
                            if (i2 > 0) {
                                stmt.append(" OR ");
                            }
                            stmt.append(this.getColumnReference(alias, refDiscrimMapping.getDataStoreMapping(0).getDatastoreField()));
                            stmt.append(" = ");
                            stmt.append("'" + refDiscrimValues[i2] + "'");
                        }
                        stmt.append("))");
                        continue;
                    }
                    if (refTypeMapping == null) continue;
                    String refTypeTableName = refTypeMapping.getDataStoreMapping(0).getDatastoreField().getDatastoreContainerObject().toString();
                    stmt.append(" INNER JOIN ").append(refTypeTableName).append(" ").append(alias + "_SUB");
                    if (rdba.supportsOption("LockOptionWithinJoinClause")) {
                        stmt.append(" WITH ").append(rdba.getSelectWithLockOption());
                    }
                    stmt.append(" ON ");
                    countRefTypeTableFields = refTypeMapping.getNumberOfDatastoreFields();
                    refIdMapping = refMapping.getDatastoreContainer().getIDMapping();
                    for (int i3 = 0; i3 < countRefTypeTableFields; ++i3) {
                        if (i3 > 0) {
                            stmt.append(" AND ");
                        }
                        stmt.append(this.getColumnReference(alias + "_SUB", refTypeMapping.getDataStoreMapping(i3).getDatastoreField()));
                        stmt.append(" = ");
                        stmt.append(this.getColumnReference(alias, refIdMapping.getDataStoreMapping(i3).getDatastoreField()));
                    }
                    continue;
                }
                stmt.append(',').append(refTableName).append(" ").append(alias);
                if (refDiscrimMapping != null && refDiscrimValues != null) {
                    joinConditions.append("(");
                }
                countMainIdFields = mainIdMapping.getNumberOfDatastoreFields();
                for (i = 0; i < countMainIdFields; ++i) {
                    if (joinConditions.length() > 0) {
                        joinConditions.append(" AND ");
                    }
                    joinConditions.append(dba.getNonAnsiLeftOuterJoinWhereClause(mainIdMapping.getDataStoreMapping(i).getDatastoreField().toString(), refMapping.getDataStoreMapping(i).getDatastoreField().toString()));
                }
                if (refDiscrimMapping != null && refDiscrimValues != null) {
                    joinConditions.append(" AND (");
                    for (i = 0; i < refDiscrimValues.length; ++i) {
                        if (i > 0) {
                            joinConditions.append(" OR ");
                        }
                        joinConditions.append(this.getColumnReference(alias, refDiscrimMapping.getDataStoreMapping(0).getDatastoreField()));
                        joinConditions.append(" = ");
                        joinConditions.append("'" + refDiscrimValues[i] + "'");
                    }
                    joinConditions.append("))");
                    continue;
                }
                if (refTypeMapping == null) continue;
                String refTypeTableName = refTypeMapping.getDataStoreMapping(0).getDatastoreField().getDatastoreContainerObject().toString();
                stmt.append(',').append(refTypeTableName).append(" ").append(alias + "_SUB");
                countRefTypeTableFields = refTypeMapping.getNumberOfDatastoreFields();
                refIdMapping = refMapping.getDatastoreContainer().getIDMapping();
                for (int i2 = 0; i2 < countRefTypeTableFields; ++i2) {
                    if (i2 > 0) {
                        stmt.append(" AND ");
                    }
                    joinConditions.append(dba.getNonAnsiInnerJoinWhereClause(refTypeMapping.getDataStoreMapping(i2).getDatastoreField().toString(), refIdMapping.getDataStoreMapping(i2).getDatastoreField().toString()));
                }
            }
        }
        if (!this.innerTableMappings.isEmpty()) {
            mainIdMapping = this.mainTable.getIDMapping();
            for (Map.Entry entry : this.innerTableMappings.entrySet()) {
                int i;
                alias = (String)entry.getKey();
                InnerJoinDefinition join = (InnerJoinDefinition)entry.getValue();
                if (dba.supportsOption("ANSI_Join_Syntax")) {
                    stmt.append(" INNER JOIN ").append(join.getTable()).append(" ").append(alias);
                    if (lock && rdba.supportsOption("LockOptionWithinJoinClause")) {
                        stmt.append(" WITH ").append(rdba.getSelectWithLockOption());
                    }
                    stmt.append(" ON ");
                    int countReferenceFields = join.getReferenceMapping().getNumberOfDatastoreFields();
                    for (int i4 = 0; i4 < countReferenceFields; ++i4) {
                        stmt.append(this.getColumnReference("THIS", mainIdMapping.getDataStoreMapping(i4).getDatastoreField()));
                        stmt.append(" = ");
                        stmt.append(this.getColumnReference(alias, join.getReferenceMapping().getDataStoreMapping(i4).getDatastoreField()));
                        if (i4 >= join.getReferenceMapping().getNumberOfDatastoreFields() - 1) continue;
                        stmt.append(" AND ");
                    }
                    continue;
                }
                stmt.append(',').append(join.getTable()).append(" ").append(alias);
                String[] supertableColumnID = new String[this.mainTable.getIDMapping().getNumberOfDatastoreFields()];
                int countReferenceFields = join.getReferenceMapping().getNumberOfDatastoreFields();
                for (i = 0; i < countReferenceFields; ++i) {
                    supertableColumnID[i] = this.getColumnReference(alias, join.getReferenceMapping().getDataStoreMapping(i).getDatastoreField());
                }
                for (i = 0; i < countReferenceFields; ++i) {
                    if (joinConditions.length() > 0) {
                        joinConditions.append(" AND ");
                    }
                    joinConditions.append(dba.getNonAnsiInnerJoinWhereClause(mainTableColumnID[i], supertableColumnID[i]));
                }
            }
        }
        StringBuffer conditionList = new StringBuffer(this.conditionList.toString());
        if (joinConditions.length() > 0) {
            conditionList = conditionList.length() > 0 ? joinConditions.append(" AND (").append(conditionList.toString()).append(')') : joinConditions;
        }
        if (conditionList.length() > 0) {
            stmt.append(" WHERE ").append(conditionList.toString());
        }
        if (lock && rdba.supportsOption("LockWithSelectForUpdate")) {
            stmt.append(" FOR UPDATE");
        }
        return stmt.toString();
    }

    class OuterJoinDefinition {
        private JavaTypeMapping referenceMapping;
        private JavaTypeMapping refDiscrimMapping;
        private JavaTypeMapping refTypeMapping;
        private Object[] discrimValues;

        public OuterJoinDefinition(JavaTypeMapping ref, JavaTypeMapping refDiscrim, Object[] discrimValues) {
            this.referenceMapping = ref;
            this.refDiscrimMapping = refDiscrim;
            this.discrimValues = discrimValues;
        }

        public OuterJoinDefinition(JavaTypeMapping ref, JavaTypeMapping refType) {
            this.referenceMapping = ref;
            this.refTypeMapping = refType;
        }

        public JavaTypeMapping getReferenceMapping() {
            return this.referenceMapping;
        }

        public JavaTypeMapping getReferenceDiscrimMapping() {
            return this.refDiscrimMapping;
        }

        public Object[] getDiscriminatorValues() {
            return this.discrimValues;
        }

        public JavaTypeMapping getReferenceTypeMapping() {
            return this.refTypeMapping;
        }
    }

    class InnerJoinDefinition {
        private DatastoreContainerObject table;
        private JavaTypeMapping referenceMapping;

        public InnerJoinDefinition(DatastoreContainerObject table, JavaTypeMapping mapping) {
            this.table = table;
            this.referenceMapping = mapping;
        }

        public JavaTypeMapping getReferenceMapping() {
            return this.referenceMapping;
        }

        public DatastoreContainerObject getTable() {
            return this.table;
        }
    }
}

