/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.FetchStatement;
import org.datanucleus.store.mapped.StatementExpressionIndex;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.rdbms.RDBMSFetchStatement;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.request.MappingStatementIndex;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class LocateRequest
extends Request {
    private final MappingStatementIndex mappingStatementIndex = new MappingStatementIndex();
    private final String locateStmt;
    private final int[] pkFieldNumbers;

    public LocateRequest(DatastoreClass table) {
        super(table);
        RDBMSFetchStatement fetchStmt = new RDBMSFetchStatement(table);
        FetchMappingConsumer consumer = new FetchMappingConsumer(fetchStmt);
        fetchStmt.select("1");
        table.provideDatastoreIdMappings(consumer);
        table.providePrimaryKeyMappings(consumer);
        this.locateStmt = ((Object)fetchStmt).toString();
        this.pkFieldNumbers = consumer.getPrimaryKeyFieldNumbers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        if (this.locateStmt != null) {
            ObjectManager om = sm.getObjectManager();
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            try {
                ManagedConnection mconn = storeMgr.getConnection(om);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForQuery(mconn, this.locateStmt);
                    try {
                        if (sm.getInternalObjectId() instanceof OID) {
                            this.table.getDataStoreObjectIdMapping().setObject(om, ps, this.mappingStatementIndex.getDatastoreId().getParameterIndex(), sm.getInternalObjectId());
                        } else {
                            sm.provideFields(this.pkFieldNumbers, (FieldManager)new ParameterSetter(sm, ps, this.mappingStatementIndex.getFields(), false));
                        }
                        ResultSet rs = sqlControl.executeStatementQuery(mconn, this.locateStmt, ps);
                        try {
                            if (!rs.next()) {
                                NucleusLogger.DATASTORE_RETRIEVE.info((Object)Request.LOCALISER.msg("050018", sm.getInternalObjectId()));
                                throw new NucleusObjectNotFoundException("No such database row", sm.getInternalObjectId());
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                String msg = Request.LOCALISER.msg("052220", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)this.locateStmt, (Object)e.getMessage());
                NucleusLogger.DATASTORE_RETRIEVE.warn((Object)msg);
                ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
                exceptions.add(e);
                while ((e = e.getNextException()) != null) {
                    exceptions.add(e);
                }
                throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
            }
        }
    }

    private class FetchMappingConsumer
    implements MappingConsumer {
        private int paramIndex = 1;
        final FetchStatement fetchStmt;
        List pkFields = new ArrayList();
        boolean initialized = false;

        public FetchMappingConsumer(FetchStatement fetchStmt) {
            this.fetchStmt = fetchStmt;
        }

        public void preConsumeMapping(int highestFieldNumber) {
            if (!this.initialized) {
                LocateRequest.this.mappingStatementIndex.setPrimaryKeys(new StatementExpressionIndex[highestFieldNumber]);
                LocateRequest.this.mappingStatementIndex.setFields(new StatementExpressionIndex[highestFieldNumber]);
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
            if (m.includeInFetchStatement()) {
                ((LocateRequest)LocateRequest.this).mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()] = new StatementExpressionIndex();
                LocateRequest.this.mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()].setMapping(m);
                if (fmd.isPrimaryKey()) {
                    int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        this.fetchStmt.andCondition(this.fetchStmt.referenceDatastoreField(m.getDataStoreMapping(j).getDatastoreField()) + " = ?");
                        this.pkFields.add(new Integer(fmd.getAbsoluteFieldNumber()));
                        ++this.paramIndex;
                    }
                    LocateRequest.this.mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()].setParameterIndex(parametersIndex);
                }
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 2) {
                this.fetchStmt.andCondition(this.fetchStmt.referenceDatastoreField((DatastoreField)LocateRequest.this.key.getColumns().get(0)) + " = ?");
                int[] nArray = new int[]{this.paramIndex++};
                LocateRequest.this.mappingStatementIndex.getDatastoreId().setParameterIndex(nArray);
            }
        }

        public void consumeUnmappedDatastoreField(DatastoreField fld) {
        }

        public int[] getPrimaryKeyFieldNumbers() {
            int[] fieldNumbers = new int[this.pkFields.size()];
            for (int i = 0; i < this.pkFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.pkFields.get(i);
            }
            return fieldNumbers;
        }
    }
}

