/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.StatementExpressionIndex;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.request.MappingStatementIndex;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.request.VersionCheckRequest;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class DeleteRequest
extends VersionCheckRequest {
    private final MappingCallbacks[] callbacks;
    private final String deleteStmt;
    private final String deleteStmtOptimistic;
    private MappingStatementIndex mappingStatementIndex = new MappingStatementIndex();
    private final int[] pkFieldNumbers;
    private final AbstractMemberMetaData[] oneToOneNonOwnerFields;

    public DeleteRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        super(table, cls, clr);
        DeleteMappingConsumer consumer = new DeleteMappingConsumer(clr, this.cmd);
        table.provideNonPrimaryKeyMappings(consumer);
        consumer.setWhereClauseConsumption(true);
        table.providePrimaryKeyMappings(consumer);
        table.provideDatastoreIdMappings(consumer);
        this.deleteStmt = consumer.getStatement();
        if (this.versionMetaData != null) {
            if (this.versionMetaData.getFieldName() != null) {
                AbstractMemberMetaData[] versionFmds = new AbstractMemberMetaData[]{this.cmd.getMetaDataForMember(this.versionMetaData.getFieldName())};
                table.provideMappingsForFields(consumer, versionFmds, false);
            } else {
                table.provideVersionMappings(consumer);
            }
        }
        this.deleteStmtOptimistic = consumer.getStatement();
        this.pkFieldNumbers = consumer.getPrimaryKeyFieldNumbers();
        this.callbacks = consumer.getMappingCallBacks().toArray(new MappingCallbacks[consumer.getMappingCallBacks().size()]);
        this.oneToOneNonOwnerFields = consumer.getOneToOneNonOwnerFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        int i;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)Request.LOCALISER.msg("052210", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)this.table));
        }
        for (i = 0; i < this.callbacks.length; ++i) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Request.LOCALISER.msg("052212", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)((JavaTypeMapping)((Object)this.callbacks[i])).getFieldMetaData().getFullFieldName()));
            }
            this.callbacks[i].preDelete(sm);
        }
        if (this.oneToOneNonOwnerFields != null && this.oneToOneNonOwnerFields.length > 0) {
            for (i = 0; i < this.oneToOneNonOwnerFields.length; ++i) {
                AbstractMemberMetaData relatedFmd = this.oneToOneNonOwnerFields[i];
                this.updateOneToOneBidirectionalOwnerObjectForField(sm, relatedFmd);
            }
        }
        String stmt = null;
        ObjectManager om = sm.getObjectManager();
        RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
        boolean optimisticChecks = this.versionMetaData != null && om.getTransaction().getOptimistic() && this.versionChecks;
        stmt = optimisticChecks ? this.deleteStmtOptimistic : this.deleteStmt;
        try {
            ManagedConnection mconn = storeMgr.getConnection(om);
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                boolean batch = true;
                if (optimisticChecks || !om.getTransaction().isActive()) {
                    batch = false;
                }
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, batch);
                try {
                    if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
                        this.table.getDataStoreObjectIdMapping().setObject(om, ps, this.mappingStatementIndex.getDatastoreId().getParameterIndex(), sm.getInternalObjectId());
                    } else if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
                        sm.provideFields(this.pkFieldNumbers, (FieldManager)new ParameterSetter(sm, ps, this.mappingStatementIndex.getPrimaryKeys(), true));
                    }
                    if (optimisticChecks) {
                        JavaTypeMapping verMapping = this.mappingStatementIndex.getVersion2().getMapping();
                        Object currentVersion = sm.getTransactionalVersion(sm.getObject());
                        if (currentVersion == null) {
                            String msg = Request.LOCALISER.msg("052202", sm.getInternalObjectId(), (Object)this.table);
                            NucleusLogger.PERSISTENCE.error((Object)msg);
                            throw new NucleusException(msg);
                        }
                        verMapping.setObject(om, ps, this.mappingStatementIndex.getVersion2().getParameterIndex(), currentVersion);
                    }
                    int[] rcs = sqlControl.executeStatementUpdate(mconn, stmt, ps, !batch);
                    if (optimisticChecks && rcs[0] == 0) {
                        String msg = Request.LOCALISER.msg("052203", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), (Object)("" + sm.getTransactionalVersion(sm.getObject())));
                        NucleusLogger.DATASTORE.error((Object)msg);
                        throw new NucleusOptimisticException(msg, sm.getObject());
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            String msg = Request.LOCALISER.msg("052211", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)stmt, (Object)e.getMessage());
            NucleusLogger.DATASTORE_PERSIST.warn((Object)msg);
            ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
            exceptions.add(e);
            while ((e = e.getNextException()) != null) {
                exceptions.add(e);
            }
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOneToOneBidirectionalOwnerObjectForField(StateManager sm, AbstractMemberMetaData fmd) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)Request.LOCALISER.msg("052217", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)fmd.getFullFieldName()));
        }
        RDBMSManager storeMgr = (RDBMSManager)sm.getStoreManager();
        ObjectManager om = sm.getObjectManager();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(clr);
        String fullClassName = ((AbstractClassMetaData)relatedMmds[0].getParent()).getFullClassName();
        String[] classes = (AbstractClassMetaData)relatedMmds[0].getParent() instanceof InterfaceMetaData ? storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(fullClassName, clr) : new String[]{fullClassName};
        HashSet<DatastoreClass> datastoreClasses = new HashSet<DatastoreClass>();
        for (int i = 0; i < classes.length; ++i) {
            datastoreClasses.add(storeMgr.getDatastoreClass(classes[i], clr));
        }
        Iterator it = datastoreClasses.iterator();
        while (it.hasNext()) {
            int j;
            DatastoreClass refTable = (DatastoreClass)it.next();
            JavaTypeMapping refMapping = refTable.getFieldMapping(fmd.getMappedBy());
            if (!refMapping.isNullable()) continue;
            StringBuffer clearLinkStmt = new StringBuffer("UPDATE " + ((Object)refTable).toString() + " SET ");
            for (j = 0; j < refMapping.getNumberOfDatastoreFields(); ++j) {
                if (j > 0) {
                    clearLinkStmt.append(",");
                }
                clearLinkStmt.append(refMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier());
                clearLinkStmt.append("=NULL");
            }
            clearLinkStmt.append(" WHERE ");
            for (j = 0; j < refMapping.getNumberOfDatastoreFields(); ++j) {
                if (j > 0) {
                    clearLinkStmt.append(" AND ");
                }
                clearLinkStmt.append(refMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier());
                clearLinkStmt.append("=?");
            }
            try {
                ManagedConnection mconn = storeMgr.getConnection(om);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = null;
                    try {
                        ps = sqlControl.getStatementForUpdate(mconn, clearLinkStmt.toString(), false);
                        refMapping.setObject(om, ps, Mappings.getParametersIndex(1, refMapping), sm.getObject());
                        sqlControl.executeStatementUpdate(mconn, clearLinkStmt.toString(), ps, true);
                    }
                    finally {
                        if (ps == null) continue;
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NucleusDataStoreException("Update request failed", (Throwable)e);
            }
        }
    }

    private class DeleteMappingConsumer
    implements MappingConsumer {
        boolean initialized = false;
        StringBuffer where = new StringBuffer();
        int paramIndex = 1;
        private List pkFields = new ArrayList();
        private List oneToOneNonOwnerFields = new ArrayList();
        private List mc = new ArrayList();
        private final ClassLoaderResolver clr;
        private final AbstractClassMetaData cmd;
        private boolean whereClauseConsumption = false;

        public DeleteMappingConsumer(ClassLoaderResolver clr, AbstractClassMetaData cmd) {
            this.clr = clr;
            this.cmd = cmd;
            this.paramIndex = 1;
        }

        public void setWhereClauseConsumption(boolean whereClause) {
            this.whereClauseConsumption = whereClause;
        }

        public void preConsumeMapping(int highest) {
            if (!this.initialized) {
                DeleteRequest.this.mappingStatementIndex.setPrimaryKeys(new StatementExpressionIndex[highest]);
                DeleteRequest.this.mappingStatementIndex.setFields(new StatementExpressionIndex[highest]);
                this.initialized = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
            block11: {
                block13: {
                    block12: {
                        if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                            return;
                        }
                        if (!m.includeInUpdateStatement()) break block11;
                        if (!fmd.isPrimaryKey()) break block12;
                        Integer abs_field_num = new Integer(fmd.getAbsoluteFieldNumber());
                        int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                        StatementExpressionIndex sei = new StatementExpressionIndex();
                        sei.setMapping(m);
                        sei.setParameterIndex(parametersIndex);
                        ((DeleteRequest)DeleteRequest.this).mappingStatementIndex.getPrimaryKeys()[fmd.getAbsoluteFieldNumber()] = sei;
                        for (int j = 0; j < parametersIndex.length; ++this.paramIndex, ++j) {
                            if (this.where.length() > 0) {
                                this.where.append(" AND ");
                            }
                            String condition = m.getDataStoreMapping(j).getDatastoreField().getIdentifier() + "=" + ((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter();
                            this.where.append(condition);
                            if (this.pkFields.contains(abs_field_num)) continue;
                            this.pkFields.add(abs_field_num);
                        }
                        break block11;
                    }
                    if (!(m instanceof PersistenceCapableMapping) && !(m instanceof ReferenceMapping)) break block13;
                    if (m.getNumberOfDatastoreFields() == 0) {
                        int relationType = fmd.getRelationType(this.clr);
                        if (relationType == 2) {
                            if (fmd.getMappedBy() != null) {
                                this.oneToOneNonOwnerFields.add(fmd);
                            }
                            break block11;
                        } else if (relationType == 6) {
                            AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(this.clr);
                            if (fmd.getJoinMetaData() == null && relatedMmds[0].getJoinMetaData() == null) {
                                // empty if block
                            }
                        }
                    }
                    break block11;
                }
                if (this.whereClauseConsumption) {
                    int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                    ++this.paramIndex;
                    StatementExpressionIndex sei = new StatementExpressionIndex();
                    sei.setMapping(m);
                    sei.setParameterIndex(parametersIndex);
                    DeleteRequest.this.mappingStatementIndex.setVersion2(sei);
                    String inputParam = ((RDBMSMapping)m.getDataStoreMapping(0)).getUpdateInputParameter();
                    String condition = " AND " + m.getDataStoreMapping(0).getDatastoreField().getIdentifier() + "=" + inputParam;
                    this.where.append(condition);
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mc.add(m);
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 2) {
                this.where.append(((Object)m.getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString());
                this.where.append("=");
                this.where.append(((RDBMSMapping)m.getDataStoreMapping(0)).getUpdateInputParameter());
                int[] param = new int[]{this.paramIndex++};
                DeleteRequest.this.mappingStatementIndex.getDatastoreId().setParameterIndex(param);
            } else if (mappingType == 1 && this.whereClauseConsumption) {
                StatementExpressionIndex versStmtIdx = DeleteRequest.this.mappingStatementIndex.getVersion2();
                int[] param = new int[]{this.paramIndex++};
                versStmtIdx.setMapping(m);
                versStmtIdx.setParameterIndex(param);
                String inputParam = ((RDBMSMapping)m.getDataStoreMapping(0)).getUpdateInputParameter();
                String condition = " AND " + m.getDataStoreMapping(0).getDatastoreField().getIdentifier() + "=" + inputParam;
                this.where.append(condition);
            }
        }

        public void consumeUnmappedDatastoreField(DatastoreField fld) {
        }

        public int[] getPrimaryKeyFieldNumbers() {
            int[] fieldNumbers = new int[this.pkFields.size()];
            for (int i = 0; i < this.pkFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.pkFields.get(i);
            }
            return fieldNumbers;
        }

        public AbstractMemberMetaData[] getOneToOneNonOwnerFields() {
            AbstractMemberMetaData[] fmds = new AbstractMemberMetaData[this.oneToOneNonOwnerFields.size()];
            for (int i = 0; i < this.oneToOneNonOwnerFields.size(); ++i) {
                fmds[i] = (AbstractMemberMetaData)this.oneToOneNonOwnerFields.get(i);
            }
            return fmds;
        }

        public List getMappingCallBacks() {
            return this.mc;
        }

        public String getStatement() {
            return "DELETE FROM " + ((Object)DeleteRequest.this.table).toString() + " WHERE " + this.where;
        }
    }
}

