/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.jdo.exceptions.ClassNotPersistenceCapableException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.query.AbstractSQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryCompiler;
import org.datanucleus.store.rdbms.query.SQLQuery;
import org.datanucleus.util.Imports;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class SQLQueryCompiler
extends QueryCompiler {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)(class$org$datanucleus$store$rdbms$RDBMSManager == null ? (class$org$datanucleus$store$rdbms$RDBMSManager = SQLQueryCompiler.class$("org.datanucleus.store.rdbms.RDBMSManager")) : class$org$datanucleus$store$rdbms$RDBMSManager).getClassLoader());
    static /* synthetic */ Class class$org$datanucleus$store$rdbms$RDBMSManager;

    public SQLQueryCompiler(AbstractSQLQuery query, Imports imports, Map parameters) {
        super((Query)query, imports, parameters);
    }

    public Object compile(int type) {
        switch (type) {
            case 3: {
                return this.generateQueryStatement();
            }
            case 4: {
                return this.generateQueryStatement();
            }
            case 1: {
                throw new NucleusException("SQL Query Compiler doesnt allow input of explicit parameters so cant compile them");
            }
            case 2: {
                throw new NucleusException("SQL Query Compiler doesnt allow input of explicit variables so cant compile them");
            }
        }
        return super.compile(type);
    }

    protected String generateQueryStatement() {
        String compiledSQL = ((AbstractSQLQuery)this.query).getInputSQL();
        if (this.candidateClass != null && this.query.getType() == 0) {
            ObjectManager om = this.query.getObjectManager();
            MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
            ClassLoaderResolver clr = om.getClassLoaderResolver();
            AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
            if (cmd == null) {
                throw new ClassNotPersistenceCapableException(this.candidateClass.getName());
            }
            if (cmd.getPersistenceCapableSuperclass() != null) {
                // empty if block
            }
            if (this.query.getResultClass() == null) {
                int i;
                String[] selectedColumns;
                String selections = compiledSQL.trim().substring(7);
                int fromStart = selections.indexOf("FROM");
                if (fromStart == -1) {
                    fromStart = selections.indexOf("from");
                }
                if ((selectedColumns = StringUtils.split((String)(selections = selections.substring(0, fromStart).trim()), (String)",")) == null || selectedColumns.length == 0) {
                    throw new NucleusUserException(LOCALISER_RDBMS.msg("059003", (Object)compiledSQL));
                }
                if (selectedColumns.length == 1 && selectedColumns[0].trim().equals("*")) {
                    return compiledSQL;
                }
                DatastoreClass table = storeMgr.getDatastoreClass(this.candidateClass.getName(), clr);
                PersistenceCapableMapping idMapping = (PersistenceCapableMapping)table.getIDMapping();
                String[] idColNames = new String[idMapping.getNumberOfDatastoreFields()];
                boolean[] idColMissing = new boolean[idMapping.getNumberOfDatastoreFields()];
                for (int i2 = 0; i2 < idMapping.getNumberOfDatastoreFields(); ++i2) {
                    DatastoreMapping m = idMapping.getDataStoreMapping(i2);
                    idColNames[i2] = ((Object)m.getDatastoreField().getIdentifier()).toString();
                    idColMissing[i2] = true;
                }
                String discriminatorColName = table.getDiscriminatorMapping(false) != null ? ((Object)table.getDiscriminatorMapping(false).getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() : null;
                String versionColName = table.getVersionMapping(false) != null ? ((Object)table.getVersionMapping(false).getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() : null;
                boolean discrimMissing = discriminatorColName != null;
                boolean versionMissing = true;
                if (versionColName == null) {
                    versionMissing = false;
                }
                DatastoreAdapter dba = storeMgr.getDatastoreAdapter();
                AbstractClassMetaData candidateCmd = om.getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
                for (i = 0; i < selectedColumns.length; ++i) {
                    String colName = selectedColumns[i].trim();
                    if (colName.indexOf(" AS ") > 0) {
                        colName = colName.substring(colName.indexOf(" AS ") + 4).trim();
                    } else if (colName.indexOf(" as ") > 0) {
                        colName = colName.substring(colName.indexOf(" as ") + 4).trim();
                    }
                    if (candidateCmd.getIdentityType() == IdentityType.DATASTORE) {
                        if (SQLQuery.columnNamesAreTheSame(dba, idColNames[0], colName)) {
                            idColMissing[0] = false;
                        }
                    } else if (candidateCmd.getIdentityType() == IdentityType.APPLICATION) {
                        for (int j = 0; j < idColNames.length; ++j) {
                            if (!SQLQuery.columnNamesAreTheSame(dba, idColNames[j], colName)) continue;
                            idColMissing[j] = false;
                        }
                    }
                    if (discrimMissing && SQLQuery.columnNamesAreTheSame(dba, discriminatorColName, colName)) {
                        discrimMissing = false;
                        continue;
                    }
                    if (!versionMissing || !SQLQuery.columnNamesAreTheSame(dba, versionColName, colName)) continue;
                    versionMissing = false;
                }
                if (discrimMissing) {
                    throw new NucleusUserException(LOCALISER_RDBMS.msg("059014", (Object)compiledSQL, (Object)this.candidateClass.getName(), (Object)discriminatorColName));
                }
                if (versionMissing) {
                    throw new NucleusUserException(LOCALISER_RDBMS.msg("059015", (Object)compiledSQL, (Object)this.candidateClass.getName(), (Object)versionColName));
                }
                for (i = 0; i < idColMissing.length; ++i) {
                    if (!idColMissing[i]) continue;
                    throw new NucleusUserException(LOCALISER_RDBMS.msg("059013", (Object)compiledSQL, (Object)this.candidateClass.getName(), (Object)idColNames[i]));
                }
            }
        }
        return compiledSQL;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

